require 'redmine'

  include IssuesHelper

Redmine::Plugin.register :redmine_wiki_issue_fields do
  name 'Redmine Wiki Issue fields plugin'
  author 'SeaSidetech'
  description 'This plugin adds a wiki macro to make it easier to list the details of issues on a wiki page.'
  url "http://www.seasidetech.net/en/plugin-redmine---wiki-issue-fields-gc8.html"
  version '0.4.0'
  requires_redmine :version_or_higher => '2.3.0'


  ##############################################################################

  Redmine::WikiFormatting::Macros.register do
    desc "Display an issue and it's details.\n\n" +
         "+Syntax:+\n" +
         "<pre>{{issue_fields(issue,[options],[arguments])}}</pre>\n\n" +
         "_issue_ : issue number\n" +
         "+Options:+\n" +
         "* -p : doesn't display the project name number\n" +
         "* -i : doesn't display the issue number\n" +
         "* -c : doesn't display the field caption of the following field\n" +
         "* -C : doesn't display the field caption of any field after this option\n\n" +
         "+Arguments:+\n" +
         "* Natives issue field : project, tracker, parent, status, priority, subject, author, assigned_to, updated_on, category, fixed_version, start_date, due_date, estimated_hours, done_ratio, created\n" +
         "* Custom issue fields\n\n" +
         "+Examples:+\n" +
         "<pre>{{issue_fields(1,subject)}} ->  test - #1, Subject : This is the subject of the issue number 1\n" +
         "{{issue_fields(2,-c,subject)}} ->  test - #2, This is the subject of the issue number 2\n" +
         "{{issue_fields(3,-p,-i,subject)}} ->  Subject : This is the subject of the issue number 3</pre>\n"
         
               
    macro :issue_fields do |obj, args|
    
  ##############################################################################
    
      return 'Error : arguments missing' unless args.length > 0

      issue_id = args[0].strip
      issue = Issue.visible.find_by_id(issue_id)
      
      return 'Error : issue missing' unless issue
      
      ##########################################################################
      response = ''.html_safe
      display_fields_caption = 1
      display_project_name = 1
      display_issue_id = 1
            
      compteur_args = 1

      while (compteur_args < args.length)
          
          entre = args[compteur_args].strip
          
          sortie = ''.html_safe
          sortie_name = ''.html_safe

          if args[compteur_args].strip == "-p" || args[compteur_args].strip == "-S"
              display_project_name = 0
          end

          if args[compteur_args].strip == "-i" || args[compteur_args].strip == "-S"
              display_issue_id = 0
          end

          if args[compteur_args].strip == "-C" || args[compteur_args].strip == "-P"
              display_fields_caption = 0
          end

         
          ######################################################################
          
          if entre == "created"   ### 1 ###
             sortie_name << ", Created : "
             
             if issue.created_on != nil
             
                 day = h(issue.created_on.day).to_s
                 if ( day.length < 2 )
                     day = '0' + day
                 end

                 month = h(issue.created_on.month).to_s
                 if ( month.length < 2 )
                     month = '0' + month
                 end
             
                 year = h(issue.created_on.year).to_s
             
                 hour = h(issue.created_on.hour).to_s
                 if ( hour.length < 2 )
                     hour = '0' + hour
                 end
             
                 min = h(issue.created_on.min).to_s
                 if ( min.length < 2 )
                     min = '0' + min
                 end
             
                 sec = h(issue.created_on.sec).to_s
                 if ( sec.length < 2 )
                     sec = '0' + sec
                 end
                 
                 sortie << day + "/" + month + "/" + year + " - " + hour + ":" + min + ":" + sec
             
             end
             
          end
          
          if entre == "tracker"
             sortie_name << ", Tracker : "
             sortie << h(issue.tracker)
          end    
          
          if entre == "author"   ### 2 ###
             sortie_name << ", Author : "
             sortie << h(issue.author)
          end    
          
          if entre == "subject"   ### 3 ###
             sortie_name << ", Subject : "
             sortie << h(issue.subject)
          end
          
          if entre == "status"   ### 4 ###
             sortie_name << ", Status : "
             sortie << h(issue.status)
          end          
          
          if entre == "priority"   ### 5 ###
             sortie_name << ", Priority : "
             sortie << h(issue.priority)
          end          
          
          if entre == "assignee"   ### 6 ###
             sortie_name << ", Assegnee : "
             sortie << h(issue.assignee)
          end 
          
          if entre == "category"   ### 7 ###
             sortie_name << ", Category : "
             sortie << h(issue.category)
          end           

          if entre == "target_version"   ### 8 ###
             sortie_name << ", Target Version : "
             sortie << h(issue.target_version)
          end 

          if entre == "duration"   ### 9 ###
             sortie_name << ", Duration : "
             sortie << h(issue.duration)
          end
          
          if entre == "start_date"   ### 10 ###
             sortie_name << ", Start Date : "
             
             if issue.start_date != nil
             
                 day = h(issue.start_date.day).to_s
                 if ( day.length < 2 )
                     day = '0' + day
                 end
             
                 month = h(issue.start_date.month).to_s
                 if ( month.length < 2 )
                     month = '0' + month
                 end
             
                 year = h(issue.start_date.year).to_s
                 
                 sortie << day + "/" + month + "/" + year
             
             end

          end
          
          if entre == "due_date"   ### 11 ###
             sortie_name << ", Due Date : "
             
             if issue.due_date != nil
             
                 day = h(issue.due_date.day).to_s
                 if ( day.length < 2 )
                     day = '0' + day
                 end
             
                 month = h(issue.due_date.month).to_s
                 if ( month.length < 2 )
                     month = '0' + month
                 end
             
                 year = h(issue.due_date.year).to_s
                 
                 sortie << day + "/" + month + "/" + year

             end

          end          
          
          if entre == "%_done"   ### 12 ###
             sortie_name << ", Done : "
             sortie << h(issue.done_ratio)
          end 
          
          if entre == "spent_time"   ### 13 ###
             sortie_name << ", Spent Time : "
             sortie << h(issue.spent_hours)
          end           

          if entre == "estimated_time"   ### 14 ###
             sortie_name << ", Estimated Time : "
             sortie << h(issue.estimated_hours)
          end       

          if entre == "parent_task"   ### 15 ###
             sortie_name << ", Parent Task : "
             sortie << h(issue.parent)
          end 
          
          if entre == "updated"   ### 16 ###
             sortie_name << ", Updated On : "
             
             if issue.updated_on != nil
             
                 day = h(issue.updated_on.day).to_s
                 if ( day.length < 2 )
                     day = '0' + day
                 end
             
                 month = h(issue.updated_on.month).to_s
                 if ( month.length < 2 )
                     month = '0' + month
                 end
             
                 year = h(issue.updated_on.year).to_s
                 
                 sortie << day + "/" + month + "/" + year

             end

          end 
          
          ######################################################################
          # Manage the custom fields
          ######################################################################
 
          if sortie == "" && sortie_name == ""
             customfield1 = []
             customfield1 = IssueCustomField.find(:all)
             
             compteur_icf = customfield1.size
             variable_boucle_icf = 0
             
             issue.custom_field_values.each do |c|
               if entre == c.custom_field.name
                   sortie_name << ", " + c.custom_field.name + " : "
                   if c.custom_field.field_format == "list"
                       sortie << c.value.join(",")
                   elsif c.custom_field.field_format == "bool"
                       if c.value == "1"
                           sortie << "Yes"
                       else
                           sortie << "No"
                       end
                   else
                       sortie << c.value
                   end
               end
             end
          end # end if

            
          ######################################################################
          #
          ######################################################################
          if args[compteur_args].strip == "-p" ||
             args[compteur_args].strip == "-i" ||
             args[compteur_args].strip == "-c" ||
             args[compteur_args].strip == "-C" || 
             args[compteur_args].strip == "-S" ||
             args[compteur_args].strip == "-N" ||
             args[compteur_args].strip == "-P"

             sortie_name = ''.html_safe 
             sortie = ''.html_safe 

          elsif args[compteur_args-1].strip == "-c" || display_fields_caption == 0
          
             sortie_name = ", ".html_safe
             
          end
          
          response << sortie_name
          response << sortie
          
          compteur_args = compteur_args + 1
      end

      ##########################################################################
      ##########################################################################
      
      # Remove the first comma
      response = response[2..-1].html_safe


      if display_issue_id == 1
         issue_link = link_to("#" + h(issue.id) + ", " + response, :controller => 'issues', :action => 'show', :id => issue.id)
      else
         issue_link = link_to(response, :controller => 'issues', :action => 'show', :id => issue.id)
      end
 
      if display_project_name == 1
         project_link = link_to(h(issue.project), :controller => 'projects', :action => 'show', :id => issue.project)
         project_link + " - " + issue_link
      else
	 issue_link + " "
      end
    end

    desc "Macro liste des trackers enfants"
  
    macro :list_subtasks do |obj, args|
      return 'Error : arguments missing' unless args.length > 0

      issue_id = args[0].strip
      issue = Issue.visible.find_by_id(issue_id)
      
      return 'Error : issue missing' unless issue
      IssuesHelper.render_descendants_tree(7)
    end

  end


end

################################################################################
