require 'redmine'

# see http://www.redmine.org/issues/show/783#note-7
require_dependency "#{RAILS_ROOT}/vendor/plugins/redmine_blogs/project_patch"


Redmine::Plugin.register :redmine_blogs do
  name 'Redmine Blogs plugin'
  author 'kyanh'
  description 'Generate blog engine (almost like News)'
  version '0.0.1'

  project_module :blogs do
    permission :manage_blogs, :blogs => [:new, :delete, :edit, :destroy_comment, :destroy]
    permission :comment_blogs, :blogs => :add_comment, :require => :member
    permission :view_blogs, :blogs => [:index, :show]
  end

  menu :project_menu, :blogs, {:controller => 'blogs', :action => 'index'},
    :caption => 'Blog', :after => :news, :param => :project_id

  activity_provider :blogs
end
