require_dependency 'project'

module ProjectPatch
  def self.included(base) # :nodoc:
    base.extend(ClassMethods)
    base.send(:include, InstanceMethods)

    # Same as typing in the class
    base.class_eval do
      has_many :blog, :dependent => :delete_all, :include => :author
    end

  end

  module ClassMethods
    # Methods to add to the Issue class
  end

  module InstanceMethods
    # Methods to add to specific issue objects
  end
end

# Add module to Issue
Project.send(:include, ProjectPatch)
