# a patch against imports_controller
ActiveSupport::Reloader.to_prepare do
  unless IssuesController.included_modules.include?(SwsApiIssuesSpentHours::IssuesControllerPatch)
    IssuesController.send(:include, SwsApiIssuesSpentHours::IssuesControllerPatch)
  end
end

require_dependency "issues_controller"

module SwsApiIssuesSpentHours
  module IssuesControllerPatch
    def self.included(base) # :nodoc:
      base.send(:include, InstanceMethods)
      base.extend(ClassMethods)

      base.class_eval do
        unloadable
        alias_method :index_without_sws, :index
        alias_method :index, :index_with_sws
      end
    end

    module InstanceMethods
      ## Overrides original to add spent hours to XML
      def index_with_sws
        use_session = !request.format.csv?
        retrieve_query(IssueQuery, use_session)

        if @query.valid?
          respond_to do |format|
            format.html {
              @issue_count = @query.issue_count
              @issue_pages = Paginator.new @issue_count, per_page_option, params["page"]
              @issues = @query.issues(:offset => @issue_pages.offset, :limit => @issue_pages.per_page)
              render :layout => !request.xhr?
            }
            format.api {
              @offset, @limit = api_offset_and_limit
              @query.column_names = %w(author)
              @issue_count = @query.issue_count
              @issues = @query.issues(:offset => @offset, :limit => @limit)
              Issue.load_visible_relations(@issues) if include_in_api_response?("relations")
              ## SWS addition
              Issue.load_visible_spent_hours(@issues) if include_in_api_response?("spent_hours")
              Issue.load_visible_total_spent_hours(@issues) if include_in_api_response?("spent_hours")
              ## SWS addition end
            }
            format.atom {
              @issues = @query.issues(:limit => Setting.feeds_limit.to_i)
              render_feed(@issues, :title => "#{@project || Setting.app_title}: #{l(:label_issue_plural)}")
            }
            format.csv {
              @issues = @query.issues(:limit => Setting.issues_export_limit.to_i)
              send_data(query_to_csv(@issues, @query, params[:csv]), :type => "text/csv; header=present", :filename => "issues.csv")
            }
            format.pdf {
              @issues = @query.issues(:limit => Setting.issues_export_limit.to_i)
              send_file_headers! :type => "application/pdf", :filename => "issues.pdf"
            }
          end
        else
          respond_to do |format|
            format.html { render :layout => !request.xhr? }
            format.any(:atom, :csv, :pdf) { head 422 }
            format.api { render_validation_errors(@query) }
          end
        end
      rescue ActiveRecord::RecordNotFound
        render_404
      end
    end

    module ClassMethods
    end
  end
end
