import std.c.windows.com;

/*

Created by: J C Calvarese
License:    Public Domain


** Batch file to create uuid.lib **

echo off
dmd -c uuid_obj.d
lib -c uuid.lib uuid_obj.obj
pause

*/

export
extern(C) {

    const IID _DBBMKGUID                           = {0xB04B30F6, 0x88D1, 0xCD11, [0xAD, 0x48, 0x00, 0xAA, 0x00, 0x3C, 0x9C, 0xB6]};
    const IID _DBCIDGUID                           = {0x004728FE, 0x88D1, 0xCD11, [0xAD, 0x48, 0x00, 0xAA, 0x00, 0x3C, 0x9C, 0xB6]};
    const IID _GUID_NAMEONLY                       = {0x7011BFE8, 0x88D1, 0xCD11, [0xAD, 0x48, 0x00, 0xAA, 0x00, 0x3C, 0x9C, 0xB6]};
    const IID ARRAYID_PathProperties               = {0x04BACB7E, 0x972D, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID BFID_GRAY_16                         = {0x00BCD6F9, 0x9C44, 0xD011, [0x91, 0x8C, 0x00, 0xAA, 0x00, 0x6C, 0x1A, 0x01]};
    const IID BFID_GRAY_8                          = {0x10E93DD9, 0x9C44, 0xD011, [0x91, 0x8C, 0x00, 0xAA, 0x00, 0x6C, 0x1A, 0x01]};
    const IID BFID_MONOCHROME                      = {0x78EB36E4, 0x4F52, 0xCE11, [0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70]};
    const IID BFID_RGB_24                          = {0x7DEB36E4, 0x4F52, 0xCE11, [0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70]};
    const IID BFID_RGB_32                          = {0x7EEB36E4, 0x4F52, 0xCE11, [0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70]};
    const IID BFID_RGB_4                           = {0x79EB36E4, 0x4F52, 0xCE11, [0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70]};
    const IID BFID_RGB_555                         = {0x7CEB36E4, 0x4F52, 0xCE11, [0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70]};
    const IID BFID_RGB_565                         = {0x7BEB36E4, 0x4F52, 0xCE11, [0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70]};
    const IID BFID_RGB_8                           = {0x7AEB36E4, 0x4F52, 0xCE11, [0x9F, 0x53, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70]};
    const IID BFID_RGBA_32                         = {0xC09A3C77, 0x7432, 0xD011, [0xB7, 0x24, 0x00, 0xAA, 0x00, 0x6C, 0x1A, 0x01]};
    const IID BHID_LinkTargetItem                  = {0x28E28139, 0x59F5, 0xD311, [0x8E, 0x3A, 0x00, 0xC0, 0x4F, 0x68, 0x37, 0xD5]};
    const IID BHID_SFObject                        = {0x24E28139, 0x59F5, 0xD311, [0x8E, 0x3A, 0x00, 0xC0, 0x4F, 0x68, 0x37, 0xD5]};
    const IID BHID_SFUIObject                      = {0x25E28139, 0x59F5, 0xD311, [0x8E, 0x3A, 0x00, 0xC0, 0x4F, 0x68, 0x37, 0xD5]};
    const IID BHID_SFViewObject                    = {0x26E28139, 0x59F5, 0xD311, [0x8E, 0x3A, 0x00, 0xC0, 0x4F, 0x68, 0x37, 0xD5]};
    const IID BHID_Storage                         = {0x27E28139, 0x59F5, 0xD311, [0x8E, 0x3A, 0x00, 0xC0, 0x4F, 0x68, 0x37, 0xD5]};
    const IID BHID_StorageEnum                     = {0xE3A42146, 0xD6F0, 0x7347, [0x8A, 0x9C, 0x46, 0xE7, 0x7B, 0x17, 0x48, 0x40]};
    const IID BHID_Stream                          = {0xABB3EB1C, 0x107C, 0x9A49, [0xA4, 0x17, 0x92, 0xCA, 0x16, 0xC4, 0xCB, 0x83]};
    const IID CATID_BrowsableShellExt              = {0x90140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CATID_BrowseInPlace                  = {0x91140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CATID_ClusCfgCapabilities            = {0xC4EE5346, 0x8827, 0xBD4E, [0xA8, 0x31, 0x7E, 0x0D, 0x9F, 0x82, 0xD6, 0xE7]};
    const IID CATID_ClusCfgMemberSetChangeListener = {0xD4EA438A, 0xF110, 0x0D44, [0x8D, 0xAA, 0x1F, 0xE3, 0x8D, 0x16, 0x98, 0xCD]};
    const IID CATID_ClusCfgResourceTypes           = {0x52AE4C7C, 0xC9CA, 0x9D49, [0x82, 0xC6, 0xBC, 0x6A, 0x21, 0x77, 0xE5, 0x56]};
    const IID CATID_ClusCfgStartupListeners        = {0xB46D40DF, 0x7278, 0x994A, [0xBB, 0x3C, 0x14, 0xA9, 0xC3, 0x39, 0x33, 0xD1]};
    const IID CATID_CommBand                       = {0x94140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CATID_Control                        = {0xD46EFC40, 0x3824, 0xCF11, [0xA3, 0xDB, 0x08, 0x00, 0x36, 0xF1, 0x25, 0x02]};
    const IID CATID_DesignTimeUIActivatableControl = {0xD156BBF2, 0x07DB, 0xD111, [0xAA, 0x6B, 0x00, 0x60, 0x97, 0xDB, 0x95, 0x39]};
    const IID CATID_DeskBand                       = {0x92140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CATID_DocObject                      = {0xD86EFC40, 0x3824, 0xCF11, [0xA3, 0xDB, 0x08, 0x00, 0x36, 0xF1, 0x25, 0x02]};
    const IID CATID_EnumClusCfgManagedResources    = {0x884FA302, 0x1AD3, 0x8846, [0xBD, 0xDD, 0x38, 0xA7, 0x39, 0xE4, 0xF8, 0x9B]};
    const IID CATID_InfoBand                       = {0x93140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CATID_Insertable                     = {0xD36EFC40, 0x3824, 0xCF11, [0xA3, 0xDB, 0x08, 0x00, 0x36, 0xF1, 0x25, 0x02]};
    const IID CATID_InternetAware                  = {0x586AE80D, 0xAA2B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID CATID_IsShortcut                     = {0xD66EFC40, 0x3824, 0xCF11, [0xA3, 0xDB, 0x08, 0x00, 0x36, 0xF1, 0x25, 0x02]};
    const IID CATID_MARSHALER                      = {0x03000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CATID_NeverShowExt                   = {0xD76EFC40, 0x3824, 0xCF11, [0xA3, 0xDB, 0x08, 0x00, 0x36, 0xF1, 0x25, 0x02]};
    const IID CATID_PersistsToFile                 = {0x566AE80D, 0xAA2B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID CATID_PersistsToMemory               = {0x556AE80D, 0xAA2B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID CATID_PersistsToMoniker              = {0x516AE80D, 0xAA2B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID CATID_PersistsToPropertyBag          = {0x576AE80D, 0xAA2B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID CATID_PersistsToStorage              = {0x526AE80D, 0xAA2B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID CATID_PersistsToStream               = {0x546AE80D, 0xAA2B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID CATID_PersistsToStreamInit           = {0x536AE80D, 0xAA2B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID CATID_Printable                      = {0xD96EFC40, 0x3824, 0xCF11, [0xA3, 0xDB, 0x08, 0x00, 0x36, 0xF1, 0x25, 0x02]};
    const IID CATID_Programmable                   = {0xD56EFC40, 0x3824, 0xCF11, [0xA3, 0xDB, 0x08, 0x00, 0x36, 0xF1, 0x25, 0x02]};
    const IID CATID_RequiresDataPathHost           = {0x506AE80D, 0xAA2B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID CATID_SafeForInitializing            = {0x0258D97D, 0x8298, 0xCF11, [0x9F, 0xA9, 0x00, 0xAA, 0x00, 0x6C, 0x42, 0xC4]};
    const IID CATID_SafeForScripting               = {0x0158D97D, 0x8298, 0xCF11, [0x9F, 0xA9, 0x00, 0xAA, 0x00, 0x6C, 0x42, 0xC4]};
    const IID CGID_DocHostCommandHandler           = {0x42C28BF3, 0x50B9, 0xD111, [0x89, 0x18, 0x00, 0xC0, 0x4F, 0xC2, 0xC8, 0x36]};
    const IID CGID_DownloadHost                    = {0x288760E0, 0x4CAE, 0xD111, [0xBA, 0x40, 0x00, 0xC0, 0x4F, 0xB9, 0x2D, 0x79]};
    const IID CGID_Explorer                        = {0xD0140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CGID_ExplorerBarDoc                  = {0xD3140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CGID_InternetExplorer                = {0x00ED7EEB, 0x4DF7, 0xD211, [0xBB, 0x7F, 0x00, 0x10, 0x4B, 0x35, 0xE7, 0xF9]};
    const IID CGID_MSHTML                          = {0x00A94BDE, 0xCA59, 0xCF11, [0x95, 0x92, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID CGID_ShellDocView                    = {0xD1140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CGID_ShellServiceObject              = {0xD2140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CGID_ShortCut                        = {0x5087A693, 0x1A95, 0xD111, [0x94, 0x6F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]};
    const IID CLSID_1                              = {0x13184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_2                              = {0x14184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_3                              = {0x15184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_4                              = {0x16184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_5                              = {0x17184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_6                              = {0x18184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_7                              = {0x19184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_8                              = {0x1A184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_9                              = {0x1B184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_a                              = {0x1C184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_AboutProtocol                  = {0x06F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_AccessControlEntry             = {0x00C05AB7, 0xDD9B, 0xD011, [0x85, 0x2C, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID CLSID_AccessControlList              = {0x52A05EB8, 0xDD9B, 0xD011, [0x85, 0x2C, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID CLSID_AccountDiscovery               = {0xED30AB3D, 0x3281, 0xBF40, [0xA8, 0xBA, 0x7B, 0x50, 0x57, 0xF0, 0xCD, 0x10]};
    const IID CLSID_ACLCustomMRU                   = {0x93DB3569, 0xE821, 0xCC4C, [0xBE, 0xB9, 0x9F, 0xE3, 0xC7, 0x7A, 0x29, 0x7A]};
    const IID CLSID_ACLHistory                     = {0x6427BB00, 0x776A, 0xD011, [0xA5, 0x35, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62]};
    const IID CLSID_ACListISF                      = {0xF136C003, 0x86A1, 0xD011, [0x82, 0x4A, 0x00, 0xAA, 0x00, 0x5B, 0x43, 0x83]};
    const IID CLSID_ACLMRU                         = {0x41A65667, 0x71DE, 0xD011, [0x83, 0x1B, 0x00, 0xAA, 0x00, 0x5B, 0x43, 0x83]};
    const IID CLSID_ACLMulti                       = {0x6527BB00, 0x776A, 0xD011, [0xA5, 0x35, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62]};
    const IID CLSID_ActiveDesktop                  = {0x00870475, 0x1FEF, 0xD011, [0x98, 0x88, 0x00, 0x60, 0x97, 0xDE, 0xAC, 0xF9]};
    const IID CLSID_AdapterInfo                    = {0xC942996F, 0xB1C1, 0xB54A, [0x93, 0xDA, 0x60, 0x58, 0x99, 0x1D, 0xC8, 0xF3]};
    const IID CLSID_AddrControl                    = {0x48030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_AddressBarParser               = {0x091AE1E0, 0xB85C, 0x6C4B, [0x83, 0x32, 0xE0, 0x07, 0x20, 0xA1, 0x68, 0xF2]};
    const IID CLSID_ADsDSOObject                   = {0xD0659354, 0x26EC, 0xCF11, [0x83, 0x10, 0x00, 0xAA, 0x00, 0xB5, 0x05, 0xDB]};
    const IID CLSID_ADsSecurityUtility             = {0x4AC670F2, 0xB8FF, 0xE44A, [0x85, 0xFE, 0x3A, 0x75, 0xE5, 0x34, 0x79, 0x66]};
    const IID CLSID_ADSystemInfo                   = {0x7F32B650, 0xD1AF, 0xD211, [0x9C, 0xB9, 0x00, 0x00, 0xF8, 0x7A, 0x36, 0x9E]};
    const IID CLSID_AlgSetup                       = {0xCCBCD027, 0x4D34, 0x8742, [0xAF, 0x37, 0x0C, 0x72, 0xC1, 0x61, 0xC1, 0x4C]};
    const IID CLSID_AllClasses                     = {0x30030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_AlphabeticalCategorizer        = {0xC654263C, 0x7273, 0x6B4F, [0xB3, 0x10, 0x55, 0xD6, 0x12, 0x8F, 0x49, 0xD2]};
    const IID CLSID_AnchorClick                    = {0x3C41D513, 0xB933, 0xD211, [0x95, 0xA7, 0x00, 0xC0, 0x4F, 0x8E, 0xCB, 0x02]};
    const IID CLSID_AnimationComposerFactory       = {0x562A2B33, 0x6CF8, 0xE747, [0x86, 0x02, 0xFC, 0x42, 0xAC, 0x8B, 0x99, 0x20]};
    const IID CLSID_AnimationComposerSiteFactory   = {0x651A9116, 0x1DD4, 0x3144, [0x87, 0xF7, 0xE7, 0x57, 0xF4, 0xD0, 0x3B, 0xD8]};
    const IID CLSID_ApplicationGatewayServices     = {0xD3E1ADF8, 0xDF49, 0x754B, [0x90, 0x05, 0xEF, 0x95, 0x08, 0xE6, 0xA3, 0x37]};
    const IID CLSID_AutoComplete                   = {0x6327BB00, 0x776A, 0xD011, [0xA5, 0x35, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62]};
    const IID CLSID_AutoDiscoveryProvider          = {0xBFD5F3C4, 0x0948, 0xE344, [0x84, 0xA4, 0x36, 0x8B, 0x6B, 0x33, 0xB0, 0xB4]};
    const IID CLSID_AutoplayForSlideShow           = {0x58B3E700, 0x5BF6, 0xCF4D, [0x83, 0xDF, 0xCD, 0x02, 0x6B, 0x94, 0xBF, 0xD4]};
    const IID CLSID_b                              = {0x1D184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_BackgroundCopyManager          = {0x4BD39149, 0xA180, 0x9142, [0x83, 0xB6, 0x33, 0x28, 0x36, 0x6B, 0x90, 0x97]};
    const IID CLSID_BackgroundCopyManager1_5       = {0x1F7787F0, 0x4FD7, 0x1A4C, [0xBB, 0x8A, 0xE1, 0x6A, 0xCA, 0x91, 0x24, 0xEA]};
    const IID CLSID_BackgroundCopyQMgr             = {0xEE4AAD69, 0xBE51, 0x9B43, [0xA9, 0x2C, 0x86, 0xAE, 0x49, 0x0E, 0x8B, 0x30]};
    const IID CLSID_BackLink                       = {0x6F90BFFC, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_BasicImageEffects              = {0xC880B216, 0x70EE, 0xD111, [0x90, 0x66, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID CLSID_BasicImageEffectsPP            = {0xC980B216, 0x70EE, 0xD111, [0x90, 0x66, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID CLSID_BlockFormats                   = {0x31F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_BridgeTerminal                 = {0xA3E7BA8E, 0x4389, 0xD111, [0x96, 0xB8, 0x00, 0xC0, 0x4F, 0xB6, 0xE8, 0x66]};
    const IID CLSID_c                              = {0x1E184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_CAccPropServices               = {0x0B35F8B5, 0x4805, 0xB148, [0xA6, 0xEE, 0x88, 0xBD, 0x00, 0xB4, 0xA5, 0xE7]};
    const IID CLSID_CActiveIMM                     = {0x33DD5549, 0x59B1, 0xD011, [0x8F, 0xCF, 0x00, 0xAA, 0x00, 0x6B, 0xCC, 0x59]};
    const IID CLSID_CAnchorBrowsePropertyPage      = {0xBBF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CaseIgnoreList                 = {0x558AF815, 0x8046, 0xD111, [0xA3, 0xB4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_CCheckBox                      = {0x86F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CColorPropPage                 = {0x0152E30B, 0x918F, 0xCE11, [0x9D, 0xE3, 0x00, 0xAA, 0x00, 0x4B, 0xB8, 0x51]};
    const IID CLSID_CCombobox                      = {0x78F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CDBurn                         = {0x058AEBFB, 0xEEBE, 0x4244, [0x80, 0x4E, 0x40, 0x9D, 0x6C, 0x45, 0x15, 0xE9]};
    const IID CLSID_CDebugDocumentHelper           = {0xA6BCB883, 0x7C68, 0xD011, [0xA4, 0x05, 0x00, 0xAA, 0x00, 0x60, 0x27, 0x5C]};
    const IID CLSID_CDeviceRect                    = {0xD4F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CDirect3DRM                    = {0x41EC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID CLSID_CDirect3DRMAnimation           = {0x9856A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMAnimationSet        = {0x9956A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMClippedVisual       = {0x2DE73454, 0x666D, 0xD111, [0xBB, 0x0B, 0x00, 0x00, 0xF8, 0x75, 0x86, 0x5A]};
    const IID CLSID_CDirect3DRMDevice              = {0x8E56A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMFace                = {0x9356A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMFrame               = {0x9056A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMFrameInterpolator   = {0xA2EAE90D, 0x843B, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID CLSID_CDirect3DRMLight               = {0x9456A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMLightInterpolator   = {0xA6EAE90D, 0x843B, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID CLSID_CDirect3DRMMaterial            = {0x9756A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMMaterialInterpolato = {0xA7EAE90D, 0x843B, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID CLSID_CDirect3DRMMesh                = {0x9156A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMMeshBuilder         = {0x9256A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMMeshInterpolator    = {0xA3EAE90D, 0x843B, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID CLSID_CDirect3DRMProgressiveMesh     = {0x40EC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID CLSID_CDirect3DRMShadow              = {0x9B56A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMTexture             = {0x9556A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMTextureInterpolator = {0xA8EAE90D, 0x843B, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID CLSID_CDirect3DRMUserVisual          = {0x9A56A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMViewport            = {0x8F56A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirect3DRMViewportInterpolato = {0xA1EAE90D, 0x843B, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID CLSID_CDirect3DRMWrap                = {0x9656A34F, 0x3F62, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID CLSID_CDirectXFile                   = {0x43EC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID CLSID_CDLAgent                       = {0x109C557D, 0xE99F, 0xD011, [0x93, 0xF7, 0x00, 0xAA, 0x00, 0x59, 0xCE, 0x02]};
    const IID CLSID_CdlProtocol                    = {0x403DD53D, 0x8B7B, 0xD011, [0xB0, 0x13, 0x00, 0xAA, 0x00, 0x59, 0xCE, 0x02]};
    const IID CLSID_CDocBrowsePropertyPage         = {0xB4F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CDownloadBehavior              = {0xBEF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CEnroll                        = {0x89F2F843, 0x207A, 0xD011, [0x8F, 0x06, 0x00, 0xC0, 0x4F, 0xC2, 0x95, 0xE1]};
    const IID CLSID_CEventObj                      = {0x8AF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CFontPropPage                  = {0x0052E30B, 0x918F, 0xCE11, [0x9D, 0xE3, 0x00, 0xAA, 0x00, 0x4B, 0xB8, 0x51]};
    const IID CLSID_CFSIconOverlayManager          = {0x811FB563, 0x68C8, 0xD011, [0x99, 0x9C, 0x00, 0xC0, 0x4F, 0xD6, 0x55, 0xE1]};
    const IID CLSID_ChannelAgent                   = {0xE6BDA8E3, 0xCEAB, 0xD011, [0xBC, 0x4B, 0x00, 0xC0, 0x4F, 0xD9, 0x29, 0xDB]};
    const IID CLSID_ChannelMgr                     = {0x90AECDB3, 0x70D1, 0xD011, [0x80, 0x2B, 0x00, 0xC0, 0x4F, 0xD7, 0x5D, 0x13]};
    const IID CLSID_CHeaderFooter                  = {0xCDF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CHtmlArea                      = {0x4FF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CIEOptionElement               = {0x98F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CIESelectElement               = {0x88F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CImageBrowsePropertyPage       = {0xB3F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_ClassInstallFilter             = {0xBB33B532, 0xAEED, 0xD011, [0xBD, 0x5A, 0x00, 0xAA, 0x00, 0xB9, 0x2A, 0xF1]};
    const IID CLSID_CLayoutRect                    = {0x64F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_ClientCaps                     = {0x4EC48B7E, 0xFFAE, 0xD111, [0x89, 0xC2, 0x00, 0xC0, 0x4F, 0xB6, 0xBF, 0xC4]};
    const IID CLSID_ClusAppWiz                     = {0x5071F924, 0x8966, 0xD111, [0x9A, 0xA7, 0x00, 0xC0, 0x4F, 0xB9, 0x3A, 0x80]};
    const IID CLSID_ClusCfgAsyncEvictCleanup       = {0x725AF308, 0xC4D7, 0xF442, [0xBC, 0x81, 0x51, 0x88, 0xE1, 0x9D, 0xFA, 0x39]};
    const IID CLSID_ClusCfgEvictCleanup            = {0xE92B1532, 0x8CDE, 0x0F4D, [0x81, 0xB0, 0xBC, 0xE5, 0xD1, 0x1E, 0xCB, 0x00]};
    const IID CLSID_ClusCfgResTypeGenScript        = {0xF4C413D5, 0x341D, 0xA344, [0x83, 0xD4, 0x81, 0x26, 0x51, 0xDB, 0x89, 0x18]};
    const IID CLSID_ClusCfgResTypeMajorityNodeSet  = {0x440B87B6, 0xDF0B, 0x464B, [0xAC, 0x1F, 0x6C, 0x69, 0x1B, 0x62, 0x2E, 0xDF]};
    const IID CLSID_ClusCfgResTypeServices         = {0x8904376A, 0x52BB, 0x2747, [0xB7, 0x40, 0x08, 0xF4, 0x94, 0x16, 0x34, 0x78]};
    const IID CLSID_ClusCfgStartupNotify           = {0xB6EE5E10, 0xFD32, 0xA94E, [0x89, 0x12, 0x84, 0x3A, 0x7F, 0xF3, 0xCA, 0x2D]};
    const IID CLSID_ClusCfgWizard                  = {0xFEC41919, 0x466F, 0x2740, [0x97, 0x7D, 0x0E, 0xF1, 0xC8, 0xF2, 0x63, 0x72]};
    const IID CLSID_ClusterConfigurationType       = {0xC26837BF, 0xE5E0, 0x8F44, [0x95, 0x2B, 0x25, 0xD4, 0x33, 0x2D, 0xEF, 0xA3]};
    const IID CLSID_CMimeTypes                     = {0xFEF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CMLangConvertCharset           = {0x996F6DD6, 0xAACD, 0xD011, [0xB8, 0x22, 0x00, 0xC0, 0x4F, 0xC9, 0xB3, 0x1F]};
    const IID CLSID_CMLangString                   = {0xCF654DC0, 0x0DB7, 0xD011, [0xB1, 0x88, 0x00, 0xAA, 0x00, 0x38, 0xC9, 0x69]};
    const IID CLSID_CMultiLanguage                 = {0xE2235C27, 0x4737, 0xD011, [0x9F, 0xEA, 0x00, 0xAA, 0x00, 0x3F, 0x86, 0x46]};
    const IID CLSID_CNetCfg                        = {0x6152035B, 0xF940, 0xD111, [0xAA, 0xEC, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID CLSID_CoDitherToRGB8                 = {0x50CE60A8, 0x1039, 0xD011, [0x86, 0xFC, 0x00, 0xA0, 0xC9, 0x13, 0xF7, 0x50]};
    const IID CLSID_CoMapMIMEToCLSID               = {0x80B0C330, 0xFB30, 0xD011, [0xB7, 0x24, 0x00, 0xAA, 0x00, 0x6C, 0x1A, 0x01]};
    const IID CLSID_ComBinding                     = {0x28030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_CommonQuery                    = {0xC05EBC83, 0x2A6F, 0xD011, [0xA1, 0xC4, 0x00, 0xAA, 0x00, 0xC1, 0x6E, 0x65]};
    const IID CLSID_CompositePP                    = {0x6036B325, 0x83FD, 0xD111, [0x8A, 0xDE, 0x44, 0x45, 0x53, 0x54, 0x00, 0x01]};
    const IID CLSID_ConnectionCommonUi             = {0xD1AC0770, 0x0232, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID CLSID_ConnectionManager              = {0xD16A12BA, 0x6621, 0xD111, [0xB1, 0xD0, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID CLSID_ConnectionManager2             = {0xE56A12BA, 0x6621, 0xD111, [0xB1, 0xD0, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID CLSID_ControlPanel                   = {0x2020EC21, 0xEA3A, 0x6910, [0xA2, 0xDD, 0x08, 0x00, 0x2B, 0x30, 0x30, 0x9D]};
    const IID CLSID_ConvertVBX                     = {0x22088FFB, 0x6401, 0x1B10, [0x84, 0xED, 0x08, 0x00, 0x2B, 0x2E, 0xC7, 0x13]};
    const IID CLSID_ConvolvePP                     = {0x6136B325, 0x83FD, 0xD111, [0x8A, 0xDE, 0x44, 0x45, 0x53, 0x54, 0x00, 0x01]};
    const IID CLSID_COpsProfile                    = {0x02F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CoSniffStream                  = {0xA0FD016A, 0xDF30, 0xD011, [0xB7, 0x24, 0x00, 0xAA, 0x00, 0x6C, 0x1A, 0x01]};
    const IID CLSID_CPersistDataPeer               = {0x87F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CPersistHistory                = {0xC8F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CPersistShortcut               = {0xC6F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CPersistSnapshot               = {0xC9F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CPersistUserData               = {0x8EF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CPicturePropPage               = {0x0252E30B, 0x918F, 0xCE11, [0x9D, 0xE3, 0x00, 0xAA, 0x00, 0x4B, 0xB8, 0x51]};
    const IID CLSID_CPlugins                       = {0xFFF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CRadioButton                   = {0x9CF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CrBarn                         = {0x40F7BDC3, 0x580B, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_CrBarnPP                       = {0x3674ADFC, 0x51F1, 0x1041, [0xB9, 0x7E, 0x32, 0xBD, 0x60, 0x7F, 0xBD, 0xB8]};
    const IID CLSID_CrBlindPP                      = {0xC1523021, 0x0D10, 0xD211, [0x8B, 0x82, 0x00, 0xA0, 0xC9, 0x3C, 0x09, 0xB2]};
    const IID CLSID_CrBlinds                       = {0xC029C400, 0xA90B, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_CrBlur                         = {0x8D491273, 0x7AE8, 0xD111, [0x81, 0xE0, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID CLSID_CrBlurPP                       = {0x7E283E62, 0x0EFC, 0xD111, [0x9A, 0x77, 0x00, 0x00, 0xF8, 0x75, 0x6A, 0x10]};
    const IID CLSID_CrEmboss                       = {0x6D3015F5, 0x5601, 0xD211, [0x81, 0xEA, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID CLSID_CrEngrave                      = {0x6E3015F5, 0x5601, 0xD211, [0x81, 0xEA, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID CLSID_CrInset                        = {0x403C0793, 0xA50B, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_CrIris                         = {0x51F3693F, 0x7903, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_CrIrisPP                       = {0xC422DE80, 0x440F, 0xD211, [0x8B, 0x82, 0x00, 0xA0, 0xC9, 0x3C, 0x09, 0xB2]};
    const IID CLSID_CrRadialWipe                   = {0xAF714B42, 0x9506, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_CrRadialWipePP                 = {0xE032D933, 0x480F, 0xD211, [0x8B, 0x82, 0x00, 0xA0, 0xC9, 0x3C, 0x09, 0xB2]};
    const IID CLSID_CrSlide                        = {0x2F400E81, 0x6B05, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_CrSlidePP                      = {0xE1ED8CCC, 0x0310, 0xD211, [0x8B, 0x82, 0x00, 0xA0, 0xC9, 0x3C, 0x09, 0xB2]};
    const IID CLSID_CrSpiral                       = {0x007EA9AC, 0x7D0C, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_CrSpiralPP                     = {0x81FEA4C6, 0x2210, 0xD211, [0x8B, 0x82, 0x00, 0xA0, 0xC9, 0x3C, 0x09, 0xB2]};
    const IID CLSID_CrStretch                      = {0xA2F25876, 0x830A, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_CrStretchPP                    = {0xE095FB15, 0x770F, 0xD211, [0x8B, 0x82, 0x00, 0xA0, 0xC9, 0x3C, 0x09, 0xB2]};
    const IID CLSID_CrWheel                        = {0xE0DAE15A, 0x6114, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_CrWheelPP                      = {0x80619FFA, 0x6414, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_CrZigzag                       = {0x203DE7E6, 0x8A0C, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_CrZigzagPP                     = {0xC1A35915, 0x2B10, 0xD211, [0x8B, 0x82, 0x00, 0xA0, 0xC9, 0x3C, 0x09, 0xB2]};
    const IID CLSID_CScriptErrorList               = {0x0013D0EF, 0x0F16, 0xD211, [0xBB, 0x2E, 0x00, 0x80, 0x5F, 0xF7, 0xEF, 0xCA]};
    const IID CLSID_CScrollBar                     = {0x8AF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CSliderBar                     = {0x8EF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CSpinButton                    = {0x8CF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CTemplatePrinter               = {0xB3F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_CUrlHistory                    = {0x404A373C, 0xE4BA, 0xCF11, [0xBF, 0x7D, 0x00, 0xAA, 0x00, 0x69, 0x46, 0xEE]};
    const IID CLSID_CURLSearchHook                 = {0x00AEBFCF, 0xA617, 0xD011, [0x99, 0xCB, 0x00, 0xC0, 0x4F, 0xD6, 0x44, 0x97]};
    const IID CLSID_CurrentUserClasses             = {0x32030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_CUtilityButton                 = {0xB0F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_d                              = {0x1F184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_DAArray                        = {0x4073DE9C, 0x203C, 0xD011, [0xA3, 0x30, 0x00, 0xAA, 0x00, 0xB9, 0x2C, 0x03]};
    const IID CLSID_DABbox2                        = {0x1E79B450, 0x3147, 0xD011, [0x89, 0x12, 0x00, 0xC0, 0x4F, 0xC2, 0xA0, 0xCA]};
    const IID CLSID_DABbox3                        = {0x0337934A, 0x6FE3, 0xD011, [0x9B, 0x99, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID CLSID_DABehavior                     = {0xF21B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DABoolean                      = {0x1DF9B025, 0x3DD2, 0xD011, [0x9B, 0x85, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID CLSID_DACamera                       = {0xD91B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAColor                        = {0xC91B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DADashStyle                    = {0x0CDCAD9C, 0x56AD, 0xD111, [0x9F, 0xF8, 0x00, 0xC0, 0x4F, 0xA3, 0x21, 0x95]};
    const IID CLSID_DAEndStyle                     = {0xABBE54FC, 0x125B, 0xD111, [0x8E, 0x7B, 0x00, 0xC0, 0x4F, 0xC2, 0x9D, 0x46]};
    const IID CLSID_DAEvent                        = {0xC487243E, 0x0987, 0xD011, [0xB1, 0x77, 0x00, 0xC0, 0x4F, 0xC2, 0xA0, 0xCA]};
    const IID CLSID_DAFontStyle                    = {0x1AA03D3F, 0x0547, 0xD011, [0x87, 0x10, 0x00, 0xC0, 0x4F, 0xC2, 0x9D, 0x46]};
    const IID CLSID_DAGeometry                     = {0xDB1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAImage                        = {0xCB1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAImportationResult            = {0xB3073828, 0x602C, 0xD011, [0xA3, 0x1D, 0x00, 0xAA, 0x00, 0xB9, 0x2C, 0x03]};
    const IID CLSID_DAJoinStyle                    = {0xAABE54FC, 0x125B, 0xD111, [0x8E, 0x7B, 0x00, 0xC0, 0x4F, 0xC2, 0x9D, 0x46]};
    const IID CLSID_DALineStyle                    = {0xB8073828, 0x602C, 0xD011, [0xA3, 0x1D, 0x00, 0xAA, 0x00, 0xB9, 0x2C, 0x03]};
    const IID CLSID_DAMatte                        = {0xC31B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAMicrophone                   = {0xE31B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAMontage                      = {0xD71B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DANumber                       = {0xC71B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAPair                         = {0x34FD0BBC, 0x1DD2, 0xD011, [0x93, 0x85, 0x00, 0xC0, 0x4F, 0xB6, 0xBD, 0x36]};
    const IID CLSID_DAPath2                        = {0xCF1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAPickableResult               = {0xD081F634, 0x4036, 0xCF11, [0x92, 0x94, 0x00, 0xAA, 0x00, 0xB8, 0xA7, 0x33]};
    const IID CLSID_DAPoint2                       = {0xD51B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAPoint3                       = {0xE51B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DarwinAppPublisher             = {0xA0C7CCCF, 0x82A2, 0xD111, [0x90, 0x82, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82]};
    const IID CLSID_DASound                        = {0xD11B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAStatics                      = {0xF31B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAString                       = {0xD31B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DataChannel                    = {0x156FB3BB, 0x8D40, 0x5640, [0x8C, 0x27, 0x92, 0x08, 0x43, 0xD4, 0x0B, 0xE5]};
    const IID CLSID_DATransform2                   = {0xDF1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DATransform3                   = {0xC51B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DATuple                        = {0xB7073828, 0x602C, 0xD011, [0xA3, 0x1D, 0x00, 0xAA, 0x00, 0xB9, 0x2C, 0x03]};
    const IID CLSID_DAUserData                     = {0xB4073828, 0x602C, 0xD011, [0xA3, 0x1D, 0x00, 0xAA, 0x00, 0xB9, 0x2C, 0x03]};
    const IID CLSID_DAVector2                      = {0xE11B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAVector3                      = {0xC01B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAView                         = {0xFF8E0D96, 0x94E4, 0xD111, [0xAB, 0x75, 0x00, 0xC0, 0x4F, 0xD9, 0x2B, 0x6B]};
    const IID CLSID_DAViewerControl                = {0xEB1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DAViewerControlWindowed        = {0xF11B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID CLSID_DCOMAccessControl              = {0x1D030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_DebugHelper                    = {0x60C0FC0B, 0x1D8C, 0xD011, [0xAC, 0xCD, 0x00, 0xAA, 0x00, 0x60, 0x27, 0x5C]};
    const IID CLSID_DeCompMimeFilter               = {0x60036B8F, 0x0DB8, 0xD011, [0xA9, 0xB3, 0x00, 0x60, 0x97, 0x94, 0x23, 0x11]};
    const IID CLSID_DefaultDebugSessionProvider    = {0xA2284183, 0xF451, 0xD011, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID CLSID_DirectDraw                     = {0xE00EB7D7, 0x4043, 0xCF11, [0xB0, 0x63, 0x00, 0x20, 0xAF, 0xC2, 0xCD, 0x35]};
    const IID CLSID_DirectDrawClipper              = {0xA0173859, 0xB37D, 0xCF11, [0xA2, 0xDE, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56]};
    const IID CLSID_DirectDrawFactory2             = {0x9047DCB9, 0xF14A, 0xD111, [0x8C, 0x4C, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5]};
    const IID CLSID_DirectInput                    = {0xE009E625, 0x59B2, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID CLSID_DirectInputDevice              = {0xE109E625, 0x59B2, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID CLSID_DirectMusic                    = {0x109F6B63, 0x7D0C, 0xD111, [0x95, 0xB2, 0x00, 0x20, 0xAF, 0xDC, 0x74, 0x21]};
    const IID CLSID_DirectMusicBand                = {0x009EBA79, 0xEEB6, 0xD111, [0x86, 0xBE, 0x00, 0xC0, 0x4F, 0xBF, 0x8F, 0xEF]};
    const IID CLSID_DirectMusicBandTrack           = {0x9428ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicChordMap            = {0x8F28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicChordMapTrack       = {0x9628ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicChordTrack          = {0x8B28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicCollection          = {0xB0F40F48, 0xB228, 0xD111, [0xBE, 0xF7, 0x00, 0xC0, 0x4F, 0xBF, 0x8F, 0xEF]};
    const IID CLSID_DirectMusicCommandTrack        = {0x8C28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicComposer            = {0x9028ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicGraph               = {0x8428ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicLoader              = {0x9228ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicMotifTrack          = {0x8E28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicMuteTrack           = {0x9828ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicPerformance         = {0x8128ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicSegment             = {0x8228ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicSegmentState        = {0x8328ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicSeqTrack            = {0x8628ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicSignPostTrack       = {0x72867EF1, 0xB4C3, 0xD111, [0x87, 0x0B, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicStyle               = {0x8A28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicStyleTrack          = {0x8D28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicSynth               = {0xD0B4C258, 0xE746, 0xD111, [0x89, 0xAC, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29]};
    const IID CLSID_DirectMusicSysExTrack          = {0x8728ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicTempoTrack          = {0x8528ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectMusicTimeSigTrack        = {0x8828ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID CLSID_DirectPlay                     = {0x206DEBD1, 0x2389, 0xD011, [0x9D, 0x97, 0x00, 0xA0, 0xC9, 0x0A, 0x43, 0xCB]};
    const IID CLSID_DirectPlayLobby                = {0x10F8E82F, 0xA5B2, 0xD011, [0xA7, 0x87, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC]};
    const IID CLSID_DirectSound                    = {0x46D9D447, 0xE862, 0xCF11, [0x93, 0xBC, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID CLSID_DirectSoundCapture             = {0x800721B0, 0xCD89, 0xD011, [0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16]};
    const IID CLSID_DispatchMapper                 = {0x965222E9, 0x59C7, 0xD111, [0xA0, 0x2B, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID CLSID_DNWithBinary                   = {0xA3C0997E, 0x35F9, 0xD211, [0xBA, 0x96, 0x00, 0xC0, 0x4F, 0xB6, 0xD0, 0xD1]};
    const IID CLSID_DNWithString                   = {0xCC574833, 0x34F9, 0xD211, [0xBA, 0x96, 0x00, 0xC0, 0x4F, 0xB6, 0xD0, 0xD1]};
    const IID CLSID_DocFileColumnProvider          = {0x014FF124, 0x1C7B, 0xD111, [0x83, 0x8F, 0x00, 0x00, 0xF8, 0x04, 0x61, 0xCF]};
    const IID CLSID_DocHostUIHandler               = {0x52E95770, 0x1BBD, 0xD111, [0x89, 0x19, 0x00, 0xC0, 0x4F, 0xC2, 0xC8, 0x36]};
    const IID CLSID_DOMChildrenCollection          = {0xAAF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_DOMDocument                    = {0x90BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID CLSID_DOMFreeThreadedDocument        = {0x91BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID CLSID_DragDropHelper                 = {0x8A275746, 0x1B41, 0xD211, [0x83, 0x9A, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0]};
    const IID CLSID_DriveSizeCategorizer           = {0x537B3594, 0x29CA, 0x784B, [0x83, 0xAE, 0xE8, 0xFE, 0x74, 0x09, 0x13, 0x4F]};
    const IID CLSID_DriveTypeCategorizer           = {0xCFF3A8B0, 0x3343, 0xAB4B, [0x88, 0x73, 0x1C, 0xCB, 0x1C, 0xAD, 0xA4, 0x8B]};
    const IID CLSID_DsDisplaySpecifier             = {0xC0A8B41A, 0x0B6A, 0xD211, [0xAD, 0x49, 0x00, 0xC0, 0x4F, 0xA3, 0x1A, 0x86]};
    const IID CLSID_DsDomainTreeBrowser            = {0x0A799816, 0xB4E2, 0xD011, [0xB0, 0xB1, 0x00, 0xC0, 0x4F, 0xD8, 0xDC, 0xA6]};
    const IID CLSID_DsFindAdvanced                 = {0xE33FEE83, 0xD957, 0xD011, [0xB9, 0x32, 0x00, 0xA0, 0x24, 0xAB, 0x2D, 0xBB]};
    const IID CLSID_DsFindComputer                 = {0x00670016, 0xAD87, 0xD011, [0x91, 0x40, 0x00, 0xAA, 0x00, 0xC1, 0x6E, 0x65]};
    const IID CLSID_DsFindContainer                = {0xF2CBB3C1, 0x6A88, 0xD011, [0x91, 0x40, 0x00, 0xAA, 0x00, 0xC1, 0x6E, 0x65]};
    const IID CLSID_DsFindDomainController         = {0x7E7B8C53, 0x5ED2, 0xD011, [0x97, 0x42, 0x00, 0xA0, 0xC9, 0x06, 0xAF, 0x45]};
    const IID CLSID_DsFindFrsMembers               = {0x184BCE94, 0xD3B3, 0xD111, [0xB9, 0xB4, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0xB0]};
    const IID CLSID_DsFindObjects                  = {0xE13FEE83, 0xD957, 0xD011, [0xB9, 0x32, 0x00, 0xA0, 0x24, 0xAB, 0x2D, 0xBB]};
    const IID CLSID_DsFindPeople                   = {0xE23FEE83, 0xD957, 0xD011, [0xB9, 0x32, 0x00, 0xA0, 0x24, 0xAB, 0x2D, 0xBB]};
    const IID CLSID_DsFindPrinter                  = {0x70F077B5, 0xE27E, 0xD011, [0x91, 0x3F, 0x00, 0xAA, 0x00, 0xC1, 0x6E, 0x65]};
    const IID CLSID_DsFindVolume                   = {0xF1CBB3C1, 0x6A88, 0xD011, [0x91, 0x40, 0x00, 0xAA, 0x00, 0xC1, 0x6E, 0x65]};
    const IID CLSID_DsFolderProperties             = {0xD0E0519E, 0x0F6E, 0xD211, [0x96, 0x01, 0x00, 0xC0, 0x4F, 0xA3, 0x1A, 0x86]};
    const IID CLSID_DsPropertyPages                = {0x30D5450D, 0x4B76, 0xD011, [0xA1, 0xCA, 0x00, 0xAA, 0x00, 0xC1, 0x6E, 0x65]};
    const IID CLSID_DsQuery                        = {0x5EE6238A, 0xC231, 0xD011, [0x89, 0x1C, 0x00, 0xA0, 0x24, 0xAB, 0x2D, 0xBB]};
    const IID CLSID_DWbemClassObject               = {0x5137AB64, 0xBC12, 0xD111, [0x9E, 0x61, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID CLSID_DWbemContext                   = {0x12F22F75, 0xB7F7, 0xD011, [0x9E, 0x4D, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID CLSID_DWbemLocator                   = {0x32A07CCB, 0x29F7, 0xD011, [0x9E, 0x4D, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID CLSID_DX2D                           = {0x0BA83A47, 0x7745, 0xD111, [0x81, 0xA8, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID CLSID_DXFade                         = {0xC580B216, 0x70EE, 0xD111, [0x90, 0x66, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID CLSID_DXGradient                     = {0x705436C6, 0x67F6, 0xD111, [0x90, 0x67, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID CLSID_DXLUTBuilder                   = {0x3B33541E, 0x002A, 0xD111, [0x81, 0x98, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID CLSID_DXRasterizer                   = {0x55CE5286, 0x809E, 0xD111, [0x90, 0x53, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID CLSID_DXSurface                      = {0x830F890E, 0x795F, 0xD111, [0x90, 0x43, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID CLSID_DXSurfaceModifier              = {0x1D9F663E, 0x239C, 0xD111, [0x90, 0x53, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID CLSID_DXTAlpha                       = {0x82CBC6AD, 0x4C42, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID CLSID_DXTAlphaImageLoader            = {0xDEFB7E0C, 0x0303, 0x6F4C, [0xA4, 0xF7, 0x31, 0xFA, 0x2B, 0xE5, 0xE3, 0x97]};
    const IID CLSID_DXTAlphaImageLoaderPP          = {0x2DCE808C, 0x0D85, 0xDA47, [0x8E, 0xCD, 0x55, 0x02, 0x35, 0x62, 0xD1, 0x67]};
    const IID CLSID_DXTAlphaPP                     = {0xE0A787D6, 0xA44B, 0xD211, [0x8A, 0xDE, 0x00, 0xA0, 0xC9, 0x8E, 0x65, 0x27]};
    const IID CLSID_DXTaskManager                  = {0x036CB24C, 0x93FF, 0xD011, [0x81, 0x7E, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID CLSID_DXTBarn                        = {0x7DA19BEC, 0xB560, 0x2B46, [0xA6, 0xD8, 0x14, 0xB8, 0x90, 0x57, 0xE2, 0x2A]};
    const IID CLSID_DXTBlinds                      = {0x514A4A9A, 0x3AFB, 0x4B4F, [0x9B, 0x57, 0xA2, 0x91, 0x2A, 0x28, 0x97, 0x69]};
    const IID CLSID_DXTCheckerBoard                = {0x0278EEB3, 0x2482, 0x8747, [0xA1, 0xEA, 0xF0, 0xDE, 0x16, 0xDE, 0xAB, 0xD3]};
    const IID CLSID_DXTCheckerBoardPP              = {0x2575F4CB, 0xD298, 0xEA45, [0xB8, 0x43, 0xFD, 0x21, 0x3D, 0x93, 0x2B, 0x10]};
    const IID CLSID_DXTChroma                      = {0xC1161542, 0xF83C, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID CLSID_DXTChromaPP                    = {0x60077EEC, 0x764C, 0xD211, [0x8A, 0xDE, 0x00, 0xA0, 0xC9, 0x8E, 0x65, 0x27]};
    const IID CLSID_DXTComposite                   = {0x44A8439A, 0x3108, 0xD111, [0x81, 0x7F, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID CLSID_DXTConvolution                 = {0x29EFC02B, 0xBAE6, 0xD111, [0x81, 0xDD, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID CLSID_DXTDropShadow                  = {0x86CBC6AD, 0x4C42, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID CLSID_DXTDropShadowPP                = {0x61077EEC, 0x764C, 0xD211, [0x8A, 0xDE, 0x00, 0xA0, 0xC9, 0x8E, 0x65, 0x27]};
    const IID CLSID_DXTFilter                      = {0xBC915A38, 0x8A1E, 0x4A4E, [0xA7, 0xA6, 0xF4, 0xFC, 0x1E, 0x6C, 0xA1, 0xBD]};
    const IID CLSID_DXTFilterBehavior              = {0x1EEC9E64, 0x79B5, 0x8C4E, [0xBB, 0x3B, 0x49, 0x97, 0xF8, 0x42, 0x65, 0x36]};
    const IID CLSID_DXTFilterCollection            = {0x347FEEA7, 0xD13B, 0x7F42, [0x92, 0x31, 0xF9, 0x41, 0xE9, 0xB7, 0xE1, 0xFE]};
    const IID CLSID_DXTFilterFactory               = {0x04723981, 0x1AF5, 0x7145, [0x8D, 0x7B, 0xDC, 0x03, 0x05, 0x21, 0xAA, 0xBD]};
    const IID CLSID_DXTGlow                        = {0x21648E9F, 0x9B3D, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID CLSID_DXTGlowPP                      = {0x64077EEC, 0x764C, 0xD211, [0x8A, 0xDE, 0x00, 0xA0, 0xC9, 0x8E, 0x65, 0x27]};
    const IID CLSID_DXTGradientD                   = {0x82283E62, 0x0EFC, 0xD111, [0x9A, 0x77, 0x00, 0x00, 0xF8, 0x75, 0x6A, 0x10]};
    const IID CLSID_DXTGradientWipe                = {0xA2676FB9, 0xC230, 0xE847, [0xBD, 0x85, 0x70, 0xA2, 0xC9, 0x48, 0xB5, 0x0F]};
    const IID CLSID_DXTICMFilter                   = {0x70B3BFA1, 0x9F5A, 0x2944, [0xBB, 0x72, 0xB1, 0x3E, 0x2F, 0xEA, 0xED, 0xEF]};
    const IID CLSID_DXTICMFilterPP                 = {0x12FB5819, 0xE631, 0xE547, [0xAA, 0x49, 0xB2, 0x3D, 0x12, 0xC8, 0x53, 0xE6]};
    const IID CLSID_DXTInset                       = {0xF263F376, 0x9F7E, 0xD74E, [0xA6, 0xA7, 0xEE, 0x30, 0x35, 0x1B, 0x66, 0x28]};
    const IID CLSID_DXTIris                        = {0xE62C9F04, 0x96D9, 0x2147, [0x89, 0x7A, 0xDB, 0x15, 0xCE, 0x9E, 0xB7, 0x3D]};
    const IID CLSID_DXTLabel                       = {0x35257054, 0x0626, 0xD111, [0x99, 0x9C, 0x00, 0x00, 0xF8, 0x75, 0x6A, 0x10]};
    const IID CLSID_DXTLight                       = {0xC2BEEFF9, 0x0243, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID CLSID_DXTLightPP                     = {0x5FF24A69, 0x4D12, 0xD311, [0x91, 0xD5, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID CLSID_DXTMaskFilter                  = {0x3BD9043A, 0xDD1E, 0x3F4F, [0xA3, 0x75, 0xA0, 0x3E, 0xC1, 0x95, 0x72, 0xC4]};
    const IID CLSID_DXTMatrix                      = {0x065ABF4A, 0x6855, 0x3448, [0xBE, 0xE3, 0x32, 0x7A, 0x6D, 0x95, 0xA6, 0x85]};
    const IID CLSID_DXTMatrixPP                    = {0x3A1091C5, 0xA8B3, 0x474D, [0xA3, 0xF7, 0x2A, 0xEE, 0xE4, 0xB8, 0x01, 0x3F]};
    const IID CLSID_DXTMetaBurnFilm                = {0xD1457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaCenterPeel              = {0x0C4D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID CLSID_DXTMetaColorFade               = {0x08C9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaFlowMotion              = {0x0BC9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaGriddler                = {0x11C9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaGriddler2               = {0x13C9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaJaws                    = {0x04C9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaLightWipe               = {0xC8457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaLiquid                  = {0x0A4D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID CLSID_DXTMetaPageTurn                = {0x084D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID CLSID_DXTMetaPeelPiece               = {0x104D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID CLSID_DXTMetaPeelSmall               = {0x0E4D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID CLSID_DXTMetaPeelSplit               = {0x124D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID CLSID_DXTMetaRadialScaleWipe         = {0xCA457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaRipple                  = {0x034D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID CLSID_DXTMetaRoll                    = {0x6EF4619C, 0x3005, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID CLSID_DXTMetaThreshold               = {0x15C9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaTwister                 = {0xCF457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaVacuum                  = {0x0DC9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaWater                   = {0xC5457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaWhiteOut                = {0xCC457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID CLSID_DXTMetaWormHole                = {0x22E06A0E, 0x830C, 0xD211, [0x8C, 0xD4, 0x00, 0x10, 0x4B, 0xC7, 0x5D, 0x9A]};
    const IID CLSID_DXTMotionBlur                  = {0x77DE13DD, 0xBAD3, 0xD442, [0xB5, 0xC6, 0x77, 0x45, 0xFA, 0x4E, 0x2D, 0x4B]};
    const IID CLSID_DXTMotionBlurPP                = {0xE1336492, 0x8F7F, 0xC64B, [0xBE, 0xC4, 0x8C, 0x12, 0x6C, 0x6B, 0x7D, 0xC4]};
    const IID CLSID_DXTRadialWipe                  = {0xA9844416, 0xD935, 0xB74F, [0x9F, 0xAB, 0x48, 0x27, 0x3B, 0x96, 0xAA, 0x1D]};
    const IID CLSID_DXTRandomBars                  = {0xB700772E, 0xC427, 0x7F43, [0x9F, 0xBF, 0x1E, 0x8B, 0xE2, 0x81, 0x75, 0x66]};
    const IID CLSID_DXTRandomBarsPP                = {0x11AEE6E3, 0xDC7F, 0xC440, [0xAF, 0xBF, 0x1D, 0xCE, 0xA8, 0x28, 0x62, 0xCC]};
    const IID CLSID_DXTRandomDissolve              = {0xB6A1F4F7, 0x878E, 0x2F45, [0xA2, 0xD7, 0x30, 0x77, 0xF5, 0x08, 0xDB, 0xC0]};
    const IID CLSID_DXTransformFactory             = {0x6267FED1, 0x48FC, 0xD011, [0x88, 0x3A, 0x3C, 0x8B, 0x00, 0xC1, 0x00, 0x00]};
    const IID CLSID_DXTRedirect                    = {0x287BB042, 0x8022, 0x3749, [0xB0, 0x35, 0x02, 0x93, 0xFB, 0x81, 0x27, 0x81]};
    const IID CLSID_DXTRevealTrans                 = {0xC4871EE3, 0xEA86, 0x4049, [0x9B, 0x8A, 0x5B, 0xD5, 0xD1, 0x79, 0xA7, 0x37]};
    const IID CLSID_DXTScale                       = {0xE2785255, 0xDB05, 0xD111, [0x88, 0x3A, 0x3C, 0x8B, 0x00, 0xC1, 0x00, 0x00]};
    const IID CLSID_DXTShadow                      = {0x63401BE7, 0x593E, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID CLSID_DXTShadowPP                    = {0x65077EEC, 0x764C, 0xD211, [0x8A, 0xDE, 0x00, 0xA0, 0xC9, 0x8E, 0x65, 0x27]};
    const IID CLSID_DXTSlide                       = {0xE7A1C5D1, 0x47CC, 0x324E, [0xBD, 0xD2, 0x4B, 0x3C, 0x5F, 0xC5, 0x0A, 0xF5]};
    const IID CLSID_DXTSpiral                      = {0xB9DC034A, 0x176E, 0x394A, [0x88, 0x45, 0x4E, 0xE7, 0xDC, 0x53, 0x31, 0xA5]};
    const IID CLSID_DXTStretch                     = {0x73DE88F0, 0xD0BD, 0x3C4E, [0x81, 0xF8, 0x6D, 0x32, 0xF4, 0xFE, 0x9D, 0x28]};
    const IID CLSID_DXTStrips                      = {0xFCB1A463, 0x9A25, 0x5B4A, [0x81, 0x29, 0xA8, 0x3B, 0x8C, 0x9E, 0x6F, 0x4F]};
    const IID CLSID_DXTStripsPP                    = {0xEEB7C0FE, 0xEC7A, 0x6740, [0x9E, 0xE1, 0xFA, 0xCF, 0xB7, 0xCE, 0x9A, 0xF9]};
    const IID CLSID_DXTWave                        = {0x88CBC6AD, 0x4C42, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID CLSID_DXTWavePP                      = {0xC05624F1, 0x9E4C, 0xD211, [0x8A, 0xDE, 0x00, 0xA0, 0xC9, 0x8E, 0x65, 0x27]};
    const IID CLSID_DXTWipe                        = {0x309B27AF, 0xEB86, 0xD111, [0x81, 0xBF, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID CLSID_DXTWipePP                      = {0x084DFE7F, 0xFDFB, 0xD111, [0x9A, 0x77, 0x00, 0x00, 0xF8, 0x75, 0x6A, 0x10]};
    const IID CLSID_DXTZigzag                      = {0x2863E223, 0x2839, 0xF240, [0x95, 0xE5, 0x93, 0xCA, 0xD6, 0x90, 0x16, 0xEB]};
    const IID CLSID_EAPOLManager                   = {0xE46A12BA, 0x6621, 0xD111, [0xB1, 0xD0, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID CLSID_Email                          = {0x57A8928F, 0x8E47, 0xD111, [0xA3, 0xB4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_EnumAdapterInfo                = {0xCA42996F, 0xB1C1, 0xB54A, [0x93, 0xDA, 0x60, 0x58, 0x99, 0x1D, 0xC8, 0xF3]};
    const IID CLSID_EVENTQUEUE                     = {0x66F40F6E, 0x9E33, 0xD111, [0xBE, 0x5B, 0x00, 0xC0, 0x4F, 0xC9, 0xE2, 0xBB]};
    const IID CLSID_EXTENDEDERRORINFO              = {0xCF22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID CLSID_FadePP                         = {0xC680B216, 0x70EE, 0xD111, [0x90, 0x66, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID CLSID_FaxNumber                      = {0x152206A5, 0x8146, 0xD111, [0xA3, 0xB4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_FilePlaybackTerminal           = {0x4C91B90C, 0xCD79, 0xDC47, [0xAD, 0xB0, 0x32, 0x7F, 0x47, 0xCE, 0xFB, 0x20]};
    const IID CLSID_FileProtocol                   = {0xE7C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_FileRecordingTerminal          = {0x063D1F52, 0xD0C3, 0x1145, [0x86, 0x17, 0x86, 0xB9, 0xA7, 0x83, 0xDA, 0x77]};
    const IID CLSID_FileRecordingTrack             = {0xE4A214BF, 0x8BE8, 0xF54E, [0x97, 0x40, 0x5A, 0xC5, 0xD0, 0x22, 0xF8, 0xC9]};
    const IID CLSID_FileSearchBand                 = {0xF331EEC4, 0x6847, 0xD211, [0xBE, 0x5C, 0x00, 0xA0, 0xC9, 0xA8, 0x3D, 0xA1]};
    const IID CLSID_FileSysColumnProvider          = {0xC4742E0D, 0x343C, 0xD211, [0xA2, 0x7E, 0x00, 0xC0, 0x4F, 0xC3, 0x08, 0x71]};
    const IID CLSID_FileTerminal                   = {0xF178F5AA, 0x70DC, 0xD011, [0x8E, 0xD3, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID CLSID_FolderShortcut                 = {0xD1CEFA0A, 0x28E8, 0xD111, [0x91, 0x87, 0xB5, 0x32, 0xF1, 0xE9, 0x57, 0x5D]};
    const IID CLSID_FolderViewHost                 = {0x23CBB120, 0x6869, 0xB94E, [0xB7, 0xD4, 0xA6, 0x6D, 0x00, 0xD0, 0x7C, 0xEE]};
    const IID CLSID_FontNames                      = {0x3AF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_FramesCollection               = {0xF6F75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_FreeSpaceCategorizer           = {0x937760B5, 0xAC24, 0xC744, [0x82, 0xE2, 0x83, 0x17, 0x26, 0xAA, 0x6C, 0xB7]};
    const IID CLSID_FtpProtocol                    = {0xE3C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_GblComponentCategoriesMgr      = {0x06E00200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_GLOBAL_BROADCAST               = {0x10184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_GopherProtocol                 = {0xE4C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_GradientPP                     = {0x80283E62, 0x0EFC, 0xD111, [0x9A, 0x77, 0x00, 0x00, 0xF8, 0x75, 0x6A, 0x10]};
    const IID CLSID_HandsetTerminal                = {0xEB78F5AA, 0x70DC, 0xD011, [0x8E, 0xD3, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID CLSID_HeadsetTerminal                = {0xED78F5AA, 0x70DC, 0xD011, [0x8E, 0xD3, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID CLSID_HNetCfgMgr                     = {0xAA66C146, 0x0831, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID CLSID_Hold                           = {0x133EADB3, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_HomeNetAutoConfigService       = {0xB5A38E9A, 0x2E57, 0xB34C, [0x9E, 0xB9, 0xEC, 0x68, 0x9A, 0xC5, 0x75, 0xAE]};
    const IID CLSID_HomePage                       = {0xAEF26B76, 0x50D6, 0xD111, [0x98, 0x11, 0x00, 0xC0, 0x4F, 0xC3, 0x1D, 0x2E]};
    const IID CLSID_HostDialogHelper               = {0x2CF99A42, 0x1FA5, 0xD211, [0x86, 0x1E, 0x00, 0xC0, 0x4F, 0xA3, 0x5C, 0x89]};
    const IID CLSID_HTADocument                    = {0xC8F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTCAttachBehavior              = {0xF5F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTCDefaultDispatch             = {0xFCF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTCDescBehavior                = {0xDDF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTCEventBehavior               = {0xFEF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTCMethodBehavior              = {0x30F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTCPropertyBehavior            = {0xDEF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLAnchorElement              = {0x48F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLAppBehavior                = {0xCBF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLApplication                = {0xD8F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLAreaElement                = {0x83F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLAreasCollection            = {0xCAF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLAttributeCollection        = {0xCCF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLBaseElement                = {0x76F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLBaseFontElement            = {0x82F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLBGsound                    = {0x70F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLBlockElement               = {0x81F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLBody                       = {0x4AF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLBRElement                  = {0x80F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLButtonElement              = {0xC6F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLCommentElement             = {0x17F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLCurrentStyle               = {0xDCF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLDDElement                  = {0x7FF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLDefaults                   = {0xC8F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLDialog                     = {0x8AF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLDivElement                 = {0x7EF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLDivPosition                = {0x49F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HtmlDlgSafeHelper              = {0x19F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLDListElement               = {0x7DF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLDocument                   = {0x20693325, 0xF903, 0xCF11, [0x8F, 0xD0, 0x00, 0xAA, 0x00, 0x68, 0x6F, 0x13]};
    const IID CLSID_HTMLDOMAttribute               = {0xB2F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLDOMImplementation          = {0x0EF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLDOMTextNode                = {0xBAF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLDTElement                  = {0x7CF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLElementCollection          = {0xCBF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLEmbed                      = {0x5DF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLFieldSetElement            = {0xE8F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLFontElement                = {0x7BF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLFormElement                = {0x51F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLFrameBase                  = {0x12F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLFrameElement               = {0x14F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLFrameSetSite               = {0x1AF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLGenericElement             = {0xB8F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLHeadElement                = {0x93F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLHeaderElement              = {0x7AF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLHistory                    = {0xA3AACEFE, 0x0584, 0xCF11, [0x8B, 0xA1, 0x00, 0xAA, 0x00, 0x47, 0x6D, 0xA6]};
    const IID CLSID_HTMLHRElement                  = {0x52F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLHtmlElement                = {0x91F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLIFrame                     = {0x16F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLImageElementFactory        = {0x8FF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLImg                        = {0x41F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLInputButtonElement         = {0xB4F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLInputElement               = {0xD8F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLInputFileElement           = {0xAEF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLInputImage                 = {0xC4F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLInputTextElement           = {0xABF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLIsIndexElement             = {0x78F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLLabelElement               = {0x2BF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLLegendElement              = {0xE9F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLLIElement                  = {0x73F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLLinkElement                = {0x77F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLListElement                = {0x72F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLLoadOptions                = {0x40508418, 0xA50F, 0xD111, [0xBA, 0x19, 0x00, 0xC0, 0x4F, 0xD9, 0x12, 0xD0]};
    const IID CLSID_HTMLLocation                   = {0xE1B13B16, 0x006E, 0xCF11, [0x83, 0x7A, 0x48, 0xDC, 0x04, 0xC1, 0x00, 0x00]};
    const IID CLSID_HTMLMapElement                 = {0x71F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLMarqueeElement             = {0xB9F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLMetaElement                = {0x75F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLNamespace                  = {0xBCF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLNamespaceCollection        = {0xB9F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLNavigator                  = {0xA6AACEFE, 0x0584, 0xCF11, [0x8B, 0xA1, 0x00, 0xAA, 0x00, 0x47, 0x6D, 0xA6]};
    const IID CLSID_HTMLNextIdElement              = {0x79F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLNoShowElement              = {0x8BF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLObjectElement              = {0x4EF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLOListElement               = {0x70F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLOptionButtonElement        = {0xBEF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLOptionElement              = {0x4DF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLOptionElementFactory       = {0x8DF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLParaElement                = {0x6FF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLParamElement               = {0x3EF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLPhraseElement              = {0x6EF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLPluginDocument             = {0x21693325, 0xF903, 0xCF11, [0x8F, 0xD0, 0x00, 0xAA, 0x00, 0x68, 0x6F, 0x13]};
    const IID CLSID_HTMLPopup                      = {0x67F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLRenderStyle                = {0xAAF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLRichtextElement            = {0xDFF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLRuleStyle                  = {0xD0F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLScreen                     = {0x5DF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLScriptElement              = {0x8CF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLSelectElement              = {0x45F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLSpanElement                = {0xF5F35030, 0xB498, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLSpanFlow                   = {0xE6F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLStyle                      = {0x85F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLStyleElement               = {0x7DF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLStyleFontFace              = {0xD4F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLStyleSheet                 = {0xE4F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLStyleSheetPage             = {0xEFF75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLStyleSheetPagesCollection  = {0xF1F75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLStyleSheetRule             = {0xCEF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLStyleSheetRulesCollection  = {0xCDF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLStyleSheetsCollection      = {0x7FF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLTable                      = {0x6BF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLTableCaption               = {0xECF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLTableCell                  = {0x46F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLTableCol                   = {0x6CF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLTableRow                   = {0x6DF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLTableSection               = {0xE9F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLTextAreaElement            = {0xACF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLTextElement                = {0x6AF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLTitleElement               = {0x84F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLUListElement               = {0x69F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLUnknownElement             = {0x68F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLUrnCollection              = {0x80F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HTMLWindow2                    = {0xC66E8AD4, 0x4A6A, 0xCF11, [0x94, 0xA7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID CLSID_HTMLWindowProxy                = {0x91F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_HttpProtocol                   = {0xE2C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_HttpSProtocol                  = {0xE5C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_HWShellExecute                 = {0x5F65B8FF, 0xB981, 0xCE4F, [0xB8, 0x9C, 0x9A, 0x6B, 0xA7, 0x6D, 0x13, 0xE7]};
    const IID CLSID_IActiveXSafetyProvider         = {0xCEC6F8AA, 0x72F9, 0xD011, [0x97, 0xEB, 0x00, 0xAA, 0x00, 0x61, 0x53, 0x33]};
    const IID CLSID_IImageDecodeFilter             = {0xE8D47F60, 0x030A, 0xD111, [0xAB, 0x1D, 0x00, 0xC0, 0x4F, 0xC9, 0xB3, 0x04]};
    const IID CLSID_IImgCtx                        = {0xD6F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_ImageList                      = {0xA26B477C, 0xB102, 0xF448, [0x80, 0x48, 0xB2, 0x46, 0x19, 0xDD, 0xC0, 0x58]};
    const IID CLSID_ImageProperties                = {0xC770B77A, 0x230E, 0x7A4D, [0x8A, 0xA2, 0x19, 0xBF, 0xAD, 0x47, 0x98, 0x29]};
    const IID CLSID_InProcFreeMarshaler            = {0x3A030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_IntDitherer                    = {0x1AFEF605, 0xEFEC, 0xD011, [0xAA, 0xE7, 0x00, 0xC0, 0x4F, 0xC9, 0xB3, 0x04]};
    const IID CLSID_IntelliForms                   = {0x2EB93A61, 0xBF16, 0xD211, [0xBC, 0xA5, 0x00, 0xC0, 0x4F, 0xD9, 0x29, 0xDB]};
    const IID CLSID_Internet                       = {0x80531C87, 0xA042, 0x6910, [0xA2, 0xEA, 0x08, 0x00, 0x2B, 0x30, 0x30, 0x9D]};
    const IID CLSID_InternetButtons                = {0x8069791E, 0xC59C, 0xD111, [0xA8, 0x3F, 0x00, 0xC0, 0x4F, 0xC9, 0x9D, 0x61]};
    const IID CLSID_InternetConnectionBeaconServic = {0x3A61DF04, 0x1056, 0xD411, [0x9E, 0xC8, 0x00, 0xB0, 0xD0, 0x22, 0xDD, 0x1F]};
    const IID CLSID_InternetExplorer               = {0x01DF0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_InternetPrintOrdering          = {0xA86AD3AD, 0x1A75, 0x7945, [0xA2, 0x66, 0xD6, 0x6F, 0x52, 0x02, 0xCC, 0xBB]};
    const IID CLSID_InternetSecurityManager        = {0x942D8A7B, 0xC90A, 0xD111, [0x89, 0x6C, 0x00, 0xC0, 0x4F, 0xB6, 0xBF, 0xC4]};
    const IID CLSID_InternetShortcut               = {0x403BF2FB, 0xF0E3, 0x1B10, [0x84, 0x88, 0x00, 0xAA, 0x00, 0x3E, 0x56, 0xF8]};
    const IID CLSID_InternetZoneManager            = {0x952D8A7B, 0xC90A, 0xD111, [0x89, 0x6C, 0x00, 0xC0, 0x4F, 0xB6, 0xBF, 0xC4]};
    const IID CLSID_LanConnectionManager           = {0xD36A12BA, 0x6621, 0xD111, [0xB1, 0xD0, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID CLSID_LargeInteger                   = {0xF5717992, 0x3909, 0xD111, [0x8B, 0xE1, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID CLSID_LDAPConnectionObject           = {0xC4A9A27D, 0x460C, 0xBD43, [0xB0, 0x4E, 0xD9, 0x2B, 0x1B, 0xE2, 0x7C, 0x45]};
    const IID CLSID_LDAPObject                     = {0x78987005, 0x9551, 0x6C46, [0x9E, 0x64, 0x48, 0x7C, 0xE3, 0xCA, 0x20, 0xBF]};
    const IID CLSID_LinkColumnProvider             = {0x024FF124, 0x1C7B, 0xD111, [0x83, 0x8F, 0x00, 0x00, 0xF8, 0x04, 0x61, 0xCF]};
    const IID CLSID_LocalMachineClasses            = {0x31030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_LogManager                     = {0xA48FDA8F, 0x6387, 0x9F47, [0xB9, 0xB1, 0x22, 0x02, 0xB2, 0x80, 0xD2, 0x93]};
    const IID CLSID_LUTBuilderPP                   = {0x6236B325, 0x83FD, 0xD111, [0x8A, 0xDE, 0x44, 0x45, 0x53, 0x54, 0x00, 0x01]};
    const IID CLSID_MachineDebugManager            = {0x66360A0C, 0xC930, 0xD011, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID CLSID_MailAutoDiscovery              = {0xDDD58F00, 0xBB6D, 0xE348, [0x99, 0x1B, 0x2D, 0x3E, 0xD6, 0x58, 0x51, 0x6A]};
    const IID CLSID_MailProtocolADEntry            = {0xF3D6A561, 0x31C1, 0x354C, [0xBF, 0x40, 0x90, 0xA5, 0x0F, 0x21, 0x41, 0x22]};
    const IID CLSID_ManualResetEvent               = {0x2C030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_McastAddressAllocation         = {0xF2AE0DDF, 0x89A2, 0xD111, [0x86, 0x97, 0x00, 0x60, 0x08, 0xB0, 0xE5, 0xD2]};
    const IID CLSID_MediaStreamTerminal            = {0xF7AEF7E2, 0x7149, 0xD111, [0xA6, 0x71, 0x00, 0x60, 0x97, 0xC9, 0xA2, 0xE8]};
    const IID CLSID_MergedCategorizer              = {0x117C828E, 0xE733, 0xC14B, [0xB2, 0x42, 0x8C, 0xD9, 0xA1, 0xC2, 0xB3, 0x04]};
    const IID CLSID_MHTMLDocument                  = {0xD9F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_MicrophoneTerminal             = {0xEF78F5AA, 0x70DC, 0xD011, [0x8E, 0xD3, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID CLSID_MicrosoftDS                    = {0xF09012FE, 0xBDCF, 0xCF11, [0xA3, 0x30, 0x00, 0xAA, 0x00, 0xC1, 0x6E, 0x65]};
    const IID CLSID_MigrationWizardAuto            = {0x851D3367, 0x17BE, 0xF642, [0x8D, 0x3F, 0x47, 0xB8, 0xE8, 0xB2, 0x66, 0x37]};
    const IID CLSID_MkProtocol                     = {0xE6C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_MofCompiler                    = {0x5797AF6D, 0x372E, 0xD211, [0xAE, 0xC9, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID CLSID_MountedVolume                  = {0x93845112, 0xB200, 0xD211, [0x9F, 0xA5, 0x9E, 0x34, 0x20, 0x52, 0x41, 0x53]};
    const IID CLSID_MSBurnEngineObj                = {0x67CA0C52, 0xA551, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID CLSID_MSDATT                         = {0xCE22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID CLSID_MSDAVTM                        = {0x8E3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID CLSID_MSDiscMasterObj                = {0x63CA0C52, 0xA551, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID CLSID_MSDiscRecorderObj              = {0x61CA0C52, 0xA551, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID CLSID_MSDiscStashObj                 = {0x65CA0C52, 0xA551, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID CLSID_MSEnumDiscRecordersObj         = {0x7A56038A, 0xCB63, 0xA84B, [0xBA, 0xF6, 0x52, 0x11, 0x98, 0x16, 0xD1, 0xEF]};
    const IID CLSID_MSOButtons                     = {0xB8348F17, 0x82A2, 0xD211, [0x86, 0xC5, 0x00, 0xC0, 0x4F, 0x8E, 0xEA, 0x99]};
    const IID CLSID_MyComputer                     = {0xE04FD020, 0xEA3A, 0x6910, [0xA2, 0xD8, 0x08, 0x00, 0x2B, 0x30, 0x30, 0x9D]};
    const IID CLSID_MyDocuments                    = {0xBA8F0D45, 0x25AD, 0xD011, [0x98, 0xA8, 0x08, 0x00, 0x36, 0x1B, 0x11, 0x03]};
    const IID CLSID_NameTranslate                  = {0x1FAE4F27, 0x2636, 0xD111, [0xA3, 0xA4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_NetAddress                     = {0x4712B7B0, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_NetConnectionHNetUtil          = {0xE36A12BA, 0x6621, 0xD111, [0xB1, 0xD0, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID CLSID_NetConnectionUiUtilities       = {0xD3AC0770, 0x0232, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID CLSID_NetCrawler                     = {0xDCC31A60, 0x6A78, 0xB04E, [0xBF, 0x40, 0xEE, 0x35, 0x21, 0xE7, 0x0B, 0xFB]};
    const IID CLSID_NetSharingManager              = {0xADC1635C, 0x5639, 0xF84F, [0x84, 0x86, 0x40, 0x03, 0x47, 0x58, 0x31, 0x5B]};
    const IID CLSID_NetworkDomain                  = {0x8066E046, 0xF04B, 0xD111, [0x83, 0xEE, 0x00, 0xA0, 0xC9, 0x0D, 0xC8, 0x49]};
    const IID CLSID_NetworkPlaces                  = {0x602C8D20, 0xEA3A, 0x6910, [0xA2, 0xD7, 0x08, 0x00, 0x2B, 0x30, 0x30, 0x9D]};
    const IID CLSID_NetworkServer                  = {0x902A54C0, 0xF04B, 0xD111, [0x83, 0xEE, 0x00, 0xA0, 0xC9, 0x0D, 0xC8, 0x49]};
    const IID CLSID_NetworkShare                   = {0xC054A754, 0xF04B, 0xD111, [0x83, 0xEE, 0x00, 0xA0, 0xC9, 0x0D, 0xC8, 0x49]};
    const IID CLSID_NetworkType                    = {0x1BD5F3D4, 0x5517, 0x5349, [0x9C, 0x8B, 0x24, 0x95, 0xAB, 0xE5, 0xE0, 0x7E]};
    const IID CLSID_NodeType                       = {0x113DAA1A, 0x9247, 0xE444, [0x9D, 0x49, 0x78, 0xFE, 0xD3, 0x69, 0x1A, 0x14]};
    const IID CLSID_NotificaitonTest1              = {0x01E533C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_NotificaitonTest2              = {0x02E533C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_NotificaitonTest3              = {0x03E533C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_NotificaitonTest4              = {0x04E533C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_NotificationManager            = {0xD03D81E1, 0xDAAA, 0x3847, [0xB5, 0xFF, 0x96, 0xB4, 0x18, 0x9C, 0x50, 0x19]};
    const IID CLSID_ObjectManager                  = {0xBD615695, 0xA2CC, 0xAC4E, [0x91, 0xD0, 0xA0, 0x39, 0x6A, 0x28, 0xAE, 0xFD]};
    const IID CLSID_OctetList                      = {0x0F404112, 0x8046, 0xD111, [0xA3, 0xB4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_OldHTMLDocument                = {0xC96E8AD4, 0x4A6A, 0xCF11, [0x94, 0xA7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID CLSID_OldHTMLFormElement             = {0x85D2040D, 0xEC6B, 0xCF11, [0x8B, 0x97, 0x00, 0xAA, 0x00, 0x47, 0x6D, 0xA6]};
    const IID CLSID_OLEDB_CONVERSIONLIBRARY        = {0xD122B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID CLSID_OLEDB_ENUMERATOR               = {0xD022B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID CLSID_OLEDB_ROWPOSITIONLIBRARY       = {0xE6EE4820, 0xA27F, 0xD011, [0x9E, 0x6A, 0x00, 0xA0, 0xC9, 0x13, 0x8C, 0x29]};
    const IID CLSID_PassportClientServices         = {0xC807232D, 0xB47D, 0xD640, [0x91, 0x00, 0xD5, 0x2A, 0xF4, 0xF9, 0x7A, 0x5B]};
    const IID CLSID_Path                           = {0x198953B2, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_Pathname                       = {0x780D0D08, 0x21F4, 0xD011, [0xA3, 0x6E, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_PeerFactory                    = {0xCFF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_PendingProxyConnection         = {0x5E8EA6D8, 0x372B, 0x6C42, [0xA3, 0x29, 0xC1, 0x17, 0xC1, 0x4C, 0x42, 0x9E]};
    const IID CLSID_PersistentDataChannel          = {0xAB549BBC, 0x8378, 0x134C, [0x90, 0x9F, 0x03, 0x3D, 0x03, 0x26, 0x79, 0x90]};
    const IID CLSID_PersistPropset                 = {0x21088FFB, 0x6401, 0x1B10, [0x84, 0xED, 0x08, 0x00, 0x2B, 0x2E, 0xC7, 0x13]};
    const IID CLSID_Picture_Dib                    = {0x16030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_Picture_EnhMetafile            = {0x19030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_Picture_Metafile               = {0x15030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_Pixelate                       = {0x34A6CE4C, 0xE0FB, 0xD111, [0x90, 0x6A, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID CLSID_PixelatePP                     = {0x35A6CE4C, 0xE0FB, 0xD111, [0x90, 0x6A, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID CLSID_PluggableSuperclassRegistratio = {0x328E91BB, 0x5C2A, 0x8649, [0xAB, 0x40, 0x16, 0x86, 0xA0, 0x34, 0x39, 0x0A]};
    const IID CLSID_PluggableTerminalRegistration  = {0x3E4E2345, 0xCC61, 0x1143, [0xA3, 0xAB, 0x24, 0x80, 0x82, 0x55, 0x44, 0x82]};
    const IID CLSID_PostAgent                      = {0x3020BDD8, 0xC96F, 0xD011, [0x86, 0x4F, 0x00, 0xAA, 0x00, 0x68, 0x09, 0xD9]};
    const IID CLSID_PostalAddress                  = {0xCDAF750A, 0x8046, 0xD111, [0xA3, 0xB4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_PrimaryControlChannel          = {0x0955EB3C, 0xCDC1, 0x2F43, [0x9D, 0x8F, 0x65, 0xD1, 0xE2, 0x86, 0xAA, 0x80]};
    const IID CLSID_Printers                       = {0x80A22722, 0xEA3A, 0x6910, [0xA2, 0xDE, 0x08, 0x00, 0x2B, 0x30, 0x30, 0x9D]};
    const IID CLSID_PROCESS_BROADCAST              = {0x11184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_ProcessDebugManager            = {0x2218A578, 0xF451, 0xD011, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID CLSID_ProgressDialog                 = {0x523838F8, 0xD3FC, 0xD111, [0xA6, 0xB9, 0x00, 0x60, 0x97, 0xDF, 0x5B, 0xD4]};
    const IID CLSID_PropertiesUI                   = {0xCFF812D9, 0x9603, 0x1549, [0x88, 0x4E, 0xFB, 0x42, 0x5D, 0x32, 0x94, 0x3B]};
    const IID CLSID_PropertyEntry                  = {0xC2EDD372, 0xC4A4, 0xD011, [0x85, 0x33, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID CLSID_PropertyValue                  = {0xB0389E7B, 0x7CA9, 0xD011, [0x85, 0x34, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID CLSID_PSBindCtx                      = {0x12030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_PSClassObject                  = {0x0E030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_PSClientSite                   = {0x0D030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_PSDragDrop                     = {0x11030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_PSEnumerators                  = {0x13030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_PseudoSink                     = {0xF0E402E0, 0xEAE6, 0xD211, [0x9C, 0xB3, 0x00, 0x10, 0x5A, 0x1F, 0x48, 0x01]};
    const IID CLSID_PSGenObject                    = {0x0C030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_PSInPlaceActive                = {0x0F030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_PSInPlaceFrame                 = {0x10030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_PSUrlMonProxy                  = {0xF1C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_PublishDropTarget              = {0xFBEF6ECC, 0xF643, 0xC546, [0x96, 0x19, 0x51, 0xD5, 0x71, 0x96, 0x7F, 0x7D]};
    const IID CLSID_PublishingWizard               = {0x3C16336B, 0xA576, 0x6C4B, [0xBF, 0x21, 0x45, 0xDE, 0x9C, 0xD5, 0x03, 0xA1]};
    const IID CLSID_QueryAssociations              = {0xFD3470A0, 0xAA6C, 0x5449, [0xAC, 0x3F, 0x97, 0xA2, 0x72, 0x16, 0xF9, 0x8A]};
    const IID CLSID_QueryCancelAutoPlay            = {0x68171F33, 0xA905, 0xDD4D, [0xB8, 0x6E, 0xDA, 0xE3, 0x4D, 0xDC, 0x99, 0x8A]};
    const IID CLSID_RecycleBin                     = {0x40F05F64, 0x8150, 0x1B10, [0x9F, 0x08, 0x00, 0xAA, 0x00, 0x2F, 0x95, 0x4E]};
    const IID CLSID_RemoteUnknownPSFactory         = {0x40030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_Rendezvous                     = {0x5B9E02F1, 0x5BCB, 0xD011, [0x8D, 0x59, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID CLSID_ReplicaPointer                 = {0xDFBAD1F5, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_Request                        = {0xB196C06B, 0xE60C, 0xD111, [0xBA, 0xAE, 0x00, 0xC0, 0x4F, 0xC2, 0xE2, 0x0D]};
    const IID CLSID_RequestMakeCall                = {0xE0FF48AC, 0xC4F8, 0xD111, [0xA0, 0x30, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID CLSID_ResProtocol                    = {0xBCF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_RTCClient                      = {0x29EA427A, 0xB7A2, 0xC440, [0xB0, 0x91, 0xF6, 0xF0, 0x24, 0xAA, 0x89, 0xBE]};
    const IID CLSID_Scriptlet                      = {0xAEFD24AE, 0xC603, 0xD111, [0x8B, 0x76, 0x00, 0x80, 0xC7, 0x44, 0xF3, 0x89]};
    const IID CLSID_SdoMachine                     = {0xE78A21E9, 0x919E, 0xD111, [0xBF, 0x60, 0x00, 0x80, 0xC7, 0x84, 0x6B, 0xC0]};
    const IID CLSID_SdpConferenceBlob              = {0xDD19279B, 0x96B6, 0xD011, [0xA4, 0x89, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID CLSID_SearchAssistantOC              = {0x30F05FB4, 0x4744, 0xD211, [0x85, 0xDE, 0x00, 0xC0, 0x4F, 0xA3, 0x5C, 0x89]};
    const IID CLSID_SearchCommand                  = {0x90E605B0, 0x8D67, 0xD111, [0xB7, 0x58, 0x00, 0xA0, 0xC9, 0x05, 0x64, 0xFE]};
    const IID CLSID_SecondaryControlChannel        = {0xA081317B, 0x2FC9, 0x6745, [0xB0, 0xFA, 0xCD, 0x9A, 0x10, 0xEC, 0xD7, 0xD1]};
    const IID CLSID_SecurityDescriptor             = {0x3CF758B9, 0xDD9B, 0xD011, [0x85, 0x2C, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID CLSID_SENS                           = {0xFECA97D5, 0x9F5B, 0xD111, [0x8D, 0xD2, 0x00, 0xAA, 0x00, 0x4A, 0xBD, 0x5E]};
    const IID CLSID_ServiceManager                 = {0x8A38D0AB, 0xC1DE, 0xF344, [0x98, 0xE1, 0x8D, 0x5C, 0xC8, 0x0B, 0x97, 0xEB]};
    const IID CLSID_SharingApplicationDefinition   = {0xB066C146, 0x0831, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID CLSID_SharingConfiguration           = {0xB166C146, 0x0831, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID CLSID_SharingManagerEnumApplicationDefiniti = {0xAE66C146, 0x0831, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID CLSID_SharingManagerEnumPortMapping  = {0xAF66C146, 0x0831, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID CLSID_SharingManagerEnumPrivateConnecti = {0xAD66C146, 0x0831, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID CLSID_SharingManagerEnumPublicConnecti = {0xAC66C146, 0x0831, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID CLSID_Shell                          = {0x20967013, 0x79C2, 0xCE11, [0xA4, 0x9E, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID CLSID_ShellBrowserWindow             = {0x90FD8AC0, 0xA1F2, 0xD111, [0x84, 0x55, 0x00, 0xA0, 0xC9, 0x1F, 0x38, 0x80]};
    const IID CLSID_ShellDesktop                   = {0x00140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_ShellDispatchInproc            = {0x60A8890A, 0xB1D7, 0xCE11, [0x83, 0x50, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID CLSID_ShellFolderItem                = {0xEA52E32F, 0x1FFD, 0xD211, [0xB1, 0xF4, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x3E]};
    const IID CLSID_ShellFolderView                = {0xA12A1162, 0xE4EB, 0xCF11, [0xA5, 0xFB, 0x00, 0x20, 0xAF, 0xE7, 0x29, 0x2D]};
    const IID CLSID_ShellFolderViewOC              = {0x7159A09B, 0xA8F6, 0xCF11, [0xA4, 0x42, 0x00, 0xA0, 0xC9, 0x0A, 0x8F, 0x39]};
    const IID CLSID_ShellFSFolder                  = {0xA04B36F3, 0xB965, 0xCE11, [0xA9, 0xBA, 0x00, 0xAA, 0x00, 0x4A, 0xE8, 0x37]};
    const IID CLSID_ShellImageDataFactory          = {0xFBE4E466, 0x85F3, 0xD04D, [0x8D, 0x74, 0xA2, 0xEF, 0xD1, 0xBC, 0x61, 0x78]};
    const IID CLSID_ShellLink                      = {0x01140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_ShellLinkObject                = {0x20942111, 0x6817, 0xD111, [0x95, 0xBE, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x4F]};
    const IID CLSID_ShellLocalMachine              = {0xAF4C6660, 0x0DAF, 0x0500, [0xA3, 0x00, 0x5C, 0x7D, 0x25, 0xFF, 0x22, 0xA0]};
    const IID CLSID_ShellLogonEnumUsers            = {0xAF4C6660, 0x0DAF, 0x0400, [0xA3, 0x00, 0x5C, 0x7D, 0x25, 0xFF, 0x22, 0xA0]};
    const IID CLSID_ShellLogonStatusHost           = {0xAF4C6660, 0x0DAF, 0x0700, [0xA3, 0x00, 0x5C, 0x7D, 0x25, 0xFF, 0x22, 0xA0]};
    const IID CLSID_ShellLogonUser                 = {0xAF4C6660, 0x0DAF, 0x0300, [0xA3, 0x00, 0x5C, 0x7D, 0x25, 0xFF, 0x22, 0xA0]};
    const IID CLSID_ShellNameSpace                 = {0x05681355, 0xDEB2, 0xD111, [0xB9, 0xF2, 0x00, 0xA0, 0xC9, 0x8B, 0xC5, 0x47]};
    const IID CLSID_ShellUIHelper                  = {0xB74BAB64, 0x1E11, 0xD111, [0x8F, 0x79, 0x00, 0xC0, 0x4F, 0xC2, 0xFB, 0xE1]};
    const IID CLSID_ShellWindows                   = {0x7259A09B, 0xA8F6, 0xCF11, [0xA4, 0x42, 0x00, 0xA0, 0xC9, 0x0A, 0x8F, 0x39]};
    const IID CLSID_SizeCategorizer                = {0x52B8D755, 0xD1F6, 0xF242, [0xAA, 0x75, 0x87, 0x28, 0xA1, 0xB2, 0xD2, 0x64]};
    const IID CLSID_SoftDistExt                    = {0xC08D5BB1, 0xE1C7, 0xD011, [0x86, 0x80, 0x00, 0xAA, 0x00, 0xBD, 0xCB, 0x71]};
    const IID CLSID_SpeakerphoneTerminal           = {0xEE78F5AA, 0x70DC, 0xD011, [0x8E, 0xD3, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID CLSID_SpeakersTerminal               = {0xF078F5AA, 0x70DC, 0xD011, [0x8E, 0xD3, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID CLSID_SpeechUIServer                 = {0x4B904314, 0xE434, 0xF640, [0xB3, 0x0F, 0x6B, 0xEB, 0x81, 0x26, 0x7B, 0x80]};
    const IID CLSID_StaticDib                      = {0x16030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_StaticMetafile                 = {0x15030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_StdAsyncActManager             = {0x29030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_StdComponentCategoriesMgr      = {0x05E00200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_StdEncodingFilterFac           = {0xD07CC354, 0x44D9, 0xD011, [0xA9, 0xF4, 0x00, 0x60, 0x97, 0x94, 0x23, 0x11]};
    const IID CLSID_StdEvent                       = {0x2B030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_StdFont                        = {0x0352E30B, 0x918F, 0xCE11, [0x9D, 0xE3, 0x00, 0xAA, 0x00, 0x4B, 0xB8, 0x51]};
    const IID CLSID_StdGlobalInterfaceTable        = {0x23030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_StdHlink                       = {0xD0C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_StdHlinkBrowseContext          = {0xD1C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_StdMarshal                     = {0x17000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_StdNotificationMgr             = {0xAFE433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_StdPicture                     = {0x0452E30B, 0x918F, 0xCE11, [0x9D, 0xE3, 0x00, 0xAA, 0x00, 0x4B, 0xB8, 0x51]};
    const IID CLSID_StdURLMoniker                  = {0xE0C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_StdURLProtocol                 = {0xE1C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_StgFolder                      = {0xAFF173E7, 0x653A, 0x6648, [0x85, 0x7D, 0x84, 0x6F, 0xC9, 0xC4, 0x59, 0x8A]};
    const IID CLSID_StockColorPage                 = {0xE1AABD7E, 0x2081, 0xCF11, [0x89, 0x9F, 0x00, 0xAA, 0x00, 0x68, 0x8B, 0x10]};
    const IID CLSID_StockFontPage                  = {0xE0AABD7E, 0x2081, 0xCF11, [0x89, 0x9F, 0x00, 0xAA, 0x00, 0x68, 0x8B, 0x10]};
    const IID CLSID_StockPicturePage               = {0xE2AABD7E, 0x2081, 0xCF11, [0x89, 0x9F, 0x00, 0xAA, 0x00, 0x68, 0x8B, 0x10]};
    const IID CLSID_SubscriptionMgr                = {0xD031BEAB, 0xAE6D, 0xD011, [0xBE, 0xCA, 0x00, 0xC0, 0x4F, 0xD9, 0x40, 0xBE]};
    const IID CLSID_SubscriptionThrottler          = {0xE5009B1E, 0x4698, 0xD111, [0xA1, 0xEE, 0x00, 0xC0, 0x4F, 0xC2, 0xFB, 0xE1]};
    const IID CLSID_SWbemDateTime                  = {0x54BEDF47, 0x76CF, 0xD311, [0xB3, 0x8F, 0x00, 0x10, 0x5A, 0x1F, 0x47, 0x3A]};
    const IID CLSID_SWbemEventSource               = {0x583DB804, 0xAE21, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemLastError                 = {0xACEEFEC2, 0xCDCF, 0xD111, [0x8B, 0x05, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemLocator                   = {0x5841A676, 0x41CB, 0xD111, [0x8B, 0x02, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemMethod                    = {0x5B3DB804, 0xAE21, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemMethodSet                 = {0x5A3DB804, 0xAE21, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemNamedValue                = {0x603DB804, 0xAE21, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemNamedValueSet             = {0x4E38ED9A, 0x8BCE, 0xD111, [0x8B, 0x05, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemObject                    = {0x623DB804, 0xAE21, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemObjectEx                  = {0xB2AFBDD6, 0x3594, 0x1F49, [0xBB, 0x87, 0x6A, 0xA0, 0xF0, 0xBC, 0x31, 0xA2]};
    const IID CLSID_SWbemObjectPath                = {0x26BC9157, 0x9CCE, 0xD111, [0x97, 0xBF, 0x00, 0x00, 0xF8, 0x1E, 0x84, 0x9C]};
    const IID CLSID_SWbemObjectSet                 = {0x613DB804, 0xAE21, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemPrivilege                 = {0xBC67EE26, 0x0458, 0xD211, [0x8B, 0x4A, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemPrivilegeSet              = {0xBE67EE26, 0x0458, 0xD211, [0x8B, 0x4A, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemProperty                  = {0x5D3DB804, 0xAE21, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemPropertySet               = {0x5C3DB804, 0xAE21, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemQualifier                 = {0x5F3DB804, 0xAE21, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemQualifierSet              = {0x5E3DB804, 0xAE21, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemRefreshableItem           = {0xBC54688C, 0x4BDE, 0xD311, [0xB3, 0x90, 0x00, 0x10, 0x5A, 0x1F, 0x47, 0x3A]};
    const IID CLSID_SWbemRefresher                 = {0x5CBF69D2, 0xC1D9, 0xD311, [0xB3, 0x8F, 0x00, 0x10, 0x5A, 0x1F, 0x47, 0x3A]};
    const IID CLSID_SWbemSecurity                  = {0xE9664DB5, 0x8722, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemServices                  = {0x633DB804, 0xAE21, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID CLSID_SWbemServicesEx                = {0xDC22E562, 0xF38C, 0xA840, [0x8B, 0x2E, 0x37, 0xD5, 0x95, 0x65, 0x1E, 0x40]};
    const IID CLSID_SWbemSink                      = {0x9A8C7175, 0x29F0, 0xD111, [0xA1, 0xAC, 0x00, 0xC0, 0x4F, 0xB6, 0xC2, 0x23]};
    const IID CLSID_SynchronizeContainer           = {0x2D030000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID CLSID_SyncMgr                        = {0x27DF9562, 0xEE35, 0xD111, [0x87, 0x07, 0x00, 0xC0, 0x4F, 0xD9, 0x33, 0x27]};
    const IID CLSID_TAPI                           = {0x8ED4D621, 0x8BA8, 0xD011, [0x83, 0xDD, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID CLSID_TaskbarList                    = {0x44F3FD56, 0x6DFD, 0xD011, [0x95, 0x8A, 0x00, 0x60, 0x97, 0xC9, 0xA0, 0x90]};
    const IID CLSID_TaskManager                    = {0xA715F6C0, 0x74F8, 0x2145, [0x87, 0x91, 0xED, 0x3B, 0x84, 0x01, 0x7E, 0xF7]};
    const IID CLSID_TerminalManager                = {0xE0F27071, 0xE39B, 0xD011, [0xA0, 0x09, 0x00, 0xAA, 0x00, 0xB6, 0x05, 0xA4]};
    const IID CLSID_THREAD_BROADCAST               = {0x12184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_ThreadDialogProcParam          = {0xEBF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID CLSID_ThumbnailFCNHandler            = {0xD865FCCE, 0xD866, 0xD111, [0x8D, 0x8C, 0x00, 0x00, 0xF8, 0x04, 0xB0, 0x57]};
    const IID CLSID_ThumbnailUpdater               = {0x1839C6A3, 0x9D88, 0xD111, [0x83, 0xE9, 0x00, 0xC0, 0x4F, 0xC2, 0xC6, 0xD4]};
    const IID CLSID_TIME                           = {0x7BF52EE3, 0xDE7F, 0x6547, [0x9B, 0xC5, 0xA1, 0xBA, 0x97, 0x05, 0xC4, 0x4E]};
    const IID CLSID_TIMEAnimation                  = {0x5A139DF9, 0x7CC0, 0x9E44, [0x96, 0x5C, 0x7D, 0xBB, 0x7C, 0x55, 0x4A, 0x51]};
    const IID CLSID_TimeCategorizer                = {0x8F11B43B, 0xFDDD, 0x304D, [0xA3, 0x48, 0x9F, 0xB5, 0xD6, 0xBF, 0x1A, 0xFE]};
    const IID CLSID_TIMEColorAnimation             = {0x5250F762, 0xECF3, 0x644A, [0x84, 0xFB, 0xAB, 0x18, 0xE0, 0x74, 0x6E, 0xD8]};
    const IID CLSID_TIMEFactory                    = {0x207A2317, 0xDB3A, 0xEC48, [0xB1, 0x82, 0x35, 0x29, 0x1F, 0x11, 0x57, 0x90]};
    const IID CLSID_TIMEFilterAnimation            = {0xD01545C5, 0xE5F2, 0xDD4B, [0xAA, 0x86, 0x1E, 0x4F, 0x23, 0xE4, 0x80, 0xE7]};
    const IID CLSID_TIMEMotionAnimation            = {0x9DA01900, 0x811A, 0xC541, [0x89, 0xEC, 0xD9, 0xE7, 0x37, 0x81, 0x13, 0x03]};
    const IID CLSID_TIMESetAnimation               = {0x53CE91BA, 0xEBBA, 0x054F, [0x86, 0x1C, 0x0A, 0x2A, 0x09, 0x34, 0xF8, 0x2E]};
    const IID CLSID_Timestamp                      = {0xEBD2BEB2, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_ToolbarExtButtons              = {0xD8B5E42C, 0x8FA2, 0xD211, [0x86, 0xC5, 0x00, 0xC0, 0x4F, 0x8E, 0xEA, 0x99]};
    const IID CLSID_TrackFile                      = {0x47C99087, 0x0BA3, 0xD011, [0x8C, 0xAB, 0x00, 0xC0, 0x4F, 0xD9, 0x0F, 0x85]};
    const IID CLSID_TrkForceOwnership              = {0x451F53A2, 0x7DC6, 0xD011, [0x8C, 0xB1, 0x00, 0xC0, 0x4F, 0xD9, 0x0F, 0x85]};
    const IID CLSID_TrkRestoreNotify               = {0x6C6F05D0, 0xA0E2, 0xD011, [0xB1, 0xC2, 0x00, 0xC0, 0x4F, 0xB9, 0x38, 0x6D]};
    const IID CLSID_TrkRestoreParser               = {0xE4395975, 0x81E3, 0xD011, [0xB1, 0xC5, 0x00, 0xC0, 0x4F, 0xB9, 0x38, 0x6D]};
    const IID CLSID_TypedName                      = {0xCB4331B3, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID CLSID_UmiLDAPQueryObject             = {0x764D5DCD, 0x18A8, 0x954F, [0xB9, 0x58, 0x79, 0x70, 0xFD, 0x94, 0x12, 0xCA]};
    const IID CLSID_UnsecuredApartment             = {0x2820BD49, 0x2315, 0xD111, [0xAD, 0x79, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID CLSID_UPnPDescriptionDocument        = {0x479B8A1D, 0x283A, 0xE24C, [0x8A, 0x4B, 0xBD, 0x34, 0xE4, 0x5B, 0xCE, 0xEB]};
    const IID CLSID_UPnPDevice                     = {0xC55225A3, 0x61BA, 0x7A45, [0xB5, 0x9A, 0xA2, 0x56, 0x1E, 0x12, 0x5E, 0x33]};
    const IID CLSID_UPnPDeviceFinder               = {0x285F08E2, 0xB7FE, 0x4A40, [0xB8, 0xE7, 0xE6, 0x59, 0xBD, 0xEA, 0xAA, 0x02]};
    const IID CLSID_UPnPDeviceHostICSSupport       = {0xB19B7A79, 0x499E, 0x634E, [0xAF, 0xE1, 0x1B, 0x45, 0xB9, 0xDC, 0x81, 0x62]};
    const IID CLSID_UPnPDeviceHostSetup            = {0x119460B4, 0x1CC8, 0xCE4C, [0x8C, 0x76, 0xC6, 0xB5, 0x0C, 0x94, 0x02, 0xC6]};
    const IID CLSID_UPnPDevices                    = {0xFD4FE8B9, 0x3CAD, 0xA440, [0xB8, 0x35, 0x08, 0x82, 0xEB, 0xCB, 0xAA, 0xA8]};
    const IID CLSID_UPnPNAT                        = {0xAA001EAE, 0xD53F, 0x3C40, [0x8A, 0x27, 0x2B, 0xBD, 0xC3, 0x0C, 0xD0, 0xE1]};
    const IID CLSID_UPnPRegistrar                  = {0xB9104820, 0xB273, 0xD411, [0xBF, 0x42, 0x00, 0xB0, 0xD0, 0x11, 0x8B, 0x56]};
    const IID CLSID_UPnPService                    = {0x95BA24C6, 0xCBFB, 0x0944, [0x8C, 0x03, 0x8C, 0xCE, 0xEC, 0x53, 0x3E, 0xF1]};
    const IID CLSID_UPnPServices                   = {0x4A4BBCC0, 0x06A4, 0xFC4E, [0x93, 0x2F, 0xB8, 0x54, 0x6B, 0x81, 0x00, 0xCC]};
    const IID CLSID_UrlMkBindCtx                   = {0xF2C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID CLSID_UserEventTimer                 = {0x88124A86, 0x4C35, 0x194D, [0x9D, 0x68, 0xC2, 0x74, 0x2B, 0xB1, 0x49, 0x97]};
    const IID CLSID_UserEventTimerCallback         = {0x13FDFF15, 0x4051, 0xB841, [0xB8, 0x9A, 0xC8, 0xD5, 0x75, 0x9C, 0xD2, 0xB2]};
    const IID CLSID_UserNotification               = {0x0E891000, 0x8987, 0x3C41, [0xAD, 0xBC, 0x48, 0xF5, 0xB5, 0x11, 0xB3, 0xAF]};
    const IID CLSID_VideoInputTerminal             = {0xEC78F5AA, 0x70DC, 0xD011, [0x8E, 0xD3, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID CLSID_VideoWindowTerm                = {0x908943F7, 0xEBD6, 0xD011, [0x82, 0xA6, 0x00, 0xAA, 0x00, 0xB5, 0xCA, 0x1B]};
    const IID CLSID_VirusScan                      = {0xE05D8EE8, 0x3EBD, 0xCF11, [0xAA, 0xFA, 0x00, 0xAA, 0x00, 0xB6, 0x01, 0x5C]};
    const IID CLSID_WbemAdministrativeLocator      = {0xCC5585CB, 0x2891, 0xD111, [0xAD, 0x9B, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID CLSID_WbemAuthenticatedLocator       = {0x364318CD, 0x2891, 0xD111, [0xAD, 0x9B, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID CLSID_WbemBackupRestore              = {0xC6329EC4, 0x8BBC, 0xD211, [0x85, 0xD4, 0x00, 0x10, 0x5A, 0x1F, 0x83, 0x04]};
    const IID CLSID_WbemClassObject                = {0x8630659A, 0x4F17, 0xD211, [0xB5, 0xF9, 0x00, 0x10, 0x4B, 0x70, 0x3E, 0xFD]};
    const IID CLSID_WbemContext                    = {0x98664B67, 0x92EE, 0xD011, [0xAD, 0x71, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID CLSID_WbemDCOMTransport              = {0x132ECEF7, 0x908C, 0xD111, [0x9E, 0x7B, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID CLSID_WbemDecoupledBasicEventProvide = {0x3757F7F5, 0x4328, 0x224F, [0x93, 0x3D, 0xC7, 0x6A, 0x97, 0xCD, 0xA6, 0x2F]};
    const IID CLSID_WbemDecoupledRegistrar         = {0x3279FC4C, 0x9D0F, 0xEF4B, [0x9C, 0x32, 0x8E, 0xA2, 0xA6, 0xB5, 0x6F, 0xCB]};
    const IID CLSID_WbemDefPath                    = {0x05C44CCF, 0xC5E2, 0xDD4D, [0xB3, 0xCE, 0x5E, 0x75, 0x82, 0xD8, 0xC9, 0xFA]};
    const IID CLSID_WbemLevel1Login                = {0x5EF0C38B, 0x6BD8, 0xD011, [0xA0, 0x75, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID CLSID_WbemLocalAddrRes               = {0x014804A1, 0x7E8F, 0xD111, [0x9E, 0x7C, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID CLSID_WbemLocator                    = {0x11F89045, 0x3A1D, 0xD011, [0x89, 0x1F, 0x00, 0xAA, 0x00, 0x4B, 0x2E, 0x24]};
    const IID CLSID_WbemObjectTextSrc              = {0x9D551C8D, 0xF084, 0xB34B, [0xA7, 0xD5, 0x56, 0xA7, 0x43, 0x5A, 0x9B, 0xA6]};
    const IID CLSID_WbemQuery                      = {0x24A0C8EA, 0xE221, 0x2345, [0xAD, 0x73, 0xA7, 0x1A, 0x0A, 0xA2, 0xF5, 0x6A]};
    const IID CLSID_WbemRefresher                  = {0xF26615C7, 0x1E56, 0xD111, [0xAD, 0x87, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID CLSID_WbemStatusCodeText             = {0xBDE187EB, 0x3332, 0xD211, [0xAE, 0xC9, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID CLSID_WbemUnauthenticatedLocator     = {0x797B3E44, 0x31DE, 0xD211, [0xB3, 0x40, 0x00, 0x10, 0x4B, 0xCC, 0x4B, 0x4A]};
    const IID CLSID_WbemUninitializedClassObject   = {0xF627027A, 0x0871, 0xD111, [0xAD, 0x90, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID CLSID_WebBrowser                     = {0x61F95688, 0x0A34, 0xD011, [0xA9, 0x6B, 0x00, 0xC0, 0x4F, 0xD7, 0x05, 0xA2]};
    const IID CLSID_WebBrowser_V1                  = {0xC32AB2EA, 0xC130, 0xCF11, [0xA7, 0xEB, 0x00, 0x00, 0xC0, 0x5B, 0xAE, 0x0B]};
    const IID CLSID_WebCheck                       = {0x205EFBE6, 0x35DE, 0xCF11, [0x9C, 0x87, 0x00, 0xAA, 0x00, 0x51, 0x27, 0xED]};
    const IID CLSID_WebCheckDefaultProcess         = {0xB0E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID CLSID_WebCheckOfflineSync            = {0x6EB8C07F, 0xA75F, 0xD111, [0xBC, 0x7C, 0x00, 0xC0, 0x4F, 0xD9, 0x29, 0xDB]};
    const IID CLSID_WebCrawlerAgent                = {0xA05E1608, 0x46E9, 0xCF11, [0x9C, 0x87, 0x00, 0xAA, 0x00, 0x51, 0x27, 0xED]};
    const IID CLSID_WebViewFolderContents          = {0xD0FE2018, 0x3E47, 0xD011, [0xA9, 0x6C, 0x00, 0xC0, 0x4F, 0xD7, 0x05, 0xA2]};
    const IID CLSID_WebWizardHost                  = {0x49F127C8, 0xC155, 0x284D, [0x93, 0x5E, 0x57, 0xE4, 0x7C, 0xAE, 0xD9, 0x73]};
    const IID CLSID_wfolders                       = {0x9A1FE3BA, 0x811B, 0xD211, [0xA9, 0x7A, 0x00, 0xC0, 0x4F, 0x8E, 0xCB, 0x02]};
    const IID CLSID_WinNTConnectionObject          = {0xEBC69279, 0x42D1, 0x3243, [0x83, 0x1E, 0x31, 0x54, 0xC5, 0x0A, 0x83, 0x16]};
    const IID CLSID_WinNTObject                    = {0x854132B8, 0x5040, 0x2042, [0x98, 0x0A, 0xAB, 0x14, 0x62, 0x3E, 0x06, 0x3A]};
    const IID CLSID_WinNTSystemInfo                = {0xC42E1866, 0xD1AF, 0xD211, [0x9C, 0xB9, 0x00, 0x00, 0xF8, 0x7A, 0x36, 0x9E]};
    const IID CLSID_WMIExtension                   = {0xFE5A97F0, 0x7F5C, 0xD211, [0x8B, 0x74, 0x00, 0x10, 0x4B, 0x2A, 0xFB, 0x41]};
    const IID CLSID_XMLDocument                    = {0xAF99C3CF, 0x76D8, 0xD011, [0x9C, 0x10, 0x00, 0xC0, 0x4F, 0xC9, 0x9C, 0x8E]};
    const IID CLSID_XMLDSOControl                  = {0x30DA0D55, 0x4105, 0xD211, [0x9C, 0xA9, 0x00, 0x60, 0xB0, 0xEC, 0x3D, 0x39]};
    const IID CLSID_XMLHTTPRequest                 = {0x8E108CED, 0x4943, 0xD211, [0x91, 0xA4, 0x00, 0xC0, 0x4F, 0x79, 0x69, 0xE8]};
    const IID CLSID_XMLParser                      = {0x203642D2, 0xA051, 0xD211, [0x9C, 0xAF, 0x00, 0x60, 0xB0, 0xEC, 0x3D, 0x39]};
    const IID DB_PROPERTY_AUTOMATICUPDATE          = {0x0922B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_BTREE                    = {0x0122B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_CHECK_OPTION             = {0x0B22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_CLUSTERED                = {0xFF21B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_CONSTRAINT_CHECK_DEFERRE = {0xF021B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_DISALLOWNULL             = {0x0522B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_DROP_CASCADE             = {0xF321B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_EXPLICITUPDATE           = {0x0A22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_FILLFACTOR               = {0x0322B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_HASH                     = {0x0222B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_IGNOREANYNULL            = {0x0722B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_IGNORENULL               = {0x0622B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_INITIALSIZE              = {0x0422B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_NONCLUSTERED             = {0x0022B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_ON_COMMIT_PRESERVE_ROWS  = {0x3022B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_PRIMARY                  = {0xFC21B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_SORTBOOKMARKS            = {0x0822B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DB_PROPERTY_UNIQUE                   = {0xF521B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBCOL_SELFCOLUMNS                    = {0x3122B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBCOL_SPECIALCOL                     = {0x3222B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_COMMAND                       = {0xF822B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_CONTAINEROBJECT               = {0xFB22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_DBSQL                         = {0xFB21B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_DEFAULT                       = {0xFB21B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_DSO                           = {0xF422B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_HISTOGRAM_ROWSET              = {0x0023B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_LDAPDialect                   = {0x8053F6EF, 0x989C, 0xCF11, [0xB9, 0x63, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_LIKE_DOS                      = {0xF721B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_LIKE_MAPI                     = {0xF921B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_LIKE_OFS                      = {0xF821B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_LIKE_SQL                      = {0xF621B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_MDX                           = {0xD0CC7CA0, 0x4881, 0xD011, [0x87, 0xBB, 0x00, 0xC0, 0x4F, 0xC3, 0x39, 0x42]};
    const IID DBGUID_ROW                           = {0xF722B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_ROWSET                        = {0xF622B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_SESSION                       = {0xF522B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_SQL                           = {0xD722B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBGUID_STREAM                        = {0xF922B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_CHARACTERSET                = {0xED22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_COLLATION                   = {0xEA22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_COLUMN                      = {0xE422B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_DATABASE                    = {0xE522B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_DOMAIN                      = {0xE922B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_PROCEDURE                   = {0xE622B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_SCHEMA                      = {0xE822B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_SCHEMAROWSET                = {0xEC22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_TABLE                       = {0xE222B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_TRANSLATION                 = {0xEE22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_TRUSTEE                     = {0xEB22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBOBJECT_VIEW                        = {0xE722B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_ADSIBIND                   = {0xC86DA66D, 0xE8B7, 0xD211, [0x9D, 0x60, 0x00, 0xC0, 0x4F, 0x68, 0x93, 0x45]};
    const IID DBPROPSET_ADSISEARCH                 = {0x28C9CFCF, 0xA29A, 0xD011, [0xA7, 0x9A, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0xA8]};
    const IID DBPROPSET_COLUMN                     = {0xB922B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_COLUMNALL                  = {0xF022B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_CONSTRAINTALL              = {0xFA22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_DATASOURCE                 = {0xBA22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_DATASOURCEALL              = {0xC022B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_DATASOURCEINFO             = {0xBB22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_DATASOURCEINFOALL          = {0xC122B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_DBINIT                     = {0xBC22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_DBINITALL                  = {0xCA22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_INDEX                      = {0xBD22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_INDEXALL                   = {0xF122B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_PROPERTIESINERROR          = {0xD422B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_ROWSET                     = {0xBE22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_ROWSETALL                  = {0xC222B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_SESSION                    = {0xC622B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_SESSIONALL                 = {0xC722B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_STREAM                     = {0xFD22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_STREAMALL                  = {0xFE22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_TABLE                      = {0xBF22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_TABLEALL                   = {0xF222B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_TRUSTEE                    = {0xE122B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_TRUSTEEALL                 = {0xF322B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_VIEW                       = {0xDF22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBPROPSET_VIEWALL                    = {0xFC22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_ASSERTIONS                  = {0x1022B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_CATALOGS                    = {0x1122B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_CHARACTER_SETS              = {0x1222B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_CHECK_CONSTRAINTS           = {0x1522B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_CHECK_CONSTRAINTS_BY_TABLE  = {0x0123B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_COLLATIONS                  = {0x1322B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_COLUMN_DOMAIN_USAGE         = {0x1B22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_COLUMN_PRIVILEGES           = {0x2122B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_COLUMNS                     = {0x1422B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_CONSTRAINT_COLUMN_USAGE     = {0x1622B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_CONSTRAINT_TABLE_USAGE      = {0x1722B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_FOREIGN_KEYS                = {0xC422B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_INDEXES                     = {0x1E22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_KEY_COLUMN_USAGE            = {0x1822B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_PRIMARY_KEYS                = {0xC522B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_PROCEDURE_COLUMNS           = {0xC922B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_PROCEDURE_PARAMETERS        = {0xB822B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_PROCEDURES                  = {0x2422B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_PROVIDER_TYPES              = {0x2C22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_REFERENTIAL_CONSTRAINTS     = {0x1922B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_SCHEMATA                    = {0x2522B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_SQL_LANGUAGES               = {0x2622B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_STATISTICS                  = {0x2722B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_TABLE_CONSTRAINTS           = {0x1A22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_TABLE_PRIVILEGES            = {0x2222B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_TABLE_STATISTICS            = {0xFF22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_TABLES                      = {0x2922B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_TABLES_INFO                 = {0xE022B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_TRANSLATIONS                = {0x2A22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_TRUSTEE                     = {0xEF22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_USAGE_PRIVILEGES            = {0x2322B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_VIEW_COLUMN_USAGE           = {0x2E22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_VIEW_TABLE_USAGE            = {0x2F22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DBSCHEMA_VIEWS                       = {0x2D22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID DDVPTYPE_BROOKTREE                   = {0x60A55213, 0x61DA, 0xCF11, [0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8]};
    const IID DDVPTYPE_CCIR656                     = {0xA026A3FC, 0x60DA, 0xCF11, [0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8]};
    const IID DDVPTYPE_E_HREFH_VREFL               = {0x20327892, 0x60DA, 0xCF11, [0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8]};
    const IID DDVPTYPE_E_HREFL_VREFL               = {0xE0779CE0, 0x60DA, 0xCF11, [0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8]};
    const IID DDVPTYPE_PHILIPS                     = {0x60F12C33, 0x61DA, 0xCF11, [0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8]};
    const IID DIID__SearchAssistantEvents          = {0xDAFD1116, 0x5B44, 0xD211, [0x85, 0xDE, 0x00, 0xC0, 0x4F, 0xA3, 0x5C, 0x89]};
    const IID DIID_DispCEventObj                   = {0x58F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispDOMChildrenCollection       = {0x77F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTCAttachBehavior           = {0x83F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTCDefaultDispatch          = {0x73F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTCDescBehavior             = {0x7EF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTCEventBehavior            = {0x74F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTCMethodBehavior           = {0x87F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTCPropertyBehavior         = {0x7FF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLAnchorElement           = {0x02F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLAppBehavior             = {0x7CF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLAreaElement             = {0x03F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLAreasCollection         = {0x6AF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLAttributeCollection     = {0x6CF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLBaseElement             = {0x18F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLBaseFontElement         = {0x04F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLBGsound                 = {0x3CF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLBlockElement            = {0x06F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLBody                    = {0x07F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLBRElement               = {0x3AF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLButtonElement           = {0x1FF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLCommentElement          = {0x0AF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLCurrentStyle            = {0x57F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLDDElement               = {0x0BF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLDefaults                = {0x8CF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLDivElement              = {0x0CF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLDivPosition             = {0x0FF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLDListElement            = {0x3BF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLDocument                = {0x5FF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLDOMAttribute            = {0x64F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLDOMImplementation       = {0x8FF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLDOMTextNode             = {0x65F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLDTElement               = {0x0DF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLElementCollection       = {0x6BF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLEmbed                   = {0x2EF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLFieldSetElement         = {0x45F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLFontElement             = {0x12F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLFormElement             = {0x10F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLFrameBase               = {0x41F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLFrameElement            = {0x13F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLFrameSetSite            = {0x14F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLGenericElement          = {0x63F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLHeadElement             = {0x61F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLHeaderElement           = {0x15F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLHRElement               = {0x3DF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLHtmlElement             = {0x60F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLIFrame                  = {0x1BF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLImg                     = {0x1CF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLInputElement            = {0x7DF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLIsIndexElement          = {0x19F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLLabelElement            = {0x22F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLLegendElement           = {0x46F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLLIElement               = {0x23F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLLinkElement             = {0x24F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLListElement             = {0x25F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLMapElement              = {0x26F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLMarqueeElement          = {0x27F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLMetaElement             = {0x17F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLNextIdElement           = {0x1AF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLNoShowElement           = {0x28F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLObjectElement           = {0x29F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLOListElement            = {0x2AF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLOptionElement           = {0x2BF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLParaElement             = {0x2CF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLParamElement            = {0x90F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLPhraseElement           = {0x2DF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLPopup                   = {0x89F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLRenderStyle             = {0x8BF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLRichtextElement         = {0x4DF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLRuleStyle               = {0x5CF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLScreen                  = {0x91F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLScriptElement           = {0x30F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLSelectElement           = {0x31F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLSpanElement             = {0x48F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLSpanFlow                = {0x44F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLStyle                   = {0x5AF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLStyleElement            = {0x11F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLStyleSheet              = {0x8DF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLTable                   = {0x32F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLTableCaption            = {0x08F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLTableCell               = {0x36F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLTableCol                = {0x33F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLTableRow                = {0x35F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLTableSection            = {0x34F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLTextAreaElement         = {0x21F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLTextElement             = {0x37F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLTitleElement            = {0x16F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLUListElement            = {0x38F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLUnknownElement          = {0x39F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLWindow2                 = {0x5DF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispHTMLWindowProxy             = {0x5EF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispIHTMLInputButtonElement     = {0x1EF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispIHTMLInputFileElement       = {0x42F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispIHTMLInputImage             = {0x1DF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispIHTMLInputTextElement       = {0x20F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DispIHTMLOptionButtonElement    = {0x09F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_DMigrationWizardAutoEvents      = {0x7D13ACD2, 0xD8A6, 0xB643, [0x98, 0x79, 0xEA, 0x34, 0xB6, 0x7E, 0x18, 0x80]};
    const IID DIID_DSearchCommandEvents            = {0x60018960, 0xF069, 0xD111, [0xB7, 0x58, 0x00, 0xA0, 0xC9, 0x05, 0x64, 0xFE]};
    const IID DIID_DShellFolderViewEvents          = {0xA22A1162, 0xE4EB, 0xCF11, [0xA5, 0xFB, 0x00, 0x20, 0xAF, 0xE7, 0x29, 0x2D]};
    const IID DIID_DShellNameSpaceEvents           = {0x06681355, 0xDEB2, 0xD111, [0xB9, 0xF2, 0x00, 0xA0, 0xC9, 0x8B, 0xC5, 0x47]};
    const IID DIID_DShellWindowsEvents             = {0xE00641FE, 0x9A39, 0xD011, [0xA4, 0x8C, 0x00, 0xA0, 0xC9, 0x0A, 0x8F, 0x39]};
    const IID DIID_DWebBridgeEvents                = {0xFF97D8A6, 0x950A, 0xD111, [0xB0, 0xBA, 0x00, 0x60, 0x08, 0x16, 0x6E, 0x11]};
    const IID DIID_DWebBrowserEvents               = {0xC22AB2EA, 0xC130, 0xCF11, [0xA7, 0xEB, 0x00, 0x00, 0xC0, 0x5B, 0xAE, 0x0B]};
    const IID DIID_DWebBrowserEvents2              = {0xA015A734, 0x8765, 0xD011, [0x92, 0x4A, 0x00, 0x20, 0xAF, 0xC7, 0xAC, 0x4D]};
    const IID DIID_HTMLAnchorEvents                = {0x9DF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLAnchorEvents2               = {0x10F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLAreaEvents                  = {0x66F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLAreaEvents2                 = {0x11F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLButtonElementEvents         = {0xB3F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLButtonElementEvents2        = {0x17F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLControlElementEvents        = {0xEAF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLControlElementEvents2       = {0x12F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLDocumentEvents              = {0x60F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLDocumentEvents2             = {0x13F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLElementEvents               = {0x3CF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLElementEvents2              = {0x0FF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLFormElementEvents           = {0x64F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLFormElementEvents2          = {0x14F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLFrameSiteEvents             = {0x00F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLFrameSiteEvents2            = {0xFFF75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLImgEvents                   = {0x5BF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLImgEvents2                  = {0x16F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLInputFileElementEvents      = {0xAFF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLInputFileElementEvents2     = {0x1AF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLInputImageEvents            = {0xC3F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLInputImageEvents2           = {0x1BF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLInputTextElementEvents      = {0xA7F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLInputTextElementEvents2     = {0x18F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLLabelEvents                 = {0x29F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLLabelEvents2                = {0x1CF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLLinkElementEvents           = {0xCCF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLLinkElementEvents2          = {0x1DF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLMapEvents                   = {0xBAF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLMapEvents2                  = {0x1EF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLMarqueeElementEvents        = {0xB8F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLMarqueeElementEvents2       = {0x1FF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLNamespaceEvents             = {0xBDF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLObjectElementEvents         = {0xC4F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLObjectElementEvents2        = {0x20F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLOptionButtonElementEvents   = {0xBDF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLOptionButtonElementEvents2  = {0x19F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLPersistEvents               = {0xC7F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLScriptEvents                = {0xE2F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLScriptEvents2               = {0x21F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLSelectElementEvents         = {0x02F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLSelectElementEvents2        = {0x22F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLStyleElementEvents          = {0xCBF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLStyleElementEvents2         = {0x15F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLTableEvents                 = {0x07F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLTableEvents2                = {0x23F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLTextContainerEvents         = {0x72AAF61F, 0x4258, 0xCF11, [0xA7, 0x07, 0x00, 0xAA, 0x00, 0xC0, 0x09, 0x8D]};
    const IID DIID_HTMLTextContainerEvents2        = {0x24F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_HTMLWindowEvents                = {0xE0A4A096, 0x62D0, 0xCF11, [0x94, 0xB6, 0x00, 0xAA, 0x00, 0x60, 0x27, 0x5C]};
    const IID DIID_HTMLWindowEvents2               = {0x25F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_IRTCDispatchEventNotification   = {0xBEDF6D17, 0xC0FE, 0x554D, [0xBC, 0x87, 0x84, 0xCF, 0xF1, 0xEF, 0x7F, 0x91]};
    const IID DIID_ISWbemSinkEvents                = {0xA08C7175, 0x29F0, 0xD111, [0xA1, 0xAC, 0x00, 0xC0, 0x4F, 0xB6, 0xC2, 0x23]};
    const IID DIID_ITTAPIDispatchEventNotification = {0x5B32349F, 0x627E, 0xD211, [0x94, 0x57, 0x00, 0xC0, 0x4F, 0x8E, 0xC8, 0x88]};
    const IID DIID_LayoutRectEvents                = {0x74F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID DIID_XMLDOMDocumentEvents            = {0x27A4FA3E, 0x2F27, 0xD211, [0x83, 0x6F, 0x00, 0x00, 0xF8, 0x7A, 0x77, 0x82]};
    const IID DPAID_ComPort                        = {0x00CEF0F2, 0xAFE0, 0xCF11, [0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID DPAID_INet                           = {0xA04DA5C4, 0xAFE0, 0xCF11, [0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID DPAID_INetPort                       = {0x414552E4, 0xA58E, 0xD111, [0x8A, 0x96, 0x00, 0x60, 0x97, 0xB0, 0x14, 0x11]};
    const IID DPAID_INetW                          = {0xA03232E6, 0xBF9D, 0xD011, [0x9C, 0xC1, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID DPAID_LobbyProvider                  = {0x4056B959, 0x6796, 0xD011, [0xA7, 0x7D, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC]};
    const IID DPAID_Modem                          = {0x00C2DCF6, 0xFEA2, 0xD011, [0x9C, 0x4F, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID DPAID_ModemW                         = {0xE092FD01, 0xFFA2, 0xD011, [0x9C, 0x4F, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID DPAID_Phone                          = {0xA089EC78, 0xAFE0, 0xCF11, [0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID DPAID_PhoneW                         = {0x707A5ABA, 0xBF9D, 0xD011, [0x9C, 0xC1, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID DPAID_ServiceProvider                = {0xC016D907, 0xAFE0, 0xCF11, [0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID DPAID_TotalSize                      = {0x60F51813, 0x2C91, 0xD011, [0x9D, 0xAA, 0x00, 0xA0, 0xC9, 0x0A, 0x43, 0xCB]};
    const IID DPLPROPERTY_LobbyGuid                = {0xA02069F5, 0x18D2, 0xD011, [0xBA, 0x39, 0x00, 0xC0, 0x4F, 0xD7, 0xED, 0x67]};
    const IID DPLPROPERTY_MessagesSupported        = {0xA1CD2C76, 0x16D9, 0xD011, [0xBA, 0x39, 0x00, 0xC0, 0x4F, 0xD7, 0xED, 0x67]};
    const IID DPLPROPERTY_PlayerGuid               = {0x229331B4, 0x0DD2, 0xD011, [0xBA, 0x39, 0x00, 0xC0, 0x4F, 0xD7, 0xED, 0x67]};
    const IID DPLPROPERTY_PlayerScore              = {0x00407848, 0x19D2, 0xD011, [0xBA, 0x39, 0x00, 0xC0, 0x4F, 0xD7, 0xED, 0x67]};
    const IID DPSPGUID_IPX                         = {0x00C45B68, 0x2C9D, 0xCF11, [0xA9, 0xCD, 0x00, 0xAA, 0x00, 0x68, 0x86, 0xE3]};
    const IID DPSPGUID_MODEM                       = {0x60A7EA44, 0x68CB, 0xCF11, [0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID DPSPGUID_SERIAL                      = {0x60681D0F, 0xD988, 0xCF11, [0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID DPSPGUID_TCPIP                       = {0xE05EE936, 0x7785, 0xCF11, [0x96, 0x0C, 0x00, 0x80, 0xC7, 0x53, 0x4E, 0x82]};
    const IID DS3DALG_HRTF_FULL                    = {0x403341C2, 0x1B1C, 0xD211, [0x94, 0xF5, 0x00, 0xC0, 0x4F, 0xC2, 0x8A, 0xCA]};
    const IID DS3DALG_HRTF_LIGHT                   = {0x423341C2, 0x1B1C, 0xD211, [0x94, 0xF5, 0x00, 0xC0, 0x4F, 0xC2, 0x8A, 0xCA]};
    const IID DS3DALG_NO_VIRTUALIZATION            = {0x3F3341C2, 0x1B1C, 0xD211, [0x94, 0xF5, 0x00, 0xC0, 0x4F, 0xC2, 0x8A, 0xCA]};
    const IID FLAGID_Internet                      = {0xA00D3096, 0xAB2B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID FMTID_AudioSummaryInformation        = {0x90044464, 0x8B4C, 0xD111, [0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03]};
    const IID FMTID_Briefcase                      = {0x218B8D32, 0x2977, 0xFC4B, [0x95, 0x4C, 0x90, 0x2B, 0x32, 0x9D, 0x56, 0xB0]};
    const IID FMTID_DiscardableInformation         = {0xB0EB25D7, 0xB8C9, 0xD111, [0x89, 0xBC, 0x00, 0x00, 0xF8, 0x04, 0xB0, 0x57]};
    const IID FMTID_Displaced                      = {0x334B179B, 0xFF40, 0xD211, [0xA2, 0x7E, 0x00, 0xC0, 0x4F, 0xC3, 0x08, 0x71]};
    const IID FMTID_DocSummaryInformation          = {0x02D5CDD5, 0x9C2E, 0x1B10, [0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE]};
    const IID FMTID_DRM                            = {0xE419ACAE, 0xAE89, 0x0845, [0xB9, 0xB7, 0xBB, 0x86, 0x7A, 0xBE, 0xE2, 0xED]};
    const IID FMTID_ImageProperties                = {0xA11DB814, 0x3501, 0x314D, [0x96, 0xD9, 0x6C, 0xBF, 0xC9, 0x67, 0x1A, 0x99]};
    const IID FMTID_ImageSummaryInformation        = {0x8F044464, 0x8B4C, 0xD111, [0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03]};
    const IID FMTID_InternetSite                   = {0xA1140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID FMTID_Intshcut                       = {0xA0140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID FMTID_MediaFileSummaryInformation    = {0x92044464, 0x8B4C, 0xD111, [0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03]};
    const IID FMTID_Misc                           = {0x344B179B, 0xFF40, 0xD211, [0xA2, 0x7E, 0x00, 0xC0, 0x4F, 0xC3, 0x08, 0x71]};
    const IID FMTID_MUSIC                          = {0x2E37A356, 0x9CCE, 0xD211, [0x9F, 0x0E, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6]};
    const IID FMTID_PropertyBag                    = {0x01180020, 0xE65D, 0xD111, [0x8E, 0x38, 0x00, 0xC0, 0x4F, 0xB9, 0x38, 0x6D]};
    const IID FMTID_Query                          = {0x901C6949, 0x177E, 0x1A10, [0xA9, 0x1C, 0x08, 0x00, 0x2B, 0x2E, 0xCD, 0xA9]};
    const IID FMTID_ShellDetails                   = {0xA66A6328, 0x3D95, 0xD211, [0xB5, 0xD6, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0]};
    const IID FMTID_Storage                        = {0x30F125B7, 0xEF47, 0x1A10, [0xA5, 0xF1, 0x02, 0x60, 0x8C, 0x9E, 0xEB, 0xAC]};
    const IID FMTID_SummaryInformation             = {0xE0859FF2, 0xF94F, 0x6810, [0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9]};
    const IID FMTID_UserDefinedProperties          = {0x05D5CDD5, 0x9C2E, 0x1B10, [0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE]};
    const IID FMTID_VideoSummaryInformation        = {0x91044464, 0x8B4C, 0xD111, [0x8B, 0x70, 0x08, 0x00, 0x36, 0xB1, 0x1A, 0x03]};
    const IID FMTID_Volume                         = {0x354B179B, 0xFF40, 0xD211, [0xA2, 0x7E, 0x00, 0xC0, 0x4F, 0xC3, 0x08, 0x71]};
    const IID FMTID_WebView                        = {0x805427F2, 0x82F7, 0x9142, [0xBD, 0x94, 0xF1, 0x36, 0x93, 0x51, 0x3A, 0xEC]};
    const IID GUID_ACPI_CMOS_INTERFACE_STANDARD    = {0x84038D3A, 0x0565, 0xCA40, [0xBC, 0x39, 0x56, 0xC1, 0x5F, 0x8C, 0x5F, 0xED]};
    const IID GUID_ACPI_INTERFACE_STANDARD         = {0x8AA091B0, 0x97BA, 0xD011, [0xBD, 0x14, 0x00, 0xAA, 0x00, 0xB7, 0xB3, 0x2A]};
    const IID GUID_ACPI_PORT_RANGES_INTERFACE_STANDA = {0x9B604FF1, 0xBDCB, 0x5749, [0xA6, 0x74, 0xBC, 0x00, 0x21, 0x3F, 0x1C, 0x97]};
    const IID GUID_ACPI_REGS_INTERFACE_STANDARD    = {0x66191406, 0x4572, 0x6963, [0x46, 0x2E, 0x4E, 0x65, 0x6C, 0x73, 0x6F, 0x6E]};
    const IID GUID_ARBITER_INTERFACE_STANDARD      = {0x85F144E6, 0x0E8C, 0xD011, [0xBE, 0xCF, 0x08, 0x00, 0x2B, 0xE2, 0x09, 0x2F]};
    const IID GUID_BUS_INTERFACE_STANDARD          = {0x80826B49, 0x256F, 0xD011, [0xBE, 0xAF, 0x08, 0x00, 0x2B, 0xE2, 0x09, 0x2F]};
    const IID GUID_BUS_TYPE_1394                   = {0xEB734EF7, 0xC59A, 0xEB45, [0xBE, 0x4D, 0x77, 0x2C, 0xC7, 0x1D, 0xDF, 0xB3]};
    const IID GUID_BUS_TYPE_AVC                    = {0x65F26FC0, 0x09AE, 0xF048, [0x81, 0x2C, 0x16, 0x75, 0x3D, 0x7C, 0xBA, 0x83]};
    const IID GUID_BUS_TYPE_DOT4PRT                = {0x01E01E44, 0x4243, 0xD511, [0xA1, 0x84, 0x00, 0xC0, 0x4F, 0x60, 0x52, 0x4D]};
    const IID GUID_BUS_TYPE_EISA                   = {0x0955C3DD, 0xFCF3, 0xD011, [0xA5, 0x37, 0x00, 0x00, 0xF8, 0x75, 0x3E, 0xD1]};
    const IID GUID_BUS_TYPE_HID                    = {0xD037AFEE, 0x6319, 0xC447, [0xAA, 0x48, 0x72, 0x47, 0x6D, 0xB7, 0xCF, 0x49]};
    const IID GUID_BUS_TYPE_INTERNAL               = {0x73EA3015, 0x6B08, 0xD111, [0xA0, 0x9F, 0x00, 0xC0, 0x4F, 0xC3, 0x40, 0xB1]};
    const IID GUID_BUS_TYPE_IRDA                   = {0xC17DE17A, 0x44C9, 0xD644, [0x88, 0x1F, 0x4C, 0x2E, 0x61, 0x05, 0x3B, 0xC1]};
    const IID GUID_BUS_TYPE_ISAPNP                 = {0x54F876E6, 0x7DD8, 0xD011, [0x92, 0xB2, 0x00, 0xA0, 0xC9, 0x05, 0x5F, 0xC5]};
    const IID GUID_BUS_TYPE_LPTENUM                = {0x0010CAC4, 0xDC2D, 0xD511, [0xA1, 0x7A, 0x00, 0xC0, 0x4F, 0x60, 0x52, 0x4D]};
    const IID GUID_BUS_TYPE_MCA                    = {0x7A99751C, 0x33DC, 0xD011, [0x92, 0xB2, 0x00, 0xA0, 0xC9, 0x05, 0x5F, 0xC5]};
    const IID GUID_BUS_TYPE_PCI                    = {0xB0DFEBC8, 0x10B5, 0xD011, [0x80, 0xE5, 0x00, 0xA0, 0xC9, 0x25, 0x42, 0xE3]};
    const IID GUID_BUS_TYPE_PCMCIA                 = {0x30363409, 0x9FAF, 0xD011, [0x92, 0xE9, 0x00, 0x00, 0xF8, 0x1E, 0x1B, 0x30]};
    const IID GUID_BUS_TYPE_SERENUM                = {0x874A1177, 0x4489, 0xD111, [0xBD, 0x90, 0x00, 0xA0, 0xC9, 0x06, 0xBE, 0x2D]};
    const IID GUID_BUS_TYPE_USB                    = {0xBCEB7D9D, 0x5DC8, 0xD111, [0x9E, 0xB4, 0x00, 0x60, 0x08, 0xC3, 0xA1, 0x9A]};
    const IID GUID_BUS_TYPE_USBPRINT               = {0x00E01E44, 0x4243, 0xD511, [0xA1, 0x84, 0x00, 0xC0, 0x4F, 0x60, 0x52, 0x4D]};
    const IID GUID_Button                          = {0xF0026DA3, 0xF3C9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_CHECKVALUEEXCLUSIVE             = {0x0C435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_ChordParam                      = {0x9E28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_Clear_All_Bands                 = {0xAB28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_COLOR                           = {0x01435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_ColorControlCallbacks           = {0xC20CD6EF, 0xE749, 0xD011, [0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A]};
    const IID GUID_CommandParam                    = {0x9D28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_CommandParam2                   = {0xF77EF928, 0x3895, 0xD211, [0x97, 0xA9, 0x00, 0xC0, 0x4F, 0xA3, 0x6E, 0x58]};
    const IID GUID_ConnectToDLSCollection          = {0x6BAEB11D, 0x2EE9, 0xD111, [0xA8, 0xC5, 0x00, 0xC0, 0x4F, 0xA3, 0x72, 0x6E]};
    const IID GUID_ConstantForce                   = {0x201C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_CustomForce                     = {0x2B1C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_D3DCallbacks2                   = {0xE184A50B, 0xB670, 0xD011, [0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A]};
    const IID GUID_D3DCallbacks3                   = {0x3012F4DD, 0x0AEC, 0xD011, [0xA9, 0xB6, 0x00, 0xAA, 0x00, 0xC0, 0x99, 0x3E]};
    const IID GUID_D3DExtendedCaps                 = {0x801FE47D, 0x939D, 0xD011, [0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29]};
    const IID GUID_D3DParseUnknownCommandCallback  = {0xA0FF042E, 0xE498, 0xD111, [0x8C, 0xE1, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8]};
    const IID GUID_Damper                          = {0x281C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_DDMoreCaps                      = {0x30AF0B88, 0x30B0, 0xD011, [0x8E, 0xA7, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x5B]};
    const IID GUID_DDMoreSurfaceCaps               = {0x66048A3B, 0x69F2, 0xD111, [0x88, 0x0B, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5]};
    const IID GUID_DDStereoMode                    = {0x9C1628F8, 0xE8A8, 0xD211, [0xA1, 0xF2, 0x00, 0xA0, 0xC9, 0x83, 0xEA, 0xF6]};
    const IID GUID_DefaultGMCollection             = {0x73867EF1, 0xB4C3, 0xD111, [0x87, 0x0B, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_DEVCLASS_1394                   = {0xC11FDD6B, 0x0F81, 0xD011, [0xBE, 0xC7, 0x08, 0x00, 0x2B, 0xE2, 0x09, 0x2F]};
    const IID GUID_DEVCLASS_1394DEBUG              = {0xD650F266, 0x0178, 0x644A, [0xB1, 0x39, 0xEE, 0xA8, 0x0A, 0x45, 0x0B, 0x24]};
    const IID GUID_DEVCLASS_61883                  = {0xC0FBBE7E, 0x0032, 0xD211, [0xB4, 0xC2, 0x00, 0xA0, 0xC9, 0x69, 0x7D, 0x07]};
    const IID GUID_DEVCLASS_ADAPTER                = {0x64E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_APMSUPPORT             = {0x181C5BD4, 0xFAC8, 0xD111, [0x9F, 0x77, 0x00, 0x00, 0xF8, 0x05, 0xF5, 0x30]};
    const IID GUID_DEVCLASS_AVC                    = {0x65F26FC0, 0x09AE, 0xF048, [0x81, 0x2C, 0x16, 0x75, 0x3D, 0x7C, 0xBA, 0x83]};
    const IID GUID_DEVCLASS_BATTERY                = {0x541E6372, 0xA478, 0xD011, [0xBC, 0xF7, 0x00, 0xAA, 0x00, 0xB7, 0xB3, 0x2A]};
    const IID GUID_DEVCLASS_BLUETOOTH              = {0x6CF0CBE0, 0x8BCD, 0x4746, [0xBB, 0x8A, 0x26, 0x3B, 0x43, 0xF0, 0xF9, 0x74]};
    const IID GUID_DEVCLASS_CDROM                  = {0x65E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_COMPUTER               = {0x66E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_DECODER                = {0xC21FDD6B, 0x0F81, 0xD011, [0xBE, 0xC7, 0x08, 0x00, 0x2B, 0xE2, 0x09, 0x2F]};
    const IID GUID_DEVCLASS_DISKDRIVE              = {0x67E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_DISPLAY                = {0x68E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_DOT4                   = {0x561B7248, 0x9567, 0xD211, [0xB1, 0xA8, 0x00, 0x80, 0xC7, 0x2E, 0x74, 0xA2]};
    const IID GUID_DEVCLASS_DOT4PRINT              = {0xC86ACE49, 0x866F, 0xD211, [0xB1, 0xE5, 0x00, 0x80, 0xC7, 0x2E, 0x74, 0xA2]};
    const IID GUID_DEVCLASS_ENUM1394               = {0x55DF59C4, 0x08DB, 0xD111, [0xB0, 0x09, 0x00, 0xA0, 0xC9, 0x08, 0x1F, 0xF6]};
    const IID GUID_DEVCLASS_FDC                    = {0x69E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_FLOPPYDISK             = {0x80E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_FSFILTER_ACTIVITYMONIT = {0x51FF6DB8, 0x1EA3, 0xAC4B, [0xB3, 0xCF, 0xE8, 0xCF, 0xE7, 0x5C, 0x9F, 0xC2]};
    const IID GUID_DEVCLASS_FSFILTER_ANTIVIRUS     = {0x69A1D1B1, 0x4FC5, 0x7943, [0x81, 0xDB, 0xBE, 0xE7, 0xD8, 0x8D, 0x74, 0x54]};
    const IID GUID_DEVCLASS_FSFILTER_CFSMETADATASERV = {0x3909CFCD, 0x5BB7, 0x3046, [0xBF, 0x76, 0x80, 0xF7, 0xBA, 0x65, 0x58, 0x84]};
    const IID GUID_DEVCLASS_FSFILTER_COMPRESSION   = {0xAF6B58F3, 0xAAB5, 0xB549, [0x8D, 0x6C, 0x05, 0x69, 0x28, 0x4C, 0x63, 0x9F]};
    const IID GUID_DEVCLASS_FSFILTER_CONTENTSCREEN = {0x74063F3E, 0x3CC8, 0x5845, [0xBB, 0x26, 0x98, 0x20, 0xE1, 0xEB, 0xA5, 0xC5]};
    const IID GUID_DEVCLASS_FSFILTER_CONTINUOUSBACK = {0xF814AA71, 0xAD6F, 0x2246, [0xAD, 0x77, 0x92, 0xBB, 0x9D, 0x7E, 0x69, 0x47]};
    const IID GUID_DEVCLASS_FSFILTER_COPYPROTECTIO = {0xF16F7889, 0x129C, 0x2F40, [0x9C, 0x9E, 0x17, 0x75, 0x3C, 0x7F, 0x43, 0x75]};
    const IID GUID_DEVCLASS_FSFILTER_ENCRYPTION    = {0xC001A7A0, 0x11A5, 0xFF42, [0xAA, 0x6C, 0x06, 0xDC, 0x03, 0x95, 0x57, 0x6F]};
    const IID GUID_DEVCLASS_FSFILTER_HSM           = {0x0A5046D5, 0xEB2A, 0xF645, [0x94, 0x82, 0xF4, 0xB1, 0x79, 0x9C, 0x31, 0x77]};
    const IID GUID_DEVCLASS_FSFILTER_INFRASTRUCTUR = {0xF9A65FE5, 0x8C12, 0x044D, [0xAB, 0xAB, 0x63, 0x0C, 0x74, 0xB1, 0x45, 0x3A]};
    const IID GUID_DEVCLASS_FSFILTER_OPENFILEBACKU = {0xA6AFECF8, 0xD166, 0xA541, [0x89, 0x9B, 0x66, 0x58, 0x5D, 0x72, 0x16, 0xB7]};
    const IID GUID_DEVCLASS_FSFILTER_PHYSICALQUOTAMANAGEME = {0x788E0A6A, 0xA6BB, 0xC44F, [0xA7, 0x09, 0x1E, 0x33, 0xCD, 0x09, 0xD6, 0x7E]};
    const IID GUID_DEVCLASS_FSFILTER_QUOTAMANAGEME = {0x11C90385, 0xC7A6, 0x1949, [0x8F, 0x79, 0x50, 0x28, 0xF5, 0x86, 0x6B, 0x0C]};
    const IID GUID_DEVCLASS_FSFILTER_REPLICATION   = {0xC4EBD348, 0xF84C, 0xFF48, [0xB8, 0x69, 0x9C, 0x68, 0xAD, 0x42, 0xEB, 0x9F]};
    const IID GUID_DEVCLASS_FSFILTER_SECURITYENHANC = {0xDAC32BD0, 0x8E0C, 0x4549, [0x9B, 0xD5, 0xF1, 0x88, 0x3C, 0x22, 0x6C, 0x8C]};
    const IID GUID_DEVCLASS_FSFILTER_SYSTEM        = {0xAA9A1B5D, 0xE201, 0xAF46, [0x84, 0x9F, 0x27, 0x2B, 0x3F, 0x32, 0x4C, 0x46]};
    const IID GUID_DEVCLASS_FSFILTER_SYSTEMRECOVER = {0x7453B12D, 0x6E70, 0x3141, [0xA0, 0xC7, 0xD7, 0xC7, 0x8E, 0xB0, 0x28, 0x9A]};
    const IID GUID_DEVCLASS_FSFILTER_UNDELETE      = {0x72158FFE, 0x7AC6, 0xC048, [0xBB, 0xAC, 0x0B, 0x5C, 0x6D, 0x66, 0xCA, 0xFB]};
    const IID GUID_DEVCLASS_GPS                    = {0xC31FDD6B, 0x0F81, 0xD011, [0xBE, 0xC7, 0x08, 0x00, 0x2B, 0xE2, 0x09, 0x2F]};
    const IID GUID_DEVCLASS_HDC                    = {0x6AE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_HIDCLASS               = {0xA0175A74, 0xD374, 0xD011, [0xB6, 0xFE, 0x00, 0xA0, 0xC9, 0x0F, 0x57, 0xDA]};
    const IID GUID_DEVCLASS_IMAGE                  = {0xC61FDD6B, 0x0F81, 0xD011, [0xBE, 0xC7, 0x08, 0x00, 0x2B, 0xE2, 0x09, 0x2F]};
    const IID GUID_DEVCLASS_INFRARED               = {0xC51FDD6B, 0x0F81, 0xD011, [0xBE, 0xC7, 0x08, 0x00, 0x2B, 0xE2, 0x09, 0x2F]};
    const IID GUID_DEVCLASS_KEYBOARD               = {0x6BE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_LEGACYDRIVER           = {0x5D05CC8E, 0x7F04, 0xD111, [0xA5, 0x37, 0x00, 0x00, 0xF8, 0x75, 0x3E, 0xD1]};
    const IID GUID_DEVCLASS_MEDIA                  = {0x6CE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_MEDIUM_CHANGER         = {0xAE3959CE, 0xDEEB, 0xD011, [0xB1, 0x81, 0x00, 0x00, 0xF8, 0x75, 0x3E, 0xC4]};
    const IID GUID_DEVCLASS_MODEM                  = {0x6DE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_MONITOR                = {0x6EE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_MOUSE                  = {0x6FE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_MTD                    = {0x70E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_MULTIFUNCTION          = {0x71E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_MULTIPORTSERIAL        = {0xB86C9050, 0x12BA, 0xD111, [0xBF, 0x5D, 0x00, 0x00, 0xF8, 0x05, 0xF5, 0x30]};
    const IID GUID_DEVCLASS_NET                    = {0x72E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_NETCLIENT              = {0x73E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_NETSERVICE             = {0x74E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_NETTRANS               = {0x75E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_NODRIVER               = {0x76E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_PCMCIA                 = {0x77E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_PNPPRINTERS            = {0x7EEE5846, 0x50F0, 0xD111, [0xB6, 0xBD, 0x00, 0xC0, 0x4F, 0xA3, 0x72, 0xA7]};
    const IID GUID_DEVCLASS_PORTS                  = {0x78E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_PRINTER                = {0x79E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_PRINTERUPGRADE         = {0x7AE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_PROCESSOR              = {0xC37D1250, 0x360F, 0x5E41, [0xA6, 0xCC, 0x4C, 0xB3, 0xBE, 0x91, 0x0B, 0x65]};
    const IID GUID_DEVCLASS_SBP2                   = {0xBE7981D4, 0x20EC, 0xD111, [0xB6, 0xB8, 0x00, 0xC0, 0x4F, 0xA3, 0x72, 0xA7]};
    const IID GUID_DEVCLASS_SCSIADAPTER            = {0x7BE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_SMARTCARDREADER        = {0x3052DD50, 0x8ABA, 0xD111, [0xBF, 0x5D, 0x00, 0x00, 0xF8, 0x05, 0xF5, 0x30]};
    const IID GUID_DEVCLASS_SOUND                  = {0x7CE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_SYSTEM                 = {0x7DE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_TAPEDRIVE              = {0x8478806D, 0x217D, 0xCF11, [0x80, 0x1C, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_UNKNOWN                = {0x7EE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVCLASS_USB                    = {0x609EFC36, 0x65C4, 0xCF11, [0x80, 0x56, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_DEVCLASS_VOLUME                 = {0xDD7CA271, 0x2A81, 0xD011, [0xBE, 0xC7, 0x08, 0x00, 0x2B, 0xE2, 0x09, 0x2F]};
    const IID GUID_DEVCLASS_VOLUMESNAPSHOT         = {0x845B3C53, 0x70EC, 0xD211, [0x95, 0x05, 0x00, 0xC0, 0x4F, 0x79, 0xDE, 0xAF]};
    const IID GUID_DEVCLASS_WCEUSBS                = {0x51CEDB25, 0x8F6C, 0x724A, [0x8A, 0x6D, 0xB5, 0x4C, 0x2B, 0x4F, 0xC8, 0x35]};
    const IID GUID_DEVICE_INTERFACE_ARRIVAL        = {0x04403ACB, 0xF046, 0xD011, [0xB0, 0x8F, 0x00, 0x60, 0x97, 0x13, 0x05, 0x3F]};
    const IID GUID_DEVICE_INTERFACE_REMOVAL        = {0x05403ACB, 0xF046, 0xD011, [0xB0, 0x8F, 0x00, 0x60, 0x97, 0x13, 0x05, 0x3F]};
    const IID GUID_DEVINTERFACE_CDCHANGER          = {0x1263F553, 0xBFB6, 0xD011, [0x94, 0xF2, 0x00, 0xA0, 0xC9, 0x1E, 0xFB, 0x8B]};
    const IID GUID_DEVINTERFACE_CDROM              = {0x0863F553, 0xBFB6, 0xD011, [0x94, 0xF2, 0x00, 0xA0, 0xC9, 0x1E, 0xFB, 0x8B]};
    const IID GUID_DEVINTERFACE_COMPORT            = {0xE0D1E086, 0x8980, 0xD011, [0x9C, 0xE4, 0x08, 0x00, 0x3E, 0x30, 0x1F, 0x73]};
    const IID GUID_DEVINTERFACE_DISK               = {0x0763F553, 0xBFB6, 0xD011, [0x94, 0xF2, 0x00, 0xA0, 0xC9, 0x1E, 0xFB, 0x8B]};
    const IID GUID_DEVINTERFACE_FLOPPY             = {0x1163F553, 0xBFB6, 0xD011, [0x94, 0xF2, 0x00, 0xA0, 0xC9, 0x1E, 0xFB, 0x8B]};
    const IID GUID_DEVINTERFACE_MEDIUMCHANGER      = {0x1063F553, 0xBFB6, 0xD011, [0x94, 0xF2, 0x00, 0xA0, 0xC9, 0x1E, 0xFB, 0x8B]};
    const IID GUID_DEVINTERFACE_PARTITION          = {0x0A63F553, 0xBFB6, 0xD011, [0x94, 0xF2, 0x00, 0xA0, 0xC9, 0x1E, 0xFB, 0x8B]};
    const IID GUID_DEVINTERFACE_SERENUM_BUS_ENUMERAT = {0x78E9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_DEVINTERFACE_STORAGEPORT        = {0x60FECC2A, 0x30C1, 0xD211, [0xB0, 0x82, 0x00, 0xA0, 0xC9, 0x1E, 0xFB, 0x8B]};
    const IID GUID_DEVINTERFACE_TAPE               = {0x0B63F553, 0xBFB6, 0xD011, [0x94, 0xF2, 0x00, 0xA0, 0xC9, 0x1E, 0xFB, 0x8B]};
    const IID GUID_DEVINTERFACE_VOLUME             = {0x0D63F553, 0xBFB6, 0xD011, [0x94, 0xF2, 0x00, 0xA0, 0xC9, 0x1E, 0xFB, 0x8B]};
    const IID GUID_DEVINTERFACE_WRITEONCEDISK      = {0x0C63F553, 0xBFB6, 0xD011, [0x94, 0xF2, 0x00, 0xA0, 0xC9, 0x1E, 0xFB, 0x8B]};
    const IID GUID_DirectDrawPaletteStream         = {0xFC7F0C73, 0x4753, 0xD111, [0x8C, 0x4D, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5]};
    const IID GUID_DirectDrawSurfaceStream         = {0x46BC43E0, 0x1753, 0xD111, [0x8C, 0x4D, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5]};
    const IID GUID_DirectMusicAllTypes             = {0x9328ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_Disable_Auto_Download           = {0xAA28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_DisableTempo                    = {0x7D70FC45, 0xB41D, 0xD211, [0xBC, 0xAC, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB]};
    const IID GUID_DisableTimeSig                  = {0x7B70FC45, 0xB41D, 0xD211, [0xBC, 0xAC, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB]};
    const IID GUID_DMUS_PROP_DLS1                  = {0x272F8F17, 0x64C3, 0xD111, [0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12]};
    const IID GUID_DMUS_PROP_DLS2                  = {0xE59945F1, 0x8946, 0xD211, [0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6]};
    const IID GUID_DMUS_PROP_Effects               = {0x11D6A8CD, 0x4A68, 0xD211, [0x87, 0x1E, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_DMUS_PROP_GM_Hardware           = {0x242F8F17, 0x64C3, 0xD111, [0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12]};
    const IID GUID_DMUS_PROP_GS_Capable            = {0xA2AB9664, 0xB061, 0xD211, [0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6]};
    const IID GUID_DMUS_PROP_GS_Hardware           = {0x252F8F17, 0x64C3, 0xD111, [0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12]};
    const IID GUID_DMUS_PROP_INSTRUMENT2           = {0x72D35F86, 0x679F, 0xD211, [0x87, 0x2A, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_DMUS_PROP_LegacyCaps            = {0xC2CDA7CF, 0xA100, 0xD211, [0xAA, 0xD5, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12]};
    const IID GUID_DMUS_PROP_MemorySize            = {0x282F8F17, 0x64C3, 0xD111, [0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12]};
    const IID GUID_DMUS_PROP_SampleMemorySize      = {0x282F8F17, 0x64C3, 0xD111, [0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12]};
    const IID GUID_DMUS_PROP_SamplePlaybackRate    = {0x13F7912A, 0xBFA4, 0xD211, [0xBB, 0xDF, 0x00, 0x60, 0x08, 0x33, 0xDB, 0xD8]};
    const IID GUID_DMUS_PROP_SynthSink_DSOUND      = {0x4478A90A, 0x77C8, 0xD111, [0x87, 0x0C, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_DMUS_PROP_SynthSink_WAVE        = {0x4578A90A, 0x77C8, 0xD111, [0x87, 0x0C, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_DMUS_PROP_Volume                = {0x25AEDFFE, 0x6EE4, 0xD111, [0xAA, 0xCE, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12]};
    const IID GUID_DMUS_PROP_WavesReverb           = {0x2256CB04, 0xE532, 0xD211, [0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6]};
    const IID GUID_DMUS_PROP_WriteLatency          = {0xA00F8A26, 0xF260, 0xD211, [0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6]};
    const IID GUID_DMUS_PROP_WritePeriod           = {0xA10F8A26, 0xF260, 0xD211, [0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6]};
    const IID GUID_DMUS_PROP_XG_Capable            = {0xA1AB9664, 0xB061, 0xD211, [0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6]};
    const IID GUID_DMUS_PROP_XG_Hardware           = {0x262F8F17, 0x64C3, 0xD111, [0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12]};
    const IID GUID_Download                        = {0xA728ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_Enable_Auto_Download            = {0xA928ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_EnableTempo                     = {0x7E70FC45, 0xB41D, 0xD211, [0xBC, 0xAC, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB]};
    const IID GUID_EnableTimeSig                   = {0x7C70FC45, 0xB41D, 0xD211, [0xBC, 0xAC, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB]};
    const IID GUID_FONTBOLD                        = {0x0F435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_FONTITALIC                      = {0x10435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_FONTNAME                        = {0x0D435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_FONTSIZE                        = {0x0E435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_FONTSTRIKETHROUGH               = {0x12435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_FONTUNDERSCORE                  = {0x11435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_Friction                        = {0x2A1C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_HANDLE                          = {0x13435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_HasPathProperties               = {0x81DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID GUID_HIDClass                        = {0xA0175A74, 0xD374, 0xD011, [0xB6, 0xFE, 0x00, 0xA0, 0xC9, 0x0F, 0x57, 0xDA]};
    const IID GUID_HIMETRIC                        = {0x00435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_HWPROFILE_CHANGE_CANCELLED      = {0x02403ACB, 0xF046, 0xD011, [0xB0, 0x8F, 0x00, 0x60, 0x97, 0x13, 0x05, 0x3F]};
    const IID GUID_HWPROFILE_CHANGE_COMPLETE       = {0x03403ACB, 0xF046, 0xD011, [0xB0, 0x8F, 0x00, 0x60, 0x97, 0x13, 0x05, 0x3F]};
    const IID GUID_HWPROFILE_QUERY_CHANGE          = {0x01403ACB, 0xF046, 0xD011, [0xB0, 0x8F, 0x00, 0x60, 0x97, 0x13, 0x05, 0x3F]};
    const IID GUID_IDirectMusicBand                = {0xAC28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_IDirectMusicChordMap            = {0xAD28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_IDirectMusicStyle               = {0xA128ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_Inertia                         = {0x291C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_INT_ROUTE_INTERFACE_STANDARD    = {0xF41B9470, 0x7300, 0xD111, [0xA0, 0x9E, 0x00, 0xC0, 0x4F, 0xC3, 0x40, 0xB1]};
    const IID GUID_Joystick                        = {0x702B1D6F, 0xA0D5, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_KernelCallbacks                 = {0x00388680, 0x066B, 0xD011, [0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8]};
    const IID GUID_KernelCaps                      = {0x4075AAFF, 0xA87A, 0xD011, [0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8]};
    const IID GUID_Key                             = {0x20827255, 0x3CD3, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_KeyboardClass                   = {0x6BE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_LEGACY_DEVICE_DETECTION_STANDAR = {0xDEB0FE50, 0x6A59, 0xD211, [0xA5, 0xB8, 0x00, 0x00, 0xF8, 0x1A, 0x46, 0x19]};
    const IID GUID_MediaClass                      = {0x6CE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_MF_ENUMERATION_INTERFACE        = {0xF095B8AE, 0x8655, 0xD111, [0x8D, 0x84, 0x00, 0xA0, 0xC9, 0x06, 0xB2, 0x44]};
    const IID GUID_Miscellaneous2Callbacks         = {0x002F6B40, 0x5A3E, 0xD111, [0xB6, 0x40, 0x00, 0xAA, 0x00, 0xA1, 0xF9, 0x6A]};
    const IID GUID_MiscellaneousCallbacks          = {0xC00CD6EF, 0xE749, 0xD011, [0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A]};
    const IID GUID_MotionCompCallbacks             = {0x402B12B1, 0xA55D, 0xD111, [0x8F, 0xCF, 0x00, 0xC0, 0x4F, 0xC2, 0x9B, 0x4E]};
    const IID GUID_MouseClass                      = {0x6FE9364D, 0x25E3, 0xCE11, [0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18]};
    const IID GUID_MuteParam                       = {0xAF28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_NDIS_802_11_ADD_WEP             = {0xF0BF0743, 0x2921, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_AUTHENTICATION_MODE = {0x240A9243, 0x2921, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_BASIC_RATES         = {0x1685194A, 0x6820, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_BSSID               = {0xC2B60425, 0xA51F, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_BSSID_LIST          = {0x9A6F5269, 0x6220, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_BSSID_LIST_SCAN     = {0xE1019E0D, 0x70BA, 0xD411, [0xB6, 0x75, 0x00, 0x20, 0x48, 0x57, 0x03, 0x37]};
    const IID GUID_NDIS_802_11_CONFIGURATION       = {0x82F94D4A, 0x6820, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_DESIRED_RATES       = {0x8EE02E45, 0x3625, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_DISASSOCIATE        = {0x401F6743, 0x2921, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_FRAGMENTATION_THRESHO = {0xC4A7AA69, 0x6220, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_INFRASTRUCTURE_MODE = {0x7E5A7D69, 0x6220, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_NETWORK_TYPE_IN_USE = {0x26237E85, 0x4120, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_NETWORK_TYPES_SUPPORT = {0xE6D63185, 0x4120, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_NUMBER_OF_ANTENNAS  = {0x36937701, 0x6420, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_POWER_MODE          = {0x7C83BE85, 0x4120, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_PRIVACY_FILTER      = {0xE9C43367, 0x9247, 0xD411, [0x97, 0xF1, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_REMOVE_WEP          = {0x5C343C43, 0x2921, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_RSSI                = {0x16DB0715, 0x5320, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_RSSI_TRIGGER        = {0xB8895615, 0x5320, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_RTS_THRESHOLD       = {0x7ED03401, 0x6420, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_RX_ANTENNA_SELECTED = {0xA207AC01, 0x6420, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_SSID                = {0xEA902A7D, 0x4120, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_STATISTICS          = {0xB073BB42, 0x2921, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_SUPPORTED_RATES     = {0x2287DB49, 0x6820, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_TX_ANTENNA_SELECTED = {0x4AB7DB01, 0x6420, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_TX_POWER_LEVEL      = {0x76BAE611, 0x5320, 0xD411, [0x97, 0xEB, 0x00, 0xC0, 0x4F, 0x79, 0xC4, 0x03]};
    const IID GUID_NDIS_802_11_WEP_STATUS          = {0x1FA227B0, 0xFA3C, 0x2541, [0x80, 0x0B, 0x3F, 0x7A, 0x18, 0xFD, 0xDC, 0xDC]};
    const IID GUID_NDIS_802_3_CURRENT_ADDRESS      = {0x00577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_3_MAC_OPTIONS          = {0x03577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_3_MAXIMUM_LIST_SIZE    = {0x02577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_3_MULTICAST_LIST       = {0x01577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_3_PERMANENT_ADDRESS    = {0xFF567944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_3_RCV_ERROR_ALIGNMENT  = {0x04577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_3_XMIT_MORE_COLLISIONS = {0x06577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_3_XMIT_ONE_COLLISION   = {0x05577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_5_CURRENT_ADDRESS      = {0x08577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_5_CURRENT_FUNCTIONAL   = {0x09577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_5_CURRENT_GROUP        = {0x0A577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_5_CURRENT_RING_STATE   = {0x3240F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_5_CURRENT_RING_STATUS  = {0xEC360A89, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_5_LAST_OPEN_STATUS     = {0x0B577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_5_LINE_ERRORS          = {0x3340F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_5_LOST_FRAMES          = {0x3440F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_802_5_PERMANENT_ADDRESS    = {0x07577944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_HW_CURRENT_ADDRESS     = {0xA1D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_MAX_AAL0_PACKET_SIZE   = {0xA5D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_MAX_AAL1_PACKET_SIZE   = {0xA6D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_MAX_AAL34_PACKET_SIZE  = {0xA7D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_MAX_AAL5_PACKET_SIZE   = {0x91D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_MAX_ACTIVE_VCI_BITS    = {0xA3D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_MAX_ACTIVE_VCS         = {0xA2D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_MAX_ACTIVE_VPI_BITS    = {0xA4D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_RCV_CELLS_DROPPED      = {0x0C48210A, 0x5FE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_RCV_CELLS_OK           = {0x0A48210A, 0x5FE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_SUPPORTED_AAL_TYPES    = {0xA0D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_SUPPORTED_SERVICE_CATEGO = {0x9FD11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_SUPPORTED_VC_RATES     = {0x9ED11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ATM_XMIT_CELLS_OK          = {0x0B48210A, 0x5FE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ENUMERATE_ADAPTER          = {0x7F2D1F98, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_ENUMERATE_VC               = {0x822D1F98, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_ATTACHMENT_TYPE       = {0x3D40F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_DOWNSTREAM_NODE_LONG  = {0x3F40F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_FRAME_ERRORS          = {0x4040F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_FRAMES_LOST           = {0x4140F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_LCONNECTION_STATE     = {0x4540F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_LCT_FAILURES          = {0x4340F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_LEM_REJECTS           = {0x4440F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_LONG_CURRENT_ADDR     = {0x3640F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_LONG_MAX_LIST_SIZE    = {0x3840F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_LONG_MULTICAST_LIST   = {0x3740F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_LONG_PERMANENT_ADDR   = {0x3540F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_RING_MGT_STATE        = {0x4240F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_SHORT_CURRENT_ADDR    = {0x3A40F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_SHORT_MAX_LIST_SIZE   = {0x3C40F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_SHORT_MULTICAST_LIST  = {0x3B40F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_SHORT_PERMANENT_ADDR  = {0x3940F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_FDDI_UPSTREAM_NODE_LONG    = {0x3E40F1AC, 0x1CA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_DRIVER_VERSION      = {0x98D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_HARDWARE_STATUS     = {0x92D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_LINK_SPEED          = {0x95D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_MAC_OPTIONS         = {0x9AD11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_MEDIA_CONNECT_STATU = {0x9BD11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_MEDIA_IN_USE        = {0x94D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_MEDIA_SUPPORTED     = {0x93D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_MINIMUM_LINK_SPEED  = {0x9DD11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_RCV_PDUS_ERROR      = {0x0848210A, 0x5FE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_RCV_PDUS_NO_BUFFER  = {0x0948210A, 0x5FE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_RCV_PDUS_OK         = {0x0648210A, 0x5FE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_VENDOR_DESCRIPTION  = {0x97D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_VENDOR_DRIVER_VERSI = {0x9CD11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_VENDOR_ID           = {0x96D11A79, 0x5CE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_XMIT_PDUS_ERROR     = {0x0748210A, 0x5FE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CO_XMIT_PDUS_OK        = {0x0548210A, 0x5FE3, 0xD011, [0x96, 0x92, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CURRENT_LOOKAHEAD      = {0x6103C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_CURRENT_PACKET_FILTER  = {0x6003C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_DRIVER_VERSION         = {0x6203C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_HARDWARE_STATUS        = {0x5403C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_LINK_SPEED             = {0x5903C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_MAC_OPTIONS            = {0x6503C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_MAXIMUM_FRAME_SIZE     = {0x5803C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_MAXIMUM_LOOKAHEAD      = {0x5703C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_MAXIMUM_SEND_PACKETS   = {0x6703C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_MAXIMUM_TOTAL_SIZE     = {0x6303C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_MEDIA_CONNECT_STATUS   = {0x6603C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_MEDIA_IN_USE           = {0x5603C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_MEDIA_SUPPORTED        = {0x5503C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_PHYSICAL_MEDIUM        = {0x6DA18C41, 0x3739, 0x0842, [0x94, 0x0A, 0xEC, 0x61, 0x96, 0x27, 0x80, 0x85]};
    const IID GUID_NDIS_GEN_RCV_ERROR              = {0xFD567944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_RCV_NO_BUFFER          = {0xFE567944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_RCV_OK                 = {0xFB567944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_RECEIVE_BLOCK_SIZE     = {0x5D03C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_RECEIVE_BUFFER_SPACE   = {0x5B03C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_TRANSMIT_BLOCK_SIZE    = {0x5C03C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_TRANSMIT_BUFFER_SPACE  = {0x5A03C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_VENDOR_DESCRIPTION     = {0x5F03C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_VENDOR_DRIVER_VERSION  = {0xF9567944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_VENDOR_ID              = {0x5E03C15E, 0x1AA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_VLAN_ID                = {0x02C75D76, 0xE8C5, 0x674B, [0x84, 0x3B, 0x3F, 0x5A, 0x4F, 0xF2, 0x64, 0x8B]};
    const IID GUID_NDIS_GEN_XMIT_ERROR             = {0xFC567944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_GEN_XMIT_OK                = {0xFA567944, 0x1BA6, 0xD011, [0x8D, 0xD4, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_LAN_CLASS                  = {0x448949AD, 0x2F76, 0xD011, [0x8D, 0xCB, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_NOTIFY_ADAPTER_ARRIVAL     = {0x812D1F98, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_NOTIFY_ADAPTER_REMOVAL     = {0x802D1F98, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_NOTIFY_BIND                = {0x1C531354, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_NOTIFY_UNBIND              = {0xECE13C6E, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_NOTIFY_VC_ARRIVAL          = {0x0C9E2F18, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_NOTIFY_VC_REMOVAL          = {0x792D1F98, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_STATUS_LINK_SPEED_CHANGE   = {0x852D1F98, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_STATUS_MEDIA_CONNECT       = {0x7D2D1F98, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_STATUS_MEDIA_DISCONNECT    = {0x7E2D1F98, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_STATUS_MEDIA_SPECIFIC_INDICATI = {0x842D1F98, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_STATUS_RESET_END           = {0x772D1F98, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_STATUS_RESET_START         = {0x762D1F98, 0xF3B1, 0xD011, [0x8D, 0xD7, 0x00, 0xC0, 0x4F, 0xC3, 0x35, 0x8C]};
    const IID GUID_NDIS_WAKE_ON_MAGIC_PACKET_ONLY  = {0x971C4FA1, 0x3988, 0x8A4F, [0x99, 0x96, 0xA2, 0x89, 0x96, 0xEB, 0xBF, 0x1D]};
    const IID GUID_NETSHELL_PROPS                  = {0xA1A9152D, 0x56A5, 0x8941, [0x91, 0xAD, 0x02, 0x74, 0x58, 0xF1, 0x1A, 0x07]};
    const IID GUID_NonLocalVidMemCaps              = {0x80FAC486, 0x848D, 0xD011, [0x94, 0xE8, 0x00, 0xC0, 0x4F, 0xC3, 0x41, 0x37]};
    const IID GUID_NOTIFICATION_CHORD              = {0x9B28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_NOTIFICATION_COMMAND            = {0x9C28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_NOTIFICATION_MEASUREANDBEAT     = {0x9A28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_NOTIFICATION_PERFORMANCE        = {0xC55BF781, 0x5D4E, 0xD211, [0xBC, 0xC7, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB]};
    const IID GUID_NOTIFICATION_SEGMENT            = {0x9928ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_NULL                            = {0x00000000, 0x0000, 0x0000, [0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]};
    const IID GUID_OPTIONVALUEEXCLUSIVE            = {0x0B435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_OptSurfaceKmodeInfo             = {0x72845CE0, 0xD451, 0xD111, [0x8C, 0xCE, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8]};
    const IID GUID_OptSurfaceUmodeInfo             = {0x0428799D, 0xA85F, 0xD111, [0x8C, 0xD0, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8]};
    const IID GUID_PathProperty                    = {0x80DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID GUID_PCI_BUS_INTERFACE_STANDARD      = {0x81826B49, 0x256F, 0xD011, [0xBE, 0xAF, 0x08, 0x00, 0x2B, 0xE2, 0x09, 0x2F]};
    const IID GUID_PCI_DEVICE_PRESENT_INTERFACE    = {0x262CB8D1, 0x49BF, 0xEF45, [0xB2, 0x16, 0x71, 0xCB, 0xD7, 0x88, 0x9B, 0x57]};
    const IID GUID_PCMCIA_BUS_INTERFACE_STANDARD   = {0xF03A1776, 0x04C5, 0xD111, [0x94, 0x7F, 0x00, 0xC0, 0x4F, 0xB9, 0x60, 0xEE]};
    const IID GUID_PerfAutoDownload                = {0x5B5609FB, 0x3136, 0xD211, [0xBC, 0xB8, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB]};
    const IID GUID_PerfMasterGrooveLevel           = {0xB228ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_PerfMasterTempo                 = {0xB028ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_PerfMasterVolume                = {0xB128ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_PNP_CUSTOM_NOTIFICATION         = {0x8E3FA7AC, 0x238D, 0xD111, [0xAC, 0x7D, 0x00, 0x00, 0xF8, 0x75, 0x71, 0xD0]};
    const IID GUID_PNP_POWER_NOTIFICATION          = {0x6006CFC2, 0x7AEB, 0xD111, [0xBD, 0x7F, 0x00, 0x00, 0xF8, 0x75, 0x71, 0xD0]};
    const IID GUID_POV                             = {0xF2026DA3, 0xF3C9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_POWER_DEVICE_ENABLE             = {0x6F0A7C82, 0xB0FE, 0xD011, [0xBD, 0x26, 0x00, 0xAA, 0x00, 0xB7, 0xB3, 0x2A]};
    const IID GUID_POWER_DEVICE_TIMEOUTS           = {0x35A75DA4, 0xB0FE, 0xD011, [0xBD, 0x26, 0x00, 0xAA, 0x00, 0xB7, 0xB3, 0x2A]};
    const IID GUID_POWER_DEVICE_WAKE_ENABLE        = {0x826A54A9, 0xB0FE, 0xD011, [0xBD, 0x26, 0x00, 0xAA, 0x00, 0xB7, 0xB3, 0x2A]};
    const IID GUID_QOS_BESTEFFORT_BANDWIDTH        = {0x905288ED, 0xEC40, 0xD111, [0x2C, 0x91, 0x00, 0xAA, 0x00, 0x57, 0x49, 0x15]};
    const IID GUID_QOS_ENABLE_AVG_STATS            = {0x116DFBBA, 0xC427, 0x0148, [0xA4, 0x6F, 0xEF, 0x80, 0x80, 0xC1, 0x88, 0xC8]};
    const IID GUID_QOS_ENABLE_WINDOW_ADJUSTMENT    = {0x256796AA, 0xE9D3, 0x554C, [0xB3, 0x35, 0x2A, 0x00, 0x27, 0x9A, 0x1E, 0x64]};
    const IID GUID_QOS_FLOW_8021P_CONFORMING       = {0x13E0C108, 0xD2FC, 0xD211, [0xBE, 0x1E, 0x00, 0xA0, 0xC9, 0x9E, 0xE6, 0x3B]};
    const IID GUID_QOS_FLOW_8021P_NONCONFORMING    = {0x913F0209, 0xD2FC, 0xD211, [0xBE, 0x1E, 0x00, 0xA0, 0xC9, 0x9E, 0xE6, 0x3B]};
    const IID GUID_QOS_FLOW_COUNT                  = {0x80F84711, 0xED40, 0xD111, [0x2C, 0x91, 0x00, 0xAA, 0x00, 0x57, 0x49, 0x15]};
    const IID GUID_QOS_FLOW_IP_CONFORMING          = {0x8B9AF907, 0xD2FC, 0xD211, [0xBE, 0x1E, 0x00, 0xA0, 0xC9, 0x9E, 0xE6, 0x3B]};
    const IID GUID_QOS_FLOW_IP_NONCONFORMING       = {0x87597A08, 0xD2FC, 0xD211, [0xBE, 0x1E, 0x00, 0xA0, 0xC9, 0x9E, 0xE6, 0x3B]};
    const IID GUID_QOS_FLOW_MODE                   = {0x0A29825C, 0x5A51, 0xD211, [0x8E, 0x58, 0x00, 0xC0, 0x4F, 0xC9, 0xBF, 0xCB]};
    const IID GUID_QOS_ISSLOW_FLOW                 = {0xA473F2AB, 0x07EE, 0xD211, [0xBE, 0x1B, 0x00, 0xA0, 0xC9, 0x9E, 0xE6, 0x3B]};
    const IID GUID_QOS_LATENCY                     = {0xF08E40FC, 0xEC40, 0xD111, [0x2C, 0x91, 0x00, 0xAA, 0x00, 0x57, 0x49, 0x15]};
    const IID GUID_QOS_MAX_OUTSTANDING_SENDS       = {0x86FA1F16, 0x2061, 0xD111, [0x2C, 0x91, 0x00, 0xAA, 0x00, 0x57, 0x49, 0x15]};
    const IID GUID_QOS_NON_BESTEFFORT_LIMIT        = {0xE0445C18, 0xED40, 0xD111, [0x2C, 0x91, 0x00, 0xAA, 0x00, 0x57, 0x49, 0x15]};
    const IID GUID_QOS_REMAINING_BANDWIDTH         = {0x2017C5C4, 0xEC40, 0xD111, [0x2C, 0x91, 0x00, 0xAA, 0x00, 0x57, 0x49, 0x15]};
    const IID GUID_QOS_STATISTICS_BUFFER           = {0x80092CBB, 0x00E9, 0xD111, [0xB0, 0x7E, 0x00, 0x80, 0xC7, 0x13, 0x82, 0xBF]};
    const IID GUID_QOS_TIMER_RESOLUTION            = {0x88CC10BA, 0x3EF1, 0xD211, [0xBE, 0x1B, 0x00, 0xA0, 0xC9, 0x9E, 0xE6, 0x3B]};
    const IID GUID_RampForce                       = {0x211C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_RhythmParam                     = {0x9F28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_RxAxis                          = {0xF4026DA3, 0xF3C9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_RyAxis                          = {0xF5026DA3, 0xF3C9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_RzAxis                          = {0xE3026DA3, 0xF3C9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_SawtoothDown                    = {0x261C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_SawtoothUp                      = {0x251C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_SeedVariations                  = {0xA56FB765, 0x37FF, 0xD211, [0x81, 0x4E, 0x00, 0xC0, 0x4F, 0xA3, 0x6E, 0x58]};
    const IID GUID_Sine                            = {0x231C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_Slider                          = {0xE4026DA3, 0xF3C9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_Spring                          = {0x271C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_Square                          = {0x221C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_StandardMIDIFile                = {0x75106206, 0x2EE9, 0xD111, [0xA8, 0xC5, 0x00, 0xC0, 0x4F, 0xA3, 0x72, 0x6E]};
    const IID GUID_SysKeyboard                     = {0x612B1D6F, 0xA0D5, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_SysKeyboardEm                   = {0x822B1D6F, 0xA0D5, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_SysKeyboardEm2                  = {0x832B1D6F, 0xA0D5, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_SysMouse                        = {0x602B1D6F, 0xA0D5, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_SysMouseEm                      = {0x802B1D6F, 0xA0D5, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_SysMouseEm2                     = {0x812B1D6F, 0xA0D5, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_TARGET_DEVICE_QUERY_REMOVE      = {0x06403ACB, 0xF046, 0xD011, [0xB0, 0x8F, 0x00, 0x60, 0x97, 0x13, 0x05, 0x3F]};
    const IID GUID_TARGET_DEVICE_REMOVE_CANCELLED  = {0x07403ACB, 0xF046, 0xD011, [0xB0, 0x8F, 0x00, 0x60, 0x97, 0x13, 0x05, 0x3F]};
    const IID GUID_TARGET_DEVICE_REMOVE_COMPLETE   = {0x08403ACB, 0xF046, 0xD011, [0xB0, 0x8F, 0x00, 0x60, 0x97, 0x13, 0x05, 0x3F]};
    const IID GUID_TempoParam                      = {0xA528ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_TimeSignature                   = {0xA428ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_TRANSLATOR_INTERFACE_STANDARD   = {0x924A156C, 0xCFAA, 0xD011, [0x8D, 0x2A, 0x00, 0xA0, 0xC9, 0x06, 0xB2, 0x44]};
    const IID GUID_Triangle                        = {0x241C5413, 0x338E, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID GUID_TRISTATE                        = {0x0A435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_Unknown                         = {0xF3026DA3, 0xF3C9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_Unload                          = {0xA828ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID GUID_UserModeDriverInfo              = {0xE2E8B0F0, 0x975F, 0xD111, [0x8C, 0xD0, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8]};
    const IID GUID_UserModeDriverPassword          = {0xB661F897, 0xA160, 0xD111, [0x8C, 0xD0, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8]};
    const IID GUID_VideoPortCallbacks              = {0xC10CD6EF, 0xE749, 0xD011, [0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A]};
    const IID GUID_VideoPortCaps                   = {0xC30CD6EF, 0xE749, 0xD011, [0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A]};
    const IID GUID_XAxis                           = {0xE0026DA3, 0xF3C9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_XPOS                            = {0x06435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_XPOSPIXEL                       = {0x02435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_XSIZE                           = {0x08435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_XSIZEPIXEL                      = {0x04435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_YAxis                           = {0xE1026DA3, 0xF3C9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_YPOS                            = {0x07435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_YPOSPIXEL                       = {0x03435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_YSIZE                           = {0x09435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_YSIZEPIXEL                      = {0x05435066, 0x0FBE, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID GUID_ZAxis                           = {0xE2026DA3, 0xF3C9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID GUID_ZPixelFormats                   = {0x80988693, 0xCF36, 0xD111, [0x9B, 0x1B, 0x00, 0xAA, 0x00, 0xBB, 0xB8, 0xAE]};
    const IID IID_AsyncIAdviseSink                 = {0x50010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_AsyncIAdviseSink2                = {0x51010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_AsyncIBackgroundCopyCallback     = {0x51D229CA, 0xBBB4, 0x7946, [0xA3, 0xD9, 0xAE, 0x80, 0x06, 0x11, 0x9D, 0x54]};
    const IID IID_AsyncIClusCfgBaseCluster         = {0x14C6A5A8, 0x1825, 0xF547, [0x96, 0xCA, 0xCA, 0xFA, 0x7F, 0xFB, 0xAF, 0x68]};
    const IID IID_AsyncIClusCfgCallback            = {0x4589CEEB, 0x69AC, 0x3A4B, [0x86, 0x5D, 0xE2, 0xD4, 0xEB, 0x33, 0xE4, 0x1B]};
    const IID IID_AsyncIClusCfgClusterInfo         = {0x47A2DB8B, 0xF504, 0x1441, [0x83, 0x7E, 0xB2, 0x63, 0x41, 0x2A, 0x4B, 0x64]};
    const IID IID_AsyncIClusCfgCredentials         = {0x0694AA54, 0x09A4, 0x494B, [0xB3, 0x14, 0x5F, 0x0A, 0x0C, 0xE4, 0xC8, 0x8F]};
    const IID IID_AsyncIClusCfgEvictCleanup        = {0x62E3E36F, 0x73D3, 0x5F4C, [0xA0, 0xAF, 0x1D, 0xFE, 0x84, 0x93, 0xC6, 0x55]};
    const IID IID_AsyncIClusCfgInitialize          = {0x2EB80E2A, 0x78F8, 0x2A49, [0x95, 0x1E, 0xAE, 0x00, 0x09, 0x18, 0xC4, 0xA6]};
    const IID IID_AsyncIClusCfgIPAddressInfo       = {0xA5F0EAAA, 0x10E3, 0x0446, [0xA5, 0x5E, 0x2F, 0x9D, 0xDC, 0x41, 0x57, 0xA9]};
    const IID IID_AsyncIClusCfgManagedResourceInfo = {0x28606173, 0x4312, 0x4947, [0xAD, 0x84, 0x0B, 0x5E, 0xB3, 0x58, 0xFF, 0xA0]};
    const IID IID_AsyncIClusCfgMemberSetChangeListen = {0x5053642B, 0x4326, 0xBC4A, [0xA4, 0xE5, 0x82, 0x4D, 0x88, 0x1B, 0x75, 0x82]};
    const IID IID_AsyncIClusCfgNetworkInfo         = {0x2DFD71ED, 0x02AD, 0xFC4D, [0xB3, 0x76, 0x5F, 0xFA, 0x5F, 0x5A, 0x7C, 0x2C]};
    const IID IID_AsyncIClusCfgNodeInfo            = {0x0BB43B4F, 0x27DF, 0xA040, [0xB3, 0x1A, 0xBA, 0x18, 0x32, 0x4C, 0xEB, 0x9D]};
    const IID IID_AsyncIClusCfgPartitionInfo       = {0x9FBD1EEC, 0x6658, 0x4648, [0x89, 0x52, 0xEC, 0x36, 0xC3, 0x96, 0x1E, 0xEF]};
    const IID IID_AsyncIClusCfgResourceTypeCreate  = {0xB9E3FC3A, 0x3E5F, 0xDF4D, [0xA8, 0xF4, 0x4B, 0x4F, 0xCB, 0xF2, 0x8F, 0x8F]};
    const IID IID_AsyncIClusCfgResourceTypeInfo    = {0x82A249C6, 0x47C8, 0x5C4F, [0x98, 0x41, 0xD2, 0xF7, 0x3B, 0x5A, 0xA7, 0x1D]};
    const IID IID_AsyncIClusCfgServer              = {0xAA40162A, 0x6145, 0x084A, [0xB5, 0xD9, 0x0A, 0xA3, 0x8C, 0x6B, 0xE6, 0x28]};
    const IID IID_AsyncIClusCfgStartupListener     = {0xF0CA82D2, 0xDE2E, 0xB94A, [0xA5, 0xD5, 0xF7, 0xBD, 0xE3, 0xD2, 0x3F, 0x10]};
    const IID IID_AsyncIClusCfgStartupNotify       = {0x6AD0B0C2, 0x5363, 0xE14E, [0xB2, 0x53, 0x6B, 0x0D, 0x75, 0xDB, 0x2C, 0xD3]};
    const IID IID_AsyncIEnumClusCfgIPAddresses     = {0xBA355FBD, 0xC00B, 0x5F45, [0x92, 0x6D, 0xC3, 0xD3, 0x56, 0x41, 0x94, 0x87]};
    const IID IID_AsyncIEnumClusCfgManagedResource = {0x3F4838B1, 0x9596, 0xA64F, [0xA9, 0x8F, 0x0D, 0xE2, 0xFB, 0x35, 0x54, 0x49]};
    const IID IID_AsyncIEnumClusCfgNetworks        = {0x0D9B6BF5, 0xB8E7, 0xEC49, [0xA8, 0x43, 0x54, 0x75, 0x07, 0x6B, 0x94, 0x7D]};
    const IID IID_AsyncIEnumClusCfgPartitions      = {0x6ABB4044, 0xACB0, 0x9D47, [0xB5, 0x34, 0x72, 0x65, 0xA3, 0x1D, 0x6C, 0x56]};
    const IID IID_AsyncIMultiQI                    = {0x20000E00, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_AsyncIPipeByte                   = {0xCB3A2FDB, 0x862F, 0xD111, [0x8E, 0x04, 0x00, 0xC0, 0x4F, 0xB9, 0x98, 0x9A]};
    const IID IID_AsyncIPipeDouble                 = {0xCF3A2FDB, 0x862F, 0xD111, [0x8E, 0x04, 0x00, 0xC0, 0x4F, 0xB9, 0x98, 0x9A]};
    const IID IID_AsyncIPipeLong                   = {0xCD3A2FDB, 0x862F, 0xD111, [0x8E, 0x04, 0x00, 0xC0, 0x4F, 0xB9, 0x98, 0x9A]};
    const IID IID_AsyncIUnknown                    = {0x00000E00, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_DFConstraint                     = {0x50F03D4A, 0xBD23, 0xD211, [0x93, 0x9F, 0x00, 0xA0, 0xC9, 0x1E, 0xED, 0xBA]};
    const IID IID_DIEnumWbemClassObject            = {0x37A07CCB, 0x29F7, 0xD011, [0x9E, 0x4D, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID IID_DIWbemCallResult                 = {0x39A07CCB, 0x29F7, 0xD011, [0x9E, 0x4D, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID IID_DIWbemClassObject                = {0x33A07CCB, 0x29F7, 0xD011, [0x9E, 0x4D, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID IID_DIWbemContext                    = {0x38A07CCB, 0x29F7, 0xD011, [0x9E, 0x4D, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID IID_DIWbemLocator                    = {0x35A07CCB, 0x29F7, 0xD011, [0x9E, 0x4D, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID IID_DIWbemObjectSink                 = {0x36A07CCB, 0x29F7, 0xD011, [0x9E, 0x4D, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID IID_DIWbemQualifierSet               = {0x34A07CCB, 0x29F7, 0xD011, [0x9E, 0x4D, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID IID_DIWbemServices                   = {0x3AA07CCB, 0x29F7, 0xD011, [0x9E, 0x4D, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID IID_Folder                           = {0x60DECBBB, 0xFFC3, 0xCE11, [0x83, 0x50, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_Folder2                          = {0xEFD8D2F0, 0x9038, 0xD211, [0xBF, 0x8B, 0x00, 0xC0, 0x4F, 0xB9, 0x36, 0x61]};
    const IID IID_Folder3                          = {0x645FAEA7, 0xD7C4, 0x7F4D, [0x93, 0x07, 0x4D, 0x24, 0xEE, 0x54, 0xB8, 0x41]};
    const IID IID_FolderItem                       = {0x802CC3FA, 0xE4CB, 0xCE11, [0x83, 0x50, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_FolderItem2                      = {0xAA17C8ED, 0xB892, 0xD111, [0xB0, 0x75, 0x00, 0xC0, 0x4F, 0xC3, 0x3A, 0xA5]};
    const IID IID_FolderItems                      = {0xE0294174, 0xE5CB, 0xCE11, [0x83, 0x50, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_FolderItems2                     = {0xD00A4FC9, 0x63F3, 0xD211, [0xA3, 0x27, 0x00, 0xC0, 0x4F, 0x8E, 0xEC, 0x7F]};
    const IID IID_FolderItems3                     = {0x09C3A7EA, 0xECBB, 0xD549, [0x82, 0x1D, 0x64, 0xD9, 0x66, 0xCB, 0x66, 0x7F]};
    const IID IID_FolderItemVerb                   = {0x003EEC08, 0xB050, 0xCF11, [0x96, 0x0C, 0x00, 0x80, 0xC7, 0xF4, 0xEE, 0x85]};
    const IID IID_FolderItemVerbs                  = {0xC052831F, 0xB050, 0xCF11, [0x96, 0x0C, 0x00, 0x80, 0xC7, 0xF4, 0xEE, 0x85]};
    const IID IID_IAccessControl                   = {0xE023DDEE, 0x1084, 0xCE11, [0xA1, 0xC3, 0x08, 0x00, 0x2B, 0x2B, 0x8D, 0x8F]};
    const IID IID_IAccessible                      = {0xE0368761, 0x3D3C, 0xCF11, [0x81, 0x0C, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71]};
    const IID IID_IAccessibleHandler               = {0x30240203, 0xC4AB, 0xD011, [0xBD, 0xE2, 0x00, 0xAA, 0x00, 0x1A, 0x19, 0x53]};
    const IID IID_IAccessor                        = {0x8C3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IAccIdentity                     = {0x8DB75278, 0xFD1C, 0xC141, [0xA6, 0x15, 0x9C, 0x0C, 0x85, 0x96, 0x0B, 0x5F]};
    const IID IID_IAccountDiscovery                = {0xBC2B20FA, 0xBE6A, 0x174C, [0xB1, 0x84, 0x57, 0x0B, 0x6C, 0xF2, 0x56, 0xA6]};
    const IID IID_IAccPropServer                   = {0xBBDBC076, 0xE015, 0x7B4E, [0xB6, 0x1B, 0x20, 0xEE, 0xEA, 0x20, 0x01, 0xE0]};
    const IID IID_IAccPropServices                 = {0x76E7266E, 0xF004, 0x5D49, [0x80, 0xE4, 0x33, 0x30, 0x35, 0x2E, 0x31, 0x69]};
    const IID IID_IACList                          = {0xB030A177, 0xFD94, 0xD011, [0xA5, 0x44, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62]};
    const IID IID_IACList2                         = {0xA0410147, 0x8651, 0xD211, [0xBB, 0xB6, 0x00, 0x60, 0x97, 0x7B, 0x46, 0x4C]};
    const IID IID_IActionProgress                  = {0x7311FF49, 0xDCEA, 0x6D44, [0x92, 0x85, 0x15, 0x64, 0x53, 0xA6, 0x43, 0x1C]};
    const IID IID_IActionProgressDialog            = {0x7211FF49, 0xDCEA, 0x6D44, [0x92, 0x85, 0x15, 0x64, 0x53, 0xA6, 0x43, 0x1C]};
    const IID IID_IActiveDesktop                   = {0x00EB90F4, 0x4012, 0xD111, [0x98, 0x88, 0x00, 0x60, 0x97, 0xDE, 0xAC, 0xF9]};
    const IID IID_IActiveIME                       = {0x6209E26F, 0x77D0, 0xD011, [0x8F, 0xE7, 0x00, 0xAA, 0x00, 0x6B, 0xCC, 0x59]};
    const IID IID_IActiveIME2                      = {0x0EBFC4E1, 0x532D, 0xD211, [0x93, 0xE1, 0x00, 0x60, 0xB0, 0x67, 0xB8, 0x6E]};
    const IID IID_IActiveIMMApp                    = {0x40E0C008, 0xD162, 0xD111, [0x93, 0x26, 0x00, 0x60, 0xB0, 0x67, 0xB8, 0x6E]};
    const IID IID_IActiveIMMIME                    = {0x1134C008, 0x6BF9, 0xD011, [0xA4, 0x75, 0x00, 0xAA, 0x00, 0x6B, 0xCC, 0x59]};
    const IID IID_IActiveIMMMessagePumpOwner       = {0xFA2CCFB5, 0xEB8A, 0xD111, [0x93, 0x64, 0x00, 0x60, 0xB0, 0x67, 0xB8, 0x6E]};
    const IID IID_IActiveIMMRegistrar              = {0x828045B3, 0x00BD, 0xD111, [0x93, 0x9B, 0x00, 0x60, 0xB0, 0x67, 0xB8, 0x6E]};
    const IID IID_IActiveScript                    = {0xE12A1ABB, 0xF9A4, 0xCF11, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID IID_IActiveScriptAuthor              = {0xA09D109C, 0x0670, 0xD111, [0xB3, 0x6C, 0x00, 0xA0, 0xC9, 0x11, 0xE8, 0xB2]};
    const IID IID_IActiveScriptAuthorProcedure     = {0x704B2D7E, 0x9ABD, 0xD011, [0x93, 0x36, 0x00, 0xA0, 0xC9, 0x0D, 0xCA, 0xA9]};
    const IID IID_IActiveScriptDebug               = {0x103C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IActiveScriptDebug32             = {0x103C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IActiveScriptDebug64             = {0x237E43BC, 0xB8F5, 0xF447, [0xBB, 0x79, 0x7D, 0x1C, 0xE5, 0x48, 0x3B, 0x86]};
    const IID IID_IActiveScriptEncode              = {0xE32A1ABB, 0xF9A4, 0xCF11, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID IID_IActiveScriptError               = {0x61BAE1EA, 0xEDA4, 0xCF11, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID IID_IActiveScriptError64             = {0xA1B21FB2, 0x8F5B, 0x6349, [0x8C, 0x21, 0x21, 0x45, 0x0F, 0x84, 0xED, 0x7F]};
    const IID IID_IActiveScriptErrorDebug          = {0x123C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IActiveScriptGarbageCollector    = {0xA0C4A26A, 0x532B, 0xD411, [0xA2, 0xA0, 0x00, 0x10, 0x4B, 0xD3, 0x50, 0x90]};
    const IID IID_IActiveScriptHostEncode          = {0x6EB7E9BE, 0xE3CF, 0xD111, [0xB7, 0x47, 0x00, 0xC0, 0x4F, 0xC2, 0xB0, 0x85]};
    const IID IID_IActiveScriptParse               = {0xE22A1ABB, 0xF9A4, 0xCF11, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID IID_IActiveScriptParse32             = {0xE22A1ABB, 0xF9A4, 0xCF11, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID IID_IActiveScriptParse64             = {0x5876EFC7, 0xEEE1, 0x0E48, [0x97, 0xEA, 0xD5, 0x2C, 0xB4, 0xD7, 0x6D, 0x17]};
    const IID IID_IActiveScriptParseProcedure      = {0x806A5BAA, 0x34B8, 0xD011, [0x93, 0x2F, 0x00, 0xA0, 0xC9, 0x0D, 0xCA, 0xA9]};
    const IID IID_IActiveScriptParseProcedure2_32  = {0x205BEE71, 0x04FB, 0xD111, [0xB3, 0xA8, 0x00, 0xA0, 0xC9, 0x11, 0xE8, 0xB2]};
    const IID IID_IActiveScriptParseProcedure2_64  = {0x71427CFE, 0x0C21, 0x8D44, [0x9F, 0x54, 0x76, 0xDA, 0xB7, 0x04, 0x7B, 0x28]};
    const IID IID_IActiveScriptParseProcedure32    = {0x806A5BAA, 0x34B8, 0xD011, [0x93, 0x2F, 0x00, 0xA0, 0xC9, 0x0D, 0xCA, 0xA9]};
    const IID IID_IActiveScriptParseProcedure64    = {0xB61347C6, 0x29E0, 0xC54C, [0x92, 0x00, 0x43, 0x8B, 0x72, 0x89, 0x0B, 0x6A]};
    const IID IID_IActiveScriptParseProcedureOld   = {0x5000FF1C, 0xDD6F, 0xD011, [0x93, 0x28, 0x00, 0xA0, 0xC9, 0x0D, 0xCA, 0xA9]};
    const IID IID_IActiveScriptParseProcedureOld32 = {0x5000FF1C, 0xDD6F, 0xD011, [0x93, 0x28, 0x00, 0xA0, 0xC9, 0x0D, 0xCA, 0xA9]};
    const IID IID_IActiveScriptParseProcedureOld64 = {0x2871F521, 0xC908, 0x3846, [0xBA, 0x12, 0x22, 0xD1, 0x5D, 0x88, 0xDC, 0x5C]};
    const IID IID_IActiveScriptProperty            = {0xD0E05449, 0xC7FB, 0xD111, [0x84, 0x10, 0x00, 0x60, 0x08, 0xC3, 0xFB, 0xFC]};
    const IID IID_IActiveScriptSIPInfo             = {0xD0514676, 0xDE38, 0xD411, [0xA2, 0xA3, 0x00, 0x10, 0x4B, 0xD3, 0x50, 0x90]};
    const IID IID_IActiveScriptSite                = {0xE3A101DB, 0x2BA4, 0xCF11, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID IID_IActiveScriptSiteDebug32         = {0x113C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IActiveScriptSiteDebug64         = {0x0A6BB9D6, 0x6374, 0x2C40, [0x92, 0xAC, 0x89, 0x98, 0x42, 0x26, 0x94, 0x2F]};
    const IID IID_IActiveScriptSiteInterruptPoll   = {0xA0989653, 0xCACD, 0xCF11, [0xA5, 0xEB, 0x00, 0xAA, 0x00, 0x47, 0xA0, 0x63]};
    const IID IID_IActiveScriptSiteWindow          = {0x61670FD1, 0xE983, 0xCF11, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID IID_IActiveScriptStats               = {0x1063DAB8, 0x9BE1, 0xD011, [0x93, 0x3C, 0x00, 0xA0, 0xC9, 0x0D, 0xCA, 0xA9]};
    const IID IID_IActiveXSafetyProvider           = {0x0151FF69, 0x63FC, 0xD011, [0x97, 0xEB, 0x00, 0xAA, 0x00, 0x61, 0x53, 0x33]};
    const IID IID_IAdapterInfo                     = {0x4AF90B48, 0xFD09, 0x8A4F, [0xA3, 0xE0, 0xB0, 0x70, 0x02, 0x82, 0xD8, 0x4D]};
    const IID IID_IAdapterNotificationSink         = {0xC32DAB44, 0xB223, 0xDE47, [0x82, 0x28, 0x2E, 0x1C, 0xCE, 0xEB, 0x99, 0x11]};
    const IID IID_IAddEvents                       = {0xAEA610D7, 0x7133, 0xD111, [0xBE, 0x5B, 0x00, 0xC0, 0x4F, 0xC9, 0xE2, 0xBB]};
    const IID IID_IAddressBarParser                = {0x4819D8C9, 0x3A44, 0xC740, [0x94, 0x5C, 0x5E, 0x17, 0x1B, 0x8C, 0x66, 0xB4]};
    const IID IID_IAddrExclusionControl            = {0x48010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IAddrTrackingControl             = {0x47010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IADs                             = {0xD05682FD, 0x15FD, 0xCE11, [0xAB, 0xC4, 0x02, 0x60, 0x8C, 0x9E, 0x75, 0x53]};
    const IID IID_IADsAccessControlEntry           = {0x4CA1F3B4, 0xDD9B, 0xD011, [0x85, 0x2C, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsAccessControlList            = {0xCC91EEB7, 0xDD9B, 0xD011, [0x85, 0x2C, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsAcePrivate                   = {0xF25D14FD, 0x96FD, 0x3541, [0x9B, 0x22, 0x68, 0xFF, 0x0F, 0x6B, 0xF5, 0xBB]};
    const IID IID_IADsAcl                          = {0xABD35284, 0x6908, 0xD111, [0xA3, 0x77, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsADSystemInfo                 = {0x2919B15B, 0xD1AF, 0xD211, [0x9C, 0xB9, 0x00, 0x00, 0xF8, 0x7A, 0x36, 0x9E]};
    const IID IID_IADsBackLink                     = {0xBD0213FD, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsCaseIgnoreList               = {0x33B5667B, 0x8046, 0xD111, [0xA3, 0xB4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsClass                        = {0xD03DF9C8, 0xE04A, 0xCF11, [0x9E, 0x73, 0x00, 0xAA, 0x00, 0x4A, 0x56, 0x91]};
    const IID IID_IADsCollection                   = {0xE045B972, 0x3B25, 0xCF11, [0xA9, 0x88, 0x00, 0xAA, 0x00, 0x6B, 0xC1, 0x49]};
    const IID IID_IADsComputer                     = {0x70CCE3EF, 0x9F1D, 0xCF11, [0xB1, 0xF3, 0x02, 0x60, 0x8C, 0x9E, 0x75, 0x53]};
    const IID IID_IADsComputerOperations           = {0x807649EF, 0x9F1D, 0xCF11, [0xB1, 0xF3, 0x02, 0x60, 0x8C, 0x9E, 0x75, 0x53]};
    const IID IID_IADsContainer                    = {0xD0771600, 0x16FD, 0xCE11, [0xAB, 0xC4, 0x02, 0x60, 0x8C, 0x9E, 0x75, 0x53]};
    const IID IID_IADsDeleteOps                    = {0x0209BDB2, 0x7888, 0xD111, [0x8C, 0x21, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsDNWithBinary                 = {0xA2C0997E, 0x35F9, 0xD211, [0xBA, 0x96, 0x00, 0xC0, 0x4F, 0xB6, 0xD0, 0xD1]};
    const IID IID_IADsDNWithString                 = {0x2EF00D37, 0x34F9, 0xD211, [0xBA, 0x96, 0x00, 0xC0, 0x4F, 0xB6, 0xD0, 0xD1]};
    const IID IID_IADsDomain                       = {0x20C2E400, 0x16FD, 0xCE11, [0xAB, 0xC4, 0x02, 0x60, 0x8C, 0x9E, 0x75, 0x53]};
    const IID IID_IADsEmail                        = {0x1A01AF97, 0x8E47, 0xD111, [0xA3, 0xB4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsExtension                    = {0x3C55353D, 0xB0D2, 0xD111, [0xB1, 0x7B, 0x00, 0x00, 0xF8, 0x75, 0x93, 0xA0]};
    const IID IID_IADsFaxNumber                    = {0xA9DE10A9, 0x8046, 0xD111, [0xA3, 0xB4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsFileService                  = {0x00199DA8, 0xCA31, 0xCF11, [0xA9, 0x8A, 0x00, 0xAA, 0x00, 0x6B, 0xC1, 0x49]};
    const IID IID_IADsFileServiceOperations        = {0x10ED2DA0, 0xCA31, 0xCF11, [0xA9, 0x8A, 0x00, 0xAA, 0x00, 0x6B, 0xC1, 0x49]};
    const IID IID_IADsFileShare                    = {0xF0CA6DEB, 0x834B, 0xCF11, [0xA9, 0x95, 0x00, 0xAA, 0x00, 0x6B, 0xC1, 0x49]};
    const IID IID_IADsGroup                        = {0x006B6327, 0x0F41, 0xCF11, [0xB1, 0xFF, 0x02, 0x60, 0x8C, 0x9E, 0x75, 0x53]};
    const IID IID_IADsHold                         = {0x373BEBB3, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsLargeInteger                 = {0x0B276890, 0x3909, 0xD111, [0x8B, 0xE1, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsLocality                     = {0xA2035EA0, 0xFEEF, 0xCF11, [0x8A, 0xBC, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsMembers                      = {0x30001A45, 0xEC72, 0xCF11, [0xB0, 0x3B, 0x00, 0xAA, 0x00, 0x6E, 0x09, 0x75]};
    const IID IID_IADsNamespaces                   = {0xA06BB928, 0x30B3, 0xCF11, [0xA9, 0xAD, 0x00, 0xAA, 0x00, 0x6B, 0xC1, 0x49]};
    const IID IID_IADsNameTranslate                = {0xA372B2B1, 0x2536, 0xD111, [0xA3, 0xA4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsNetAddress                   = {0xA9501AB2, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsO                            = {0xC62DCDA1, 0xFEEF, 0xCF11, [0x8A, 0xBC, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsObjectOptions                = {0xDA4FF146, 0x2B23, 0xD111, [0xA8, 0x08, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0xA8]};
    const IID IID_IADsObjOptPrivate                = {0x29B8CB81, 0x6718, 0xD211, [0x92, 0x20, 0x00, 0xC0, 0x4F, 0xB6, 0xD0, 0xD1]};
    const IID IID_IADsOctetList                    = {0x0FB8287B, 0x8046, 0xD111, [0xA3, 0xB4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsOpenDSObject                 = {0x1E89F2DD, 0x9C0F, 0xD011, [0x8A, 0xD4, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsOU                           = {0xB833F7A2, 0xFEEF, 0xCF11, [0x8A, 0xBC, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsPath                         = {0xD5FC87B2, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsPathname                     = {0xD4AE92D5, 0x20F4, 0xD011, [0xA3, 0x6E, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsPathnameProvider             = {0x301DCDAA, 0xD08B, 0xD211, [0x92, 0xA9, 0x00, 0xC0, 0x4F, 0x79, 0xF8, 0x34]};
    const IID IID_IADsPostalAddress                = {0x29CFDE7A, 0x8046, 0xD111, [0xA3, 0xB4, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsPrintJob                     = {0x8067FB32, 0xD01E, 0xCF11, [0xA9, 0x88, 0x00, 0xAA, 0x00, 0x6B, 0xC1, 0x49]};
    const IID IID_IADsPrintJobOperations           = {0x30DB529A, 0xCF1E, 0xCF11, [0xA9, 0x88, 0x00, 0xAA, 0x00, 0x6B, 0xC1, 0x49]};
    const IID IID_IADsPrintQueue                   = {0xD06051B1, 0x2612, 0xCF11, [0xA9, 0x85, 0x00, 0xAA, 0x00, 0x6B, 0xC1, 0x49]};
    const IID IID_IADsPrintQueueOperations         = {0xC0E54B12, 0x6E15, 0xCF11, [0xA9, 0x86, 0x00, 0xAA, 0x00, 0x6B, 0xC1, 0x49]};
    const IID IID_IADsProperty                     = {0xD33DF9C8, 0xE04A, 0xCF11, [0x9E, 0x73, 0x00, 0xAA, 0x00, 0x4A, 0x56, 0x91]};
    const IID IID_IADsPropertyEntry                = {0x8E2C7905, 0x1F94, 0xD011, [0x85, 0x29, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsPropertyList                 = {0xB602F6C6, 0x698F, 0xD011, [0x85, 0x28, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsPropertyValue                = {0xD09AFA79, 0x7CA9, 0xD011, [0x85, 0x34, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsPropertyValue2               = {0x1C836E30, 0xC75B, 0xD111, [0xA3, 0xB8, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsReplicaPointer               = {0x03B80FF6, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsResource                     = {0x205BA034, 0xAB4A, 0xCF11, [0xAE, 0x2C, 0x00, 0xAA, 0x00, 0x6E, 0xBF, 0xB9]};
    const IID IID_IADsSearch                       = {0x80779FC6, 0x0840, 0xD011, [0xB9, 0x4C, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0xA8]};
    const IID IID_IADsSecurityDescriptor           = {0xCA87C7B8, 0xDD9B, 0xD011, [0x85, 0x2C, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsSecurityUtility              = {0xB25132A6, 0x215F, 0x4B47, [0xAB, 0x52, 0x4A, 0x8E, 0xFA, 0xD1, 0x08, 0x95]};
    const IID IID_IADsService                      = {0xE066AF68, 0xCA31, 0xCF11, [0xA9, 0x8A, 0x00, 0xAA, 0x00, 0x6B, 0xC1, 0x49]};
    const IID IID_IADsServiceOperations            = {0xF0337B5D, 0xCA31, 0xCF11, [0xA9, 0x8A, 0x00, 0xAA, 0x00, 0x6B, 0xC1, 0x49]};
    const IID IID_IADsSession                      = {0xA07D8B39, 0xAB4A, 0xCF11, [0xAE, 0x2C, 0x00, 0xAA, 0x00, 0x6E, 0xBF, 0xB9]};
    const IID IID_IADsSyntax                       = {0xD23DF9C8, 0xE04A, 0xCF11, [0x9E, 0x73, 0x00, 0xAA, 0x00, 0x4A, 0x56, 0x91]};
    const IID IID_IADsTimestamp                    = {0x01A9F5B2, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsTypedName                    = {0x49A371B3, 0x8040, 0xD111, [0xA3, 0xAC, 0x00, 0xC0, 0x4F, 0xB9, 0x50, 0xDC]};
    const IID IID_IADsUmiHelperPrivate             = {0xF043E24F, 0x89AD, 0xBC4C, [0x9B, 0x14, 0x48, 0x61, 0x26, 0x44, 0x6A, 0xE0]};
    const IID IID_IADsUser                         = {0x20E3373E, 0xE217, 0xCF11, [0xAB, 0xC4, 0x02, 0x60, 0x8C, 0x9E, 0x75, 0x53]};
    const IID IID_IADsValue                        = {0xAAF03E1E, 0xF5AE, 0xD011, [0x85, 0x37, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IADsWinNTSystemInfo              = {0xDC656D6C, 0xD1AF, 0xD211, [0x9C, 0xB9, 0x00, 0x00, 0xF8, 0x7A, 0x36, 0x9E]};
    const IID IID_IAdviseSink                      = {0x0F010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IAdviseSink2                     = {0x25010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IAdviseSinkEx                    = {0x9042F23A, 0x960C, 0xCE11, [0xA0, 0xCF, 0x00, 0xAA, 0x00, 0x60, 0x0A, 0xB8]};
    const IID IID_IAlertReport                     = {0xE8DF814E, 0xA04C, 0x1A10, [0x82, 0x06, 0x08, 0x00, 0x2B, 0x2F, 0xC0, 0x9B]};
    const IID IID_IAlertTarget                     = {0xC0619B58, 0xE654, 0xCE11, [0x94, 0xDD, 0x00, 0xAA, 0x00, 0x51, 0xE4, 0x0F]};
    const IID IID_IAlgSetup                        = {0x1AAF79A7, 0x9A00, 0x444C, [0xB9, 0xF0, 0x8F, 0x0F, 0x4C, 0xF2, 0xAE, 0x49]};
    const IID IID_IAlterIndex                      = {0xA63A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IAlterTable                      = {0xA53A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IAnchorClick                     = {0x3B41D513, 0xB933, 0xD211, [0x95, 0xA7, 0x00, 0xC0, 0x4F, 0x8E, 0xCB, 0x02]};
    const IID IID_IAnimationComposer               = {0x3DC85954, 0x2B32, 0xB344, [0x8D, 0xAA, 0x24, 0xC9, 0x47, 0xE7, 0xB2, 0x75]};
    const IID IID_IAnimationComposer2              = {0x790E4F1A, 0xCD09, 0xF347, [0xAF, 0xF1, 0x48, 0x3B, 0xF3, 0xA2, 0x22, 0xDC]};
    const IID IID_IAnimationComposerFactory        = {0x3332EBBE, 0x1FF7, 0x8346, [0x8B, 0x05, 0x9A, 0x53, 0x14, 0xC9, 0x7D, 0xBC]};
    const IID IID_IAnimationComposerSite           = {0x56CB8F48, 0xD68F, 0xDA4C, [0xA0, 0x6A, 0x5B, 0xB2, 0x32, 0x93, 0x0E, 0xCA]};
    const IID IID_IAnimationComposerSiteFactory    = {0x8156EAB4, 0x72ED, 0xFE4E, [0xBB, 0xD7, 0x7C, 0x47, 0xD1, 0x32, 0x56, 0x96]};
    const IID IID_IAnimationComposerSiteSink       = {0x646CF78E, 0xCD71, 0x0F48, [0x96, 0xFC, 0xBA, 0x26, 0x96, 0xE6, 0x59, 0xBE]};
    const IID IID_IAnimationFragment               = {0x88FD9D31, 0xC60A, 0xB14A, [0xA1, 0x9F, 0x90, 0x22, 0x3B, 0xA2, 0xDA, 0x16]};
    const IID IID_IAnimationRoot                   = {0x8763DF29, 0xB430, 0x624A, [0x89, 0x1B, 0xA9, 0xC5, 0xBE, 0x37, 0xBE, 0x88]};
    const IID IID_IApplicationDebugger             = {0x2A3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IApplicationDebuggerUI           = {0x2B3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IApplicationGateway              = {0x2B843451, 0xCEFD, 0x5D48, [0x93, 0xCD, 0xDE, 0x16, 0x40, 0x64, 0x3B, 0xBE]};
    const IID IID_IApplicationGatewayServices      = {0x2A843451, 0xCEFD, 0x5D48, [0x93, 0xCD, 0xDE, 0x16, 0x40, 0x64, 0x3B, 0xBE]};
    const IID IID_IAppPublisher                    = {0x100A2507, 0xF99C, 0xD111, [0x90, 0x76, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82]};
    const IID IID_IAsyncBindCtx                    = {0xD4C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IAsyncManager                    = {0x2A000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IAsyncMoniker                    = {0xD3C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IAsyncOperation                  = {0x90058B3D, 0x91F6, 0xD211, [0x8E, 0xA9, 0x00, 0x60, 0x97, 0xDF, 0x5B, 0xD4]};
    const IID IID_IAsyncRpcChannelBuffer           = {0xB69F02A5, 0x343C, 0xD111, [0x9C, 0x99, 0x00, 0xC0, 0x4F, 0xB9, 0x98, 0xAA]};
    const IID IID_IAttributesRaw                   = {0xA896C06B, 0xE60C, 0xD111, [0xBA, 0xAE, 0x00, 0xC0, 0x4F, 0xC2, 0xE2, 0x0D]};
    const IID IID_IAuditControl                    = {0x2F29A61D, 0x66BC, 0xCE11, [0xAA, 0xE3, 0x00, 0xAA, 0x00, 0x4C, 0x27, 0x37]};
    const IID IID_IAuthenticate                    = {0xD0C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IAutoComplete                    = {0x6227BB00, 0x776A, 0xD011, [0xA5, 0x35, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62]};
    const IID IID_IAutoComplete2                   = {0xC04BC0EA, 0x9137, 0xD211, [0xBB, 0x95, 0x00, 0x60, 0x97, 0x7B, 0x46, 0x4C]};
    const IID IID_IAutoCompleteDropDown            = {0xF441D13C, 0x6A3C, 0xD211, [0xBC, 0xAA, 0x00, 0xC0, 0x4F, 0xD9, 0x29, 0xDB]};
    const IID IID_IAutoCompList                    = {0x6027BB00, 0x776A, 0xD011, [0xA5, 0x35, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62]};
    const IID IID_IAutoDiscoveryProvider           = {0x374ACF9D, 0xDE01, 0x4945, [0xA9, 0xCB, 0x3A, 0xC3, 0x1E, 0xC2, 0x3C, 0x4F]};
    const IID IID_IBackgroundCopyCallback          = {0xC799EA97, 0x8601, 0xD44A, [0x8D, 0xF9, 0xC5, 0xB4, 0xE0, 0xED, 0x6B, 0x22]};
    const IID IID_IBackgroundCopyCallback1         = {0x93654F08, 0x0038, 0x084E, [0x9B, 0x59, 0x99, 0xFA, 0x59, 0xAD, 0xDF, 0x82]};
    const IID IID_IBackgroundCopyError             = {0xA013C619, 0xB8FC, 0x284F, [0x81, 0xAE, 0x89, 0x7C, 0x3D, 0x07, 0x8F, 0x81]};
    const IID IID_IBackgroundCopyFile              = {0x23BDB701, 0x88FB, 0x774A, [0x84, 0x90, 0x58, 0x91, 0xD3, 0xE4, 0x65, 0x3A]};
    const IID IID_IBackgroundCopyGroup             = {0xA780ED1D, 0xEA53, 0x4F42, [0x8A, 0x04, 0x17, 0xFE, 0xA9, 0xAD, 0xC4, 0xF5]};
    const IID IID_IBackgroundCopyJob               = {0x378D6637, 0x7E50, 0x6041, [0x93, 0x16, 0x26, 0x30, 0x6D, 0x15, 0x0B, 0x12]};
    const IID IID_IBackgroundCopyJob1              = {0x3C55F559, 0x3120, 0x2946, [0xBB, 0x18, 0x26, 0x45, 0xA6, 0x97, 0x09, 0x47]};
    const IID IID_IBackgroundCopyJob2              = {0x3907B554, 0x6F68, 0xEB45, [0x9D, 0xFF, 0xD6, 0xA9, 0xA0, 0xFA, 0xA9, 0xAF]};
    const IID IID_IBackgroundCopyManager           = {0x0D4CE35C, 0xC90D, 0x1F4C, [0x89, 0x7C, 0xDA, 0xA1, 0xB7, 0x8C, 0xEE, 0x7C]};
    const IID IID_IBackgroundCopyQMgr              = {0x691CF416, 0xF509, 0xD241, [0x8C, 0xD8, 0x3C, 0x08, 0xC4, 0x7B, 0xC8, 0xA8]};
    const IID IID_IBidiRequestSpl                  = {0x0070009C, 0xA8FF, 0xFF44, [0xB2, 0xB3, 0xAE, 0x91, 0x02, 0xC7, 0x4D, 0x4C]};
    const IID IID_IBindCtx                         = {0x0E000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IBindEventHandler                = {0xB0BCCD63, 0xB1C1, 0xD011, [0x93, 0x36, 0x00, 0xA0, 0xC9, 0x0D, 0xCA, 0xA9]};
    const IID IID_IBindHost                        = {0xA10148FC, 0xA92B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID IID_IBinding                         = {0xC0C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IBindProtocol                    = {0xCDC9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IBindResource                    = {0xB13A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IBindStatusCallback              = {0xC1C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IBindStatusCallbackHolder        = {0xCCC9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IBindStatusCallbackMsg           = {0xD5C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IBitsTest1                       = {0xDB83A151, 0xE067, 0x7244, [0x86, 0x02, 0x3D, 0xBC, 0x73, 0x0B, 0x7E, 0xF5]};
    const IID IID_IBlockFormats                    = {0x30F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IBlockingLock                    = {0x7AD4F330, 0x4764, 0xD111, [0x8E, 0x3C, 0x00, 0xC0, 0x4F, 0xB9, 0x38, 0x6D]};
    const IID IID_IBoundObject                     = {0x00BCFB9B, 0xF1EF, 0x1A10, [0x84, 0xED, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IBoundObjectSite                 = {0x01BCFB9B, 0xF1EF, 0x1A10, [0x84, 0xED, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IBriefcaseStg                    = {0xA11FCE8B, 0x2109, 0x1B10, [0xB1, 0xFF, 0x00, 0xDD, 0x01, 0x0C, 0xCC, 0x48]};
    const IID IID_IBurnEngine                      = {0x66CA0C52, 0xA551, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID IID_ICallFactory                     = {0x303A731C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICallFrame                       = {0xB0B473D5, 0x4E89, 0xD211, [0xB8, 0xB6, 0x00, 0xC0, 0x4F, 0xB9, 0x61, 0x8A]};
    const IID IID_ICallFrameEvents                 = {0x43085EFD, 0x91FC, 0xD011, [0x97, 0xD7, 0x00, 0xC0, 0x4F, 0xB9, 0x61, 0x8A]};
    const IID IID_ICallFrameWalker                 = {0x1939B208, 0x2D39, 0xD211, [0xB8, 0xA4, 0x00, 0xC0, 0x4F, 0xB9, 0x61, 0x8A]};
    const IID IID_ICallIndirect                    = {0xB1B473D5, 0x4E89, 0xD211, [0xB8, 0xB6, 0x00, 0xC0, 0x4F, 0xB9, 0x61, 0x8A]};
    const IID IID_ICallInterceptor                 = {0x75CAC760, 0x6D89, 0xD211, [0xB8, 0xB6, 0x00, 0xC0, 0x4F, 0xB9, 0x61, 0x8A]};
    const IID IID_ICallUnmarshal                   = {0x03B03353, 0x422E, 0xD211, [0xB8, 0x9D, 0x00, 0xC0, 0x4F, 0xB9, 0x61, 0x8A]};
    const IID IID_ICancelMethodCalls               = {0x29000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ICatalogFileInfo                 = {0x00761C71, 0x486B, 0xD111, [0xB4, 0x03, 0x00, 0xAA, 0x00, 0xB9, 0x2A, 0xF1]};
    const IID IID_ICategorizer                     = {0x8945B1A3, 0x7491, 0xA849, [0x89, 0xA3, 0x06, 0xA1, 0xAE, 0x2B, 0x9B, 0xA7]};
    const IID IID_ICategoryProvider                = {0x0948F69A, 0x6458, 0x264C, [0xA7, 0x20, 0xC1, 0xF7, 0x8C, 0x08, 0x6E, 0xE3]};
    const IID IID_ICatInformation                  = {0x13E00200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ICatRegister                     = {0x12E00200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ICDBurn                          = {0x59A6733D, 0xD0E5, 0x424D, [0xAF, 0xC0, 0x51, 0x21, 0xBA, 0x42, 0x5C, 0x8D]};
    const IID IID_ICEnroll                         = {0x88F2F843, 0x207A, 0xD011, [0x8F, 0x06, 0x00, 0xC0, 0x4F, 0xC2, 0x95, 0xE1]};
    const IID IID_ICEnroll2                        = {0x30A74C70, 0x0BC9, 0xD111, [0x9B, 0xEC, 0x00, 0xC0, 0x4F, 0xC2, 0x95, 0xE1]};
    const IID IID_ICEnroll3                        = {0x952D8CC2, 0xDEB7, 0xD211, [0xA4, 0x21, 0x00, 0xC0, 0x4F, 0x79, 0xFE, 0x8E]};
    const IID IID_ICEnroll4                        = {0x8A18F1C1, 0xB52E, 0x804A, [0x84, 0x1B, 0x7E, 0x72, 0x9A, 0x35, 0x6D, 0x90]};
    const IID IID_IChannelHook                     = {0xA0C40810, 0x1376, 0xCF11, [0x9A, 0xF1, 0x00, 0x20, 0xAF, 0x6E, 0x72, 0xF4]};
    const IID IID_IChannelMgr                      = {0x828EBD85, 0xBA0F, 0xD111, [0x90, 0xC3, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x68]};
    const IID IID_IChapteredRowset                 = {0x933A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICheckBox                        = {0x85F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ICiAdmin                         = {0xD8C767AE, 0xD385, 0xD011, [0x8C, 0x45, 0x00, 0xC0, 0x4F, 0xC2, 0xDB, 0x8D]};
    const IID IID_ICiAdminParams                   = {0xC6482DA8, 0x0F3F, 0xD011, [0x8C, 0x91, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCAdviseStatus                 = {0x4A7305CA, 0x1812, 0xD311, [0xAE, 0x7A, 0x00, 0xC0, 0x4F, 0x72, 0xF8, 0x31]};
    const IID IID_ICiCDeferredPropRetriever        = {0x70AF73C2, 0x726D, 0xD011, [0x8D, 0x64, 0x00, 0xA0, 0xC9, 0x08, 0xDB, 0xF1]};
    const IID IID_ICiCDocName                      = {0x76506176, 0x2B3C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCDocNameToWorkidTranslator    = {0x543FFC25, 0xB43C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCDocNameToWorkidTranslatorEx  = {0xE676BA7B, 0xE3A0, 0xD211, [0xBC, 0x5D, 0x00, 0xC0, 0x4F, 0xA3, 0x54, 0xBA]};
    const IID IID_ICiCDocStore                     = {0x68546246, 0x323C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCDocStoreEx                   = {0xA78282F9, 0x72FA, 0xD111, [0x97, 0x98, 0x00, 0xC0, 0x4F, 0xC2, 0xF4, 0x10]};
    const IID IID_ICiCDocStoreLocator              = {0x067CEE97, 0x0859, 0xD011, [0x8C, 0x9B, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCEventLogItem                 = {0x6A88CC44, 0x1443, 0xD011, [0x8C, 0x91, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCFilterClient                 = {0xB6BCE0A1, 0x243C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCFilterStatus                 = {0x603D5FBC, 0xBC8B, 0xD111, [0x8F, 0x73, 0x00, 0xA0, 0xC9, 0x19, 0x17, 0xF5]};
    const IID IID_ICiCIndexNotificationStatus      = {0x4038FF5F, 0x768E, 0xD011, [0x8D, 0x69, 0x00, 0xA0, 0xC9, 0x08, 0xDB, 0xF1]};
    const IID IID_ICiCLangRes                      = {0x6C2E4C91, 0xFE43, 0xD011, [0x8C, 0x91, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiControl                       = {0xF4B7DE63, 0xCB3C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCOpenedDoc                    = {0xBEDF1E15, 0x2F3C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCPropertyStorage              = {0x5A22464C, 0xB53C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCPropRetriever                = {0xDAB2D977, 0x0144, 0xD011, [0x8C, 0x91, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCQueryNotification            = {0x6C9F9E0A, 0xE23C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCQuerySession                 = {0xD61F46AE, 0x1D4E, 0xD011, [0x8C, 0x94, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCResourceMonitor              = {0x8EFF00F7, 0xEE20, 0xD211, [0x80, 0xF7, 0x00, 0xC0, 0x4F, 0xA3, 0x54, 0xBA]};
    const IID IID_ICiCScope                        = {0x82C82110, 0xC03C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCScopeChecker                 = {0x9C0C827D, 0xBC3C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCScopeEnumerator              = {0xEA0585CF, 0xCA3C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCSecurityChecker              = {0xF40C13CA, 0xC23C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiCUserSecurity                 = {0xCED9015D, 0xC23C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiDocChangeNotifySink           = {0x8613FA8B, 0xE53C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiEnumWorkids                   = {0x50019077, 0x9CA0, 0xD011, [0xA8, 0x0D, 0x00, 0xA0, 0xC9, 0x06, 0x24, 0x1A]};
    const IID IID_ICiFrameworkQuery                = {0xD9C767AE, 0xD385, 0xD011, [0x8C, 0x45, 0x00, 0xC0, 0x4F, 0xC2, 0xDB, 0x8D]};
    const IID IID_ICiIndexNotification             = {0xE0D62C4F, 0x748E, 0xD011, [0x8D, 0x69, 0x00, 0xA0, 0xC9, 0x08, 0xDB, 0xF1]};
    const IID IID_ICiIndexNotificationEntry        = {0xD0690721, 0x758E, 0xD011, [0x8D, 0x69, 0x00, 0xA0, 0xC9, 0x08, 0xDB, 0xF1]};
    const IID IID_ICiISearchCreator                = {0xA07FC07D, 0x2E90, 0xD011, [0xA8, 0x0C, 0x00, 0xA0, 0xC9, 0x06, 0x24, 0x1A]};
    const IID IID_ICiManager                       = {0x56CF0FCF, 0xCE3C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiPersistIncrFile               = {0xE211B331, 0x9844, 0xD011, [0x8C, 0x91, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_ICiQueryPropertyMapper           = {0xB03E33D2, 0x6B75, 0xD011, [0x8D, 0x66, 0x00, 0xA0, 0xC9, 0x08, 0xDB, 0xF1]};
    const IID IID_ICiStartup                       = {0xB82C2368, 0xCC3C, 0xD011, [0x8C, 0x90, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_IClassActivator                  = {0x40010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IClassFactory                    = {0x01000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IClassFactory2                   = {0x8FB296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IClassFactoryEx                  = {0xA01E2D34, 0x25AE, 0xD111, [0x89, 0xC5, 0x00, 0x60, 0x08, 0xC3, 0xFB, 0xFC]};
    const IID IID_IClientCaps                      = {0x4DC48B7E, 0xFFAE, 0xD111, [0x89, 0xC2, 0x00, 0xC0, 0x4F, 0xB6, 0xBF, 0xC4]};
    const IID IID_IClientSecurity                  = {0x3D010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IClusCfgAsyncEvictCleanup        = {0x950BC852, 0xADC1, 0x4042, [0x8D, 0x89, 0x72, 0xE9, 0xFA, 0x84, 0x02, 0x5E]};
    const IID IID_IClusCfgBaseCluster              = {0x13C6A5A8, 0x1825, 0xF547, [0x96, 0xCA, 0xCA, 0xFA, 0x7F, 0xFB, 0xAF, 0x68]};
    const IID IID_IClusCfgCallback                 = {0x63CA8D23, 0xEFE2, 0x324F, [0xA2, 0x4D, 0xAC, 0xBF, 0x97, 0x5B, 0xE8, 0x42]};
    const IID IID_IClusCfgCapabilities             = {0x53B24AD9, 0xC736, 0xC141, [0xB5, 0x2E, 0x26, 0xB4, 0x51, 0x97, 0x5C, 0x8D]};
    const IID IID_IClusCfgClusterConnection        = {0x0CF96ECE, 0x0236, 0xE741, [0x95, 0xBD, 0xAA, 0xFD, 0x37, 0xA6, 0x76, 0xDF]};
    const IID IID_IClusCfgClusterInfo              = {0xC0BBB485, 0xC4DD, 0xE74A, [0x82, 0x68, 0xF4, 0x85, 0x0B, 0xB2, 0xA6, 0xEE]};
    const IID IID_IClusCfgCredentials              = {0x0694AA54, 0x09A4, 0x494B, [0xB3, 0x14, 0x5F, 0x0A, 0x0C, 0xE4, 0xC8, 0x8E]};
    const IID IID_IClusCfgEvictCleanup             = {0x61E3E36F, 0x73D3, 0x5F4C, [0xA0, 0xAF, 0x1D, 0xFE, 0x84, 0x93, 0xC6, 0x55]};
    const IID IID_IClusCfgGroupCfg                 = {0xD2D3B6DC, 0x5FA5, 0xE549, [0xA6, 0x4A, 0x0C, 0xCF, 0xEB, 0x01, 0xED, 0x3A]};
    const IID IID_IClusCfgInitialize               = {0x2DB80E2A, 0x78F8, 0x2A49, [0x95, 0x1E, 0xAE, 0x00, 0x09, 0x18, 0xC4, 0xA6]};
    const IID IID_IClusCfgIPAddressInfo            = {0xA5F0EAAA, 0x10E3, 0x0446, [0xA5, 0x5E, 0x2F, 0x9D, 0xDC, 0x41, 0x57, 0xA8]};
    const IID IID_IClusCfgManagedResourceCfg       = {0x0F0A3060, 0xE177, 0x0C44, [0xBD, 0x94, 0x6B, 0xFB, 0x0D, 0xBF, 0xDB, 0x3A]};
    const IID IID_IClusCfgManagedResourceInfo      = {0x474832E0, 0x2015, 0xB041, [0xB9, 0x60, 0x54, 0x19, 0x8D, 0xA5, 0xF8, 0xAF]};
    const IID IID_IClusCfgMemberSetChangeListener  = {0x4F53642B, 0x4326, 0xBC4A, [0xA4, 0xE5, 0x82, 0x4D, 0x88, 0x1B, 0x75, 0x82]};
    const IID IID_IClusCfgNetworkInfo              = {0x8075FC19, 0x0A95, 0xA644, [0x96, 0x6E, 0x74, 0xB1, 0x4B, 0x20, 0x91, 0x8F]};
    const IID IID_IClusCfgNodeInfo                 = {0x15FAB5E4, 0x07DD, 0x9E43, [0xA6, 0x23, 0x88, 0x23, 0x52, 0x4E, 0x3D, 0x19]};
    const IID IID_IClusCfgPartitionInfo            = {0x9FBD1EEC, 0x6658, 0x4648, [0x89, 0x52, 0xEC, 0x36, 0xC3, 0x96, 0x1E, 0xEE]};
    const IID IID_IClusCfgPollingCallback          = {0xFDB12DC7, 0xA251, 0xE643, [0xB7, 0x08, 0xD9, 0xDB, 0x7D, 0xA7, 0x96, 0x30]};
    const IID IID_IClusCfgPollingCallbackInfo      = {0xA75DF52A, 0x6FCB, 0xDE40, [0xBB, 0x11, 0x66, 0x73, 0x46, 0x4B, 0x2C, 0x54]};
    const IID IID_IClusCfgResourceCreate           = {0x1AB44706, 0x77C7, 0x3C44, [0x94, 0x32, 0x02, 0xCC, 0xCF, 0x4F, 0xF4, 0x43]};
    const IID IID_IClusCfgResourcePostCreate       = {0x54BFA972, 0xB613, 0x1F45, [0x91, 0x0D, 0x69, 0x13, 0xEB, 0xF0, 0x25, 0xAB]};
    const IID IID_IClusCfgResourcePreCreate        = {0xA1F64042, 0x499D, 0x7E42, [0x8F, 0x3D, 0x09, 0x38, 0x4E, 0x1F, 0x59, 0xE4]};
    const IID IID_IClusCfgResourceTypeCreate       = {0xB8E3FC3A, 0x3E5F, 0xDF4D, [0xA8, 0xF4, 0x4B, 0x4F, 0xCB, 0xF2, 0x8F, 0x8F]};
    const IID IID_IClusCfgResourceTypeInfo         = {0x81A249C6, 0x47C8, 0x5C4F, [0x98, 0x41, 0xD2, 0xF7, 0x3B, 0x5A, 0xA7, 0x1D]};
    const IID IID_IClusCfgResTypeServicesInitializ = {0x9896106E, 0xC4DF, 0x7144, [0xAC, 0xE1, 0x04, 0x14, 0x93, 0x1B, 0x3B, 0xB3]};
    const IID IID_IClusCfgServer                   = {0xE6EA064C, 0x0E99, 0x5140, [0x8A, 0xA1, 0xAD, 0x4B, 0x4E, 0xAE, 0x9C, 0xAF]};
    const IID IID_IClusCfgSetCredentials           = {0xB9E5E658, 0x8847, 0x9A4D, [0x82, 0x55, 0x1E, 0x27, 0x4E, 0x5D, 0xCC, 0xB0]};
    const IID IID_IClusCfgStartupListener          = {0xEFCA82D2, 0xDE2E, 0xB94A, [0xA5, 0xD5, 0xF7, 0xBD, 0xE3, 0xD2, 0x3F, 0x0F]};
    const IID IID_IClusCfgStartupNotify            = {0x69D0B0C2, 0x5363, 0xE14E, [0xB2, 0x53, 0x6B, 0x0D, 0x75, 0xDB, 0x2C, 0xD3]};
    const IID IID_IClusCfgVerify                   = {0xECBE7BD4, 0x8622, 0x1445, [0xAA, 0x90, 0x7E, 0x88, 0xBD, 0x0F, 0xE5, 0x43]};
    const IID IID_IClusCfgWizard                   = {0x3B7AB52E, 0x8DDA, 0x564B, [0x97, 0xCF, 0xA3, 0x19, 0x1B, 0xF8, 0xFD, 0x5B]};
    const IID IID_IClusterApplicationWizard        = {0x5171F924, 0x8966, 0xD111, [0x9A, 0xA7, 0x00, 0xC0, 0x4F, 0xB9, 0x3A, 0x80]};
    const IID IID_ICodeInstall                     = {0xD1C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IColumnMapper                    = {0x7AE3630B, 0xCC9C, 0xD011, [0xBC, 0xDB, 0x00, 0x80, 0x5F, 0xCC, 0xCE, 0x04]};
    const IID IID_IColumnMapperCreator             = {0x7BE3630B, 0xCC9C, 0xD011, [0xBC, 0xDB, 0x00, 0x80, 0x5F, 0xCC, 0xCE, 0x04]};
    const IID IID_IColumnProvider                  = {0x045002E8, 0x421C, 0xD211, [0xBE, 0x2C, 0x00, 0xA0, 0xC9, 0xA8, 0x3D, 0xA1]};
    const IID IID_IColumnsInfo                     = {0x113A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IColumnsInfo2                    = {0xB83A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IColumnsRowset                   = {0x103A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICombobox                        = {0x77F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ICommand                         = {0x633A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICommandCost                     = {0x4E3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICommandPersist                  = {0xA73A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICommandPrepare                  = {0x263A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICommandProperties               = {0x793A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICommandStream                   = {0xBF3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICommandText                     = {0x273A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICommandTree                     = {0x873A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICommandValidate                 = {0x183A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICommandWithParameters           = {0x643A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICommDlgBrowser                  = {0xF1140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ICommDlgBrowser2                 = {0x16953310, 0x9428, 0xD211, [0x90, 0x39, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x3E]};
    const IID IID_ICommonQuery                     = {0xC0DE50AB, 0x1D6F, 0xD011, [0xA1, 0xC4, 0x00, 0xAA, 0x00, 0xC1, 0x6E, 0x65]};
    const IID IID_IComThreadingInfo                = {0xCE010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IConfigurationConnection         = {0x9181ADDD, 0xC566, 0x304A, [0xA4, 0xDF, 0xCB, 0x6C, 0x21, 0x67, 0x04, 0xCA]};
    const IID IID_IConnectionInfo                  = {0xE32C1815, 0xD782, 0x3F47, [0x92, 0xDE, 0x70, 0x6E, 0x2B, 0xCE, 0xA9, 0x02]};
    const IID IID_IConnectionManager               = {0x687701C0, 0xF31B, 0x5243, [0x8D, 0x6C, 0x3A, 0x8C, 0x1D, 0x0F, 0xB4, 0x77]};
    const IID IID_IConnectionPoint                 = {0x86B296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IConnectionPointContainer        = {0x84B296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IContextCallback                 = {0xDA010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IContextMenu                     = {0xE4140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IContextMenu2                    = {0xF4140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IContextMenu3                    = {0xA0E0FCBC, 0x17EC, 0xD011, [0x8D, 0x10, 0x00, 0xA0, 0xC9, 0x0F, 0x27, 0x19]};
    const IID IID_IContinue                        = {0x2A010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IContinueCallback                = {0xCABC22B7, 0x684E, 0x1B10, [0xA2, 0xBC, 0x00, 0xAA, 0x00, 0x40, 0x47, 0x70]};
    const IID IID_IConvertType                     = {0x883A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICrBarn                          = {0xE02E6A27, 0x5D0B, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID IID_ICrBarn2                         = {0x1B7A6AB6, 0xC68F, 0x8C44, [0xA2, 0xEB, 0x3C, 0x55, 0x95, 0x74, 0x78, 0xA1]};
    const IID IID_ICrBlinds                        = {0x40C3F55A, 0xA90B, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID IID_ICrBlinds2                       = {0x03D45970, 0x9A59, 0x6442, [0x81, 0x40, 0x64, 0x1E, 0xB8, 0xAE, 0x1F, 0x64]};
    const IID IID_ICrBlur                          = {0x27787C9F, 0x7AE8, 0xD111, [0x81, 0xE0, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_ICreateErrorInfo                 = {0x4033F022, 0x7D54, 0x1B10, [0x8E, 0x65, 0x08, 0x00, 0x2B, 0x2B, 0xD1, 0x19]};
    const IID IID_ICreateRow                       = {0xB23A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ICreateTypeInfo                  = {0x05040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ICreateTypeInfo2                 = {0x0E040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ICreateTypeLib                   = {0x06040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ICreateTypeLib2                  = {0x0F040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ICrEmboss                        = {0x80FBACE4, 0x3E05, 0xD211, [0x81, 0xEA, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_ICrEngrave                       = {0x7FFBACE4, 0x3E05, 0xD211, [0x81, 0xEA, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_ICrInset                         = {0x20EEC505, 0xA60B, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID IID_ICrIris                          = {0x50F3693F, 0x7903, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID IID_ICrIris2                         = {0x6169B0F7, 0x8CBA, 0x7049, [0x91, 0x8B, 0x1C, 0x60, 0xCB, 0x9F, 0xF1, 0x80]};
    const IID IID_ICrRadialWipe                    = {0xAE714B42, 0x9506, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID IID_ICrSlide                         = {0x2E400E81, 0x6B05, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID IID_ICrSpiral                        = {0xA027E50D, 0x7E0C, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID IID_ICrStretch                       = {0x00AF8466, 0x870A, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID IID_ICrWheel                         = {0x80DE4339, 0x6414, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID IID_ICrZigzag                        = {0xA0645A4E, 0x8B0C, 0xD211, [0xA4, 0x84, 0x00, 0xC0, 0x4F, 0x8E, 0xFB, 0x69]};
    const IID IID_ICSSFilter                       = {0xECF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ICSSFilterDispatch               = {0x2B151995, 0x8494, 0x6C4A, [0xB6, 0xA7, 0x4F, 0x25, 0xE9, 0x2D, 0x6C, 0x6B]};
    const IID IID_ICSSFilterSite                   = {0xEDF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ICurrentWorkingDirectory         = {0x216D9591, 0x7692, 0xD111, [0x92, 0x1A, 0x00, 0x60, 0x97, 0xDF, 0x5B, 0xD4]};
    const IID IID_ICursor                          = {0x00A76A9F, 0x88D1, 0xCD11, [0xAD, 0x48, 0x00, 0xAA, 0x00, 0x3C, 0x9C, 0xB6]};
    const IID IID_ICursorFind                      = {0x50781DE0, 0x88D1, 0xCD11, [0xAD, 0x48, 0x00, 0xAA, 0x00, 0x3C, 0x9C, 0xB6]};
    const IID IID_ICursorMove                      = {0x9006FFAC, 0x88D1, 0xCD11, [0xAD, 0x48, 0x00, 0xAA, 0x00, 0x3C, 0x9C, 0xB6]};
    const IID IID_ICursorScroll                    = {0x20E487BB, 0x88D1, 0xCD11, [0xAD, 0x48, 0x00, 0xAA, 0x00, 0x3C, 0x9C, 0xB6]};
    const IID IID_ICursorUpdateARow                = {0xA01642D1, 0x88D1, 0xCD11, [0xAD, 0x48, 0x00, 0xAA, 0x00, 0x3C, 0x9C, 0xB6]};
    const IID IID_ICustomDoc                       = {0xF0F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ICustomRatingHelper              = {0x2D84D9D0, 0x11E2, 0x2C4B, [0x88, 0xDC, 0xBC, 0x72, 0x93, 0x42, 0xDF, 0xCB]};
    const IID IID_IDA2Array                        = {0x060B8F2A, 0x2BBE, 0xD111, [0xB2, 0x19, 0x00, 0xC0, 0x4F, 0xC2, 0xA0, 0xCA]};
    const IID IID_IDA2Behavior                     = {0xF01B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDA2Event                        = {0x70BCB569, 0x199B, 0xD011, [0x9B, 0x60, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID IID_IDA2FontStyle                    = {0xB5073828, 0x602C, 0xD011, [0xA3, 0x1D, 0x00, 0xAA, 0x00, 0xB9, 0x2C, 0x03]};
    const IID IID_IDA2Geometry                     = {0x0237934A, 0x6FE3, 0xD011, [0x9B, 0x99, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID IID_IDA2Image                        = {0xF03D3945, 0xB954, 0xCF11, [0x92, 0xA2, 0x00, 0xAA, 0x00, 0xB8, 0xA7, 0x33]};
    const IID IID_IDA2LineStyle                    = {0x6815E72A, 0x344B, 0xD111, [0xB1, 0xE3, 0x00, 0xC0, 0x4F, 0xC2, 0xA0, 0xCA]};
    const IID IID_IDA2Statics                      = {0xC20675D1, 0x266B, 0xD011, [0x89, 0x14, 0x00, 0xC0, 0x4F, 0xC2, 0xA0, 0xCA]};
    const IID IID_IDA2View                         = {0x45F5005F, 0x18DF, 0xD111, [0xAB, 0x6F, 0x00, 0xC0, 0x4F, 0xD9, 0x2B, 0x6B]};
    const IID IID_IDA2ViewerControl                = {0xEF1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDA2ViewerControlWindowed        = {0xED1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAArray                         = {0xF01C26FA, 0x4EC4, 0xD111, [0x9B, 0xE4, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID IID_IDABbox2                         = {0x3E038BBA, 0x911E, 0xD111, [0x88, 0x09, 0x00, 0xC0, 0x4F, 0xC2, 0x9D, 0x46]};
    const IID IID_IDABbox3                         = {0x7B25410E, 0x2D81, 0xD011, [0x9B, 0x4A, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID IID_IDABehavior                      = {0x5126FB5D, 0x6896, 0xD011, [0xB1, 0x7B, 0x00, 0xC0, 0x4F, 0xC2, 0xA0, 0xCA]};
    const IID IID_IDABoolean                       = {0xDA1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDABvrHook                       = {0x1F79B450, 0x3147, 0xD011, [0x89, 0x12, 0x00, 0xC0, 0x4F, 0xC2, 0xA0, 0xCA]};
    const IID IID_IDACamera                        = {0xCA1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAColor                         = {0xDC1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDADashStyle                     = {0x22B5E1F3, 0xA6D8, 0xD111, [0x9B, 0xE5, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID IID_IDADrawingSurface                = {0xF41B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDADXTransformResult             = {0x058386AF, 0x0BAB, 0xD011, [0x87, 0x6A, 0x00, 0xC0, 0x4F, 0xC2, 0x9D, 0x46]};
    const IID IID_IDAEndStyle                      = {0x4CC2FFB6, 0x137E, 0xD011, [0x9B, 0x47, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID IID_IDAEvent                         = {0xCE1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAFontStyle                     = {0xC11B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAGeometry                      = {0xCC1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAImage                         = {0xC41B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAImport                        = {0xEE1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAImportationResult             = {0x58520EB9, 0x4A57, 0xD111, [0x8E, 0x7B, 0x00, 0xC0, 0x4F, 0xC2, 0x9D, 0x46]};
    const IID IID_IDAJoinStyle                     = {0x564003A3, 0x1CEC, 0xD111, [0x9B, 0xE8, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID IID_IDALineStyle                     = {0xEF90AD69, 0x201C, 0xD111, [0x88, 0x01, 0x00, 0xC0, 0x4F, 0xC2, 0x9D, 0x46]};
    const IID IID_IDAMatte                         = {0xE41B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAMicrophone                    = {0xD81B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAModifiableBehavior            = {0xEC1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAMontage                       = {0xC81B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDANumber                        = {0xC30675D1, 0x266B, 0xD011, [0x89, 0x14, 0x00, 0xC0, 0x4F, 0xC2, 0xA0, 0xCA]};
    const IID IID_IDAPair                          = {0x53B42F54, 0x0350, 0xCF11, [0x92, 0xA2, 0x00, 0xAA, 0x00, 0xB8, 0xA7, 0x33]};
    const IID IID_IDAPath2                         = {0xD01B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAPickableResult                = {0xDE1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAPoint2                        = {0x4173DE9C, 0x203C, 0xD011, [0xA3, 0x30, 0x00, 0xAA, 0x00, 0xB9, 0x2C, 0x03]};
    const IID IID_IDAPoint3                        = {0xD61B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAPreferences                   = {0x5A520EB9, 0x4A57, 0xD111, [0x8E, 0x7B, 0x00, 0xC0, 0x4F, 0xC2, 0x9D, 0x46]};
    const IID IID_IDASite                          = {0x59520EB9, 0x4A57, 0xD111, [0x8E, 0x7B, 0x00, 0xC0, 0x4F, 0xC2, 0x9D, 0x46]};
    const IID IID_IDASound                         = {0xE61B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAStatics                       = {0x5026FB5D, 0x6896, 0xD011, [0xB1, 0x7B, 0x00, 0xC0, 0x4F, 0xC2, 0xA0, 0xCA]};
    const IID IID_IDAString                        = {0xD21B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDataAdviseHolder                = {0x10010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IDataChannel                     = {0x2AD142AD, 0xD04A, 0x5648, [0x91, 0x9E, 0xE8, 0x54, 0xC9, 0x1D, 0x18, 0x56]};
    const IID IID_IDataConvert                     = {0x8D3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDataFilter                      = {0x804CD169, 0x8EC1, 0xD011, [0xA9, 0xCE, 0x00, 0x60, 0x97, 0x94, 0x23, 0x11]};
    const IID IID_IDataObject                      = {0x0E010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IDATransform2                    = {0xD41B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDATransform3                    = {0xE01B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDATuple                         = {0x52B42F54, 0x0350, 0xCF11, [0x92, 0xA2, 0x00, 0xAA, 0x00, 0xB8, 0xA7, 0x33]};
    const IID IID_IDAUntilNotifier                 = {0x1CF9B025, 0x3DD2, 0xD011, [0x9B, 0x85, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID IID_IDAUserData                      = {0x864DCDBA, 0x4F4A, 0xD111, [0x9B, 0xC8, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID IID_IDAVector2                       = {0xC61B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAVector3                       = {0xE21B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAView                          = {0x048386AF, 0x0BAB, 0xD011, [0x87, 0x6A, 0x00, 0xC0, 0x4F, 0xC2, 0x9D, 0x46]};
    const IID IID_IDAViewerControl                 = {0xDD1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAViewerControlWindowed         = {0xCD1B6CC4, 0x523C, 0xD011, [0x92, 0x00, 0x84, 0x8C, 0x1D, 0x00, 0x00, 0x00]};
    const IID IID_IDAViewSite                      = {0x751FBBBC, 0x84E3, 0xD011, [0x9B, 0x99, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID IID_IDBAsynchNotify                  = {0x963A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDBAsynchStatus                  = {0x953A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDBBinderProperties              = {0xB33A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDBCreateCommand                 = {0x1D3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDBCreateSession                 = {0x5D3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDBDataSourceAdmin               = {0x7A3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDBInfo                          = {0x893A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDBInitialize                    = {0x8B3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDBProperties                    = {0x8A3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDBSchemaCommand                 = {0x503A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDBSchemaRowset                  = {0x7B3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDCInfo                          = {0x9C3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IDDVideoAcceleratorContainer     = {0x2021A1AC, 0x5633, 0xD111, [0x8F, 0xCF, 0x00, 0xC0, 0x4F, 0xC2, 0x9B, 0x4E]};
    const IID IID_IDDVideoPortContainer            = {0x6027146C, 0x33A7, 0xCE11, [0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60]};
    const IID IID_IDebug                           = {0x23010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IDebugApplication                = {0x323C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugApplication32              = {0x323C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugApplication64              = {0x54C7ED4D, 0xC704, 0x104F, [0x9E, 0x60, 0x16, 0xA3, 0x90, 0xFE, 0x6E, 0x62]};
    const IID IID_IDebugApplicationEx              = {0x003C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugApplicationNode            = {0x343C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugApplicationNodeEvents      = {0x353C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugApplicationThread          = {0x383C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugApplicationThread64        = {0x8658AC9D, 0xADDB, 0x6D45, [0x9D, 0xEE, 0x5D, 0xEC, 0x39, 0xAB, 0x3D, 0xDA]};
    const IID IID_IDebugAsyncOperation             = {0x1B3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugAsyncOperationCallBack     = {0x1C3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugCodeContext                = {0x133C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugCookie                     = {0x393C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugDocument                   = {0x213C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugDocumentContext            = {0x283C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugDocumentHelper32           = {0x263C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugDocumentHelper64           = {0x3C36C7C4, 0xFD20, 0xF947, [0xBD, 0x82, 0x48, 0x55, 0xE0, 0x15, 0x08, 0x71]};
    const IID IID_IDebugDocumentHelperEx           = {0x023C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugDocumentHost               = {0x273C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugDocumentInfo               = {0x1F3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugDocumentProvider           = {0x203C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugDocumentText               = {0x223C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugDocumentTextAuthor         = {0x243C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugDocumentTextEvents         = {0x233C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugDocumentTextExternalAuthor = {0x253C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugExpression                 = {0x143C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugExpressionCallBack         = {0x163C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugExpressionContext          = {0x153C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugExtendedProperty           = {0x523C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugFormatter                  = {0x053C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugHelper                     = {0x3F3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugHelperEx                   = {0x083C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugOut                        = {0xF1E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_IDebugProperty                   = {0x503C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugPropertyEnumType_All       = {0x553C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugPropertyEnumType_Arguments = {0x573C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugPropertyEnumType_Locals    = {0x563C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugPropertyEnumType_LocalsPlusAr = {0x583C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugPropertyEnumType_Registers = {0x593C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugRegister                   = {0xF0E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_IDebugSessionProvider            = {0x293C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugSessionProviderEx          = {0x093C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugSetValueCallback           = {0x063C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugStackFrame                 = {0x173C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugStackFrameSniffer          = {0x183C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugStackFrameSnifferEx        = {0x193C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugStackFrameSnifferEx32      = {0x193C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugStackFrameSnifferEx64      = {0xF42AD18C, 0xC149, 0x524D, [0x8D, 0x8A, 0xC1, 0x46, 0xF4, 0x75, 0x81, 0xAA]};
    const IID IID_IDebugStream                     = {0x24010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IDebugSyncOperation              = {0x1A3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugThreadCall                 = {0x363C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugThreadCall32               = {0x363C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IDebugThreadCall64               = {0x35A33FCB, 0x79E9, 0xFD42, [0x9F, 0xCF, 0xA7, 0x54, 0x6A, 0x0F, 0x39, 0x05]};
    const IID IID_IDelaydC                         = {0x30C0F9BF, 0x8FB5, 0xCE11, [0xB5, 0xB0, 0x00, 0xAA, 0x00, 0x6C, 0xB3, 0x7D]};
    const IID IID_IDelayedRelease                  = {0xED140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IDelegateFolder                  = {0x80BAD8AD, 0x2B00, 0xD011, [0x8F, 0x0F, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62]};
    const IID IID_IDeskBand                        = {0x72E10FEB, 0x3A1A, 0xD011, [0x89, 0xB3, 0x00, 0xA0, 0xC9, 0x0A, 0x90, 0xAC]};
    const IID IID_IDeviceRect                      = {0xD5F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IDfReserved1                     = {0x13000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IDfReserved2                     = {0x14000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IDfReserved3                     = {0x15000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IDialBranding                    = {0xA9AFEC8A, 0x0643, 0xCC43, [0x8C, 0x5A, 0x76, 0x5F, 0x29, 0x79, 0xCC, 0x16]};
    const IID IID_IDialEngine                      = {0x2B78FD39, 0x0579, 0xD540, [0x91, 0x48, 0x3C, 0x9B, 0x19, 0x04, 0x23, 0xD5]};
    const IID IID_IDialEventSink                   = {0xFFF4862D, 0x2D6E, 0x8844, [0xB2, 0xE9, 0x69, 0x34, 0xAF, 0xD4, 0x1B, 0xEA]};
    const IID IID_IDifferencing                    = {0xF00A4F99, 0x7729, 0xCE11, [0xBB, 0x80, 0x08, 0x00, 0x2B, 0x36, 0xB2, 0xB0]};
    const IID IID_IDirect3D                        = {0x8000BA3B, 0x2124, 0xCF11, [0xA3, 0x1A, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56]};
    const IID IID_IDirect3D2                       = {0xC11EAE6A, 0x2A66, 0xD011, [0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A]};
    const IID IID_IDirect3D3                       = {0x403222BB, 0x2BE7, 0xD011, [0xA9, 0xB4, 0x00, 0xAA, 0x00, 0xC0, 0x99, 0x3E]};
    const IID IID_IDirect3D7                       = {0x779E04F5, 0x6148, 0xD211, [0xA4, 0x07, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8]};
    const IID IID_IDirect3DDevice                  = {0x00881064, 0x7D95, 0xD011, [0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29]};
    const IID IID_IDirect3DDevice2                 = {0x01152893, 0xF88C, 0xD011, [0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29]};
    const IID IID_IDirect3DDevice3                 = {0x603BABB0, 0xD733, 0xD111, [0xA9, 0x81, 0x00, 0xC0, 0x4F, 0xD7, 0xB1, 0x74]};
    const IID IID_IDirect3DDevice7                 = {0x799E04F5, 0x6148, 0xD211, [0xA4, 0x07, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8]};
    const IID IID_IDirect3DExecuteBuffer           = {0x45C11744, 0xAD33, 0xCF11, [0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E]};
    const IID IID_IDirect3DHALDevice               = {0xE03DE684, 0xAA46, 0xCF11, [0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E]};
    const IID IID_IDirect3DLight                   = {0x42C11744, 0xAD33, 0xCF11, [0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E]};
    const IID IID_IDirect3DMaterial                = {0x44C11744, 0xAD33, 0xCF11, [0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E]};
    const IID IID_IDirect3DMaterial2               = {0x03152893, 0xF88C, 0xD011, [0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29]};
    const IID IID_IDirect3DMaterial3               = {0xF4469CCA, 0xC5D3, 0xD111, [0xB7, 0x5A, 0x00, 0x60, 0x08, 0x52, 0xB3, 0x12]};
    const IID IID_IDirect3DMMXDevice               = {0xA1491988, 0xF3D6, 0xD011, [0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29]};
    const IID IID_IDirect3DNullDevice              = {0x22DF6787, 0xCCBA, 0xD111, [0x89, 0x69, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8]};
    const IID IID_IDirect3DRampDevice              = {0x206B08F2, 0x9F25, 0xCF11, [0xA3, 0x1A, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56]};
    const IID IID_IDirect3DRefDevice               = {0x43669350, 0xE913, 0xD111, [0x89, 0xAA, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29]};
    const IID IID_IDirect3DRGBDevice               = {0x605C66A4, 0x7326, 0xCF11, [0xA3, 0x1A, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56]};
    const IID IID_IDirect3DRM                      = {0x6193C42B, 0x2783, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRM2                     = {0xC8EC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID IID_IDirect3DRM3                     = {0x83EC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID IID_IDirect3DRMAnimation             = {0x0DCB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMAnimation2            = {0x777F6BFF, 0x0EA4, 0xD111, [0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66]};
    const IID IID_IDirect3DRMAnimationArray        = {0xE0CAF1D5, 0xD74B, 0xD111, [0xB9, 0x74, 0x00, 0x60, 0x08, 0x3E, 0x45, 0xF3]};
    const IID IID_IDirect3DRMAnimationSet          = {0x0ECB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMAnimationSet2         = {0x797F6BFF, 0x0EA4, 0xD111, [0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66]};
    const IID IID_IDirect3DRMClippedVisual         = {0x33E73454, 0x666D, 0xD111, [0xBB, 0x0B, 0x00, 0x00, 0xF8, 0x75, 0x86, 0x5A]};
    const IID IID_IDirect3DRMDevice                = {0x8092E1E9, 0x056E, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMDevice2               = {0x78EC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID IID_IDirect3DRMDevice3               = {0x8B499F54, 0xEBBF, 0xD111, [0x8E, 0xD8, 0x00, 0xA0, 0xC9, 0x67, 0xA4, 0x82]};
    const IID IID_IDirect3DRMDeviceArray           = {0x10CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMFace                  = {0x07CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMFace2                 = {0x81EC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID IID_IDirect3DRMFaceArray             = {0x17CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMFrame                 = {0x03CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMFrame2                = {0x60BDDFC3, 0x8839, 0xD011, [0x9E, 0xC2, 0x00, 0x00, 0xC0, 0x29, 0x1A, 0xC3]};
    const IID IID_IDirect3DRMFrame3                = {0x707F6BFF, 0x0EA4, 0xD111, [0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66]};
    const IID IID_IDirect3DRMFrameArray            = {0x12CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMInterpolator          = {0xC16B2F24, 0x4938, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID IID_IDirect3DRMLight                 = {0x08CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMLightArray            = {0x14CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMMaterial              = {0x0BCB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMMaterial2             = {0x757F6BFF, 0x0EA4, 0xD111, [0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66]};
    const IID IID_IDirect3DRMMesh                  = {0x010DA8A3, 0x126E, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMMeshBuilder           = {0x020DA8A3, 0x126E, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMMeshBuilder2          = {0x77EC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID IID_IDirect3DRMMeshBuilder3          = {0x82EC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID IID_IDirect3DRMObject                = {0x00CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMObject2               = {0x7CEC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID IID_IDirect3DRMObjectArray           = {0xC26B2F24, 0x4938, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID IID_IDirect3DRMPicked2Array          = {0x7BEC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID IID_IDirect3DRMPickedArray           = {0x16CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMProgressiveMesh       = {0x79EC1645, 0x208F, 0xD011, [0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3]};
    const IID IID_IDirect3DRMShadow                = {0x809735AF, 0xA36B, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMShadow2               = {0x254EB486, 0x829C, 0xD111, [0xBB, 0x0B, 0x00, 0xA0, 0xC9, 0x81, 0xA0, 0xA6]};
    const IID IID_IDirect3DRMTexture               = {0x09CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMTexture2              = {0xC0300F12, 0x2916, 0xD011, [0x94, 0x1C, 0x00, 0x80, 0xC8, 0x0C, 0xFA, 0x7B]};
    const IID IID_IDirect3DRMTexture3              = {0x737F6BFF, 0x0EA4, 0xD111, [0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66]};
    const IID IID_IDirect3DRMUserVisual            = {0xE03D1659, 0x436D, 0xCF11, [0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMViewport              = {0x02CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMViewport2             = {0xE61B1B4A, 0xEDBF, 0xD111, [0x8E, 0xD8, 0x00, 0xA0, 0xC9, 0x67, 0xA4, 0x82]};
    const IID IID_IDirect3DRMViewportArray         = {0x11CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMVisual                = {0x04CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMVisualArray           = {0x13CB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMWinDevice             = {0xC06C01C5, 0x73D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DRMWrap                  = {0x0ACB16EB, 0x71D2, 0xCE11, [0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1]};
    const IID IID_IDirect3DTexture                 = {0xE0D9DC2C, 0xA025, 0xCF11, [0xA3, 0x1A, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56]};
    const IID IID_IDirect3DTexture2                = {0x02152893, 0xF88C, 0xD011, [0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29]};
    const IID IID_IDirect3DTnLHalDevice            = {0x789E04F5, 0x6148, 0xD211, [0xA4, 0x07, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8]};
    const IID IID_IDirect3DVertexBuffer            = {0x5535507A, 0x834A, 0xD111, [0xA5, 0xDB, 0x00, 0xA0, 0xC9, 0x03, 0x67, 0xF8]};
    const IID IID_IDirect3DVertexBuffer7           = {0x7D9E04F5, 0x6148, 0xD211, [0xA4, 0x07, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8]};
    const IID IID_IDirect3DViewport                = {0x46C11744, 0xAD33, 0xCF11, [0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E]};
    const IID IID_IDirect3DViewport2               = {0x00152893, 0xF88C, 0xD011, [0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29]};
    const IID IID_IDirect3DViewport3               = {0x613BABB0, 0xD733, 0xD111, [0xA9, 0x81, 0x00, 0xC0, 0x4F, 0xD7, 0xB1, 0x74]};
    const IID IID_IDirectDraw                      = {0x80DB146C, 0x33A7, 0xCE11, [0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60]};
    const IID IID_IDirectDraw2                     = {0xE0F3A6B3, 0x432B, 0xCF11, [0xA2, 0xDE, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56]};
    const IID IID_IDirectDraw4                     = {0x9A50599C, 0xBD39, 0xD111, [0x8C, 0x4A, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5]};
    const IID IID_IDirectDraw7                     = {0xC05EE615, 0x9C3B, 0xD211, [0xB9, 0x2F, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x5B]};
    const IID IID_IDirectDrawClipper               = {0x85DB146C, 0x33A7, 0xCE11, [0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60]};
    const IID IID_IDirectDrawColorControl          = {0xE00E9F4B, 0x7E0D, 0xD011, [0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8]};
    const IID IID_IDirectDrawFactory2              = {0x88C4B289, 0xF44A, 0xD111, [0x8C, 0x4C, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5]};
    const IID IID_IDirectDrawGammaControl          = {0x3E1CC169, 0x6BB4, 0xD111, [0xAD, 0x7A, 0x00, 0xC0, 0x4F, 0xC2, 0x9B, 0x4E]};
    const IID IID_IDirectDrawKernel                = {0x20C1568D, 0x086A, 0xD011, [0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8]};
    const IID IID_IDirectDrawOptSurface            = {0x1E1F1951, 0x2B4F, 0xD111, [0x8C, 0xC3, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8]};
    const IID IID_IDirectDrawPalette               = {0x84DB146C, 0x33A7, 0xCE11, [0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60]};
    const IID IID_IDirectDrawPalette2              = {0x7E473CC0, 0x1965, 0xD111, [0x8C, 0x52, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5]};
    const IID IID_IDirectDrawSurface               = {0x81DB146C, 0x33A7, 0xCE11, [0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60]};
    const IID IID_IDirectDrawSurface2              = {0x85588057, 0xEC6E, 0xCF11, [0x94, 0x41, 0xA8, 0x23, 0x03, 0xC1, 0x0E, 0x27]};
    const IID IID_IDirectDrawSurface3              = {0x004E04DA, 0xB269, 0xD011, [0xA1, 0xD5, 0x00, 0xAA, 0x00, 0xB8, 0xDF, 0xBB]};
    const IID IID_IDirectDrawSurface4              = {0x30862B0B, 0x35AD, 0xD011, [0x8E, 0xA6, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x5B]};
    const IID IID_IDirectDrawSurface7              = {0x805A6706, 0x9B3B, 0xD211, [0xB9, 0x2F, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x5B]};
    const IID IID_IDirectDrawSurfaceKernel         = {0xA05D7560, 0x406A, 0xD011, [0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8]};
    const IID IID_IDirectDrawVideoAccelerator      = {0x40D7B2C9, 0x5633, 0xD111, [0x8F, 0xCF, 0x00, 0xC0, 0x4F, 0xC2, 0x9B, 0x4E]};
    const IID IID_IDirectDrawVideoPort             = {0xE0936DB3, 0x432B, 0xCF11, [0xA2, 0xDE, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56]};
    const IID IID_IDirectInput2A                   = {0x62E64459, 0x8AAA, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IDirectInput2W                   = {0x63E64459, 0x8AAA, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IDirectInput7A                   = {0x84B64C9A, 0x6D23, 0xD311, [0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE]};
    const IID IID_IDirectInput7W                   = {0x85B64C9A, 0x6D23, 0xD311, [0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE]};
    const IID IID_IDirectInputA                    = {0x60135289, 0x8AAA, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IDirectInputDevice2A             = {0x82E64459, 0x2EC9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IDirectInputDevice2W             = {0x83E64459, 0x2EC9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IDirectInputDevice7A             = {0xBCC6D757, 0x5623, 0xD311, [0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE]};
    const IID IID_IDirectInputDevice7W             = {0xBDC6D757, 0x5623, 0xD311, [0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE]};
    const IID IID_IDirectInputDeviceA              = {0x80E64459, 0x2EC9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IDirectInputDeviceW              = {0x81E64459, 0x2EC9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IDirectInputEffect               = {0xC0F7E1E7, 0xD288, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID IID_IDirectInputEffectDriver         = {0x30815302, 0x8F89, 0xD011, [0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35]};
    const IID IID_IDirectInputJoyConfig            = {0xB12AE11D, 0xF5C9, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IDirectInputPIDDriver            = {0x3A99C6EE, 0xFDB3, 0xD211, [0xA9, 0x16, 0x00, 0xC0, 0x4F, 0xB9, 0x86, 0x38]};
    const IID IID_IDirectInputW                    = {0x61135289, 0x8AAA, 0xCF11, [0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IDirectMusic                     = {0x5A113665, 0x2D7B, 0xD211, [0xBA, 0x18, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12]};
    const IID IID_IDirectMusic2                    = {0xE1CAC26F, 0x78BC, 0xD211, [0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6]};
    const IID IID_IDirectMusicBand                 = {0xC028ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicBuffer               = {0x7828ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicChordMap             = {0xBE28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicCollection           = {0x7C28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicComposer             = {0xBF28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicDownload             = {0x7B28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicDownloadedInstrument = {0x7E28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicGetLoader            = {0x4448A068, 0x3DD1, 0xD111, [0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6]};
    const IID IID_IDirectMusicGraph                = {0x77C2EF2B, 0x9754, 0xD211, [0xBC, 0xCB, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB]};
    const IID IID_IDirectMusicInstrument           = {0x7D28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicLoader               = {0xA2ACFA2F, 0xCA5D, 0xD211, [0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6]};
    const IID IID_IDirectMusicObject               = {0xB528ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicPerformance          = {0x033DD407, 0x2365, 0xD211, [0x87, 0x1D, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicPerformance2         = {0xE0CAC26F, 0x78BC, 0xD211, [0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6]};
    const IID IID_IDirectMusicPort                 = {0xC9D8F208, 0xC237, 0xD211, [0xB9, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12]};
    const IID IID_IDirectMusicPortDownload         = {0x7A28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicSegment              = {0xA22960F9, 0x8242, 0xD211, [0x87, 0x17, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicSegment2             = {0xD19488D3, 0x52C0, 0xD211, [0x87, 0x2F, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicSegmentState         = {0xC7DCAFA3, 0xEED3, 0xD111, [0xBC, 0x8D, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB]};
    const IID IID_IDirectMusicStyle                = {0xBD28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicThru                 = {0xE753D1CE, 0x0636, 0xD211, [0xB9, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12]};
    const IID IID_IDirectMusicTool                 = {0xBA28ACD2, 0x9BB3, 0xD111, [0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectMusicTrack                = {0xA12960F9, 0x8242, 0xD211, [0x87, 0x17, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD]};
    const IID IID_IDirectoryObject                 = {0x2CDE98E7, 0xE422, 0xD011, [0x84, 0xFE, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IDirectorySchemaMgmt             = {0x9C3BDB75, 0xD8A4, 0xD011, [0xA7, 0x9C, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0xA8]};
    const IID IID_IDirectorySearch                 = {0xECA89B10, 0xF092, 0xD011, [0xA7, 0x90, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0xA8]};
    const IID IID_IDirectPlay                      = {0xA0E95454, 0x65DB, 0xCE11, [0x92, 0x1C, 0x00, 0xAA, 0x00, 0x6C, 0x49, 0x72]};
    const IID IID_IDirectPlay2                     = {0xC0F7742B, 0x5491, 0xCF11, [0xA9, 0xCD, 0x00, 0xAA, 0x00, 0x68, 0x86, 0xE3]};
    const IID IID_IDirectPlay2A                    = {0x8005469D, 0x22A8, 0xCF11, [0x96, 0x0C, 0x00, 0x80, 0xC7, 0x53, 0x4E, 0x82]};
    const IID IID_IDirectPlay3                     = {0x40FE3E13, 0xDC32, 0xD011, [0x9C, 0xFB, 0x00, 0xA0, 0xC9, 0x0A, 0x43, 0xCB]};
    const IID IID_IDirectPlay3A                    = {0x41FE3E13, 0xDC32, 0xD011, [0x9C, 0xFB, 0x00, 0xA0, 0xC9, 0x0A, 0x43, 0xCB]};
    const IID IID_IDirectPlay4                     = {0x30C5B10A, 0x4547, 0xD111, [0xA7, 0xA1, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC]};
    const IID IID_IDirectPlay4A                    = {0x31C5B10A, 0x4547, 0xD111, [0xA7, 0xA1, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC]};
    const IID IID_IDirectPlayLobby                 = {0x715C46AF, 0x8895, 0xCF11, [0xA0, 0x20, 0x00, 0xAA, 0x00, 0x61, 0x57, 0xAC]};
    const IID IID_IDirectPlayLobby2                = {0x20C29401, 0x03A3, 0xD011, [0x9C, 0x4F, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID IID_IDirectPlayLobby2A               = {0x80AFB41B, 0x03A3, 0xD011, [0x9C, 0x4F, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E]};
    const IID IID_IDirectPlayLobby3                = {0x9024B72D, 0x2C65, 0xD111, [0xA7, 0xA8, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC]};
    const IID IID_IDirectPlayLobby3A               = {0x9124B72D, 0x2C65, 0xD111, [0xA7, 0xA8, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC]};
    const IID IID_IDirectPlayLobbyA                = {0x706AC626, 0x67B3, 0xCF11, [0xA0, 0x24, 0x00, 0xAA, 0x00, 0x61, 0x57, 0xAC]};
    const IID IID_IDirectSound                     = {0x83FA9A27, 0x8149, 0xCE11, [0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60]};
    const IID IID_IDirectSound3DBuffer             = {0x86FA9A27, 0x8149, 0xCE11, [0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60]};
    const IID IID_IDirectSound3DListener           = {0x84FA9A27, 0x8149, 0xCE11, [0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60]};
    const IID IID_IDirectSoundBuffer               = {0x85FA9A27, 0x8149, 0xCE11, [0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60]};
    const IID IID_IDirectSoundCapture              = {0x810721B0, 0xCD89, 0xD011, [0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16]};
    const IID IID_IDirectSoundCaptureBuffer        = {0x820721B0, 0xCD89, 0xD011, [0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16]};
    const IID IID_IDirectSoundNotify               = {0x830721B0, 0xCD89, 0xD011, [0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16]};
    const IID IID_IDirectWriterLock                = {0x924D6D0E, 0x3867, 0xCF11, [0x96, 0x08, 0x00, 0xAA, 0x00, 0x68, 0x0D, 0xB4]};
    const IID IID_IDirectXFile                     = {0x40AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID IID_IDirectXFileBinary               = {0x46AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID IID_IDirectXFileData                 = {0x44AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID IID_IDirectXFileDataReference        = {0x45AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID IID_IDirectXFileEnumObject           = {0x41AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID IID_IDirectXFileObject               = {0x43AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID IID_IDirectXFileSaveObject           = {0x42AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID IID_IDiscardableBrowserProperty      = {0x7CDEC349, 0x29D3, 0xD011, [0xAB, 0x73, 0x00, 0xC0, 0x4F, 0xC3, 0x3E, 0x80]};
    const IID IID_IDiscMaster                      = {0x62CA0C52, 0xA551, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID IID_IDiscMasterProgressEvents        = {0xC1519EEC, 0x5D4E, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID IID_IDiscRecorder                    = {0x7697AC85, 0x88CA, 0xF24C, [0x89, 0x4E, 0x09, 0x59, 0x8C, 0x07, 0x8A, 0x41]};
    const IID IID_IDiscStash                       = {0x64CA0C52, 0xA551, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID IID_IDispatch                        = {0x00040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IDispatchEx                      = {0x6098EFA6, 0x20C7, 0xD011, [0x93, 0x37, 0x00, 0xA0, 0xC9, 0x0D, 0xCA, 0xA9]};
    const IID IID_IDispError                       = {0x6198EFA6, 0x20C7, 0xD011, [0x93, 0x37, 0x00, 0xA0, 0xC9, 0x0D, 0xCA, 0xA9]};
    const IID IID_IDisplayPointer                  = {0x9EF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IDisplayServices                 = {0x9DF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IDithererImpl                    = {0x40E8487C, 0x1039, 0xD011, [0x86, 0xFC, 0x00, 0xA0, 0xC9, 0x13, 0xF7, 0x50]};
    const IID IID_IDocHostShowUI                   = {0xB044D2C4, 0x3ED4, 0xCF11, [0x89, 0x3B, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x1A]};
    const IID IID_IDocHostUIHandler                = {0xC0233FBD, 0x3ED4, 0xCF11, [0x89, 0x3B, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x1A]};
    const IID IID_IDocHostUIHandler2               = {0xD0F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IDockingWindow                   = {0x20D92D01, 0x267B, 0xD011, [0x8C, 0xA9, 0x00, 0xA0, 0xC9, 0x2D, 0xBF, 0xE8]};
    const IID IID_IDockingWindowFrame              = {0x7A65D247, 0x277B, 0xD011, [0x8C, 0xA9, 0x00, 0xA0, 0xC9, 0x2D, 0xBF, 0xE8]};
    const IID IID_IDockingWindowSite               = {0xC22F342A, 0x267B, 0xD011, [0x8C, 0xA9, 0x00, 0xA0, 0xC9, 0x2D, 0xBF, 0xE8]};
    const IID IID_IDoTask                          = {0xF8C93002, 0x7FEE, 0x0743, [0x98, 0xDB, 0x72, 0x6E, 0xBC, 0xAE, 0x55, 0xD6]};
    const IID IID_IDownloadBehavior                = {0xBDF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IDownloadManager                 = {0xA4348998, 0x4B06, 0xD311, [0xBB, 0x80, 0x00, 0x10, 0x4B, 0x35, 0xE7, 0xF9]};
    const IID IID_IDownloadNotify                  = {0x285DEBCA, 0x4CAE, 0xD111, [0xBA, 0x40, 0x00, 0xC0, 0x4F, 0xB9, 0x2D, 0x79]};
    const IID IID_IDragSourceHelper                = {0x86F75BDE, 0x7A47, 0xD211, [0x83, 0x9D, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0]};
    const IID IID_IDropSource                      = {0x21010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IDropTarget                      = {0x22010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IDropTargetHelper                = {0x8B275746, 0x1B41, 0xD211, [0x83, 0x9A, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xD0]};
    const IID IID_IDsBrowseDomainTree              = {0x1ECFAB7C, 0xF578, 0xD211, [0x96, 0x0C, 0x00, 0xC0, 0x4F, 0xA3, 0x1A, 0x86]};
    const IID IID_IDsQueryColumnHandler            = {0x9E9972C0, 0x49FA, 0xD111, [0xA0, 0xAF, 0x00, 0xC0, 0x4F, 0xA3, 0x1A, 0x86]};
    const IID IID_IDummy                           = {0x4AA57C0D, 0x52D2, 0xCB4F, [0x91, 0x04, 0xF6, 0xDD, 0xD3, 0x10, 0xB3, 0xF9]};
    const IID IID_IDummyHICONIncluder              = {0xDE907994, 0x28CC, 0xD211, [0xA0, 0xF7, 0x00, 0x80, 0x5F, 0x85, 0x8F, 0xB1]};
    const IID IID_IDX2D                            = {0xA902FD9E, 0x96A9, 0xD111, [0x81, 0xC9, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_IDX2DDebug                       = {0x5724BB03, 0x79A2, 0xD111, [0x81, 0xC6, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_IDXARGBReadPtr                   = {0xD6C2AAEA, 0x90C2, 0xD111, [0x90, 0x5D, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXARGBReadWritePtr              = {0xD7C2AAEA, 0x90C2, 0xD111, [0x90, 0x5D, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXARGBSurfaceInit               = {0x3AB6A39E, 0x7DC3, 0xD111, [0x90, 0x5E, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXBaseObject                    = {0x2B9BB517, 0xC89C, 0xD111, [0x90, 0x53, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXBasicImage                    = {0xC780B216, 0x70EE, 0xD111, [0x90, 0x66, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXDCLock                        = {0x5694610F, 0x39CF, 0xD111, [0x90, 0x5E, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXDLUTBuilder                   = {0x31820673, 0xEE35, 0xD111, [0x81, 0xA1, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_IDXDMapper                       = {0x8B08D97F, 0xED35, 0xD111, [0x81, 0xA1, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_IDXEffect                        = {0x1BB81FE3, 0x3513, 0xD111, [0x81, 0x89, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_IDXGradient                      = {0x514B02B2, 0x77EE, 0xD111, [0x90, 0x66, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXGradient2                     = {0x802AEFD0, 0xDC61, 0xD211, [0xB2, 0xEB, 0x00, 0xA0, 0xC9, 0x36, 0xB2, 0x12]};
    const IID IID_IDXLookupTable                   = {0x7FFCBA01, 0x639E, 0xD111, [0x90, 0x53, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXLUTBuilder                    = {0xC10F37F4, 0xDBCA, 0xD011, [0xB5, 0x2C, 0x00, 0xA0, 0xC9, 0x05, 0x43, 0x73]};
    const IID IID_IDXMapper                        = {0xE5785255, 0xDB05, 0xD111, [0x88, 0x3A, 0x3C, 0x8B, 0x00, 0xC1, 0x00, 0x00]};
    const IID IID_IDXPixelate                      = {0x0F183ED3, 0xE9FB, 0xD111, [0x90, 0x6A, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXRasterizer                    = {0x35B6A39E, 0x7DC3, 0xD111, [0x90, 0x5E, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXRawSurface                    = {0x8A6C7509, 0x6AD9, 0xD111, [0x90, 0x62, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXSurface                       = {0x3FD79FB3, 0x39E1, 0xD111, [0x90, 0x65, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXSurfaceFactory                = {0xF5464914, 0xD4C4, 0xD111, [0x81, 0xD1, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_IDXSurfaceInit                   = {0x39B6A39E, 0x7DC3, 0xD111, [0x90, 0x5E, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXSurfaceModifier               = {0x37B6A39E, 0x7DC3, 0xD111, [0x90, 0x5E, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXSurfacePick                   = {0x79FBA530, 0x1FE1, 0xD111, [0x90, 0x64, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXTAlpha                        = {0xE037461D, 0x3C38, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID IID_IDXTAlphaImageLoader             = {0xE8D3F2A5, 0x7E7A, 0xE548, [0xBC, 0x75, 0x40, 0x79, 0x0B, 0xE4, 0xA9, 0x41]};
    const IID IID_IDXTaskManager                   = {0xC1BB4D25, 0x22F9, 0xD011, [0x88, 0x3A, 0x3C, 0x8B, 0x00, 0xC1, 0x00, 0x00]};
    const IID IID_IDXTBindHost                     = {0x55CE6BD2, 0xDCE9, 0xD111, [0x90, 0x66, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXTCheckerBoard                 = {0x76253CAD, 0x7C11, 0x1045, [0x84, 0xDD, 0xB6, 0x68, 0x97, 0x1D, 0xCF, 0xD1]};
    const IID IID_IDXTChroma                       = {0xE237461D, 0x3C38, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID IID_IDXTClipOrigin                   = {0xD86316EE, 0x8809, 0x484C, [0x9F, 0xD6, 0xDB, 0x44, 0x50, 0x88, 0x56, 0x68]};
    const IID IID_IDXTComposite                    = {0x43A8439A, 0x3108, 0xD111, [0x81, 0x7F, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_IDXTConvolution                  = {0xAFF8A77B, 0xEAE5, 0xD111, [0x81, 0xDD, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_IDXTDropShadow                   = {0xE337461D, 0x3C38, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID IID_IDXTFade                         = {0xC480B216, 0x70EE, 0xD111, [0x90, 0x66, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXTFilter                       = {0xA2E58761, 0x45A4, 0x0846, [0x8F, 0xC0, 0xBE, 0x7A, 0x6C, 0x8D, 0xB3, 0x86]};
    const IID IID_IDXTFilterBehavior               = {0xDDDDD714, 0xA2AC, 0x454E, [0x95, 0x04, 0x38, 0x08, 0xAB, 0xEB, 0x4F, 0x92]};
    const IID IID_IDXTFilterBehaviorSite           = {0xC2239B90, 0x1890, 0x9F49, [0xA8, 0x6D, 0x4E, 0x7D, 0xA9, 0x37, 0xE9, 0x31]};
    const IID IID_IDXTFilterCollection             = {0x337BB022, 0xFB8B, 0xD449, [0x9B, 0x90, 0x09, 0x38, 0x37, 0x0C, 0x90, 0x19]};
    const IID IID_IDXTFilterController             = {0xF215F35C, 0x3D27, 0xB647, [0xB9, 0xED, 0xF7, 0x5D, 0xC3, 0xB0, 0x15, 0x0B]};
    const IID IID_IDXTGlow                         = {0xE437461D, 0x3C38, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID IID_IDXTGradientD                    = {0x81283E62, 0x0EFC, 0xD111, [0x9A, 0x77, 0x00, 0x00, 0xF8, 0x75, 0x6A, 0x10]};
    const IID IID_IDXTGridSize                     = {0x1EE9BBD6, 0x60FF, 0xD211, [0x8F, 0x6E, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x74]};
    const IID IID_IDXTICMFilter                    = {0xED214373, 0x7B1E, 0x1C4E, [0xBB, 0xFA, 0x89, 0xC8, 0x19, 0x80, 0x0E, 0x2F]};
    const IID IID_IDXTLabel                        = {0x0E7FC1C0, 0x41AE, 0xD111, [0x9A, 0x3B, 0x00, 0x00, 0xF8, 0x75, 0x6A, 0x10]};
    const IID IID_IDXTLight                        = {0xC1BEEFF9, 0x0243, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID IID_IDXTMask                         = {0x467106A1, 0x63B0, 0xD747, [0xA5, 0x4A, 0x2C, 0x23, 0x09, 0xE9, 0x88, 0x9D]};
    const IID IID_IDXTMatrix                       = {0x93A466AC, 0x0C0F, 0x764C, [0x82, 0x5C, 0x9D, 0x68, 0xBE, 0xDE, 0x91, 0x88]};
    const IID IID_IDXTMetaBurnFilm                 = {0xD0457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaCenterPeel               = {0x0B4D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID IID_IDXTMetaColorFade                = {0x07C9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaFlowMotion               = {0x0AC9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaGriddler                 = {0x10C9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaGriddler2                = {0x12C9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaJaws                     = {0x03C9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaLightWipe                = {0xC7457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaLiquid                   = {0x094D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID IID_IDXTMetaPageTurn                 = {0x074D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID IID_IDXTMetaPeelPiece                = {0x0F4D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID IID_IDXTMetaPeelSmall                = {0x0D4D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID IID_IDXTMetaPeelSplit                = {0x114D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID IID_IDXTMetaRadialScaleWipe          = {0xC9457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaRipple                   = {0x024D0DAA, 0xA306, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID IID_IDXTMetaRoll                     = {0x6DF4619C, 0x3005, 0xD211, [0x8F, 0x98, 0x00, 0xC0, 0x4F, 0xB9, 0x2E, 0xB7]};
    const IID IID_IDXTMetaThreshold                = {0x14C9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaTwister                  = {0xCE457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaVacuum                   = {0x0CC9542A, 0xAA07, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaWater                    = {0xC4457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaWhiteOut                 = {0xCB457010, 0xE006, 0xD211, [0x8D, 0x6D, 0x00, 0xC0, 0x4F, 0x8E, 0xF8, 0xE0]};
    const IID IID_IDXTMetaWormHole                 = {0x21E06A0E, 0x830C, 0xD211, [0x8C, 0xD4, 0x00, 0x10, 0x4B, 0xC7, 0x5D, 0x9A]};
    const IID IID_IDXTMotionBlur                   = {0xBE579008, 0xF5D3, 0x2C4A, [0xB1, 0x0A, 0xA5, 0x13, 0x01, 0x84, 0xA0, 0xF7]};
    const IID IID_IDXTRandomBars                   = {0x22206D8A, 0x8F4A, 0xB94E, [0xBB, 0x25, 0xAA, 0x05, 0x20, 0x1F, 0x9C, 0x84]};
    const IID IID_IDXTransform                     = {0x78FBA530, 0x1FE1, 0xD111, [0x90, 0x64, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXTransformFactory              = {0x2B0B956A, 0x71A9, 0xD111, [0x81, 0xC8, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_IDXTRedirect                     = {0x0B14F502, 0x6F62, 0x1940, [0x9C, 0x9E, 0x2D, 0xAA, 0x1E, 0x93, 0xE8, 0xFC]};
    const IID IID_IDXTRedirectFilterInit           = {0x9470A5D1, 0xF721, 0x6C4E, [0x93, 0xE5, 0xF5, 0xF7, 0x7F, 0x74, 0x82, 0x93]};
    const IID IID_IDXTRevealTrans                  = {0x065009B8, 0x28A1, 0x4B46, [0x8B, 0x2D, 0x90, 0x58, 0x0A, 0xEE, 0x2B, 0x05]};
    const IID IID_IDXTScale                        = {0x42D79FB3, 0x39E1, 0xD111, [0x90, 0x65, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXTScaleOutput                  = {0x504B02B2, 0x77EE, 0xD111, [0x90, 0x66, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0x9D]};
    const IID IID_IDXTShadow                       = {0xE637461D, 0x3C38, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID IID_IDXTStrips                       = {0x5C9B3CA8, 0x11FB, 0xF54A, [0x8F, 0x65, 0xD0, 0x3F, 0x15, 0x1D, 0x3E, 0xD5]};
    const IID IID_IDXTWave                         = {0xE737461D, 0x3C38, 0xD211, [0x95, 0x2A, 0x00, 0xC0, 0x4F, 0xA3, 0x4F, 0x05]};
    const IID IID_IDXTWipe                         = {0x2F9B27AF, 0xEB86, 0xD111, [0x81, 0xBF, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID IID_IDXTWipe2                        = {0x9180FFE1, 0x2B44, 0x0148, [0x88, 0xB6, 0x2B, 0x47, 0xB1, 0x61, 0x1F, 0xD2]};
    const IID IID_IDynamicPortMapping              = {0x8202C84F, 0xB623, 0x7843, [0x9A, 0x27, 0xCD, 0x8F, 0x17, 0xC9, 0x40, 0x0C]};
    const IID IID_IDynamicPortMappingCollection    = {0x0FE00DB6, 0x6E15, 0x8D4E, [0x9E, 0xC1, 0x3A, 0x23, 0x42, 0xC1, 0x08, 0x99]};
    const IID IID_IEditDebugServices               = {0x0BF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementAdorner                  = {0x07F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehavior                 = {0x25F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorCategory         = {0xEDF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorFactory          = {0x29F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorFocus            = {0xB6F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorLayout           = {0xBAF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorLayout2          = {0x46F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorRender           = {0xAAF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorSite             = {0x27F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorSiteCategory     = {0xEEF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorSiteLayout       = {0xB7F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorSiteLayout2      = {0x47F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorSiteOM           = {0x89F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorSiteOM2          = {0x59F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorSiteRender       = {0xA7F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorSubmit           = {0x46F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementBehaviorUI               = {0xBFF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementNamespace                = {0x71F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementNamespaceFactory         = {0x72F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementNamespaceFactory2        = {0x05F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementNamespaceFactoryCallback = {0xFDF75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementNamespacePrivate         = {0xFFF75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementNamespaceTable           = {0x70F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IElementSegment                  = {0x8FF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IEmptyVolumeCache                = {0x2752CE8F, 0xDA04, 0xD111, [0xA0, 0x04, 0x00, 0x80, 0x5F, 0x8A, 0xBE, 0x06]};
    const IID IID_IEmptyVolumeCache2               = {0xBAE3B702, 0xB34D, 0xD211, [0xB2, 0xD9, 0x00, 0xC0, 0x4F, 0x8E, 0xEC, 0x8C]};
    const IID IID_IEmptyVolumeCacheCallBack        = {0x6133796E, 0xC673, 0xD011, [0x84, 0x69, 0x00, 0xAA, 0x00, 0x44, 0x29, 0x01]};
    const IID IID_IEncodingFilterFactory           = {0x00DEBD70, 0x8EC1, 0xD011, [0xA9, 0xCE, 0x00, 0x60, 0x97, 0x94, 0x23, 0x11]};
    const IID IID_IEnroll                          = {0x3878AAAC, 0x8545, 0xD111, [0xAB, 0x57, 0x00, 0xC0, 0x4F, 0xC2, 0x95, 0xE1]};
    const IID IID_IEnroll2                         = {0x99E180C0, 0xDFB7, 0xD211, [0xA4, 0x21, 0x00, 0xC0, 0x4F, 0x79, 0xFE, 0x8E]};
    const IID IID_IEnroll4                         = {0xE53F05F8, 0xF478, 0x8F44, [0xA0, 0xDB, 0x41, 0xD6, 0x1B, 0x73, 0x44, 0x6B]};
    const IID IID_IEntryID                         = {0x1098D1E4, 0x88D1, 0xCD11, [0xAD, 0x48, 0x00, 0xAA, 0x00, 0x3C, 0x9C, 0xB6]};
    const IID IID_IEnumACDGroup                    = {0x5731FC5A, 0xCC4B, 0xD111, [0xBF, 0x80, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_IEnumACString                    = {0x10C2748E, 0x9DCF, 0xAF4E, [0xA4, 0x03, 0x73, 0x56, 0x42, 0x8F, 0x0A, 0x5A]};
    const IID IID_IEnumAdapterInfo                 = {0x119D3FA2, 0x4C71, 0xFE41, [0x84, 0x71, 0xFF, 0xB1, 0x9B, 0xC2, 0x84, 0x54]};
    const IID IID_IEnumAddress                     = {0xA1FC6616, 0x6393, 0xD011, [0x83, 0x5C, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_IEnumAgent                       = {0x4D31FC5A, 0xCC4B, 0xD111, [0xBF, 0x80, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_IEnumAgentHandler                = {0x288C7E58, 0x0298, 0xD111, [0xA0, 0xA4, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_IEnumAgentSession                = {0x4E31FC5A, 0xCC4B, 0xD111, [0xBF, 0x80, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_IEnumBackgroundCopyFiles         = {0x65E151CA, 0x65C3, 0x4C42, [0x8D, 0x41, 0x24, 0xAA, 0xA4, 0xFF, 0x3C, 0x40]};
    const IID IID_IEnumBackgroundCopyGroups        = {0x03E693D9, 0xA44A, 0xC547, [0x86, 0x65, 0xC2, 0x0D, 0x39, 0xC2, 0xBA, 0x4F]};
    const IID IID_IEnumBackgroundCopyJobs          = {0x12F6F41A, 0x713B, 0x6F46, [0x8F, 0x58, 0x7B, 0x6F, 0x73, 0xAC, 0x57, 0xAD]};
    const IID IID_IEnumBackgroundCopyJobs1         = {0x9DBAAE8B, 0x1C8F, 0xC442, [0xB8, 0x2C, 0x09, 0xAE, 0x79, 0x98, 0x0D, 0x25]};
    const IID IID_IEnumBstr                        = {0x49203735, 0xC60B, 0xD211, [0xA0, 0x33, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_IEnumCall                        = {0xF69C26AE, 0x5E93, 0xD011, [0x83, 0x5C, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_IEnumCallback                    = {0x08010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumCallHub                     = {0x5054C1A3, 0x925B, 0xD111, [0x8F, 0x4E, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_IEnumCallingCard                 = {0x028F4D0C, 0xDB8D, 0xD111, [0xA0, 0x9E, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_IEnumCATEGORYINFO                = {0x11E00200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumChannels                    = {0x2554C6A4, 0x820F, 0xD111, [0x90, 0xC3, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x68]};
    const IID IID_IEnumClusCfgIPAddresses          = {0xBA355FBD, 0xC00B, 0x5F45, [0x92, 0x6D, 0xC3, 0xD3, 0x56, 0x41, 0x94, 0x86]};
    const IID IID_IEnumClusCfgManagedResources     = {0xEB11BE7D, 0xDFA5, 0x3445, [0xAB, 0xF6, 0x8B, 0xAC, 0x7B, 0x53, 0xFC, 0x95]};
    const IID IID_IEnumClusCfgNetworks             = {0xD8AE3FCF, 0x2213, 0xCB4B, [0x99, 0x23, 0xB5, 0xB7, 0x45, 0xA6, 0x9E, 0x36]};
    const IID IID_IEnumClusCfgPartitions           = {0x6ABB4044, 0xACB0, 0x9D47, [0xB5, 0x34, 0x72, 0x65, 0xA3, 0x1D, 0x6C, 0x55]};
    const IID IID_IEnumCodePage                    = {0xE3235C27, 0x4737, 0xD011, [0x9F, 0xEA, 0x00, 0xAA, 0x00, 0x3F, 0x86, 0x46]};
    const IID IID_IEnumConnectionPoints            = {0x85B296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IEnumConnections                 = {0x87B296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IEnumCookies                     = {0x2E483E5E, 0x223C, 0x2C48, [0xB6, 0x64, 0x69, 0x30, 0x51, 0xAD, 0x0A, 0x5D]};
    const IID IID_IEnumDebugApplicationNodes       = {0x3A3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IEnumDebugCodeContexts           = {0x1D3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IEnumDebugExpressionContexts     = {0x403C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IEnumDebugExtendedPropertyInfo   = {0x533C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IEnumDebugPropertyInfo           = {0x513C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IEnumDebugStackFrames            = {0x1E3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IEnumDebugStackFrames64          = {0x5388C30D, 0xB0C1, 0x7641, [0xA9, 0x84, 0xB2, 0x98, 0x36, 0x10, 0x27, 0xAF]};
    const IID IID_IEnumDialableAddrs               = {0x701D6234, 0xFF6C, 0xD111, [0xAF, 0xF7, 0x00, 0xC0, 0x4F, 0xC3, 0x1F, 0xEE]};
    const IID IID_IEnumDirectory                   = {0x6D1D6234, 0xFF6C, 0xD111, [0xAF, 0xF7, 0x00, 0xC0, 0x4F, 0xC3, 0x1F, 0xEE]};
    const IID IID_IEnumDirectoryObject             = {0x4AB6C906, 0x6D30, 0xD111, [0x97, 0x74, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_IEnumDiscMasterFormats           = {0xE145F4DD, 0xBA54, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID IID_IEnumDiscRecorders               = {0xE121199B, 0xAC54, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID IID_IEnumExtraSearch                 = {0xE10B700E, 0xB69D, 0xD111, [0xA1, 0xCE, 0x00, 0xC0, 0x4F, 0xD7, 0x5D, 0x13]};
    const IID IID_IEnumFORMATETC                   = {0x03010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumGeneric                     = {0x06010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumGUID                        = {0x00E00200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumHLITEM                      = {0xC6C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IEnumHNetApplicationProtocols    = {0x7B8BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IEnumHNetBridgedConnections      = {0x7D8BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IEnumHNetBridges                 = {0x778BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IEnumHNetFirewalledConnections   = {0x788BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IEnumHNetIcsPrivateConnections   = {0x7A8BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IEnumHNetIcsPublicConnections    = {0x798BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IEnumHNetPortMappingBindings     = {0x818BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IEnumHNetPortMappingProtocols    = {0x7C8BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IEnumHolder                      = {0x07010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumIDList                      = {0xF2140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumInputContext                = {0xB0EAB509, 0x97F9, 0xD111, [0x93, 0xD4, 0x00, 0x60, 0xB0, 0x67, 0xB8, 0x6E]};
    const IID IID_IEnumItemProperties              = {0x968D2CF7, 0xBD6D, 0xD111, [0xA1, 0xE8, 0x00, 0xC0, 0x4F, 0xC2, 0xFB, 0xE1]};
    const IID IID_IEnumLocation                    = {0x018F4D0C, 0xDB8D, 0xD111, [0xA0, 0x9E, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_IEnumMcastScope                  = {0x09AF0DDF, 0x89A2, 0xD111, [0x86, 0x97, 0x00, 0x60, 0x08, 0xB0, 0xE5, 0xD2]};
    const IID IID_IEnumMedia                       = {0xBE9783CA, 0xA42F, 0xD111, [0x97, 0x74, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_IEnumMoniker                     = {0x02010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumNetCfgBindingInterface      = {0x90AEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_IEnumNetCfgBindingPath           = {0x91AEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_IEnumNetCfgComponent             = {0x92AEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_IEnumNetConnection               = {0xA05689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_IEnumNetSharingEveryConnection   = {0xB85689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_IEnumNetSharingPortMapping       = {0xB05689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_IEnumNetSharingPrivateConnection = {0xB55689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_IEnumNetSharingPublicConnection  = {0xB45689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_IEnumNodes                       = {0x63E377C4, 0x0AAF, 0x0342, [0xA6, 0x04, 0x45, 0xCD, 0x60, 0x7D, 0xD7, 0x10]};
    const IID IID_IEnumNotification                = {0xA8E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_IEnumNotificationSinkItem        = {0xAAE433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_IEnumOleDocumentViews            = {0xC8BC22B7, 0x684E, 0x1B10, [0xA2, 0xBC, 0x00, 0xAA, 0x00, 0x40, 0x47, 0x70]};
    const IID IID_IEnumOleUndoUnits                = {0x40C3E7B3, 0x97EF, 0xCE11, [0x9B, 0xC9, 0x00, 0xAA, 0x00, 0x60, 0x8E, 0x01]};
    const IID IID_IEnumOLEVERB                     = {0x04010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumParticipant                 = {0x6CB5910A, 0x355A, 0xD211, [0x95, 0xA0, 0x00, 0xA0, 0x24, 0x4D, 0x22, 0x98]};
    const IID IID_IEnumPhone                       = {0x69765BF1, 0x8047, 0x9545, [0x8C, 0x89, 0xFB, 0x36, 0x9C, 0x8C, 0xF7, 0xAA]};
    const IID IID_IEnumPluggableSuperclassInfo     = {0x806A58E9, 0xE689, 0xFF4C, [0x93, 0x1D, 0x47, 0x8D, 0x57, 0x51, 0xF4, 0xC0]};
    const IID IID_IEnumPluggableTerminalClassInfo  = {0x0C456745, 0xEEDB, 0x3F4E, [0xAA, 0xF5, 0x37, 0xBF, 0x9E, 0xBF, 0x5E, 0x29]};
    const IID IID_IEnumPrivacyRecords              = {0x44F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IEnumPropertyMap                 = {0xA1E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_IEnumPublishedApps               = {0x8C4F120B, 0xF091, 0xD111, [0xB8, 0xB5, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82]};
    const IID IID_IEnumQueue                       = {0x5831FC5A, 0xCC4B, 0xD111, [0xBF, 0x80, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_IEnumRegisterWordA               = {0x1234C008, 0x6BF9, 0xD011, [0xA4, 0x75, 0x00, 0xAA, 0x00, 0x6B, 0xCC, 0x59]};
    const IID IID_IEnumRegisterWordW               = {0x31DD5549, 0x59B1, 0xD011, [0x8F, 0xCF, 0x00, 0xAA, 0x00, 0x6B, 0xCC, 0x59]};
    const IID IID_IEnumRemoteDebugApplications     = {0x3B3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IEnumRemoteDebugApplicationThrea = {0x3C3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IEnumRfc1766                     = {0x1D9DC33D, 0x30C0, 0xD011, [0xB8, 0x1B, 0x00, 0xC0, 0x4F, 0xC9, 0xB3, 0x1F]};
    const IID IID_IEnumScheduleGroup               = {0xA9E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_IEnumScript                      = {0x30145FAE, 0x8B38, 0xD211, [0x83, 0x80, 0x00, 0xC0, 0x4F, 0x8F, 0x5D, 0xA1]};
    const IID IID_IEnumSTATDATA                    = {0x05010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumSTATPROPBAG                 = {0x01180220, 0xE65D, 0xD111, [0x8E, 0x38, 0x00, 0xC0, 0x4F, 0xB9, 0x38, 0x6D]};
    const IID IID_IEnumSTATPROPSETSTG              = {0x3B010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumSTATPROPSTG                 = {0x39010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumSTATSTG                     = {0x0D000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumSTATURL                     = {0x424A373C, 0xE4BA, 0xCF11, [0xBF, 0x7D, 0x00, 0xAA, 0x00, 0x69, 0x46, 0xEE]};
    const IID IID_IEnumStream                      = {0x06D63BEE, 0x6838, 0xD211, [0xA0, 0x45, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_IEnumString                      = {0x01010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumSubscription                = {0x978D2CF7, 0xBD6D, 0xD111, [0xA1, 0xE8, 0x00, 0xC0, 0x4F, 0xC2, 0xFB, 0xE1]};
    const IID IID_IEnumSubStream                   = {0x09D63BEE, 0x6838, 0xD211, [0xA0, 0x45, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_IEnumSyncItems                   = {0x9A58E1F0, 0x00A7, 0xD111, [0x98, 0x31, 0x00, 0xC0, 0x4F, 0xD9, 0x10, 0xDD]};
    const IID IID_IEnumSyncSchedules               = {0x9858E1F0, 0x00A7, 0xD111, [0x98, 0x31, 0x00, 0xC0, 0x4F, 0xD9, 0x10, 0xDD]};
    const IID IID_IEnumTerminal                    = {0xF49C26AE, 0x5E93, 0xD011, [0x83, 0x5C, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_IEnumTerminalClass               = {0xF59C26AE, 0x5E93, 0xD011, [0x83, 0x5C, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_IEnumTime                        = {0x2E325590, 0xA82F, 0xD111, [0x97, 0x74, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_IEnumTravelLogEntry              = {0x85DDBF7E, 0x18AD, 0xD311, [0xA4, 0xC5, 0x00, 0xC0, 0x4F, 0x72, 0xD6, 0xB8]};
    const IID IID_IEnumUnknown                     = {0x00010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumVARIANT                     = {0x04040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IEnumWbemClassObject             = {0xE1477902, 0x31D7, 0xCE11, [0xA3, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01]};
    const IID IID_IErrorInfo                       = {0x20B1F21C, 0x7D54, 0x1B10, [0x8E, 0x65, 0x08, 0x00, 0x2B, 0x2B, 0xD1, 0x19]};
    const IID IID_IErrorLog                        = {0x40CA2731, 0x6E44, 0xCE11, [0x81, 0x35, 0x00, 0xAA, 0x00, 0x4B, 0xB8, 0x51]};
    const IID IID_IErrorLookup                     = {0x663A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IErrorRecords                    = {0x673A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IESP                             = {0xAA049AE9, 0x95AB, 0xD011, [0xBE, 0x96, 0x00, 0xA0, 0xC9, 0x49, 0x89, 0xDE]};
    const IID IID_IExtendObjectManager             = {0xB9B07BCA, 0x0C70, 0xC54D, [0x99, 0x1E, 0x75, 0xF9, 0xE6, 0x5E, 0xE9, 0x75]};
    const IID IID_IExtensionServices               = {0xCBC9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IExternalConnection              = {0x19000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IExtractIconA                    = {0xEB140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IExtractIconW                    = {0xFA140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IExtractImage                    = {0x7C612EBB, 0x2009, 0xD111, [0x9A, 0x0B, 0x00, 0xC0, 0x4F, 0xC2, 0xD6, 0xC1]};
    const IID IID_IExtractImage2                   = {0xEEB13B95, 0xB493, 0xD111, [0x98, 0xA3, 0x00, 0xC0, 0x4F, 0xB6, 0x87, 0xDA]};
    const IID IID_IFileSearchBand                  = {0xA1EE912D, 0x3299, 0xD211, [0xBE, 0x86, 0x00, 0xA0, 0xC9, 0xA8, 0x3D, 0xA1]};
    const IID IID_IFileSystemBindData              = {0x108DE101, 0x8B4D, 0xD211, [0x85, 0x5D, 0x00, 0x60, 0x08, 0x05, 0x93, 0x67]};
    const IID IID_IFileViewerA                     = {0xF0140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IFileViewerSite                  = {0xF3140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IFileViewerW                     = {0xF8140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IFillLockBytes                   = {0x10F0CA99, 0x5E41, 0xCF11, [0x88, 0x14, 0x00, 0xAA, 0x00, 0xB5, 0x69, 0xF5]};
    const IID IID_IFilter                          = {0x40B7BC89, 0x1961, 0x1A10, [0xBC, 0xB7, 0x00, 0xDD, 0x01, 0x06, 0x55, 0xAF]};
    const IID IID_IFilterAnimationInfo             = {0x0093E202, 0x58C7, 0xB449, [0x9E, 0x11, 0xC5, 0x8B, 0xFE, 0x90, 0x55, 0x8B]};
    const IID IID_IFilterStatus                    = {0x6082EBF4, 0xDA8D, 0xD111, [0xB3, 0xAA, 0x00, 0xA0, 0xC9, 0x06, 0x37, 0x96]};
    const IID IID_IFolderFilter                    = {0x8628C29C, 0x8EDC, 0xD211, [0xB1, 0xD0, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x3E]};
    const IID IID_IFolderFilterSite                = {0xF551A6C0, 0x8BB4, 0xD211, [0xB5, 0xED, 0x00, 0x60, 0x97, 0xC6, 0x86, 0xF6]};
    const IID IID_IFolderView                      = {0xB025E7CD, 0xC9CC, 0x1945, [0x91, 0x7E, 0x32, 0x5D, 0x72, 0xFA, 0xB4, 0xCE]};
    const IID IID_IFolderViewHost                  = {0x028FA51E, 0x5AD5, 0x1D41, [0xB0, 0x9E, 0x9E, 0x65, 0xAC, 0x21, 0x60, 0x5B]};
    const IID IID_IFolderViewOC                    = {0x7059A09B, 0xA8F6, 0xCF11, [0xA4, 0x42, 0x00, 0xA0, 0xC9, 0x0A, 0x8F, 0x39]};
    const IID IID_IFont                            = {0x02E0F6BE, 0x74A8, 0x1A10, [0x8B, 0xBA, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID IID_IFontDisp                        = {0x03E0F6BE, 0x74A8, 0x1A10, [0x8B, 0xBA, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID IID_IFontEventsDisp                  = {0x0A10F64E, 0x88AF, 0xD011, [0x98, 0x46, 0x00, 0xC0, 0x4F, 0xC2, 0x99, 0x93]};
    const IID IID_IFontNames                       = {0x39F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IForegroundTransfer              = {0x45010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IFsCiAdmin                       = {0x308C3975, 0x267A, 0xD011, [0xA8, 0x0A, 0x00, 0xA0, 0xC9, 0x06, 0x24, 0x1A]};
    const IID IID_IGatherData                      = {0x4A8F3165, 0x3CB6, 0x214E, [0xAD, 0xDC, 0xBD, 0xCF, 0xB9, 0x69, 0xE1, 0x81]};
    const IID IID_IGetClusterDataInfo              = {0x51DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IGetClusterGroupInfo             = {0x54DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IGetClusterNetInterfaceInfo      = {0x57DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IGetClusterNetworkInfo           = {0x56DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IGetClusterNodeInfo              = {0x53DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IGetClusterObjectInfo            = {0x52DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IGetClusterResourceInfo          = {0x55DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IGetClusterUIInfo                = {0x50DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IGetDataSource                   = {0x753A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IGetRow                          = {0xAF3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IGetSession                      = {0xBA3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IGetSourceRow                    = {0xBB3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IGlobalInterfaceTable            = {0x46010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IH26XEncodeOptions               = {0x408D6965, 0x2D28, 0xD011, [0x88, 0x00, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IH26XEncoderControl              = {0xA18AB7F9, 0x12EA, 0xCF11, [0x9F, 0xEC, 0x00, 0xAA, 0x00, 0xA5, 0x9F, 0x69]};
    const IID IID_IH26XRTPControl                  = {0xC0F2C31F, 0xFD2B, 0xD011, [0x88, 0x00, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IH26XSnapshot                    = {0xA094B13C, 0xAA10, 0xD011, [0x88, 0x00, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IH26XVideoEffects                = {0x40515521, 0x2B9C, 0xCF11, [0x90, 0xFA, 0x00, 0xAA, 0x00, 0xA7, 0x29, 0xEA]};
    const IID IID_IH323LineEx                      = {0x9D6ACF44, 0x40CB, 0xBC4B, [0xB2, 0xD3, 0xB6, 0xAA, 0x93, 0x32, 0x2C, 0x71]};
    const IID IID_IHeaderFooter                    = {0xCEF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHighlightRenderingServices      = {0x06F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHighlightSegment                = {0x90F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHlink                           = {0xC3C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IHlinkBrowseContext              = {0xC7C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IHlinkFrame                      = {0xC5C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IHlinkSite                       = {0xC2C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IHlinkTarget                     = {0xC4C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IHNetApplicationProtocol         = {0x7F8BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetBridge                      = {0x758BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetBridgedConnection           = {0x768BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetBridgeSettings              = {0x6D8BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetCfgMgr                      = {0x6C8BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetConnection                  = {0x718BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetFirewalledConnection        = {0x728BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetFirewallSettings            = {0x6E8BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetIcsPrivateConnection        = {0x748BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetIcsPublicConnection         = {0x738BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetIcsSettings                 = {0x6F8BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetPortMappingBinding          = {0x808BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetPortMappingProtocol         = {0x7E8BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHNetProtocolSettings            = {0x708BD185, 0x3230, 0xD411, [0x93, 0x48, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x71]};
    const IID IID_IHomePage                        = {0xAFF26B76, 0x50D6, 0xD111, [0x98, 0x11, 0x00, 0xC0, 0x4F, 0xC3, 0x1D, 0x2E]};
    const IID IID_IHostBehaviorInit                = {0x42F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHostDialogHelper                = {0x38C1DE53, 0x1EA5, 0xD211, [0x86, 0x1E, 0x00, 0xC0, 0x4F, 0xA3, 0x5C, 0x89]};
    const IID IID_IHTCAttachBehavior               = {0xF4F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTCAttachBehavior2              = {0xEBF75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTCDefaultDispatch              = {0xFDF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTCDescBehavior                 = {0xDCF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTCEventBehavior                = {0xFFF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTCMethodBehavior               = {0x31F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTCPropertyBehavior             = {0xDFF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLAnchorElement               = {0xDAF15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLAnchorElement2              = {0x25F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLAppBehavior                 = {0xCAF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLAppBehavior2                = {0xC9F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLAppBehavior3                = {0xCDF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHtmlArea                        = {0x4EF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLAreaElement                 = {0x65F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLAreasCollection             = {0x83F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLAreasCollection2            = {0xECF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLAreasCollection3            = {0x37F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLAttributeCollection         = {0xC3F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLAttributeCollection2        = {0x0AF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLBaseElement                 = {0x04F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLBaseFontElement             = {0x02F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLBGsound                     = {0x69F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLBlockElement                = {0x08F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLBlockElement2               = {0x23F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLBodyElement                 = {0xD8F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLBodyElement2                = {0xC5F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLBookmarkCollection          = {0xCEF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLBRElement                   = {0xF0F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLButtonElement               = {0xBBF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLCaret                       = {0x04F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLChangeLog                   = {0x49F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLChangePlayback              = {0xE0F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLChangeSink                  = {0x4AF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLCommentElement              = {0x0CF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLCommentElement2             = {0x13F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLComputedStyle               = {0xC3F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLControlElement              = {0xE9F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLControlRange                = {0x9CF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLControlRange2               = {0x5EF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLCurrentStyle                = {0xDBF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLCurrentStyle2               = {0x58F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLCurrentStyle3               = {0x18F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDatabinding                 = {0xF2F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDataTransfer                = {0xB3F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDDElement                   = {0xF2F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDialog                      = {0x16F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDialog2                     = {0xE0F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDialog3                     = {0x88F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDivElement                  = {0x00F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDivPosition                 = {0x12F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHtmlDlgSafeHelper               = {0x1AF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDListElement                = {0xF1F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDocument                    = {0x20C56F62, 0x1EA4, 0xCF11, [0xA7, 0x31, 0x00, 0xA0, 0xC9, 0x08, 0x26, 0x37]};
    const IID IID_IHTMLDocument2                   = {0x25442C33, 0xCB26, 0xD011, [0xB4, 0x83, 0x00, 0xC0, 0x4F, 0xD9, 0x01, 0x19]};
    const IID IID_IHTMLDocument3                   = {0x85F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDocument4                   = {0x9AF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDocument5                   = {0x0CF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDOMAttribute                = {0xB0F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDOMAttribute2               = {0x10F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDOMChildrenCollection       = {0xABF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDOMImplementation           = {0x0DF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDOMNode                     = {0xDAF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDOMNode2                    = {0x0BF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDOMTextNode                 = {0xB1F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDOMTextNode2                = {0x09F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDTElement                   = {0xF3F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLDXTransform                 = {0x7DABE230, 0xDD4F, 0x5941, [0xB7, 0xEA, 0xDC, 0x72, 0x2B, 0xF4, 0xAD, 0xE5]};
    const IID IID_IHTMLEditDesigner                = {0x62F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLEditHost                    = {0xA0F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLEditHost2                   = {0x48F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0D]};
    const IID IID_IHTMLEditingServices             = {0xFBF75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLEditor                      = {0xFAF75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLEditServices                = {0x63F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLEditServices2               = {0x12F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLElement                     = {0xFFF15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLElement2                    = {0x34F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLElement3                    = {0x73F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLElement4                    = {0x0FF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLElementCollection           = {0x1FF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLElementCollection2          = {0xEEF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLElementCollection3          = {0x35F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLElementDefaults             = {0xC9F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLElementRender               = {0x69F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLEmbedElement                = {0x5FF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLEventObj                    = {0x2DF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLEventObj2                   = {0x8BF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLEventObj3                   = {0x80F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLEventObj4                   = {0x14F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFieldSetElement             = {0xE7F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFieldSetElement2            = {0x33F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFilterPainter               = {0xDEF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFilterPaintSite             = {0xD3F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFiltersCollection           = {0xEEF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFontElement                 = {0xD9F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFontNamesCollection         = {0x76F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFontSizesCollection         = {0x77F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFormElement                 = {0xF7F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFormElement2                = {0xF6F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFormElement3                = {0x36F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFrameBase                   = {0x11F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFrameBase2                  = {0xDBF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFrameBase3                  = {0x2EF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFrameElement                = {0x13F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFrameElement2               = {0xF5F75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFramesCollection2           = {0x26442C33, 0xCB26, 0xD011, [0xB4, 0x83, 0x00, 0xC0, 0x4F, 0xD9, 0x01, 0x19]};
    const IID IID_IHTMLFrameSetElement             = {0x19F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLFrameSetElement2            = {0xC6F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLGenericElement              = {0xB7F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLHeadElement                 = {0x1DF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLHeaderElement               = {0xF6F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLHRElement                   = {0xF4F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLHtmlElement                 = {0x1CF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLIFrameElement               = {0x15F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLIFrameElement2              = {0xE6F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLImageElementFactory         = {0x8EF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLImgElement                  = {0x40F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLImgElement2                 = {0x26F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLInputButtonElement          = {0xB2F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLInputElement                = {0xD2F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLInputElement2               = {0x21F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLInputFileElement            = {0xADF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLInputHiddenElement          = {0xA4F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLInputImage                  = {0xC2F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLInputTextElement            = {0xA6F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLIPrintCollection            = {0xB5F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLIsIndexElement              = {0x06F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLIsIndexElement2             = {0x2FF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLLabelElement                = {0x2AF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLLabelElement2               = {0x32F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLLegendElement               = {0xEAF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLLegendElement2              = {0x34F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLLIElement                   = {0xE0F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLLinkElement                 = {0x05F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLLinkElement2                = {0xE5F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLLinkElement3                = {0x1EF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLListElement                 = {0x0EF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLListElement2                = {0x22F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHtmlLoadOptions                 = {0x08081AA7, 0x880F, 0xD111, [0xBA, 0x19, 0x00, 0xC0, 0x4F, 0xD9, 0x12, 0xD0]};
    const IID IID_IHTMLLocation                    = {0xE0B13B16, 0x006E, 0xCF11, [0x83, 0x7A, 0x48, 0xDC, 0x04, 0xC1, 0x00, 0x00]};
    const IID IID_IHTMLMapElement                  = {0x66F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLMarqueeElement              = {0xB5F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLMetaElement                 = {0x03F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLMetaElement2                = {0x1FF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLMimeTypesCollection         = {0xFCF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLModelessInit                = {0xE4F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLNamespace                   = {0xBBF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLNamespaceCollection         = {0xB8F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLNextIdElement               = {0x07F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLNoShowElement               = {0x8AF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLObjectElement               = {0x4FF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLObjectElement2              = {0xCDF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLObjectElement3              = {0x27F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLOListElement                = {0xDEF15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLOMWindowServices            = {0xFCF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLOpsProfile                  = {0x01F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLOptionButtonElement         = {0xBCF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLOptionElement               = {0x11F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLOptionElement2              = {0x97F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLOptionElement3              = {0x20F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLOptionElementFactory        = {0x8CF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLOptionsHolder               = {0x78F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPainter                     = {0xA6F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPainterEventInfo            = {0xDFF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPainterOverlay              = {0xE3F75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPaintSite                   = {0xA7F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLParaElement                 = {0xF5F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLParamElement                = {0x3DF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPersistData                 = {0xC5F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPersistDataOM               = {0xC0F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPhraseElement               = {0x0AF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPhraseElement2              = {0x24F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPluginsCollection           = {0xFDF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPopup                       = {0x66F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPrivateWindow               = {0xDCF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPrivateWindow2              = {0xE5F75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLPrivateWindow3              = {0x40F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLRect                        = {0xA3F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLRectCollection              = {0xA4F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLRenderStyle                 = {0xAEF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLRuleStyle                   = {0xCFF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLRuleStyle2                  = {0xACF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLRuleStyle3                  = {0x57F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLRuleStyle4                  = {0x17F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLScreen                      = {0x5CF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLScreen2                     = {0x4AF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLScriptElement               = {0x8BF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLScriptElement2              = {0x28F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLSelectElement               = {0x44F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLSelectElement2              = {0xEDF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLSelectElement3              = {0x87F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLSelectElement4              = {0x38F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLSelectionObject             = {0x5AF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLSelectionObject2            = {0xECF75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLSpanElement                 = {0xF3F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLSpanFlow                    = {0xE5F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyle                       = {0x5EF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyle2                      = {0xA2F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyle3                      = {0x56F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyle4                      = {0x16F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyleElement                = {0x75F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyleFontFace               = {0xD5F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyleSheet                  = {0xE3F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyleSheet2                 = {0xD1F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyleSheetPage              = {0xEEF75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyleSheetPagesCollection   = {0xF0F75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyleSheetRule              = {0x57F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyleSheetRulesCollection   = {0xE5F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLStyleSheetsCollection       = {0x7EF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLSubmitData                  = {0x45F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTable                       = {0x1EF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTable2                      = {0xADF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTable3                      = {0x29F85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableCaption                = {0xEBF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableCell                   = {0x3DF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableCell2                  = {0x2DF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableCol                    = {0x3AF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableCol2                   = {0x2AF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableRow                    = {0x3CF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableRow2                   = {0xA1F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableRow3                   = {0x2CF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableRowMetrics             = {0x13F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableSection                = {0x3BF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableSection2               = {0xC7F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTableSection3               = {0x2BF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTextAreaElement             = {0xAAF25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTextContainer               = {0x30F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTextElement                 = {0x18F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTextRangeMetrics            = {0x0BF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTextRangeMetrics2           = {0xA6F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTitleElement                = {0x22F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTxtRange                    = {0x20F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLTxtRangeCollection          = {0xEDF75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLUListElement                = {0xDDF15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLUniqueName                  = {0xD0F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLUnknownElement              = {0x09F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLUrnCollection               = {0xE2F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLUserDataOM                  = {0x8FF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLViewFilter                  = {0xF1F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLViewFilterSite              = {0xF4F25030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLWindow2                     = {0x27442C33, 0xCB26, 0xD011, [0xB4, 0x83, 0x00, 0xC0, 0x4F, 0xD9, 0x01, 0x19]};
    const IID IID_IHTMLWindow3                     = {0xAEF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHTMLWindow4                     = {0xCFF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IHttpNegotiate                   = {0xD2C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IHttpNegotiate2                  = {0xCB9F9F4F, 0xF4E0, 0xEB48, [0xB7, 0xAB, 0xFA, 0x2E, 0xA9, 0x36, 0x5C, 0xB4]};
    const IID IID_IHttpSecurity                    = {0xD7C9EA79, 0xFABA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IHWEventHandler                  = {0xD073FBC1, 0x3AEC, 0xA24B, [0xB5, 0x12, 0x8C, 0xDB, 0x91, 0x87, 0xB6, 0xD1]};
    const IID IID_IImageDecodeEventSink            = {0xA042A3BA, 0xED2D, 0xD011, [0x86, 0xF4, 0x00, 0xA0, 0xC9, 0x13, 0xF7, 0x50]};
    const IID IID_IImageDecodeFilter               = {0xF3EDCCA3, 0xE22D, 0xD011, [0x86, 0xF4, 0x00, 0xA0, 0xC9, 0x13, 0xF7, 0x50]};
    const IID IID_IImageList                       = {0x2659EB46, 0x2E58, 0x1740, [0x9F, 0xDF, 0xE8, 0x99, 0x8D, 0xAA, 0x09, 0x50]};
    const IID IID_IIMEServices                     = {0xCAF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IImgCtx                          = {0xD7F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IIndexDefinition                 = {0x683A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IInputObject                     = {0xAA4F2868, 0x486A, 0xD011, [0x8C, 0x78, 0x00, 0xC0, 0x4F, 0xD9, 0x18, 0xB4]};
    const IID IID_IInputObjectSite                 = {0x9283DBF1, 0x3173, 0xD011, [0x8C, 0x99, 0x00, 0xA0, 0xC9, 0x2D, 0xBF, 0xE8]};
    const IID IID_IIntDitherer                     = {0xA00C6706, 0xEFEC, 0xD011, [0xAA, 0xE7, 0x00, 0xC0, 0x4F, 0xC9, 0xB3, 0x04]};
    const IID IID_IIntelliForms                    = {0xE6689F9B, 0xAA1A, 0xD211, [0xBC, 0xA5, 0x00, 0xC0, 0x4F, 0xD9, 0x29, 0xDB]};
    const IID IID_IInterfaceRelated                = {0x795AFBD1, 0x0677, 0xD111, [0xAD, 0xBA, 0x00, 0xC0, 0x4F, 0xC2, 0xAD, 0xC0]};
    const IID IID_IInternalMoniker                 = {0x11000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IInternalUnknown                 = {0x21000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IInternet                        = {0xE0C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetBindInfo                = {0xE1C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetConnectionDevice        = {0x3761DF04, 0x1056, 0xD411, [0x9E, 0xC8, 0x00, 0xB0, 0xD0, 0x22, 0xDD, 0x1F]};
    const IID IID_IInternetConnectionDeviceClient  = {0x3961DF04, 0x1056, 0xD411, [0x9E, 0xC8, 0x00, 0xB0, 0xD0, 0x22, 0xDD, 0x1F]};
    const IID IID_IInternetConnectionDeviceSharedConnecti = {0x3861DF04, 0x1056, 0xD411, [0x9E, 0xC8, 0x00, 0xB0, 0xD0, 0x22, 0xDD, 0x1F]};
    const IID IID_IInternetHostSecurityManager     = {0xB680F23A, 0x3FCB, 0xD011, [0x89, 0x1E, 0x00, 0xC0, 0x4F, 0xB6, 0xBF, 0xC4]};
    const IID IID_IInternetPriority                = {0xEBC9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetProtocol                = {0xE4C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetProtocolInfo            = {0xECC9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetProtocolRoot            = {0xE3C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetProtocolSink            = {0xE5C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetProtocolSinkStackable   = {0xF0C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetSecurityManager         = {0xEEC9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetSecurityMgrSite         = {0xEDC9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetSession                 = {0xE7C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetThreadSwitch            = {0xE8C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IInternetZoneManager             = {0xEFC9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IIpxAdapterInfo                  = {0x70321398, 0x204B, 0xD111, [0xAB, 0x01, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_IItemNameLimits                  = {0xF1D7F01D, 0x67B2, 0x284D, [0x8B, 0x10, 0x12, 0xE2, 0x32, 0x02, 0xA5, 0xC4]};
    const IID IID_IJolietDiscMaster                = {0xCE42BCE3, 0x5C4E, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID IID_IKeyFrameControl                 = {0x861334C3, 0x91AF, 0xF94E, [0x83, 0xB6, 0xBE, 0x37, 0x62, 0xE4, 0x2E, 0xCB]};
    const IID IID_IKsControl                       = {0x8546F528, 0xFD06, 0xD211, [0xB2, 0x7A, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96]};
    const IID IID_IKsPropertySet                   = {0x30ACEF31, 0x5C51, 0xD011, [0xA9, 0xAA, 0x00, 0xAA, 0x00, 0x61, 0xBE, 0x93]};
    const IID IID_ILayoutRect                      = {0x65F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ILayoutStorage                   = {0x904D6D0E, 0x3867, 0xCF11, [0x96, 0x08, 0x00, 0xAA, 0x00, 0x68, 0x0D, 0xB4]};
    const IID IID_ILineInfo                        = {0xE2F75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ILocalMachine                    = {0xAF4C6660, 0x0DAF, 0x0510, [0xA3, 0x00, 0x5C, 0x7D, 0x25, 0xFF, 0x22, 0xA0]};
    const IID IID_ILockBytes                       = {0x0A000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ILogger                          = {0x188459D9, 0x4E30, 0x944F, [0xB6, 0xA1, 0xE6, 0x42, 0xFE, 0x95, 0xED, 0x57]};
    const IID IID_ILogManager                      = {0x11DC5947, 0xA08D, 0x6142, [0xBB, 0xFB, 0xEC, 0x32, 0x19, 0x11, 0xD1, 0xC9]};
    const IID IID_ILogonEnumUsers                  = {0xAF4C6660, 0x0DAF, 0x0410, [0xA3, 0x00, 0x5C, 0x7D, 0x25, 0xFF, 0x22, 0xA0]};
    const IID IID_ILogonStatusHost                 = {0xAF4C6660, 0x0DAF, 0x0710, [0xA3, 0x00, 0x5C, 0x7D, 0x25, 0xFF, 0x22, 0xA0]};
    const IID IID_ILogonUser                       = {0xAF4C6660, 0x0DAF, 0x0310, [0xA3, 0x00, 0x5C, 0x7D, 0x25, 0xFF, 0x22, 0xA0]};
    const IID IID_IMachineDebugManager             = {0x2C3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IMachineDebugManagerCookie       = {0x2D3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IMachineDebugManagerEvents       = {0x2E3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IMailAutoDiscovery               = {0xEE2D4080, 0x14B1, 0x324D, [0xB4, 0x4E, 0x82, 0xFD, 0x82, 0x34, 0xC9, 0x2A]};
    const IID IID_IMailProtocolADEntry             = {0x688CEF40, 0x54D5, 0xED47, [0xAA, 0x37, 0xE5, 0xFB, 0x6B, 0xC9, 0x10, 0x75]};
    const IID IID_IMalloc                          = {0x02000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IMallocSpy                       = {0x1D000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IMapMIMEToCLSID                  = {0x0095E8D9, 0xFA30, 0xD011, [0xB7, 0x24, 0x00, 0xAA, 0x00, 0x6C, 0x1A, 0x01]};
    const IID IID_IMarkupContainer                 = {0xF9F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IMarkupContainer2                = {0x48F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IMarkupPointer                   = {0x9FF45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IMarkupPointer2                  = {0x75F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IMarkupServices                  = {0xA0F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IMarkupServices2                 = {0x82F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IMarkupTextFrags                 = {0xFAF55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IMarshal                         = {0x03000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IMarshal2                        = {0xCF010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IMcastAddressAllocation          = {0xF1AE0DDF, 0x89A2, 0xD111, [0x86, 0x97, 0x00, 0x60, 0x08, 0xB0, 0xE5, 0xD2]};
    const IID IID_IMcastLeaseInfo                  = {0xFDAE0DDF, 0x89A2, 0xD111, [0x86, 0x97, 0x00, 0x60, 0x08, 0xB0, 0xE5, 0xD2]};
    const IID IID_IMcastScope                      = {0xF4AE0DDF, 0x89A2, 0xD111, [0x86, 0x97, 0x00, 0x60, 0x08, 0xB0, 0xE5, 0xD2]};
    const IID IID_IMDDataset                       = {0xD1CC7CA0, 0x4881, 0xD011, [0x87, 0xBB, 0x00, 0xC0, 0x4F, 0xC3, 0x39, 0x42]};
    const IID IID_IMDFind                          = {0xD2CC7CA0, 0x4881, 0xD011, [0x87, 0xBB, 0x00, 0xC0, 0x4F, 0xC3, 0x39, 0x42]};
    const IID IID_IMDRangeRowset                   = {0xA03A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IMessageFilter                   = {0x16000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IMigrationWizardAuto             = {0xB9DA20CE, 0x53B3, 0x9B46, [0x8B, 0x4D, 0x6D, 0xBB, 0x3A, 0x7B, 0xA0, 0x16]};
    const IID IID_IMimeInfo                        = {0xA05974F7, 0x9ABF, 0xCF11, [0xBA, 0x4E, 0x00, 0xC0, 0x4F, 0xD7, 0x08, 0x16]};
    const IID IID_IMLangCodePages                  = {0x43349F35, 0x4ABD, 0xD011, [0xB1, 0x88, 0x00, 0xAA, 0x00, 0x38, 0xC9, 0x69]};
    const IID IID_IMLangConvertCharset             = {0x986F6DD6, 0xAACD, 0xD011, [0xB8, 0x22, 0x00, 0xC0, 0x4F, 0xC9, 0xB3, 0x1F]};
    const IID IID_IMLangFontLink                   = {0x41349F35, 0x4ABD, 0xD011, [0xB1, 0x88, 0x00, 0xAA, 0x00, 0x38, 0xC9, 0x69]};
    const IID IID_IMLangFontLink2                  = {0x62C1CFDC, 0x382B, 0xD211, [0xB7, 0xEC, 0x00, 0xC0, 0x4F, 0x8F, 0x5D, 0x9A]};
    const IID IID_IMLangLineBreakConsole           = {0xE12EBEF5, 0xD7BF, 0xD011, [0xB1, 0x88, 0x00, 0xAA, 0x00, 0x38, 0xC9, 0x69]};
    const IID IID_IMLangString                     = {0xCE654DC0, 0x0DB7, 0xD011, [0xB1, 0x88, 0x00, 0xAA, 0x00, 0x38, 0xC9, 0x69]};
    const IID IID_IMLangStringAStr                 = {0xD2654DC0, 0x0DB7, 0xD011, [0xB1, 0x88, 0x00, 0xAA, 0x00, 0x38, 0xC9, 0x69]};
    const IID IID_IMLangStringBufA                 = {0x23CD4AD2, 0x72BA, 0xD011, [0xB1, 0x88, 0x00, 0xAA, 0x00, 0x38, 0xC9, 0x69]};
    const IID IID_IMLangStringBufW                 = {0x21CD4AD2, 0x72BA, 0xD011, [0xB1, 0x88, 0x00, 0xAA, 0x00, 0x38, 0xC9, 0x69]};
    const IID IID_IMLangStringWStr                 = {0xD0654DC0, 0x0DB7, 0xD011, [0xB1, 0x88, 0x00, 0xAA, 0x00, 0x38, 0xC9, 0x69]};
    const IID IID_IMofCompiler                     = {0x4E97AF6D, 0x372E, 0xD211, [0xAE, 0xC9, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID IID_IMoniker                         = {0x0F000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IMonikerProp                     = {0x7F5FCAA5, 0x4718, 0x874D, [0x9C, 0x5B, 0x91, 0x85, 0x09, 0xF7, 0x51, 0x1D]};
    const IID IID_IMountedVolume                   = {0x92845112, 0xB200, 0xD211, [0x9F, 0xA5, 0x9E, 0x34, 0x20, 0x52, 0x41, 0x53]};
    const IID IID_IMulticastControl                = {0x07A50F41, 0xC64D, 0x5A41, [0x90, 0x14, 0x63, 0x38, 0x75, 0xD5, 0x40, 0x6E]};
    const IID IID_IMultiLanguage                   = {0xE1235C27, 0x4737, 0xD011, [0x9F, 0xEA, 0x00, 0xAA, 0x00, 0x3F, 0x86, 0x46]};
    const IID IID_IMultiLanguage2                  = {0x64C1CFDC, 0x382B, 0xD211, [0xB7, 0xEC, 0x00, 0xC0, 0x4F, 0x8F, 0x5D, 0x9A]};
    const IID IID_IMultiLanguage3                  = {0xAB68584E, 0x57B1, 0x2346, [0x9A, 0xCC, 0x6A, 0x1D, 0x9C, 0xAE, 0xBE, 0x04]};
    const IID IID_IMultiplePropertyAccess          = {0xDEFE81EC, 0x32D4, 0xCE11, [0x92, 0x44, 0x00, 0x20, 0xAF, 0x6E, 0x72, 0xDB]};
    const IID IID_IMultipleResults                 = {0x903A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IMultiQI                         = {0x20000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_INamedPropertyBag                = {0x300470FB, 0x2C95, 0xD111, [0x94, 0x6F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]};
    const IID IID_INATEventManager                 = {0x88D54B62, 0x6090, 0x0941, [0xB0, 0xB0, 0x1A, 0xDB, 0xBC, 0xAC, 0x32, 0xDF]};
    const IID IID_INATExternalIPAddressCallback    = {0x4067419C, 0x4EA3, 0x6F44, [0xBA, 0x06, 0xAB, 0xD0, 0x4C, 0x31, 0x49, 0xAE]};
    const IID IID_INATNumberOfEntriesCallback      = {0x740A3AC8, 0xEE91, 0xB641, [0xB6, 0x7A, 0x67, 0xE0, 0xF0, 0x0B, 0xBD, 0x78]};
    const IID IID_INetCfg                          = {0x93AEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgBindingInterface          = {0x94AEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgBindingPath               = {0x96AEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgClass                     = {0x97AEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgClassSetup                = {0x9DAEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgComponent                 = {0x99AEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgComponentBindings         = {0x9EAEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgComponentControl          = {0xDF382293, 0xA1BE, 0xD011, [0x92, 0x98, 0x00, 0xC0, 0x4F, 0xC9, 0x9D, 0xCF]};
    const IID IID_INetCfgComponentNotifyBinding    = {0xE1382293, 0xA1BE, 0xD011, [0x92, 0x98, 0x00, 0xC0, 0x4F, 0xC9, 0x9D, 0xCF]};
    const IID IID_INetCfgComponentNotifyGlobal     = {0xE2382293, 0xA1BE, 0xD011, [0x92, 0x98, 0x00, 0xC0, 0x4F, 0xC9, 0x9D, 0xCF]};
    const IID IID_INetCfgComponentPrivate          = {0x73321398, 0x204B, 0xD111, [0xAB, 0x01, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgComponentPropertyUi       = {0xE0382293, 0xA1BE, 0xD011, [0x92, 0x98, 0x00, 0xC0, 0x4F, 0xC9, 0x9D, 0xCF]};
    const IID IID_INetCfgComponentSetup            = {0xE3382293, 0xA1BE, 0xD011, [0x92, 0x98, 0x00, 0xC0, 0x4F, 0xC9, 0x9D, 0xCF]};
    const IID IID_INetCfgComponentSysPrep          = {0x9AAEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgComponentUpperEdge        = {0xE4382293, 0xA1BE, 0xD011, [0x92, 0x98, 0x00, 0xC0, 0x4F, 0xC9, 0x9D, 0xCF]};
    const IID IID_INetCfgInternalSetup             = {0x76321398, 0x204B, 0xD111, [0xAB, 0x01, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgLock                      = {0x9FAEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgPnpReconfigCallback       = {0x35BD848D, 0x27E2, 0xD211, [0xB7, 0x00, 0x00, 0xA0, 0xC9, 0x8A, 0x6A, 0x85]};
    const IID IID_INetCfgSpecialCase               = {0x95AEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCfgSysPrep                   = {0x98AEE8C0, 0x6E30, 0xD111, [0xAA, 0xCF, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnection                   = {0xA15689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnection2                  = {0x6ACFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionBrandingInfo       = {0x5BCFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionCMUtil             = {0x60CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionCommonUi           = {0xA55689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionConnectUi          = {0xA35689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionHNetUtil           = {0x64CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionManager            = {0xA25689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionManager2           = {0x69CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionManagerDebug       = {0x5DCFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionManagerEvents      = {0xBA5689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionNotifySink         = {0x5CCFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionPropertyUi         = {0xA45689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionPropertyUi2        = {0xB95689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionProps              = {0x957C27F4, 0x5BCE, 0x3D46, [0x81, 0x67, 0x56, 0x62, 0xD9, 0xBC, 0xAA, 0x72]};
    const IID IID_INetConnectionRefresh            = {0x5FCFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionSysTray            = {0x65CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionUiLock             = {0x50CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionUiUtilities        = {0x5ECFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionWizardUi           = {0x51CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetConnectionWizardUiContext    = {0x52CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetCrawler                      = {0xEE29C949, 0xB7A1, 0x584C, [0xB5, 0x39, 0xE6, 0x3B, 0xE3, 0x92, 0xB6, 0xF3]};
    const IID IID_INetDefaultConnection            = {0x66CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetInboundConnection            = {0x53CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetInstallQueue                 = {0x74321398, 0x204B, 0xD111, [0xAB, 0x01, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetLanConnection                = {0x54CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetLanConnectionUiInfo          = {0xA65689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetLanConnectionWizardUi        = {0x56CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetMachinePolicies              = {0x68CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetRasConnection                = {0x57CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetRasConnectionIpUiInfo        = {0x58CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetSharedAccessConnection       = {0x55CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetSharingConfiguration         = {0xB65689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetSharingEveryConnectionCollecti = {0x3C64C433, 0x1178, 0xFA46, [0xA8, 0x9A, 0x76, 0x85, 0x97, 0xBD, 0x72, 0x23]};
    const IID IID_INetSharingManager               = {0xB75689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetSharingPortMapping           = {0xB15689C0, 0xD31C, 0xD111, [0xB1, 0xC5, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_INetSharingPortMappingCollection = {0xDEA2E402, 0x20DA, 0x344E, [0x89, 0xC8, 0xAC, 0x22, 0x27, 0x5A, 0x01, 0x0B]};
    const IID IID_INetSharingPortMappingProps      = {0xB5E9B724, 0x8FE3, 0x8546, [0x85, 0x1B, 0x00, 0x89, 0x2C, 0xF5, 0xF9, 0x40]};
    const IID IID_INetSharingPrivateConnectionCollecti = {0xE069AE38, 0x0944, 0x2A40, [0xA2, 0xCB, 0xE9, 0x65, 0xC7, 0x27, 0xF8, 0x40]};
    const IID IID_INetSharingPublicConnectionCollecti = {0x55637A7D, 0x72F3, 0x7149, [0xA1, 0x49, 0xBF, 0xC9, 0x27, 0xBE, 0x76, 0x2A]};
    const IID IID_INewShortcutHookA                = {0xE1140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_INewShortcutHookW                = {0xF7140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_INewWDEvents                     = {0x51C55107, 0x6875, 0xC941, [0x8E, 0x5B, 0xE2, 0x2E, 0x38, 0x91, 0x92, 0x36]};
    const IID IID_INotification                    = {0xA3E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_INotificationHelper              = {0xABE433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_INotificationManager             = {0x01155395, 0x8287, 0x4548, [0x90, 0x1D, 0x31, 0x2F, 0x36, 0xBA, 0x6C, 0x6E]};
    const IID IID_INotificationMgr                 = {0xA4E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_INotificationPing                = {0xACE433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_INotificationProcessMgr0         = {0xAEE433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_INotificationReport              = {0xA7E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_INotificationRunning             = {0xADE433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_INotificationSink                = {0xA5E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_INotifyDBEvents                  = {0xC06C52DB, 0x88D1, 0xCD11, [0xAD, 0x48, 0x00, 0xAA, 0x00, 0x3C, 0x9C, 0xB6]};
    const IID IID_INotifyReplica                   = {0x63011899, 0x16DA, 0x1A10, [0x93, 0x5C, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_INotifyUI                        = {0x01D4E8E5, 0x371A, 0xBF4F, [0x88, 0x0C, 0x82, 0x6C, 0xC8, 0x95, 0x16, 0xFD]};
    const IID IID_IObjectAccessControl             = {0xA33A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IObjectIdentity                  = {0xE6B704CA, 0x210D, 0xD111, [0x8C, 0xC5, 0x00, 0xC0, 0x4F, 0xC2, 0xB0, 0x85]};
    const IID IID_IObjectManager                   = {0xDF5113D5, 0x9463, 0x3642, [0x97, 0x83, 0x65, 0xED, 0x05, 0x63, 0x10, 0x68]};
    const IID IID_IObjectSafety                    = {0x81DC5BCB, 0xC193, 0xCF11, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID IID_IObjectWithSite                  = {0xA30148FC, 0xA92B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID IID_IObjMgr                          = {0x6127BB00, 0x776A, 0xD011, [0xA5, 0x35, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62]};
    const IID IID_IOInet                           = {0xE0C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IOInetBindClient                 = {0xE2C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IOInetBindInfo                   = {0xE1C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IOInetCache                      = {0xEAC9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IOInetPriority                   = {0xEBC9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IOInetProtocol                   = {0xE4C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IOInetProtocolInfo               = {0xECC9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IOInetProtocolRoot               = {0xE3C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IOInetProtocolSink               = {0xE5C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IOInetSession                    = {0x67C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IOInetThreadSwitch               = {0x68C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IOldSyncMgrRegister              = {0x558C4D89, 0xDFBD, 0xD111, [0xB8, 0x5D, 0x00, 0xC0, 0x4F, 0xB9, 0x39, 0x81]};
    const IID IID_IOldSyncMgrSynchronize           = {0x28DF9562, 0xEE35, 0xD111, [0x87, 0x07, 0x00, 0xC0, 0x4F, 0xD9, 0x33, 0x27]};
    const IID IID_IOldSyncMgrSynchronizeCallback   = {0x29DF9562, 0xEE35, 0xD111, [0x87, 0x07, 0x00, 0xC0, 0x4F, 0xD9, 0x33, 0x27]};
    const IID IID_IOleAdviseHolder                 = {0x11010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleCache                        = {0x1E010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleCache2                       = {0x28010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleCacheControl                 = {0x29010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleClientSite                   = {0x18010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleCommandTarget                = {0xCBBC22B7, 0x684E, 0x1B10, [0xA2, 0xBC, 0x00, 0xAA, 0x00, 0x40, 0x47, 0x70]};
    const IID IID_IOleContainer                    = {0x1B010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleControl                      = {0x88B296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IOleControlSite                  = {0x89B296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IOleDocument                     = {0xC5BC22B7, 0x684E, 0x1B10, [0xA2, 0xBC, 0x00, 0xAA, 0x00, 0x40, 0x47, 0x70]};
    const IID IID_IOleDocumentSite                 = {0xC7BC22B7, 0x684E, 0x1B10, [0xA2, 0xBC, 0x00, 0xAA, 0x00, 0x40, 0x47, 0x70]};
    const IID IID_IOleDocumentView                 = {0xC6BC22B7, 0x684E, 0x1B10, [0xA2, 0xBC, 0x00, 0xAA, 0x00, 0x40, 0x47, 0x70]};
    const IID IID_IOleInPlaceActiveObject          = {0x17010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleInPlaceFrame                 = {0x16010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleInPlaceObject                = {0x13010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleInPlaceObjectWindowless      = {0xCC56201C, 0xF45E, 0x1B10, [0x8B, 0xC8, 0x00, 0xAA, 0x00, 0x3E, 0x3B, 0x29]};
    const IID IID_IOleInPlaceSite                  = {0x19010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleInPlaceSiteEx                = {0x80AD2C9C, 0x2434, 0xCF11, [0xB6, 0x70, 0x00, 0xAA, 0x00, 0x4C, 0xD6, 0xD8]};
    const IID IID_IOleInPlaceSiteWindowless        = {0xA0AD2E92, 0x2434, 0xCF11, [0xB6, 0x70, 0x00, 0xAA, 0x00, 0x4C, 0xD6, 0xD8]};
    const IID IID_IOleInPlaceUIWindow              = {0x15010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleItemContainer                = {0x1C010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleLink                         = {0x1D010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleManager                      = {0x1F010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleObject                       = {0x12010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleParentUndoUnit               = {0x30F3FAA1, 0x97EF, 0xCE11, [0x9B, 0xC9, 0x00, 0xAA, 0x00, 0x60, 0x8E, 0x01]};
    const IID IID_IOlePresObj                      = {0x20010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOleUndoManager                  = {0x00F201D0, 0x97EF, 0xCE11, [0x9B, 0xC9, 0x00, 0xAA, 0x00, 0x60, 0x8E, 0x01]};
    const IID IID_IOleUndoUnit                     = {0xB0D34A89, 0x97EF, 0xCE11, [0x9B, 0xC9, 0x00, 0xAA, 0x00, 0x60, 0x8E, 0x01]};
    const IID IID_IOleWindow                       = {0x14010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOmHistory                       = {0xA2AACEFE, 0x0584, 0xCF11, [0x8B, 0xA1, 0x00, 0xAA, 0x00, 0x47, 0x6D, 0xA6]};
    const IID IID_IOmNavigator                     = {0xA5AACEFE, 0x0584, 0xCF11, [0x8B, 0xA1, 0x00, 0xAA, 0x00, 0x47, 0x6D, 0xA6]};
    const IID IID_IOpaqueDataInfo                  = {0xA9010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IOpenRowset                      = {0x693A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IOplockStorage                   = {0x34C8198D, 0x7988, 0xD111, [0x83, 0xE9, 0x00, 0xC0, 0x4F, 0xC2, 0xC6, 0xD4]};
    const IID IID_IOpsProfileSimple                = {0x2C36D17D, 0xB628, 0xD211, [0xBC, 0xA7, 0x00, 0xC0, 0x4F, 0xD9, 0x29, 0xDB]};
    const IID IID_IOptionArray                     = {0x92D4B622, 0x880F, 0xD111, [0xBA, 0x19, 0x00, 0xC0, 0x4F, 0xD9, 0x12, 0xD0]};
    const IID IID_IOverlappedCompletion            = {0xF0281A52, 0x0BE4, 0xCE11, [0xB2, 0xC9, 0x00, 0xAA, 0x00, 0x68, 0x09, 0x37]};
    const IID IID_IOverlappedStream                = {0x70403849, 0x0AE4, 0xCE11, [0xB2, 0xC9, 0x00, 0xAA, 0x00, 0x68, 0x09, 0x37]};
    const IID IID_IParentRowset                    = {0xAA3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IParseDisplayName                = {0x1A010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IParser                          = {0xB0426418, 0x2E47, 0xD111, [0x89, 0x52, 0x00, 0xC0, 0x4F, 0xD6, 0x11, 0xD7]};
    const IID IID_IParserSession                   = {0xB1426418, 0x2E47, 0xD111, [0x89, 0x52, 0x00, 0xC0, 0x4F, 0xD6, 0x11, 0xD7]};
    const IID IID_IParserTreeProperties            = {0xB2426418, 0x2E47, 0xD111, [0x89, 0x52, 0x00, 0xC0, 0x4F, 0xD6, 0x11, 0xD7]};
    const IID IID_IParserVerify                    = {0xB3426418, 0x2E47, 0xD111, [0x89, 0x52, 0x00, 0xC0, 0x4F, 0xD6, 0x11, 0xD7]};
    const IID IID_IPassportClientServices          = {0x05730FB3, 0x6759, 0xD145, [0xB7, 0xBC, 0xD6, 0xEB, 0x71, 0x63, 0xD7, 0x70]};
    const IID IID_IPeerFactory                     = {0xD3F96366, 0x82B4, 0xD111, [0x89, 0xC6, 0x00, 0xC0, 0x4F, 0xB6, 0xBF, 0xC4]};
    const IID IID_IPendingProxyConnection          = {0x43508EB6, 0x3D3E, 0xC24C, [0xB9, 0xC1, 0x5F, 0x8F, 0x88, 0xFE, 0xE8, 0x1C]};
    const IID IID_IPerPropertyBrowsing             = {0xAAD36B37, 0x4538, 0x1B10, [0x84, 0xED, 0x08, 0x00, 0x2B, 0x2E, 0xC7, 0x13]};
    const IID IID_IPerPropertyBrowsing2            = {0x543C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IPersist                         = {0x0C010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IPersistentDataChannel           = {0x34E980A1, 0x2AD9, 0x5D41, [0x91, 0x44, 0x75, 0x9F, 0x80, 0x54, 0xE8, 0xF6]};
    const IID IID_IPersistFile                     = {0x0B010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IPersistFolder                   = {0xEA140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IPersistFolder2                  = {0xF0D9C31A, 0x5C17, 0xD111, [0x95, 0xBE, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x4F]};
    const IID IID_IPersistFolder3                  = {0xDF4FF0CE, 0x72FE, 0xD211, [0x87, 0xA5, 0x00, 0xC0, 0x4F, 0x68, 0x37, 0xCF]};
    const IID IID_IPersistHistory                  = {0xC165A591, 0x8FE3, 0xD011, [0x94, 0xBF, 0x00, 0xA0, 0xC9, 0x05, 0x5C, 0xBF]};
    const IID IID_IPersistIDList                   = {0xFCAC7910, 0xBD29, 0xD311, [0x8E, 0x0D, 0x00, 0xC0, 0x4F, 0x68, 0x37, 0xD5]};
    const IID IID_IPersistMemory                   = {0xE0E51ABD, 0xAEA6, 0xCE11, [0xBD, 0x37, 0x50, 0x42, 0x00, 0xC1, 0x00, 0x00]};
    const IID IID_IPersistMoniker                  = {0xC9C9EA79, 0xF9BA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IPersistNetConnection            = {0x59CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_IPersistPropertyBag              = {0x604FD837, 0xCB42, 0xCE11, [0x81, 0x35, 0x00, 0xAA, 0x00, 0x4B, 0xB8, 0x51]};
    const IID IID_IPersistPropertyBag2             = {0x8158F522, 0x0B28, 0xD011, [0xA8, 0xA9, 0x00, 0xA0, 0xC9, 0x0C, 0x20, 0x04]};
    const IID IID_IPersistQuery                    = {0xB814311A, 0x2EA6, 0xD011, [0xA6, 0xC5, 0x00, 0xA0, 0xC9, 0x06, 0xAF, 0x45]};
    const IID IID_IPersistStorage                  = {0x0A010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IPersistStream                   = {0x09010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IPersistStreamInit               = {0x8023D57F, 0x074E, 0x1B10, [0xAE, 0x2D, 0x08, 0x00, 0x2B, 0x2E, 0xC7, 0x13]};
    const IID IID_IPhraseSink                      = {0xF06F90CC, 0x58C0, 0x1A10, [0xB5, 0x54, 0x08, 0x00, 0x2B, 0x33, 0xB0, 0xE6]};
    const IID IID_IPicture                         = {0x8009F87B, 0x32BF, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID IID_IPictureDisp                     = {0x8109F87B, 0x32BF, 0x1A10, [0x8B, 0xBB, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID IID_IPipeByte                        = {0xCA3A2FDB, 0x862F, 0xD111, [0x8E, 0x04, 0x00, 0xC0, 0x4F, 0xB9, 0x98, 0x9A]};
    const IID IID_IPipeDouble                      = {0xCE3A2FDB, 0x862F, 0xD111, [0x8E, 0x04, 0x00, 0xC0, 0x4F, 0xB9, 0x98, 0x9A]};
    const IID IID_IPipeLong                        = {0xCC3A2FDB, 0x862F, 0xD111, [0x8E, 0x04, 0x00, 0xC0, 0x4F, 0xB9, 0x98, 0x9A]};
    const IID IID_IPointerInactive                 = {0xA00B9855, 0xAA35, 0xCF11, [0xB6, 0x71, 0x00, 0xAA, 0x00, 0x4C, 0xD6, 0xD8]};
    const IID IID_IPrimaryControlChannel           = {0x628B2E1A, 0x1290, 0xE64B, [0x84, 0xAE, 0x32, 0xBD, 0x66, 0xBA, 0x65, 0x7A]};
    const IID IID_IPrint                           = {0xC9BC22B7, 0x684E, 0x1B10, [0xA2, 0xBC, 0x00, 0xAA, 0x00, 0x40, 0x47, 0x70]};
    const IID IID_IPrintDialogCallback             = {0xC3A25258, 0x3065, 0xD111, [0xB6, 0xA3, 0x00, 0x00, 0xF8, 0x75, 0x7B, 0xF9]};
    const IID IID_IPrintDialogServices             = {0xDAAE9A50, 0x3956, 0xD111, [0xB6, 0xA1, 0x00, 0x00, 0xF8, 0x75, 0x7B, 0xF9]};
    const IID IID_IPrivacyServices                 = {0x4BF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IPrivateDispatch                 = {0xBE4BAB86, 0xF665, 0xD111, [0x8C, 0x13, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IPrivateUnknown                  = {0xAB6B1289, 0xAD6E, 0xD111, [0x8C, 0x18, 0x00, 0xC0, 0x4F, 0xD8, 0xD5, 0x03]};
    const IID IID_IPrivSyncMgrSynchronizeInvoke    = {0x2EDF9562, 0xEE35, 0xD111, [0x87, 0x07, 0x00, 0xC0, 0x4F, 0xD9, 0x33, 0x27]};
    const IID IID_IProcessDebugManager             = {0x2F3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IProcessDebugManager32           = {0x2F3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IProcessDebugManager64           = {0x1CFCB956, 0xA963, 0xC14C, [0xAC, 0x21, 0x08, 0x7D, 0x69, 0xA1, 0x7F, 0xAB]};
    const IID IID_IProcessInitControl              = {0x550D3872, 0x2B8D, 0xA343, [0x85, 0x13, 0x2B, 0x6E, 0xF3, 0x14, 0x34, 0xE9]};
    const IID IID_IProfferService                  = {0x208B72CB, 0x86F7, 0xCE11, [0x92, 0xAD, 0x00, 0xAA, 0x00, 0xA7, 0x4C, 0xD0]};
    const IID IID_IProgressDialog                  = {0x047CBCEB, 0x5E31, 0xD211, [0xB6, 0x2F, 0x00, 0x60, 0x97, 0xDF, 0x5B, 0xD4]};
    const IID IID_IProgressNotify                  = {0xA058D7A9, 0x1746, 0xCF11, [0x95, 0xFC, 0x00, 0xAA, 0x00, 0x68, 0x0D, 0xB4]};
    const IID IID_IProgSink                        = {0x71F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IPropertyBag                     = {0x002A2755, 0xCB42, 0xCE11, [0x81, 0x35, 0x00, 0xAA, 0x00, 0x4B, 0xB8, 0x51]};
    const IID IID_IPropertyBag2                    = {0x8258F522, 0x0B28, 0xD011, [0xA8, 0xA9, 0x00, 0xA0, 0xC9, 0x0C, 0x20, 0x04]};
    const IID IID_IPropertyBagEx                   = {0x01180120, 0xE65D, 0xD111, [0x8E, 0x38, 0x00, 0xC0, 0x4F, 0xB9, 0x38, 0x6D]};
    const IID IID_IPropertyFrame                   = {0x8AB296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IPropertyMap                     = {0xA2E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_IPropertyMapper                  = {0x26B224B3, 0xA041, 0xD011, [0x8C, 0x91, 0x00, 0x20, 0xAF, 0x1D, 0x74, 0x0E]};
    const IID IID_IPropertyNotifySink              = {0x02BCFB9B, 0xF1EF, 0x1A10, [0x84, 0xED, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IPropertyPage                    = {0x8DB296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IPropertyPage2                   = {0x6546E401, 0xAC24, 0x1B10, [0x84, 0xED, 0x08, 0x00, 0x2B, 0x2E, 0xC7, 0x13]};
    const IID IID_IPropertyPageSite                = {0x8CB296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IPropertySetContainer            = {0x60AEFFB4, 0xCAA7, 0xCD11, [0xB5, 0x8B, 0x00, 0x00, 0x6B, 0x82, 0x91, 0x56]};
    const IID IID_IPropertySetStorage              = {0x3A010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IPropertyStorage                 = {0x38010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IPropertyUI                      = {0x9F7D7A75, 0x9A91, 0x1841, [0x99, 0xD7, 0xDB, 0xB2, 0x08, 0xC8, 0xCC, 0x66]};
    const IID IID_IPropSheetPage                   = {0xF6140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IProvideClassInfo                = {0x83B296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_IProvideClassInfo2               = {0xC03ABCA6, 0xAADB, 0xCE11, [0x9D, 0xE3, 0x00, 0xAA, 0x00, 0x4B, 0xB8, 0x51]};
    const IID IID_IProvideExpressionContexts       = {0x413C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IProvideMoniker                  = {0x4D3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IProvideMultipleClassInfo        = {0xC1A9ABA7, 0x8389, 0xCF11, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID IID_IProxy                           = {0x27000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IProxyManager                    = {0x08000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IPSFactory                       = {0x09000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IPSFactoryBuffer                 = {0xD069F5D5, 0x3B59, 0x1A10, [0xB5, 0x69, 0x08, 0x00, 0x2B, 0x2D, 0xBF, 0x7A]};
    const IID IID_IPublishedApp                    = {0xE052C71B, 0x4690, 0xD111, [0xB8, 0xB3, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82]};
    const IID IID_IPublishingWizard                = {0xBB9891AA, 0xECCC, 0x2D47, [0xBE, 0xED, 0x19, 0xA4, 0xF6, 0x73, 0x3F, 0x7A]};
    const IID IID_IQualityControl                  = {0xAB96C06B, 0xE60C, 0xD111, [0xBA, 0xAE, 0x00, 0xC0, 0x4F, 0xC2, 0xE2, 0x0D]};
    const IID IID_IQuery                           = {0x513A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IQueryAssociations               = {0x90A56CC4, 0x3F3C, 0xD211, [0xBE, 0xE6, 0x00, 0x00, 0xF8, 0x05, 0xCA, 0x57]};
    const IID IID_IQueryCancelAutoPlay             = {0x73E8EFDD, 0x9769, 0x684E, [0xBE, 0x26, 0x39, 0xB6, 0x33, 0xAD, 0xBE, 0x12]};
    const IID IID_IQueryContinue                   = {0x5C050773, 0x4AB2, 0x6B48, [0x9F, 0x25, 0x16, 0x3E, 0x59, 0x7A, 0x28, 0xA9]};
    const IID IID_IQueryForm                       = {0x30EEFC8C, 0xBD39, 0xD011, [0xB8, 0xD1, 0x00, 0xA0, 0x24, 0xAB, 0x2D, 0xBB]};
    const IID IID_IQueryFrame                      = {0x207C8C7E, 0x9D7C, 0xD011, [0x91, 0x3F, 0x00, 0xAA, 0x00, 0xC1, 0x6E, 0x65]};
    const IID IID_IQueryHandler                    = {0x3FC70CA6, 0xFCE0, 0xD011, [0x97, 0x50, 0x00, 0xA0, 0xC9, 0x06, 0xAF, 0x45]};
    const IID IID_IQueryInfo                       = {0x00150200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IQuickActivate                   = {0x10ED51CF, 0xFE62, 0xCF11, [0xBF, 0x86, 0x00, 0xA0, 0xC9, 0x03, 0x48, 0x36]};
    const IID IID_IRadioButton                     = {0x9BF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IRatingNotification              = {0xBD479463, 0xD3B2, 0xB944, [0x9F, 0xB0, 0x51, 0x0F, 0x23, 0xCB, 0x45, 0xE4]};
    const IID IID_IReadData                        = {0x6A3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IReadEvents                      = {0xDEEF4AF6, 0x7633, 0xD111, [0xBE, 0x5B, 0x00, 0xC0, 0x4F, 0xC9, 0xE2, 0xBB]};
    const IID IID_IRecalcEngine                    = {0x96F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IRecalcHost                      = {0x97F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IRecalcHostDebug                 = {0xF7F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IRecalcProperty                  = {0xD6F55030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IReconcilableObject              = {0x62011899, 0x16DA, 0x1A10, [0x93, 0x5C, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IReconcileInitiator              = {0x61011899, 0x16DA, 0x1A10, [0x93, 0x5C, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IRecordInfo                      = {0x2F000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IRedbookDiscMaster               = {0xCD42BCE3, 0x5C4E, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID IID_IReferenceClock                  = {0x9768A856, 0xD40A, 0xCE11, [0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70]};
    const IID IID_IRegisterProvider                = {0xB93A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRegisterVirusScanEngine         = {0x60E02508, 0x61B9, 0xCF11, [0xAA, 0xFA, 0x00, 0xAA, 0x00, 0xB6, 0x01, 0x5C]};
    const IID IID_IReleaseMarshalBuffers           = {0xE8B90CEB, 0x9679, 0xD211, [0x87, 0x2E, 0x00, 0x00, 0xF8, 0x08, 0x08, 0x59]};
    const IID IID_IRemoteCallBack                  = {0x48C64789, 0x3338, 0xD111, [0x86, 0x82, 0x00, 0xC0, 0x4F, 0xBF, 0xE1, 0x71]};
    const IID IID_IRemoteComputer                  = {0xFE140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IRemoteDebugApplication          = {0x303C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IRemoteDebugApplicationEvents    = {0x333C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IRemoteDebugApplicationEx        = {0x013C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IRemoteDebugApplicationThread    = {0x373C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_IRemoteDebugApplicationThreadEx  = {0x0C2BB3B9, 0x4791, 0xD111, [0x94, 0xEA, 0x00, 0xC0, 0x4F, 0xA3, 0x02, 0xA1]};
    const IID IID_IRemoteDelaydC                   = {0xA0404539, 0xCF6F, 0xD011, [0xAC, 0xE0, 0x00, 0x00, 0xF8, 0x01, 0x14, 0xD3]};
    const IID IID_IRemoteESP                       = {0xAB049AE9, 0x95AB, 0xD011, [0xBE, 0x96, 0x00, 0xA0, 0xC9, 0x49, 0x89, 0xDE]};
    const IID IID_IRemoteFinder                    = {0x32D54A94, 0x9DB0, 0xCE11, [0xB5, 0x9C, 0x00, 0xAA, 0x00, 0x6C, 0xB3, 0x7D]};
    const IID IID_IRemoteStats                     = {0x31D54A94, 0x9DB0, 0xCE11, [0xB5, 0x9C, 0x00, 0xAA, 0x00, 0x6C, 0xB3, 0x7D]};
    const IID IID_IRequest                         = {0xA796C06B, 0xE60C, 0xD111, [0xBA, 0xAE, 0x00, 0xC0, 0x4F, 0xC2, 0xE2, 0x0D]};
    const IID IID_IRequestHandler                  = {0xAA96C06B, 0xE60C, 0xD111, [0xBA, 0xAE, 0x00, 0xC0, 0x4F, 0xC2, 0xE2, 0x0D]};
    const IID IID_IRequestSource                   = {0xA996C06B, 0xE60C, 0xD111, [0xBA, 0xAE, 0x00, 0xC0, 0x4F, 0xC2, 0xE2, 0x0D]};
    const IID IID_IRequestState                    = {0xBA96C06B, 0xE60C, 0xD111, [0xBA, 0xAE, 0x00, 0xC0, 0x4F, 0xC2, 0xE2, 0x0D]};
    const IID IID_IResolveShellLink                = {0x8329D55C, 0x4994, 0xD211, [0x96, 0x3A, 0x00, 0xC0, 0x4F, 0x79, 0xAD, 0xF0]};
    const IID IID_IRichEditOle                     = {0x000D0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IRichEditOleCallback             = {0x030D0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IRootStorage                     = {0x12000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IROTData                         = {0xC06B9FF2, 0x2150, 0xCE11, [0xAA, 0x15, 0x00, 0x00, 0x69, 0x01, 0x29, 0x3F]};
    const IID IID_IRow                             = {0xB43A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowChange                       = {0xB53A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowInfo                         = {0xC13A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowPosition                     = {0x943A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowPositionChange               = {0x71A59709, 0x6E12, 0xD011, [0x9F, 0x8A, 0x00, 0xA0, 0xC9, 0xA0, 0x63, 0x1E]};
    const IID IID_IRowSchemaChange                 = {0xAE3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowset                          = {0x7C3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetAsynch                    = {0x0F3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetBookmark                  = {0xC23A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetChange                    = {0x053A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetChapterMember             = {0xA83A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetCopyRows                  = {0x6B3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetCurrentIndex              = {0xBD3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetExactScroll               = {0x7F3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetFind                      = {0x9D3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetIdentity                  = {0x093A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetIndex                     = {0x823A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetInfo                      = {0x553A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetKeys                      = {0x123A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetLocate                    = {0x7D3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetNewRowAfter               = {0x713A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetNextRowset                = {0x723A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetNotify                    = {0x833A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetQueryStatus               = {0xED77ACA7, 0xD7F8, 0xCE11, [0xA7, 0x98, 0x00, 0x20, 0xF8, 0x00, 0x80, 0x24]};
    const IID IID_IRowsetRefresh                   = {0xA93A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetResynch                   = {0x843A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetScroll                    = {0x7E3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetUpdate                    = {0x6D3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetView                      = {0x993A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetWatchAll                  = {0x733A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetWatchNotify               = {0x443A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetWatchRegion               = {0x453A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRowsetWithParameters            = {0x6E3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IRpcChannel                      = {0x04000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IRpcChannelBuffer                = {0x606BF5D5, 0x3B59, 0x1A10, [0xB5, 0x69, 0x08, 0x00, 0x2B, 0x2D, 0xBF, 0x7A]};
    const IID IID_IRpcChannelBuffer2               = {0xD0314F59, 0x197F, 0xD011, [0xB1, 0x94, 0x00, 0xA0, 0xC9, 0x0D, 0xC8, 0xBF]};
    const IID IID_IRpcChannelBuffer3               = {0x0056B125, 0x1501, 0xD011, [0xBF, 0x0D, 0x00, 0xAA, 0x00, 0xB8, 0xDF, 0xD2]};
    const IID IID_IRpcHelper                       = {0x49010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IRpcOptions                      = {0x44010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IRpcProxy                        = {0x07000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IRpcProxyBuffer                  = {0x346AF5D5, 0x3B59, 0x1A10, [0xB5, 0x69, 0x08, 0x00, 0x2B, 0x2D, 0xBF, 0x7A]};
    const IID IID_IRpcStub                         = {0x05000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IRpcStubBuffer                   = {0xFC6AF5D5, 0x3B59, 0x1A10, [0xB5, 0x69, 0x08, 0x00, 0x2B, 0x2D, 0xBF, 0x7A]};
    const IID IID_IRpcSyntaxNegotiate              = {0x1985A058, 0xC824, 0x3549, [0xB4, 0x82, 0x3F, 0xD8, 0x23, 0x33, 0x3A, 0x4F]};
    const IID IID_IRTC                             = {0x40EA1148, 0x82B5, 0xCE11, [0xB5, 0xAF, 0x00, 0xAA, 0x00, 0x6C, 0xB3, 0x7D]};
    const IID IID_IRTCBuddy                        = {0xC836B1FC, 0x907B, 0x0C4E, [0xBE, 0xFE, 0x56, 0xED, 0xF0, 0xBA, 0x6F, 0x1C]};
    const IID IID_IRTCBuddyEvent                   = {0x5D756DF3, 0xE617, 0x4E40, [0x95, 0x4F, 0x0F, 0xC0, 0x75, 0x74, 0xC7, 0x8D]};
    const IID IID_IRTCClient                       = {0x459E8207, 0x349A, 0x8E40, [0xA0, 0x11, 0xBD, 0xDF, 0x13, 0x48, 0x7C, 0xD1]};
    const IID IID_IRTCClientEvent                  = {0x7A3B492B, 0xBA3C, 0x7041, [0x9C, 0x8B, 0x76, 0xA9, 0xDA, 0xCD, 0xD6, 0x44]};
    const IID IID_IRTCClientPresence               = {0xCCCBC311, 0x4407, 0xD142, [0x96, 0x8A, 0x51, 0xAA, 0x1B, 0xB2, 0x74, 0xC6]};
    const IID IID_IRTCClientProvisioning           = {0x06CFF5B9, 0xB965, 0x804A, [0xA0, 0xE6, 0x73, 0xCA, 0xE3, 0xEF, 0x38, 0x22]};
    const IID IID_IRTCCollection                   = {0x96807CEC, 0x18B9, 0x4440, [0x94, 0xF1, 0xE4, 0xFB, 0xA0, 0x36, 0x1D, 0x5C]};
    const IID IID_IRTCEnumBuddies                  = {0x176929F7, 0x6955, 0x3B4B, [0xB3, 0xAF, 0x98, 0xD1, 0x14, 0x4B, 0x2B, 0x87]};
    const IID IID_IRTCEnumParticipants             = {0x296FD5FC, 0x4F4A, 0xB241, [0xBA, 0x5C, 0xF5, 0xBC, 0xCC, 0x06, 0x0B, 0xF6]};
    const IID IID_IRTCEnumProfiles                 = {0x1CC4B729, 0x82ED, 0xCA4B, [0x84, 0xAD, 0x39, 0xD5, 0x10, 0x1B, 0x58, 0xE3]};
    const IID IID_IRTCEnumWatchers                 = {0xD7557DA8, 0x74DB, 0xD14E, [0x9C, 0xA4, 0x77, 0xA0, 0xE4, 0x1B, 0x41, 0x3E]};
    const IID IID_IRTCEventNotification            = {0xC724FA13, 0x4857, 0x214B, [0x91, 0xF5, 0x73, 0x97, 0x60, 0x9C, 0xE7, 0x47]};
    const IID IID_IRTCIntensityEvent               = {0x51BF234C, 0x0C39, 0x9249, [0xA4, 0x1D, 0x41, 0xEE, 0xC0, 0x5B, 0x2A, 0x4B]};
    const IID IID_IRTCMediaEvent                   = {0xFB449909, 0xDABC, 0x3E45, [0x8C, 0x41, 0xE1, 0x3D, 0xA2, 0xAD, 0xF7, 0xF3]};
    const IID IID_IRTCMessagingEvent               = {0x419560D3, 0x291B, 0xE54D, [0xA4, 0xAD, 0x5A, 0xEB, 0xAF, 0x31, 0x95, 0x12]};
    const IID IID_IRTCParticipant                  = {0xD5AD86AE, 0xB126, 0x1444, [0xAF, 0x1D, 0xB9, 0x4C, 0xD9, 0x38, 0xD7, 0x39]};
    const IID IID_IRTCParticipantStateChangeEvent  = {0x97B5BC09, 0xFAF0, 0xF948, [0xB4, 0x20, 0x46, 0x8C, 0xEA, 0x7F, 0xDE, 0x04]};
    const IID IID_IRTCPresenceContact              = {0x2CF9228B, 0x90CD, 0xDB42, [0xA7, 0x33, 0x21, 0x22, 0x05, 0xC3, 0xE3, 0xDF]};
    const IID IID_IRTCProfile                      = {0x9ECA7ED0, 0x6240, 0xD44D, [0x9E, 0x7D, 0x72, 0x2A, 0x49, 0xBA, 0x73, 0x03]};
    const IID IID_IRTCProfileEvent                 = {0x3BABD5D6, 0x0E77, 0xE843, [0x80, 0x0A, 0x79, 0xB0, 0x62, 0x39, 0x5F, 0xCA]};
    const IID IID_IRTCRegistrationStateChangeEvent = {0x1B99D062, 0xAB50, 0x024F, [0xB9, 0x48, 0xCA, 0x94, 0xF2, 0x6F, 0x8F, 0x95]};
    const IID IID_IRTCSession                      = {0x86807C38, 0xBE99, 0xFB42, [0x99, 0x73, 0x7C, 0x0F, 0xC0, 0xCA, 0x9F, 0xA8]};
    const IID IID_IRTCSessionOperationCompleteEven = {0xC0F4BFA6, 0xC8F7, 0x3C4D, [0x9A, 0x41, 0x35, 0x50, 0xF7, 0x8A, 0x95, 0xB0]};
    const IID IID_IRTCSessionStateChangeEvent      = {0x03D7BAB5, 0x5259, 0xB348, [0x93, 0x21, 0x7F, 0x45, 0x00, 0x52, 0x15, 0x06]};
    const IID IID_IRTCWatcher                      = {0xD8DACEC7, 0x6B34, 0x1B4D, [0xAC, 0x02, 0xA2, 0x08, 0x8D, 0xF9, 0xBE, 0x4F]};
    const IID IID_IRTCWatcherEvent                 = {0x61720DF3, 0x7A58, 0x4F42, [0x82, 0x2C, 0x31, 0x27, 0x88, 0xF4, 0x35, 0x48]};
    const IID IID_IRunnableObject                  = {0x26010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IRunnableTask                    = {0x008D7885, 0x0768, 0xD011, [0xB8, 0x10, 0x00, 0xC0, 0x4F, 0xD7, 0x06, 0xEC]};
    const IID IID_IRunningObjectTable              = {0x10000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IScheduleGroup                   = {0xA6E433C7, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID IID_IScopedOperations                = {0xB03A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IScriptEntry                     = {0x952AEE0A, 0xBBBC, 0xD011, [0x8C, 0x72, 0x00, 0xC0, 0x4F, 0xC2, 0xB0, 0x85]};
    const IID IID_IScriptErrorList                 = {0x240F47F3, 0xFD15, 0xD211, [0xBB, 0x2E, 0x00, 0x80, 0x5F, 0xF7, 0xEF, 0xCA]};
    const IID IID_IScriptNode                      = {0x942AEE0A, 0xBBBC, 0xD011, [0x8C, 0x72, 0x00, 0xC0, 0x4F, 0xC2, 0xB0, 0x85]};
    const IID IID_IScriptScriptlet                 = {0x962AEE0A, 0xBBBC, 0xD011, [0x8C, 0x72, 0x00, 0xC0, 0x4F, 0xC2, 0xB0, 0x85]};
    const IID IID_IScrollBar                       = {0x89F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ISdo                             = {0xDE53BC56, 0xDB96, 0xD111, [0xBF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]};
    const IID IID_ISdoCollection                   = {0xE253BC56, 0xDB96, 0xD111, [0xBF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]};
    const IID IID_ISdoDictionaryOld                = {0xF4E532D4, 0xD853, 0xD211, [0x9A, 0x3A, 0x00, 0xC0, 0x4F, 0xB9, 0x98, 0xAC]};
    const IID IID_ISdoMachine                      = {0x756E9F47, 0xA249, 0xD211, [0x8E, 0xCA, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x19]};
    const IID IID_ISdoServiceControl               = {0x746E9F47, 0xA249, 0xD211, [0x8E, 0xCA, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x19]};
    const IID IID_ISearch                          = {0xA43992BA, 0xD53D, 0xD211, [0xBF, 0x8B, 0x00, 0xC0, 0x4F, 0xB9, 0x36, 0x61]};
    const IID IID_ISearchAssistantOC               = {0x8F3E4272, 0x1180, 0xD211, [0xBE, 0x79, 0x00, 0xA0, 0xC9, 0xA8, 0x3D, 0xA1]};
    const IID IID_ISearchAssistantOC2              = {0x8F3E4272, 0x1180, 0xD211, [0xBE, 0x79, 0x00, 0xA0, 0xC9, 0xA8, 0x3D, 0xA2]};
    const IID IID_ISearchAssistantOC3              = {0x8F3E4272, 0x1180, 0xD211, [0xBE, 0x79, 0x00, 0xA0, 0xC9, 0xA8, 0x3D, 0xA3]};
    const IID IID_ISearchCommandExt                = {0x50FD2E1D, 0xCE75, 0xD111, [0xB7, 0x5A, 0x00, 0xA0, 0xC9, 0x05, 0x64, 0xFE]};
    const IID IID_ISearchContext                   = {0xA256F609, 0xAF41, 0x0C48, [0x88, 0xF7, 0x16, 0xCC, 0x0D, 0x16, 0x46, 0x15]};
    const IID IID_ISearches                        = {0xA222C947, 0xD53D, 0xD211, [0xBF, 0x8B, 0x00, 0xC0, 0x4F, 0xB9, 0x36, 0x61]};
    const IID IID_ISearchQueryHits                 = {0xE0E78CED, 0x6C10, 0xCE11, [0x84, 0xE2, 0x00, 0xAA, 0x00, 0x4B, 0x99, 0x86]};
    const IID IID_ISecondaryControlChannel         = {0x109D3FA2, 0x4C71, 0xFE41, [0x84, 0x71, 0xFF, 0xB1, 0x9B, 0xC2, 0x84, 0x54]};
    const IID IID_ISecureUrlHost                   = {0xC48419C8, 0xC874, 0xD211, [0xBA, 0xA9, 0x00, 0xC0, 0x4F, 0xC2, 0x04, 0x0E]};
    const IID IID_ISecurityInfo                    = {0xA43A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ISegment                         = {0x83F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ISegmentList                     = {0x05F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ISegmentListIterator             = {0x92F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ISelectionObject2                = {0xFCF75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ISelectionServices               = {0x84F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ISelectionServicesListener       = {0x99F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ISensLogon                       = {0xB3BA97D5, 0x9F5B, 0xD111, [0x8D, 0xD2, 0x00, 0xAA, 0x00, 0x4A, 0xBD, 0x5E]};
    const IID IID_ISensLogon2                      = {0xB4BA97D5, 0x9F5B, 0xD111, [0x8D, 0xD2, 0x00, 0xAA, 0x00, 0x4A, 0xBD, 0x5E]};
    const IID IID_ISensNetwork                     = {0xB1BA97D5, 0x9F5B, 0xD111, [0x8D, 0xD2, 0x00, 0xAA, 0x00, 0x4A, 0xBD, 0x5E]};
    const IID IID_ISensOnNow                       = {0xB2BA97D5, 0x9F5B, 0xD111, [0x8D, 0xD2, 0x00, 0xAA, 0x00, 0x4A, 0xBD, 0x5E]};
    const IID IID_ISequenceNumber                  = {0xC1F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ISequentialStream                = {0x303A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IServerSecurity                  = {0x3E010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IServiceProvider                 = {0xC140516D, 0x3674, 0xCE11, [0x80, 0x34, 0x00, 0xAA, 0x00, 0x60, 0x09, 0xFA]};
    const IID IID_ISessionProperties               = {0x853A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ISetNextStatement                = {0x033C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_ISharedAccessBeacon              = {0x6BCFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_ISharedAccessBeaconFinder        = {0x67CFEDFA, 0xFE31, 0xD111, [0xAA, 0xD2, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_IShellApp                        = {0x6049E1A3, 0x5F93, 0xD111, [0xB8, 0xB8, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82]};
    const IID IID_IShellBrowser                    = {0xE2140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellChangeNotify               = {0xB1E22BD8, 0x6457, 0xD011, [0xA9, 0x6E, 0x00, 0xC0, 0x4F, 0xD7, 0x05, 0xA2]};
    const IID IID_IShellCopyHookA                  = {0xEF140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellCopyHookW                  = {0xFC140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellDetails                    = {0xEC140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellDetails3                   = {0xC005A1D2, 0xD587, 0xD111, [0x83, 0x91, 0x00, 0x00, 0xF8, 0x04, 0x61, 0xCF]};
    const IID IID_IShellDispatch                   = {0xC015F0D8, 0x78C2, 0xCE11, [0xA4, 0x9E, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IShellDispatch2                  = {0x2C89C6A4, 0xA93B, 0xD211, [0x9D, 0xEA, 0x00, 0xC0, 0x4F, 0xB1, 0x61, 0x62]};
    const IID IID_IShellDispatch3                  = {0xCA607117, 0x5ABB, 0x1C41, [0x84, 0x1D, 0xBD, 0x38, 0xFA, 0xCD, 0xEA, 0xA0]};
    const IID IID_IShellDispatch4                  = {0x2D4BD8EF, 0xCF4B, 0x9842, [0xBE, 0x25, 0xEB, 0x54, 0x2A, 0x59, 0xFB, 0xDA]};
    const IID IID_IShellExecuteHookA               = {0xF5140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellExecuteHookW               = {0xFB140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellExtInit                    = {0xE8140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellFavoritesNameSpace         = {0x04681355, 0xDEB2, 0xD111, [0xB9, 0xF2, 0x00, 0xA0, 0xC9, 0x8B, 0xC5, 0x47]};
    const IID IID_IShellFolder                     = {0xE6140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellFolder2                    = {0x8CF6F293, 0x1B1D, 0xD311, [0xA3, 0x0E, 0x00, 0xC0, 0x4F, 0x79, 0xAB, 0xD1]};
    const IID IID_IShellFolderViewCB               = {0x20E34720, 0xA9F2, 0xCE11, [0xAE, 0x65, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62]};
    const IID IID_IShellFolderViewDual             = {0x80AFA1E7, 0x964D, 0xCF11, [0x96, 0x0C, 0x00, 0x80, 0xC7, 0xF4, 0xEE, 0x85]};
    const IID IID_IShellFolderViewDual2            = {0xB647C131, 0xDE0A, 0x3C4A, [0xB5, 0x14, 0xDD, 0xF9, 0x32, 0xEF, 0x6D, 0x17]};
    const IID IID_IShellIcon                       = {0xE5140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellIconOverlay                = {0x708A687D, 0x13C6, 0xD011, [0x99, 0x9B, 0x00, 0xC0, 0x4F, 0xD6, 0x55, 0xE1]};
    const IID IID_IShellIconOverlayIdentifier      = {0x00426C0C, 0x89C5, 0xD011, [0x99, 0x9A, 0x00, 0xC0, 0x4F, 0xD6, 0x55, 0xE1]};
    const IID IID_IShellImageData                  = {0x12ECDEBF, 0x4080, 0x0344, [0xA5, 0xEA, 0x9E, 0x07, 0xDA, 0xFC, 0xF5, 0x30]};
    const IID IID_IShellImageDataAbort             = {0x588EFB53, 0xC050, 0x0340, [0xB4, 0xAA, 0x0C, 0x8D, 0xF2, 0x8E, 0x7F, 0x3A]};
    const IID IID_IShellImageDataFactory           = {0x5CEDE89B, 0xABED, 0x754D, [0x90, 0xF3, 0xBD, 0x5B, 0xDB, 0xB2, 0x1C, 0x82]};
    const IID IID_IShellLinkA                      = {0xEE140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellLinkDataList               = {0xAEB4E245, 0xC3B1, 0xD011, [0xB9, 0x2F, 0x00, 0xA0, 0xC9, 0x03, 0x12, 0xE1]};
    const IID IID_IShellLinkDual                   = {0x005CA088, 0x00F0, 0xCE11, [0x83, 0x50, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00]};
    const IID IID_IShellLinkDual2                  = {0x49E27E31, 0x2EF1, 0xD211, [0xB1, 0xE4, 0x00, 0xC0, 0x4F, 0x8E, 0xEB, 0x3E]};
    const IID IID_IShellLinkW                      = {0xF9140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellNameSpace                  = {0xC9D372E5, 0xBE37, 0xE24A, [0x82, 0x5D, 0xD5, 0x21, 0x76, 0x3E, 0x31, 0x08]};
    const IID IID_IShellPropSheetExt               = {0xE9140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellUIHelper                   = {0xF8E29F72, 0xA81E, 0xD111, [0x8F, 0x85, 0x00, 0xC0, 0x4F, 0xC2, 0xFB, 0xE1]};
    const IID IID_IShellView                       = {0xE3140200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IShellView2                      = {0x809EE388, 0x7835, 0xCF11, [0xAE, 0x69, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62]};
    const IID IID_IShellWindows                    = {0x0069CB85, 0x954D, 0xCF11, [0x96, 0x0C, 0x00, 0x80, 0xC7, 0xF4, 0xEE, 0x85]};
    const IID IID_ISimpleCommandCreator            = {0xB71A345E, 0xD002, 0xD111, [0x90, 0x0C, 0x00, 0xA0, 0xC9, 0x06, 0x37, 0x96]};
    const IID IID_ISimpleConnectionPoint           = {0x3E3C9751, 0x0CCB, 0xD011, [0xB5, 0xC9, 0x00, 0xA0, 0x24, 0x4A, 0x0E, 0x7A]};
    const IID IID_ISimpleFrameSite                 = {0x010E2B74, 0xE614, 0x1B10, [0x91, 0x4E, 0x00, 0xAA, 0x00, 0x30, 0x0C, 0xAB]};
    const IID IID_ISliderBar                       = {0x8DF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ISniffStream                     = {0x4079F14E, 0xE030, 0xD011, [0xB7, 0x24, 0x00, 0xAA, 0x00, 0x6C, 0x1A, 0x01]};
    const IID IID_ISOAPRequest                     = {0x254519AD, 0x016E, 0xCA4B, [0x92, 0x9C, 0x23, 0xC7, 0x38, 0x33, 0x36, 0xAF]};
    const IID IID_ISoftDistExt                     = {0xC18D5BB1, 0xE1C7, 0xD011, [0x86, 0x80, 0x00, 0xAA, 0x00, 0xBD, 0xCB, 0x71]};
    const IID IID_ISourcesRowset                   = {0x1E3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ISpecialSystemProperties         = {0xB9010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ISpecifyPropertyPages            = {0x8BB296B1, 0xB4BA, 0x1A10, [0xB6, 0x9C, 0x00, 0xAA, 0x00, 0x34, 0x1D, 0x07]};
    const IID IID_ISpinButton                      = {0x8BF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ISQLErrorInfo                    = {0x743A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IStandardActivator               = {0xB8010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IStandardInfo                    = {0xA5C1D9F1, 0x8995, 0xDD40, [0xB6, 0x3D, 0x9B, 0xB0, 0xB3, 0x8A, 0x10, 0x22]};
    const IID IID_IStaticPortMapping               = {0x1F71106F, 0x9B72, 0xE541, [0x93, 0xB8, 0xF2, 0x1D, 0x0F, 0x81, 0x8D, 0xF1]};
    const IID IID_IStaticPortMappingCollection     = {0x773E1FCD, 0xD666, 0x6446, [0x82, 0xC7, 0x36, 0xDB, 0xB6, 0x41, 0xD0, 0xF1]};
    const IID IID_IStats                           = {0x30D54A94, 0x9DB0, 0xCE11, [0xB5, 0x9C, 0x00, 0xAA, 0x00, 0x6C, 0xB3, 0x7D]};
    const IID IID_IStdMarshalInfo                  = {0x18000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IStemmer                         = {0x40F1BAEF, 0x427F, 0xCE11, [0xBE, 0x57, 0x00, 0xAA, 0x00, 0x51, 0xFE, 0x20]};
    const IID IID_IStemSink                        = {0x30C377FE, 0x427F, 0xCE11, [0xBE, 0x57, 0x00, 0xAA, 0x00, 0x51, 0xFE, 0x20]};
    const IID IID_IStorage                         = {0x0B000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IStream                          = {0x0C000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IStub                            = {0x26000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IStubManager                     = {0x06000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ISubDivisionProvider             = {0xD2F45030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ISubscriptionAgentControl        = {0xF08F9EA8, 0xF470, 0xD111, [0xBC, 0x7F, 0x00, 0xC0, 0x4F, 0xD9, 0x29, 0xDB]};
    const IID IID_ISubscriptionAgentEvents         = {0xF18F9EA8, 0xF470, 0xD111, [0xBC, 0x7F, 0x00, 0xC0, 0x4F, 0xD9, 0x29, 0xDB]};
    const IID IID_ISubscriptionAgentShellExt       = {0xBA84B181, 0x02B3, 0xD111, [0x85, 0x52, 0x00, 0xC0, 0x4F, 0xA3, 0x5C, 0x89]};
    const IID IID_ISubscriptionItem                = {0xF85975A9, 0x4A6C, 0xD111, [0xA1, 0xE8, 0x00, 0xC0, 0x4F, 0xC2, 0xFB, 0xE1]};
    const IID IID_ISubscriptionMgr                 = {0xC0B25F08, 0xF80D, 0xD111, [0x8F, 0x4B, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x3F]};
    const IID IID_ISubscriptionMgr2                = {0x70C24B61, 0xDFAE, 0xD111, [0xA1, 0xF9, 0x00, 0xC0, 0x4F, 0xC2, 0xFB, 0xE1]};
    const IID IID_ISubscriptionMgrPriv             = {0x9E396BD6, 0x1DAF, 0xD111, [0xA1, 0xF9, 0x00, 0xC0, 0x4F, 0xC2, 0xFB, 0xE1]};
    const IID IID_ISubscriptionThrottler           = {0xE4009B1E, 0x4698, 0xD111, [0xA1, 0xEE, 0x00, 0xC0, 0x4F, 0xC2, 0xFB, 0xE1]};
    const IID IID_ISupportErrorInfo                = {0x603D0BDF, 0x8F54, 0x1B10, [0x8E, 0x65, 0x08, 0x00, 0x2B, 0x2B, 0xD1, 0x19]};
    const IID IID_ISurrogate                       = {0x22000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ISWbemDateTime                   = {0x8A45975E, 0x77CF, 0xD311, [0xB3, 0x8F, 0x00, 0x10, 0x5A, 0x1F, 0x47, 0x3A]};
    const IID IID_ISWbemEventSource                = {0x924DD527, 0xBE0E, 0xD211, [0x8B, 0x22, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemLastError                  = {0x84DB62D9, 0xBBD4, 0xD111, [0x8B, 0x09, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemLocator                    = {0x5B41A676, 0x41CB, 0xD111, [0x8B, 0x02, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemMethod                     = {0x908E2E42, 0x55D9, 0xD111, [0x8B, 0x09, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemMethodSet                  = {0x92A23BC9, 0x55D9, 0xD111, [0x8B, 0x09, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemNamedValue                 = {0x6441A676, 0x41CB, 0xD111, [0x8B, 0x02, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemNamedValueSet              = {0xEA7623CF, 0x8CCE, 0xD111, [0x8B, 0x05, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemObject                     = {0x5A41A676, 0x41CB, 0xD111, [0x8B, 0x02, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemObjectEx                   = {0x6AD59A26, 0x678A, 0x2941, [0xBC, 0x8C, 0x05, 0x06, 0xDC, 0xFE, 0x98, 0x80]};
    const IID IID_ISWbemObjectPath                 = {0x27BC9157, 0x9CCE, 0xD111, [0x97, 0xBF, 0x00, 0x00, 0xF8, 0x1E, 0x84, 0x9C]};
    const IID IID_ISWbemObjectSet                  = {0x5F41A676, 0x41CB, 0xD111, [0x8B, 0x02, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemPrivilege                  = {0xBD67EE26, 0x0458, 0xD211, [0x8B, 0x4A, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemPrivilegeSet               = {0xBF67EE26, 0x0458, 0xD211, [0x8B, 0x4A, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemProperty                   = {0x988F381A, 0xBAD4, 0xD111, [0x8B, 0x09, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemPropertySet                = {0xB2A7A0DE, 0xBAD4, 0xD111, [0x8B, 0x09, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemQualifier                  = {0x3259B079, 0xB7D3, 0xD111, [0x8B, 0x06, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemQualifierSet               = {0x16ED169B, 0xDFD3, 0xD111, [0x8B, 0x08, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemRefreshableItem            = {0x92BFD45A, 0xABDA, 0xD311, [0xB3, 0x8F, 0x00, 0x10, 0x5A, 0x1F, 0x47, 0x3A]};
    const IID IID_ISWbemRefresher                  = {0x0E25D814, 0xC2D9, 0xD311, [0xB3, 0x8F, 0x00, 0x10, 0x5A, 0x1F, 0x47, 0x3A]};
    const IID IID_ISWbemSecurity                   = {0xE6664DB5, 0x8722, 0xD211, [0x8B, 0x33, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemServices                   = {0x5C41A676, 0x41CB, 0xD111, [0x8B, 0x02, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID IID_ISWbemServicesEx                 = {0x4384F6D2, 0xDC85, 0x7E42, [0x91, 0xD8, 0x36, 0x65, 0x54, 0xCC, 0x75, 0x4C]};
    const IID IID_ISWbemSink                       = {0x9F8C7175, 0x29F0, 0xD111, [0xA1, 0xAC, 0x00, 0xC0, 0x4F, 0xB6, 0xC2, 0x23]};
    const IID IID_ISynchronize                     = {0x30000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ISynchronizeContainer            = {0x33000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ISynchronizedCallBack            = {0x4160C274, 0xD170, 0xD111, [0xB7, 0x5A, 0x00, 0xA0, 0xC9, 0x05, 0x64, 0xFE]};
    const IID IID_ISynchronizeEvent                = {0x32000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ISynchronizeHandle               = {0x31000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ISynchronizeMutex                = {0x25000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ISyncMgrEnumItems                = {0x2ADF9562, 0xEE35, 0xD111, [0x87, 0x07, 0x00, 0xC0, 0x4F, 0xD9, 0x33, 0x27]};
    const IID IID_ISyncMgrRegisterCSC              = {0x611A6847, 0x74BC, 0xD211, [0xB5, 0xC5, 0x00, 0xC0, 0x4F, 0xB9, 0x39, 0x81]};
    const IID IID_ISyncMgrSynchronizeInvoke        = {0x2CDF9562, 0xEE35, 0xD111, [0x87, 0x07, 0x00, 0xC0, 0x4F, 0xD9, 0x33, 0x27]};
    const IID IID_ISyncSchedule                    = {0x9958E1F0, 0x00A7, 0xD111, [0x98, 0x31, 0x00, 0xC0, 0x4F, 0xD9, 0x10, 0xDD]};
    const IID IID_ISyncScheduleMgr                 = {0x9758E1F0, 0x00A7, 0xD111, [0x98, 0x31, 0x00, 0xC0, 0x4F, 0xD9, 0x10, 0xDD]};
    const IID IID_ISyncSchedulep                   = {0x9B58E1F0, 0x00A7, 0xD111, [0x98, 0x31, 0x00, 0xC0, 0x4F, 0xD9, 0x10, 0xDD]};
    const IID IID_ITableCreation                   = {0xBC3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ITableDefinition                 = {0x863A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ITableDefinitionWithConstraints  = {0xAB3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ITableRename                     = {0x773A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ITACDGroup                       = {0x4831FC5A, 0xCC4B, 0xD111, [0xBF, 0x80, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITACDGroupEvent                  = {0x32307F29, 0x11BD, 0xD111, [0xA0, 0xA7, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITAddress                        = {0x86C3EFB1, 0x5593, 0xD011, [0x83, 0x5C, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_ITAddress2                       = {0x9B5DAEB0, 0x51BE, 0xC946, [0xB0, 0xF7, 0xDF, 0xA8, 0xA2, 0x2A, 0x8B, 0xC4]};
    const IID IID_ITAddressCapabilities            = {0xF532F28D, 0x1B82, 0xD111, [0xBB, 0x5C, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITAddressDeviceSpecificEvent     = {0x6B21CB3A, 0xBD40, 0x7A48, [0x86, 0x72, 0x5C, 0xE7, 0x7B, 0xD7, 0xE3, 0xA3]};
    const IID IID_ITAddressEvent                   = {0xD1E21C83, 0xB583, 0xD111, [0xBB, 0x5C, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITAddressTranslation             = {0x038F4D0C, 0xDB8D, 0xD111, [0xA0, 0x9E, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITAddressTranslationInfo         = {0x4559C1AF, 0x408D, 0xD111, [0xA0, 0x9E, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITAgent                          = {0xE5EC7057, 0x274B, 0xD111, [0xBF, 0x80, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITAgentEvent                     = {0x4A31FC5A, 0xCC4B, 0xD111, [0xBF, 0x80, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITAgentHandler                   = {0x228C7E58, 0x0298, 0xD111, [0xA0, 0xA4, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITAgentHandlerEvent              = {0x34307F29, 0x11BD, 0xD111, [0xA0, 0xA7, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITAgentSession                   = {0x4731FC5A, 0xCC4B, 0xD111, [0xBF, 0x80, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITAgentSessionEvent              = {0x4B31FC5A, 0xCC4B, 0xD111, [0xBF, 0x80, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITAllocatorProperties            = {0x903CBCC1, 0xFEBC, 0xD111, [0x97, 0x45, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_ITAMMediaFormat                  = {0x00EB6403, 0x774A, 0xD111, [0xA6, 0x71, 0x00, 0x60, 0x97, 0xC9, 0xA2, 0xE8]};
    const IID IID_ITargetContainer                 = {0x01EC4778, 0xEC2B, 0xD011, [0x82, 0xB4, 0x00, 0xA0, 0xC9, 0x0C, 0x29, 0xC5]};
    const IID IID_ITargetEmbedding                 = {0xC0938754, 0x749E, 0xCF11, [0x96, 0x55, 0x00, 0xA0, 0xC9, 0x03, 0x49, 0x23]};
    const IID IID_ITargetFrame                     = {0x808CF7D5, 0x5252, 0xCF11, [0x90, 0xFA, 0x00, 0xAA, 0x00, 0x42, 0x10, 0x6E]};
    const IID IID_ITargetFrame2                    = {0x112ED586, 0xA894, 0xD011, [0x82, 0xAF, 0x00, 0xC0, 0x4F, 0xD5, 0xAE, 0x38]};
    const IID IID_ITargetFramePriv                 = {0x21E41692, 0xF52B, 0xD011, [0x82, 0xB4, 0x00, 0xA0, 0xC9, 0x0C, 0x29, 0xC5]};
    const IID IID_ITargetNotify                    = {0xA0993A86, 0xBC21, 0xD011, [0x82, 0xB4, 0x00, 0xA0, 0xC9, 0x0C, 0x29, 0xC5]};
    const IID IID_ITargetNotify2                   = {0xB1F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ITaskAnalyzeCluster              = {0xA1375779, 0x3AE1, 0xEB45, [0x8D, 0xFD, 0x81, 0x85, 0xC4, 0xB7, 0xAD, 0x4E]};
    const IID IID_ITaskbarList                     = {0x42F3FD56, 0x6DFD, 0xD011, [0x95, 0x8A, 0x00, 0x60, 0x97, 0xC9, 0xA0, 0x90]};
    const IID IID_ITaskbarList2                    = {0x95492D60, 0x3AB1, 0x9B42, [0xA6, 0x6E, 0x19, 0x35, 0xE4, 0x4F, 0x43, 0x17]};
    const IID IID_ITaskCommitClusterChanges        = {0xDE2DF11B, 0xB0F8, 0xB149, [0xA4, 0x58, 0x67, 0x47, 0xDB, 0x78, 0x8A, 0x47]};
    const IID IID_ITaskCompareAndPushInformation   = {0xAFC2F1D4, 0x70B3, 0xDE49, [0x87, 0x68, 0x40, 0x10, 0xB5, 0x68, 0x63, 0x6C]};
    const IID IID_ITaskGatherClusterInfo           = {0x5C9667E1, 0xD6C5, 0x3C49, [0xA3, 0x43, 0x4C, 0x10, 0x5C, 0x01, 0xDD, 0xE7]};
    const IID IID_ITaskGatherInformation           = {0xF8F3AAB9, 0x8E23, 0x9349, [0xBA, 0x31, 0x14, 0x85, 0x98, 0x04, 0xF9, 0x2C]};
    const IID IID_ITaskGatherNodeInfo              = {0x012E9AF1, 0xB32C, 0xB447, [0x8F, 0x5D, 0xB9, 0x77, 0x17, 0x6B, 0x45, 0xC8]};
    const IID IID_ITaskGetDomains                  = {0xCD4ACBDF, 0xDBC4, 0xB44D, [0x8E, 0xBB, 0x1D, 0xD0, 0x7A, 0x9D, 0x5B, 0x82]};
    const IID IID_ITaskGetDomainsCallback          = {0x442E4085, 0x3468, 0xDF41, [0x85, 0x90, 0x01, 0x82, 0x7D, 0x12, 0x4E, 0x1B]};
    const IID IID_ITaskLoginDomain                 = {0x518EAD76, 0xC353, 0x4743, [0x89, 0x5D, 0x6C, 0x30, 0xF4, 0x13, 0x93, 0x74]};
    const IID IID_ITaskLoginDomainCallback         = {0x433CAFEF, 0x8F7A, 0x9B46, [0xB8, 0xBB, 0xC8, 0x0C, 0x57, 0x47, 0xCE, 0x05]};
    const IID IID_ITaskManager                     = {0x94661116, 0xC5DF, 0x0B47, [0xAC, 0x12, 0x46, 0xFB, 0xB0, 0x1C, 0xEF, 0x10]};
    const IID IID_ITaskPollingCallback             = {0x9523E949, 0xAF66, 0xDD4A, [0xA4, 0x1E, 0x43, 0x51, 0x2C, 0xB5, 0x19, 0xB3]};
    const IID IID_ITaskVerifyIPAddress             = {0xB1E1950C, 0xFF0C, 0x4047, [0x8A, 0xBD, 0x69, 0x91, 0x2D, 0x10, 0x5B, 0xD1]};
    const IID IID_ITASRTerminalEvent               = {0x026A01EE, 0xA94F, 0x7C46, [0x93, 0x3F, 0x5A, 0x15, 0xB1, 0x23, 0x77, 0xD7]};
    const IID IID_ITAttributeList                  = {0x82FB3750, 0xE9CA, 0xD011, [0x8D, 0x58, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_ITAudioDeviceControl             = {0xC5B60A6C, 0xE321, 0xD311, [0xA5, 0x77, 0x00, 0xC0, 0x4F, 0x8E, 0xF6, 0xE3]};
    const IID IID_ITAudioSettings                  = {0xC6B60A6C, 0xE321, 0xD311, [0xA5, 0x77, 0x00, 0xC0, 0x4F, 0x8E, 0xF6, 0xE3]};
    const IID IID_ITAutomatedPhoneControl          = {0x0EAFE11E, 0x5961, 0x614A, [0xB7, 0x9B, 0x6A, 0x4B, 0xA3, 0xFC, 0x9D, 0xFC]};
    const IID IID_ITBasicAudioTerminal             = {0x8DC3EFB1, 0x5593, 0xD011, [0x83, 0x5C, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_ITBasicCallControl               = {0x89C3EFB1, 0x5593, 0xD011, [0x83, 0x5C, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_ITBasicCallControl2              = {0x564A1A16, 0x991E, 0x3F4B, [0xA4, 0x6A, 0x16, 0x8F, 0x38, 0xA5, 0xEE, 0x4C]};
    const IID IID_ITCallHub                        = {0x4E54C1A3, 0x925B, 0xD111, [0x8F, 0x4E, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITCallHubEvent                   = {0x5154C1A3, 0x925B, 0xD111, [0x8F, 0x4E, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITCallInfo                       = {0xD1850F35, 0x2712, 0xD311, [0x83, 0xD4, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITCallInfo2                      = {0xA60CD794, 0xB07A, 0xAA4D, [0x81, 0xCA, 0xB8, 0xF8, 0x64, 0x3F, 0xAE, 0xC1]};
    const IID IID_ITCallInfoChangeEvent            = {0xF9654B5D, 0x1CE5, 0xD111, [0xA0, 0x2F, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITCallingCard                    = {0x008F4D0C, 0xDB8D, 0xD111, [0xA0, 0x9E, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITCallMediaEvent                 = {0x7FB836FF, 0x3AEC, 0xD011, [0x8E, 0xE4, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITCallNotificationEvent          = {0xDF015889, 0xD63D, 0xD111, [0x8F, 0x30, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITCallQualityControl             = {0xE08A1DFE, 0xC4ED, 0xB549, [0x8F, 0x8C, 0x4D, 0xE4, 0x0F, 0x9C, 0xDF, 0xAF]};
    const IID IID_ITCallStateEvent                 = {0x9770F462, 0xC995, 0xD011, [0x83, 0x5D, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_ITCollection                     = {0xF2ACC55E, 0x029C, 0xD011, [0x83, 0x62, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_ITCollection2                    = {0xA5DDDDE6, 0xD3A6, 0xFF48, [0x87, 0x37, 0xD3, 0x2F, 0xC4, 0xD9, 0x54, 0x77]};
    const IID IID_ITConferenceBlob                 = {0xAAD759C2, 0xABC8, 0xD011, [0x8D, 0x58, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_ITConnection                     = {0xD481A38F, 0xC2C8, 0xD011, [0x8D, 0x58, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_ITcpipProperties                 = {0x71321398, 0x204B, 0xD111, [0xAB, 0x01, 0x00, 0x80, 0x5F, 0xC1, 0x27, 0x0E]};
    const IID IID_ITCustomTone                     = {0x64D77A35, 0xC6B3, 0x2A4B, [0x8F, 0xA5, 0x07, 0x22, 0x82, 0x7A, 0x92, 0x54]};
    const IID IID_ITDetectTone                     = {0xBD791F96, 0x9730, 0xDF49, [0xA1, 0xD6, 0x90, 0x9B, 0x77, 0xE8, 0x9C, 0xA0]};
    const IID IID_ITDigitDetectionEvent            = {0xACBFD380, 0xD957, 0xD211, [0xA0, 0x4A, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITDigitGenerationEvent           = {0xADBFD380, 0xD957, 0xD211, [0xA0, 0x4A, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITDigitsGatheredEvent            = {0xC1C42EE5, 0xA3CB, 0x1A44, [0x9E, 0x6A, 0x93, 0xCB, 0x90, 0x9E, 0x97, 0x24]};
    const IID IID_ITDirectory                      = {0x6C1D6234, 0xFF6C, 0xD111, [0xAF, 0xF7, 0x00, 0xC0, 0x4F, 0xC3, 0x1F, 0xEE]};
    const IID IID_ITDirectoryObject                = {0x6E1D6234, 0xFF6C, 0xD111, [0xAF, 0xF7, 0x00, 0xC0, 0x4F, 0xC3, 0x1F, 0xEE]};
    const IID IID_ITDirectoryObjectConference      = {0x5D9E02F1, 0x5BCB, 0xD011, [0x8D, 0x59, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_ITDirectoryObjectUser            = {0x6F1D6234, 0xFF6C, 0xD111, [0xAF, 0xF7, 0x00, 0xC0, 0x4F, 0xC3, 0x1F, 0xEE]};
    const IID IID_ITDispatchMapper                 = {0x955222E9, 0x59C7, 0xD111, [0xA0, 0x2B, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITemplatePrinter                 = {0xB4F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ITemplatePrinter2                = {0x3FF85030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ITFileTerminalEvent              = {0xACFBA7E4, 0x178C, 0x2744, [0x9F, 0x55, 0x9F, 0x58, 0x9A, 0xC8, 0xAF, 0x00]};
    const IID IID_ITFileTrack                      = {0xA96ECA31, 0x8AC0, 0xEA4B, [0x88, 0x11, 0x8E, 0x9C, 0x1B, 0xA3, 0xEA, 0x3A]};
    const IID IID_ITfLangBarAddIn                  = {0xC3DAADC9, 0xCB15, 0x5749, [0xB9, 0x3C, 0xDB, 0x08, 0x73, 0xFF, 0x98, 0xBB]};
    const IID IID_ITFormatControl                  = {0xC1B60A6C, 0xE321, 0xD311, [0xA5, 0x77, 0x00, 0xC0, 0x4F, 0x8E, 0xF6, 0xE3]};
    const IID IID_ITForwardInformation             = {0x9E659F44, 0xA388, 0xD111, [0xBB, 0x5D, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITForwardInformation2            = {0xEDB42952, 0x60B2, 0x8243, [0x8E, 0x1A, 0x5D, 0xF3, 0xA8, 0xA4, 0xCC, 0xC0]};
    const IID IID_ITfSpeechUIServer                = {0x44A9E990, 0x4492, 0x9F48, [0xA7, 0x8F, 0xDE, 0x67, 0xAF, 0xC0, 0x13, 0xA7]};
    const IID IID_IThumbnailCapture                = {0x6692A34E, 0x1172, 0x9F40, [0xB6, 0x22, 0xF6, 0x3D, 0xBD, 0x16, 0xC5, 0x33]};
    const IID IID_IThumbnailExtractor              = {0x08C79D96, 0x765C, 0xD111, [0x8D, 0x86, 0x00, 0x00, 0xF8, 0x04, 0xB0, 0x57]};
    const IID IID_ITILSConfig                      = {0x721D6234, 0xFF6C, 0xD111, [0xAF, 0xF7, 0x00, 0xC0, 0x4F, 0xC3, 0x1F, 0xEE]};
    const IID IID_ITIMEActiveElementCollection     = {0x40253E40, 0x2045, 0xD311, [0x93, 0xAB, 0x00, 0xA0, 0xC9, 0x67, 0xA4, 0x38]};
    const IID IID_ITimeAndNoticeControl            = {0xAEF60BBC, 0x7888, 0xD111, [0x83, 0xE9, 0x00, 0xC0, 0x4F, 0xC2, 0xC6, 0xD4]};
    const IID IID_ITIMEAnimationElement            = {0xB1144FA7, 0xA2B6, 0x0A43, [0xA5, 0xE8, 0x1F, 0x4E, 0x53, 0xF7, 0x10, 0xFE]};
    const IID IID_ITIMEAnimationElement2           = {0x6186CE29, 0x43BD, 0x1A42, [0xB6, 0x16, 0xE9, 0xB3, 0x1F, 0x33, 0xA5, 0x72]};
    const IID IID_ITIMEBodyElement                 = {0x48E3908C, 0x0AEC, 0x2942, [0x90, 0xB0, 0xE5, 0x7D, 0x2C, 0xA4, 0x5C, 0xCB]};
    const IID IID_ITIMEDMusicPlayerObject          = {0xF5547940, 0xAB2B, 0xFA4C, [0x95, 0x4D, 0x24, 0x9F, 0x9F, 0xCE, 0x43, 0xA1]};
    const IID IID_ITIMEDVDPlayerObject             = {0x68ABF73A, 0x294F, 0x2C46, [0xAA, 0x6E, 0x58, 0x72, 0x44, 0x88, 0x99, 0xE3]};
    const IID IID_ITIMEElement                     = {0x4EF62E1C, 0x7DF0, 0x3843, [0x97, 0x71, 0x91, 0x54, 0x49, 0x1C, 0xD8, 0xB9]};
    const IID IID_ITIMEElementCollection           = {0x24C2AB50, 0x536D, 0x834F, [0x91, 0x35, 0x24, 0x40, 0xA4, 0x1B, 0x7B, 0xC8]};
    const IID IID_ITIMEFactory                     = {0x46E451CD, 0x0630, 0x4F43, [0x90, 0xE2, 0xE3, 0x7E, 0x8F, 0xB8, 0xCA, 0x8F]};
    const IID IID_ITIMEMediaElement                = {0x2F97A647, 0x65AE, 0x6B4A, [0xAE, 0x63, 0xD0, 0xC1, 0xD5, 0x30, 0x7B, 0x58]};
    const IID IID_ITIMEMediaElement2               = {0x0094E29E, 0xE67E, 0x3A45, [0x85, 0xB3, 0x4E, 0xC2, 0x8E, 0x03, 0x05, 0xB4]};
    const IID IID_ITIMEMediaPlayer                 = {0xBE954AEA, 0xC9AC, 0xF04B, [0x85, 0xA4, 0x1B, 0xF3, 0xC5, 0x1E, 0x43, 0x1C]};
    const IID IID_ITIMEMediaPlayerAudio            = {0xDACFAAFF, 0x74B3, 0x224F, [0xAC, 0x9A, 0xC5, 0xBB, 0x94, 0x37, 0xCB, 0x56]};
    const IID IID_ITIMEMediaPlayerControl          = {0xE7997A89, 0x86F3, 0xC845, [0xB5, 0x1B, 0x3A, 0x25, 0xBB, 0xCB, 0xBA, 0x69]};
    const IID IID_ITIMEMediaPlayerNetwork          = {0xCA7F98B9, 0xBB7F, 0x1540, [0xBD, 0x3D, 0x74, 0x18, 0x60, 0x55, 0x14, 0xDA]};
    const IID IID_ITIMEMediaPlayerSite             = {0xED7105BF, 0x4F34, 0x584F, [0x82, 0xC7, 0x74, 0x31, 0xED, 0x0F, 0xD8, 0x34]};
    const IID IID_ITIMEPlayItem                    = {0xD996602A, 0xE02C, 0xDC47, [0xA8, 0x13, 0x90, 0x99, 0xA2, 0x46, 0x63, 0x09]};
    const IID IID_ITIMEPlayItem2                   = {0x38CD6242, 0xDC6B, 0xA440, [0xBC, 0x50, 0x4C, 0xC5, 0x03, 0x66, 0xE7, 0x02]};
    const IID IID_ITIMEPlayList                    = {0x625BB7E9, 0x97DD, 0x194B, [0x8F, 0xD9, 0x96, 0x46, 0x29, 0x29, 0x52, 0xE0]};
    const IID IID_ITimer                           = {0x60F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ITimerService                    = {0x5FF35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ITimerSink                       = {0x61F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ITIMEState                       = {0x2AC65EDD, 0x779D, 0x7345, [0x80, 0xA8, 0x75, 0x85, 0x94, 0xE6, 0x9C, 0xEA]};
    const IID IID_ITIMETransitionElement           = {0x6FD683F3, 0x685E, 0xC24F, [0xB6, 0x41, 0x03, 0x67, 0x2B, 0x54, 0x3A, 0x49]};
    const IID IID_ITLegacyAddressMediaControl      = {0x403649AB, 0x0B4C, 0xD211, [0xA0, 0x46, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITLegacyAddressMediaControl2     = {0x2B51EEB0, 0x31A5, 0x9E40, [0x9D, 0xD9, 0x40, 0x99, 0xFE, 0x86, 0xC7, 0x38]};
    const IID IID_ITLegacyCallMediaControl         = {0x2F5824D6, 0x23CC, 0x3644, [0xB8, 0xA5, 0x47, 0xC6, 0x25, 0xC8, 0x04, 0x5D]};
    const IID IID_ITLegacyCallMediaControl2        = {0x2D33CA57, 0xC27B, 0xF144, [0xA6, 0x0C, 0x93, 0x6F, 0xE8, 0xD7, 0xCE, 0x73]};
    const IID IID_ITLegacyWaveSupport              = {0xEA237820, 0x52E2, 0xD211, [0xB7, 0x7E, 0x00, 0x80, 0xC7, 0x13, 0x53, 0x81]};
    const IID IID_ITLocalParticipant               = {0x55F0CB39, 0x7AF7, 0xD211, [0xA8, 0x24, 0x00, 0xC0, 0x4F, 0x8E, 0xF6, 0xE3]};
    const IID IID_ITLocationInfo                   = {0xFF8E4D0C, 0xDB8D, 0xD111, [0xA0, 0x9E, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITMedia                          = {0x53F0C10C, 0xEBCA, 0xD011, [0x8D, 0x58, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_ITMediaCollection                = {0xA2168E6A, 0xBC0A, 0xD111, [0x97, 0x6D, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_ITMediaControl                   = {0xE8DD45C4, 0x9951, 0xC74B, [0x98, 0x07, 0x5F, 0xFB, 0x92, 0xE4, 0x2E, 0x09]};
    const IID IID_ITMediaPlayback                  = {0xE68A7E62, 0x4CAE, 0x694A, [0xBB, 0x63, 0x2A, 0xD6, 0x25, 0x40, 0x4B, 0x77]};
    const IID IID_ITMediaRecord                    = {0x9245DDF5, 0x7654, 0xC14C, [0x9D, 0x4D, 0xFA, 0xD3, 0xEE, 0xFE, 0x7D, 0xB2]};
    const IID IID_ITMediaSupport                   = {0x84C3EFB1, 0x5593, 0xD011, [0x83, 0x5C, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_ITMSPAddress                     = {0x00D63BEE, 0x6838, 0xD211, [0xA0, 0x45, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITMultiTrackTerminal             = {0x910004FE, 0xE8AD, 0x7240, [0x95, 0xC9, 0xBF, 0x7D, 0xE8, 0xC5, 0x4B, 0x44]};
    const IID IID_ITParticipant                    = {0x20B89958, 0x345A, 0xD211, [0x95, 0xA0, 0x00, 0xA0, 0x24, 0x4D, 0x22, 0x98]};
    const IID IID_ITParticipantControl             = {0x8466EED2, 0x345A, 0xD211, [0x95, 0xA0, 0x00, 0xA0, 0x24, 0x4D, 0x22, 0x98]};
    const IID IID_ITParticipantEvent               = {0x7050B38B, 0xAD2D, 0xD311, [0xA5, 0x80, 0x00, 0xC0, 0x4F, 0x8E, 0xF6, 0xE3]};
    const IID IID_ITParticipantSubStreamControl    = {0x0891672C, 0x355A, 0xD211, [0x95, 0xA0, 0x00, 0xA0, 0x24, 0x4D, 0x22, 0x98]};
    const IID IID_ITPhone                          = {0xB48DD409, 0xCC10, 0x8843, [0x9D, 0xE7, 0xA8, 0x46, 0x56, 0x18, 0x97, 0x5A]};
    const IID IID_ITPhoneDeviceSpecificEvent       = {0xA6B2FF63, 0x2B87, 0xD34C, [0xA5, 0x01, 0x32, 0x6E, 0x8F, 0xB4, 0x0A, 0xF7]};
    const IID IID_ITPhoneEvent                     = {0xD82D948F, 0xED64, 0xAF4A, [0xA7, 0x7D, 0xB2, 0x3D, 0xB0, 0x83, 0x7E, 0xAD]};
    const IID IID_ITPluggableTerminalClassInfo     = {0x4A7F7541, 0x09CF, 0x344B, [0xBC, 0x96, 0x0A, 0x79, 0xD2, 0x39, 0x00, 0x76]};
    const IID IID_ITPluggableTerminalClassRegistrati = {0x23374A92, 0x0BA0, 0x5F4F, [0x9F, 0xEE, 0x8E, 0x9A, 0xEB, 0x9E, 0x82, 0xAA]};
    const IID IID_ITPluggableTerminalEventSink     = {0xBE87086E, 0x1ABA, 0x2E49, [0xBD, 0x10, 0x40, 0x20, 0xEC, 0x5E, 0x33, 0xE0]};
    const IID IID_ITPluggableTerminalEventSinkRegistrati = {0x095711F7, 0x16A2, 0x5749, [0xA7, 0x59, 0x06, 0x0A, 0xB3, 0x2A, 0x90, 0xD1]};
    const IID IID_ITPluggableTerminalInitializatio = {0x3C48D6AE, 0x0433, 0xD211, [0x86, 0xF1, 0x00, 0x60, 0x08, 0xB0, 0xE5, 0xD2]};
    const IID IID_ITPluggableTerminalSuperclassInf = {0x2CE4546D, 0x2546, 0x5943, [0xA6, 0xF7, 0x63, 0x19, 0x99, 0x10, 0x7E, 0x05]};
    const IID IID_ITPluggableTerminalSuperclassRegistrati = {0x8AC0D360, 0x3EC1, 0x9541, [0x9A, 0xB0, 0x8D, 0xE7, 0x68, 0x09, 0x0F, 0x25]};
    const IID IID_ITPrivateEvent                   = {0xD09C260E, 0xD410, 0x2141, [0x9C, 0x22, 0x9C, 0x85, 0xD6, 0x25, 0x65, 0x0D]};
    const IID IID_ITQOSApplicationID               = {0x279DC8E8, 0xBDA3, 0xD547, [0xA6, 0xFC, 0xD2, 0xAE, 0x40, 0xCD, 0xBC, 0x6E]};
    const IID IID_ITQOSEvent                       = {0x7C35A3CF, 0x77AD, 0xD111, [0xBB, 0x68, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITQueue                          = {0x4931FC5A, 0xCC4B, 0xD111, [0xBF, 0x80, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITQueueEvent                     = {0x33307F29, 0x11BD, 0xD111, [0xA0, 0xA7, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITrackFile                       = {0x48C99087, 0x0BA3, 0xD011, [0x8C, 0xAB, 0x00, 0xC0, 0x4F, 0xD9, 0x0F, 0x85]};
    const IID IID_ITransaction                     = {0x8450B10F, 0x41AF, 0xCE11, [0xBD, 0x2B, 0x20, 0x4C, 0x4F, 0x4F, 0x50, 0x20]};
    const IID IID_ITransaction2                    = {0x48150234, 0x6500, 0xD311, [0xBA, 0xC1, 0x00, 0xC0, 0x4F, 0x79, 0x7B, 0xE2]};
    const IID IID_ITransactionCloner               = {0x50696502, 0x5221, 0xD011, [0x94, 0x4C, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x6E]};
    const IID IID_ITransactionDispenser            = {0xE1D96A3A, 0xB923, 0xCF11, [0xAD, 0x60, 0x00, 0xAA, 0x00, 0xA7, 0x4C, 0xCD]};
    const IID IID_ITransactionJoin                 = {0x5E3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ITransactionLocal                = {0x5F3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ITransactionObject               = {0x603A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ITransactionOptions              = {0xE0D96A3A, 0xB923, 0xCF11, [0xAD, 0x60, 0x00, 0xAA, 0x00, 0xA7, 0x4C, 0xCD]};
    const IID IID_ITransactionOutcomeEvents        = {0xE2D96A3A, 0xB923, 0xCF11, [0xAD, 0x60, 0x00, 0xAA, 0x00, 0xA7, 0x4C, 0xCD]};
    const IID IID_ITransmt                         = {0x50F1C9B3, 0x93B5, 0xCE11, [0xB5, 0xB0, 0x00, 0xAA, 0x00, 0x6C, 0xB3, 0x7D]};
    const IID IID_ITravelEntry                     = {0x3BDB6EF4, 0x2FBC, 0xD011, [0x94, 0x12, 0x00, 0xAA, 0x00, 0xA3, 0xEB, 0xD3]};
    const IID IID_ITravelLog                       = {0x08CBA966, 0x0248, 0xD211, [0xA5, 0x61, 0x00, 0xA0, 0xC9, 0x2D, 0xBF, 0xE8]};
    const IID IID_ITravelLogClient                 = {0x7AF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ITravelLogClient2                = {0xCE64D30A, 0xCBAD, 0xD311, [0x82, 0x69, 0x00, 0x80, 0x5F, 0xC7, 0x32, 0xC0]};
    const IID IID_ITravelLogEntry                  = {0x87DDBF7E, 0x18AD, 0xD311, [0xA4, 0xC5, 0x00, 0xC0, 0x4F, 0x72, 0xD6, 0xB8]};
    const IID IID_ITravelLogEx                     = {0x79F65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_ITravelLogStg                    = {0x80DDBF7E, 0x18AD, 0xD311, [0xA4, 0xC5, 0x00, 0xC0, 0x4F, 0x72, 0xD6, 0xB8]};
    const IID IID_ITRendezvous                     = {0x6B1D6234, 0xFF6C, 0xD111, [0xAF, 0xF7, 0x00, 0xC0, 0x4F, 0xC3, 0x1F, 0xEE]};
    const IID IID_ITRequest                        = {0xDFFF48AC, 0xC4F8, 0xD111, [0xA0, 0x30, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITRequestEvent                   = {0xDEFF48AC, 0xC4F8, 0xD111, [0xA0, 0x30, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITridentEventSink                = {0x50CAC91D, 0xEF06, 0xD211, [0x84, 0x15, 0x00, 0x60, 0x08, 0xC3, 0xFB, 0xFC]};
    const IID IID_ITrkForceOwnership               = {0x441F53A2, 0x7DC6, 0xD011, [0x8C, 0xB1, 0x00, 0xC0, 0x4F, 0xD9, 0x0F, 0x85]};
    const IID IID_ITrkRestoreNotify                = {0x6B6F05D0, 0xA0E2, 0xD011, [0xB1, 0xC2, 0x00, 0xC0, 0x4F, 0xB9, 0x38, 0x6D]};
    const IID IID_ITrkRestoreParser                = {0xE3395975, 0x81E3, 0xD011, [0xB1, 0xC5, 0x00, 0xC0, 0x4F, 0xB9, 0x38, 0x6D]};
    const IID IID_ITrusteeAdmin                    = {0xA13A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ITrusteeGroupAdmin               = {0xA23A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_ITScriptableAudioFormat          = {0xBD5876B8, 0x593C, 0x644F, [0xBE, 0x74, 0xAE, 0xDE, 0x3E, 0x86, 0xA8, 0x1E]};
    const IID IID_ITSdp                            = {0xD819279B, 0x96B6, 0xD011, [0xA4, 0x89, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_ITStaticAudioTerminal            = {0x71786BA8, 0x4CD1, 0xE648, [0x92, 0x2E, 0xA8, 0xD1, 0x5F, 0x98, 0x48, 0x00]};
    const IID IID_ITStream                         = {0x05D63BEE, 0x6838, 0xD211, [0xA0, 0x45, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITStreamControl                  = {0x04D63BEE, 0x6838, 0xD211, [0xA0, 0x45, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITStreamQualityControl           = {0xC2B60A6C, 0xE321, 0xD311, [0xA5, 0x77, 0x00, 0xC0, 0x4F, 0x8E, 0xF6, 0xE3]};
    const IID IID_ITSubStream                      = {0x08D63BEE, 0x6838, 0xD211, [0xA0, 0x45, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITSubStreamControl               = {0x07D63BEE, 0x6838, 0xD211, [0xA0, 0x45, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITTAPI                           = {0x82C3EFB1, 0x5593, 0xD011, [0x83, 0x5C, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_ITTAPI2                          = {0x8CDCFB54, 0x0FD9, 0xAD4D, [0x96, 0x95, 0xB3, 0x73, 0x09, 0x7F, 0x09, 0x4B]};
    const IID IID_ITTAPICallCenter                 = {0x5431FC5A, 0xCC4B, 0xD111, [0xBF, 0x80, 0x00, 0x80, 0x5F, 0xC1, 0x47, 0xD3]};
    const IID IID_ITTAPIEventNotification          = {0x2694DBED, 0x913B, 0xD111, [0x8F, 0x30, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITTAPIObjectEvent                = {0x484D85F4, 0x7A93, 0xD111, [0xBB, 0x58, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID IID_ITTAPIObjectEvent2               = {0x6EDA9D35, 0xCE68, 0x8343, [0xBF, 0x0B, 0x16, 0x91, 0x33, 0xC4, 0x1B, 0x46]};
    const IID IID_ITTerminal                       = {0x8AC3EFB1, 0x5593, 0xD011, [0x83, 0x5C, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_ITTerminalControl                = {0x3B48D6AE, 0x0433, 0xD211, [0x86, 0xF1, 0x00, 0x60, 0x08, 0xB0, 0xE5, 0xD2]};
    const IID IID_ITTerminalManager                = {0xDEF27071, 0xE39B, 0xD011, [0xA0, 0x09, 0x00, 0xAA, 0x00, 0xB6, 0x05, 0xA4]};
    const IID IID_ITTerminalManager2               = {0xC6DE33BB, 0xC7B2, 0xE646, [0x9E, 0xD1, 0x49, 0x8B, 0x91, 0xFA, 0x85, 0xAC]};
    const IID IID_ITTerminalSupport                = {0x85C3EFB1, 0x5593, 0xD011, [0x83, 0x5C, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID IID_ITTerminalSupport2               = {0xBC39EBF3, 0x1F1B, 0x994E, [0xA0, 0xC0, 0x56, 0x30, 0x5C, 0x4D, 0xD5, 0x91]};
    const IID IID_ITTime                           = {0x78BB5226, 0x1615, 0xD111, [0x97, 0x71, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_ITTimeCollection                 = {0x4FF0C10C, 0xEBCA, 0xD011, [0x8D, 0x58, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID IID_ITToneDetectionEvent             = {0xAF0F7E40, 0x47D0, 0x5347, [0xB0, 0xC6, 0x8E, 0x06, 0x03, 0x73, 0xFE, 0xCD]};
    const IID IID_ITToneTerminalEvent              = {0x0960F5E6, 0x1F61, 0x4549, [0xBB, 0xD2, 0x2D, 0x0C, 0xE5, 0x61, 0x20, 0x56]};
    const IID IID_ITTTSTerminalEvent               = {0x8F7864D9, 0xA595, 0x1D46, [0xAB, 0x0C, 0xB9, 0x90, 0x0A, 0x6C, 0x27, 0x13]};
    const IID IID_ITypeChangeEvents                = {0x10040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ITypeComp                        = {0x03040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ITypeFactory                     = {0x2E000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ITypeInfo                        = {0x01040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ITypeInfo2                       = {0x12040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ITypeLib                         = {0x02040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ITypeLib2                        = {0x11040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_ITypeMarshal                     = {0x2D000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IUmiADSIPrivate                  = {0x01CBCECF, 0x2331, 0x2649, [0xB5, 0xE3, 0x62, 0x78, 0x08, 0x27, 0x26, 0x43]};
    const IID IID_IUniformResourceLocatorA         = {0x803BF2FB, 0xF0E3, 0x1B10, [0x84, 0x88, 0x00, 0xAA, 0x00, 0x3E, 0x56, 0xF8]};
    const IID IID_IUniformResourceLocatorW         = {0xA00DBBCA, 0x57DA, 0xCF11, [0x99, 0x74, 0x00, 0x20, 0xAF, 0xD7, 0x97, 0x62]};
    const IID IID_IUnknown                         = {0x00000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IUnsecuredApartment              = {0x8CBAFA1C, 0x2315, 0xD111, [0xAD, 0x79, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID IID_IUPnPDescriptionDocument         = {0xB2C1D111, 0xAA7D, 0x9E4C, [0x95, 0x95, 0x7F, 0x82, 0xED, 0x20, 0x6D, 0x1E]};
    const IID IID_IUPnPDescriptionDocumentCallback = {0x694C3977, 0x8654, 0xD640, [0x9B, 0xC3, 0x49, 0x91, 0x98, 0x3E, 0x02, 0xDA]};
    const IID IID_IUPnPDevice                      = {0xD1D0443D, 0xC998, 0x8948, [0xAC, 0xD1, 0xF9, 0xD6, 0x74, 0xBF, 0x22, 0x21]};
    const IID IID_IUPnPDeviceControl               = {0xBA104820, 0xB273, 0xD411, [0xBF, 0x42, 0x00, 0xB0, 0xD0, 0x11, 0x8B, 0x56]};
    const IID IID_IUPnPDeviceDocumentAccess        = {0x042877E7, 0x8732, 0x8E41, [0x90, 0x72, 0xCF, 0x2B, 0x47, 0x23, 0x89, 0x81]};
    const IID IID_IUPnPDeviceFinder                = {0x553DDAAD, 0x726F, 0x1943, [0xBF, 0xF9, 0x18, 0x60, 0x0A, 0x53, 0x9B, 0x10]};
    const IID IID_IUPnPDeviceFinderAddCallbackWithInterfa = {0x0BFC3D98, 0x9617, 0xDF44, [0x89, 0x75, 0xCA, 0x54, 0x5B, 0x62, 0x0E, 0xE5]};
    const IID IID_IUPnPDeviceFinderCallback        = {0x4A985A41, 0xB388, 0xF349, [0x92, 0xAF, 0x05, 0x08, 0xBE, 0xDF, 0x0D, 0x6C]};
    const IID IID_IUPnPDeviceHostICSSupport        = {0xE55AFC3F, 0x6BA6, 0x9C49, [0xA1, 0x80, 0xC7, 0x39, 0x3D, 0xB6, 0xBA, 0x8D]};
    const IID IID_IUPnPDeviceHostSetup             = {0x0949D36B, 0xE754, 0xBF4F, [0x85, 0x62, 0x7B, 0x89, 0x70, 0x9A, 0x58, 0x9A]};
    const IID IID_IUPnPDeviceProvider              = {0xB8104820, 0xB273, 0xD411, [0xBF, 0x42, 0x00, 0xB0, 0xD0, 0x11, 0x8B, 0x56]};
    const IID IID_IUPnPDevices                     = {0x730CBCFD, 0xA3BD, 0x664C, [0xAC, 0x4F, 0xF2, 0xD9, 0x6F, 0xDA, 0xD6, 0x8C]};
    const IID IID_IUPnPEventSink                   = {0xB4104820, 0xB273, 0xD411, [0xBF, 0x42, 0x00, 0xB0, 0xD0, 0x11, 0x8B, 0x56]};
    const IID IID_IUPnPEventSource                 = {0xB5104820, 0xB273, 0xD411, [0xBF, 0x42, 0x00, 0xB0, 0xD0, 0x11, 0x8B, 0x56]};
    const IID IID_IUPnPNAT                         = {0x12C871B1, 0x76CC, 0x5A48, [0x94, 0xD8, 0xB6, 0xB3, 0xA2, 0x79, 0x4E, 0x99]};
    const IID IID_IUPnPPrivateCallbackHelper       = {0x2783CC8D, 0xE9DB, 0xE648, [0x84, 0x6C, 0x33, 0x72, 0x58, 0x65, 0xD5, 0x0C]};
    const IID IID_IUPnPPrivateDocumentCallbackHelp = {0x8E2A4319, 0x324A, 0x6048, [0xB8, 0xFB, 0x95, 0xB1, 0x11, 0x7C, 0xD4, 0xE5]};
    const IID IID_IUPnPPrivateServiceHelper2       = {0x76400F34, 0x5668, 0xF948, [0xB3, 0xC4, 0x97, 0xB9, 0x1B, 0x68, 0xD7, 0x7E]};
    const IID IID_IUPnPRegistrar                   = {0xB6104820, 0xB273, 0xD411, [0xBF, 0x42, 0x00, 0xB0, 0xD0, 0x11, 0x8B, 0x56]};
    const IID IID_IUPnPReregistrar                 = {0xB7104820, 0xB273, 0xD411, [0xBF, 0x42, 0x00, 0xB0, 0xD0, 0x11, 0x8B, 0x56]};
    const IID IID_IUPnPService                     = {0x9C0195A2, 0x65DC, 0xDD47, [0x90, 0xDC, 0x7F, 0xE9, 0x18, 0xA1, 0xAB, 0x44]};
    const IID IID_IUPnPServiceCallback             = {0xA9DCFA31, 0x73AB, 0x4B46, [0xB6, 0x7D, 0x5C, 0x1D, 0x0F, 0x83, 0xC8, 0xB8]};
    const IID IID_IUPnPServiceCallbackPrivate      = {0x1525EA24, 0x12F6, 0x2845, [0xBA, 0x82, 0x7B, 0xD3, 0xDB, 0xBA, 0xD3, 0x03]};
    const IID IID_IUPnPServices                    = {0x9E8E8C3F, 0x7A9A, 0xC84D, [0xBC, 0x41, 0xFF, 0x31, 0xFA, 0x37, 0x49, 0x56]};
    const IID IID_IUrlHistoryNotify                = {0xC1BE40BC, 0x93C4, 0xD011, [0x83, 0x1B, 0x00, 0xC0, 0x4F, 0xD5, 0xAE, 0x38]};
    const IID IID_IUrlHistoryStg                   = {0x414A373C, 0xE4BA, 0xCF11, [0xBF, 0x7D, 0x00, 0xAA, 0x00, 0x69, 0x46, 0xEE]};
    const IID IID_IUrlHistoryStg2                  = {0x11DCA0AF, 0x13C3, 0xD011, [0x83, 0x1A, 0x00, 0xC0, 0x4F, 0xD5, 0xAE, 0x38]};
    const IID IID_IUrlMon                          = {0x26000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IURLSearchHook                   = {0xA0F660AC, 0xD90F, 0xD011, [0x99, 0xCB, 0x00, 0xC0, 0x4F, 0xD6, 0x44, 0x97]};
    const IID IID_IURLSearchHook2                  = {0xA44DE45E, 0x326D, 0xE346, [0x86, 0xBC, 0x07, 0x54, 0x0D, 0xED, 0xD0, 0xE0]};
    const IID IID_IUrlTrackingStg                  = {0xB3CBF8F2, 0x40B0, 0xD011, [0xBB, 0x16, 0x00, 0xC0, 0x4F, 0xB6, 0x6F, 0x63]};
    const IID IID_IUserEventTimer                  = {0x944B500F, 0x426E, 0xE642, [0x99, 0xE0, 0xE2, 0x0F, 0xAF, 0xE5, 0x2A, 0xB4]};
    const IID IID_IUserEventTimerCallback          = {0xE6D8EAE9, 0x252A, 0x0E41, [0x9B, 0x58, 0xA9, 0xFB, 0xEF, 0x1D, 0xD1, 0xA2]};
    const IID IID_IUserNotification                = {0xBA1197BA, 0x9358, 0x8747, [0xA7, 0xE1, 0x41, 0x27, 0x71, 0x51, 0x55, 0x0B]};
    const IID IID_IUtilityButton                   = {0xAFF65030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID IID_IVariantChangeType               = {0x6298EFA6, 0x20C7, 0xD011, [0x93, 0x37, 0x00, 0xA0, 0xC9, 0x0D, 0xCA, 0xA9]};
    const IID IID_IVersionHost                     = {0xAC157166, 0x02DC, 0xD111, [0xBA, 0x57, 0x00, 0xC0, 0x4F, 0xC2, 0x04, 0x0E]};
    const IID IID_IVersionVector                   = {0x1014B04E, 0x1ADB, 0xD111, [0xBA, 0x53, 0x00, 0xC0, 0x4F, 0xC2, 0x04, 0x0E]};
    const IID IID_IViewChapter                     = {0x983A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IViewFilter                      = {0x9B3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IViewObject                      = {0x0D010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IViewObject2                     = {0x27010000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IViewObjectEx                    = {0x9242F23A, 0x960C, 0xCE11, [0xA0, 0xCF, 0x00, 0xAA, 0x00, 0x60, 0x0A, 0xB8]};
    const IID IID_IViewRowset                      = {0x973A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IViewSort                        = {0x9A3A730C, 0x1C2A, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID IID_IVirusScanEngine                 = {0x80B13D08, 0xA8B4, 0xCF11, [0xAA, 0xFA, 0x00, 0xAA, 0x00, 0xB6, 0x01, 0x5C]};
    const IID IID_IVirusScanner                    = {0xE0BE8945, 0xB1B4, 0xCF11, [0xAA, 0xFA, 0x00, 0xAA, 0x00, 0xB6, 0x01, 0x5C]};
    const IID IID_IWaitMultiple                    = {0x2B000000, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IWbemAddressResolution           = {0x122ECEF7, 0x908C, 0xD111, [0x9E, 0x7B, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID IID_IWbemBackupRestore               = {0xC7329EC4, 0x8BBC, 0xD211, [0x85, 0xD4, 0x00, 0x10, 0x5A, 0x1F, 0x83, 0x04]};
    const IID IID_IWbemBackupRestoreEx             = {0xC5DE59A3, 0x13E8, 0x3448, [0x8A, 0x2A, 0xBA, 0x7F, 0x1D, 0x77, 0x7D, 0x76]};
    const IID IID_IWbemCallResult                  = {0x75A6AC44, 0xFCE8, 0xD011, [0xA0, 0x7C, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID IID_IWbemCallStatus                  = {0x47DC1242, 0x2E14, 0x6C4C, [0xBC, 0x49, 0x6C, 0xA2, 0x32, 0xDD, 0x09, 0x59]};
    const IID IID_IWbemClassObject                 = {0x81A612DC, 0x7F73, 0xCF11, [0x88, 0x4D, 0x00, 0xAA, 0x00, 0x4B, 0x2E, 0x24]};
    const IID IID_IWbemClientConnectionTransport   = {0x2AC789A8, 0xC1FC, 0x9E4A, [0xAF, 0x61, 0xED, 0x07, 0x13, 0x33, 0xFB, 0x5B]};
    const IID IID_IWbemClientTransport             = {0x112ECEF7, 0x908C, 0xD111, [0x9E, 0x7B, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID IID_IWbemConfigure                   = {0x7682369A, 0xCF26, 0xD011, [0xAD, 0x3C, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID IID_IWbemConfigureRefresher          = {0x923C3549, 0x6B51, 0xD111, [0xAE, 0xA6, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID IID_IWbemConnectorLogin              = {0xB19CECD8, 0x35B1, 0x104F, [0x8B, 0x1B, 0xC7, 0x18, 0x8B, 0xB0, 0xD1, 0x86]};
    const IID IID_IWbemConstructClassObject        = {0x9461F79E, 0xD570, 0xD111, [0xAD, 0x90, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID IID_IWbemContext                     = {0x74A6AC44, 0xFCE8, 0xD011, [0xA0, 0x7C, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID IID_IWbemDecoupledBasicEventProvider = {0x206D3386, 0x11CA, 0x8647, [0x9E, 0xF1, 0xBC, 0x8A, 0x94, 0x6B, 0x42, 0xFC]};
    const IID IID_IWbemDecoupledEventSink          = {0xF2EB94CD, 0x22E6, 0xD211, [0x9C, 0xB3, 0x00, 0x10, 0x5A, 0x1F, 0x48, 0x01]};
    const IID IID_IWbemDecoupledRegistrar          = {0xCFCB0510, 0x4FE6, 0x4646, [0xBC, 0xD3, 0x3A, 0x08, 0x9D, 0x8A, 0x84, 0xB4]};
    const IID IID_IWbemEventConsumerProvider       = {0x7A1046E2, 0x6EB0, 0xD011, [0xAD, 0x61, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID IID_IWbemEventConsumerProviderEx     = {0x4A53CF17, 0xA3D8, 0xD04A, [0xAC, 0x92, 0x5E, 0x3D, 0x01, 0x71, 0x71, 0x51]};
    const IID IID_IWbemEventProvider               = {0x5B1045E2, 0x6EB0, 0xD011, [0xAD, 0x61, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID IID_IWbemEventProviderQuerySink      = {0xF8CA0A58, 0x1CFA, 0xD011, [0xAD, 0x72, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID IID_IWbemEventProviderSecurity       = {0x967D1F63, 0x93D9, 0xD211, [0xB3, 0x39, 0x00, 0x10, 0x5A, 0x1F, 0x4A, 0xAF]};
    const IID IID_IWbemEventSink                   = {0x0A08E03A, 0x3A7E, 0x6643, [0xBF, 0x89, 0x0F, 0xEE, 0xDC, 0x93, 0x16, 0x59]};
    const IID IID_IWbemHiPerfEnum                  = {0x88C20527, 0xAE79, 0xD211, [0xB3, 0x48, 0x00, 0x10, 0x5A, 0x1F, 0x81, 0x77]};
    const IID IID_IWbemHiPerfProvider              = {0x933C3549, 0x6B51, 0xD111, [0xAE, 0xA6, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID IID_IWbemLevel1Login                 = {0x18AD09F3, 0x6AD8, 0xD011, [0xA0, 0x75, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID IID_IWbemLocator                     = {0x87A612DC, 0x7F73, 0xCF11, [0x88, 0x4D, 0x00, 0xAA, 0x00, 0x4B, 0x2E, 0x24]};
    const IID IID_IWbemObjectAccess                = {0x9A3C3549, 0x6B51, 0xD111, [0xAE, 0xA6, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID IID_IWbemObjectSink                  = {0x0178857C, 0x8173, 0xCF11, [0x88, 0x4D, 0x00, 0xAA, 0x00, 0x4B, 0x2E, 0x24]};
    const IID IID_IWbemObjectTextSrc               = {0x3A88BFBF, 0xD7CA, 0xD311, [0xA1, 0x1B, 0x00, 0x10, 0x5A, 0x1F, 0x51, 0x5A]};
    const IID IID_IWbemPath                        = {0xF25AC13B, 0x6C73, 0x7E47, [0x9E, 0x51, 0x23, 0x8A, 0xF8, 0x66, 0x7D, 0xCC]};
    const IID IID_IWbemPathKeyList                 = {0x7728E69A, 0x4475, 0xB04B, [0xAA, 0x26, 0xA1, 0x38, 0x24, 0x65, 0x9E, 0xD6]};
    const IID IID_IWbemPropertyProvider            = {0x41E861CE, 0xBC65, 0xD011, [0xB6, 0xBD, 0x00, 0xAA, 0x00, 0x32, 0x40, 0xC7]};
    const IID IID_IWbemProviderIdentity            = {0x977D1F63, 0x93D9, 0xD211, [0xB3, 0x39, 0x00, 0x10, 0x5A, 0x1F, 0x4A, 0xAF]};
    const IID IID_IWbemProviderInit                = {0x7215E41B, 0xDD91, 0xD111, [0xAE, 0xB2, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID IID_IWbemProviderInitSink            = {0x7115E41B, 0xDD91, 0xD111, [0xAE, 0xB2, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID IID_IWbemQualifierSet                = {0x80A612DC, 0x7F73, 0xCF11, [0x88, 0x4D, 0x00, 0xAA, 0x00, 0x4B, 0x2E, 0x24]};
    const IID IID_IWbemQuery                       = {0x586F1681, 0x98DD, 0xD311, [0xA1, 0x20, 0x00, 0x10, 0x5A, 0x1F, 0x51, 0x5A]};
    const IID IID_IWbemRawSdAccessor               = {0x59D7E2C1, 0xBDCA, 0xD311, [0xA1, 0x1B, 0x00, 0x10, 0x5A, 0x1F, 0x51, 0x5A]};
    const IID IID_IWbemRefresher                   = {0x993C3549, 0x6B51, 0xD111, [0xAE, 0xA6, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID IID_IWbemServices                    = {0x99DC5695, 0x8C82, 0xCF11, [0xA3, 0x7E, 0x00, 0xAA, 0x00, 0x32, 0x40, 0xC7]};
    const IID IID_IWbemShutdown                    = {0xF91DB3B7, 0x15D5, 0xD311, [0xA1, 0x1C, 0x00, 0x10, 0x5A, 0x1F, 0x51, 0x5A]};
    const IID IID_IWbemStatusCodeText              = {0xBCE187EB, 0x3332, 0xD211, [0xAE, 0xC9, 0x00, 0xC0, 0x4F, 0xB6, 0x88, 0x20]};
    const IID IID_IWbemTransport                   = {0x84E53F55, 0x5621, 0xD011, [0xB6, 0xAE, 0x00, 0xAA, 0x00, 0x32, 0x40, 0xC7]};
    const IID IID_IWbemUnboundObjectSink           = {0x7B1046E2, 0x6EB0, 0xD011, [0xAD, 0x61, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID IID_IWBScriptControl                 = {0x700817A5, 0xF80C, 0xD111, [0x8B, 0x91, 0x00, 0x80, 0xC7, 0x44, 0xF3, 0x89]};
    const IID IID_IWCContextMenuCallback           = {0x64DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IWCPropertySheetCallback         = {0x60DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IWCWizard97Callback              = {0x67DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IWCWizardCallback                = {0x62DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IWebBridge                       = {0xADFD24AE, 0xC603, 0xD111, [0x8B, 0x76, 0x00, 0x80, 0xC7, 0x44, 0xF3, 0x89]};
    const IID IID_IWebBrowser                      = {0xC12AB2EA, 0xC130, 0xCF11, [0xA7, 0xEB, 0x00, 0x00, 0xC0, 0x5B, 0xAE, 0x0B]};
    const IID IID_IWebBrowser2                     = {0x61160CD3, 0xAFCD, 0xD011, [0x8A, 0x3E, 0x00, 0xC0, 0x4F, 0xC9, 0xE2, 0x6E]};
    const IID IID_IWebBrowserApp                   = {0x05DF0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID IID_IWebWizardExtension              = {0x663F6B0E, 0xD198, 0xC048, [0xA2, 0x22, 0xFB, 0xDE, 0x74, 0xE2, 0xFB, 0xC5]};
    const IID IID_IWebWizardHost                   = {0x59C3BC18, 0x9049, 0xFB4B, [0xB9, 0x51, 0x3C, 0x83, 0x70, 0x2B, 0xE5, 0xF9]};
    const IID IID_IWEExtendContextMenu             = {0x65DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IWEExtendPropertySheet           = {0x61DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IWEExtendWizard                  = {0x63DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IWEExtendWizard97                = {0x68DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_IWEInvokeCommand                 = {0x66DEDE97, 0x6BFC, 0xCF11, [0xB5, 0xF5, 0x00, 0xA0, 0xC9, 0x0A, 0xB5, 0x05]};
    const IID IID_Iwfolders                        = {0x981FE3BA, 0x811B, 0xD211, [0xA9, 0x7A, 0x00, 0xC0, 0x4F, 0x8E, 0xCB, 0x02]};
    const IID IID_IWindowForBindingUI              = {0xD5C9EA79, 0xFABA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IWinInetHttpInfo                 = {0xD8C9EA79, 0xFABA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IWinInetInfo                     = {0xD6C9EA79, 0xFABA, 0xCE11, [0x8C, 0x82, 0x00, 0xAA, 0x00, 0x4B, 0xA9, 0x0B]};
    const IID IID_IWizardExtension                 = {0x96A62EC0, 0xCC86, 0x1E49, [0x9B, 0x23, 0x74, 0x39, 0x4A, 0x04, 0x44, 0xA8]};
    const IID IID_IWizardSite                      = {0x5B0F9688, 0x2F42, 0x7B4E, [0x80, 0x13, 0x73, 0x41, 0x53, 0x81, 0xC3, 0xC3]};
    const IID IID_IWMIExtension                    = {0x6EF0C1AD, 0x7E5C, 0xD211, [0x8B, 0x74, 0x00, 0x10, 0x4B, 0x2A, 0xFB, 0x41]};
    const IID IID_IWordBreaker                     = {0xC85235D5, 0xE377, 0x1A10, [0xB5, 0x52, 0x08, 0x00, 0x2B, 0x33, 0xB0, 0xE6]};
    const IID IID_IWordSink                        = {0x547090CC, 0x58C0, 0x1A10, [0xB5, 0x54, 0x08, 0x00, 0x2B, 0x33, 0xB0, 0xE6]};
    const IID IID_IWrappedProtocol                 = {0x8547C853, 0x2584, 0xC54D, [0x97, 0x1B, 0xE5, 0x8D, 0x9C, 0x19, 0xF9, 0xB6]};
    const IID IID_IXMLAttribute                    = {0xFCA0D4D4, 0x733B, 0xD111, [0xB2, 0xB4, 0x00, 0xC0, 0x4F, 0xB9, 0x25, 0x96]};
    const IID IID_IXMLDocument                     = {0x612B2EF5, 0xA118, 0xD111, [0xB1, 0x05, 0x00, 0x80, 0x5F, 0x49, 0x91, 0x6B]};
    const IID IID_IXMLDocument2                    = {0xFEE28D2B, 0x2D8D, 0xD111, [0xB2, 0xFC, 0x00, 0xC0, 0x4F, 0xD9, 0x15, 0xA9]};
    const IID IID_IXMLDOMAttribute                 = {0x85BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMCDATASection              = {0x8ABF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMCharacterData             = {0x84BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMComment                   = {0x88BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMDocument                  = {0x81BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMDocumentFragment          = {0x13A4FA3E, 0x2F27, 0xD211, [0x83, 0x6F, 0x00, 0x00, 0xF8, 0x7A, 0x77, 0x82]};
    const IID IID_IXMLDOMDocumentType              = {0x8BBF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMElement                   = {0x86BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMEntity                    = {0x8DBF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMEntityReference           = {0x8EBF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMImplementation            = {0x8FBF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMNamedNodeMap              = {0x83BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMNode                      = {0x80BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMNodeList                  = {0x82BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMNotation                  = {0x8CBF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMParseError                = {0x26A4FA3E, 0x2F27, 0xD211, [0x83, 0x6F, 0x00, 0x00, 0xF8, 0x7A, 0x77, 0x82]};
    const IID IID_IXMLDOMProcessingInstruction     = {0x89BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDOMText                      = {0x87BF3329, 0x367B, 0xD211, [0xB2, 0x0E, 0x00, 0xC0, 0x4F, 0x98, 0x3E, 0x60]};
    const IID IID_IXMLDSOControl                   = {0x62FA0A31, 0x7505, 0xD211, [0x9C, 0xA9, 0x00, 0x60, 0xB0, 0xEC, 0x3D, 0x39]};
    const IID IID_IXMLElement                      = {0xAC317F3F, 0x5FE1, 0xD011, [0x9C, 0x25, 0x00, 0xC0, 0x4F, 0xC9, 0x9C, 0x8E]};
    const IID IID_IXMLElement2                     = {0xFFE28D2B, 0x2D8D, 0xD111, [0xB2, 0xFC, 0x00, 0xC0, 0x4F, 0xD9, 0x15, 0xA9]};
    const IID IID_IXMLElementCollection            = {0x80557265, 0x5D9B, 0xD011, [0x9B, 0xFE, 0x00, 0xC0, 0x4F, 0xC9, 0x9C, 0x8E]};
    const IID IID_IXMLError                        = {0xD35A8C94, 0x8DC5, 0xD011, [0x9C, 0x0B, 0x00, 0xC0, 0x4F, 0xC9, 0x9C, 0x8E]};
    const IID IID_IXMLGenericParse                 = {0x7130E2E4, 0x074D, 0xD211, [0xAE, 0x76, 0x00, 0x80, 0xC7, 0x3B, 0xC1, 0x99]};
    const IID IID_IXMLHttpRequest                  = {0x8D108CED, 0x4943, 0xD211, [0x91, 0xA4, 0x00, 0xC0, 0x4F, 0x79, 0x69, 0xE8]};
    const IID IID_IXMLNodeFactory                  = {0x1F3642D2, 0xA051, 0xD211, [0x9C, 0xAF, 0x00, 0x60, 0xB0, 0xEC, 0x3D, 0x39]};
    const IID IID_IXMLNodeSource                   = {0x1D3642D2, 0xA051, 0xD211, [0x9C, 0xAF, 0x00, 0x60, 0xB0, 0xEC, 0x3D, 0x39]};
    const IID IID_IXMLParser                       = {0x1E3642D2, 0xA051, 0xD211, [0x9C, 0xAF, 0x00, 0x60, 0xB0, 0xEC, 0x3D, 0x39]};
    const IID IID_IXTLRuntime                      = {0x25A4FA3E, 0x2F27, 0xD211, [0x83, 0x6F, 0x00, 0x00, 0xF8, 0x7A, 0x77, 0x82]};
    const IID IID_StdOle                           = {0x30040200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID KSDATAFORMAT_SUBTYPE_DIRECTMUSIC     = {0xBCF8821A, 0x8B3F, 0xD211, [0xB7, 0x74, 0x00, 0x60, 0x08, 0x33, 0x16, 0xC1]};
    const IID KSDATAFORMAT_SUBTYPE_MIDI            = {0x6027261D, 0x57E9, 0xCF11, [0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00]};
    const IID LIBID_Accessibility                  = {0xF0DBA41E, 0x3B3C, 0xCF11, [0x81, 0x0C, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71]};
    const IID LIBID_ActiveIMM                      = {0x30DD5549, 0x59B1, 0xD011, [0x8F, 0xCF, 0x00, 0xAA, 0x00, 0x6B, 0xCC, 0x59]};
    const IID LIBID_ADs                            = {0xB05DD297, 0x6303, 0xCF11, [0xAB, 0xC4, 0x02, 0x60, 0x8C, 0x9E, 0x75, 0x53]};
    const IID LIBID_ALGLib                         = {0x98D0D1B6, 0x35E2, 0x994B, [0xBA, 0x98, 0x7C, 0x62, 0x4F, 0xD8, 0x75, 0xDB]};
    const IID LIBID_AutoDiscovery                  = {0x88B8AF4E, 0xCB81, 0xBA4E, [0xBA, 0xC9, 0xDA, 0x25, 0x4E, 0x57, 0x21, 0xF1]};
    const IID LIBID_BackgroundCopyManager          = {0x4FB7EE1D, 0x1579, 0x6045, [0xB5, 0x58, 0x91, 0x8C, 0x83, 0xF1, 0x76, 0xA6]};
    const IID LIBID_BackgroundCopyManager1_5       = {0xEA1993EA, 0x28C6, 0x0F48, [0x83, 0x31, 0x76, 0x8F, 0xAC, 0x39, 0x7E, 0x4E]};
    const IID LIBID_BackgroundCopyQMgr             = {0xCB6DB2F5, 0x7EB3, 0x7C4D, [0xAE, 0x7A, 0x1C, 0xB3, 0xFB, 0xEB, 0x18, 0x3E]};
    const IID LIBID_CHANNELMGR                     = {0xE0F20448, 0x6ED1, 0xD011, [0x80, 0x2B, 0x00, 0xC0, 0x4F, 0xD7, 0x5D, 0x13]};
    const IID LIBID_CLADMWIZLib                    = {0x4071F924, 0x8966, 0xD111, [0x9A, 0xA7, 0x00, 0xC0, 0x4F, 0xB9, 0x3A, 0x80]};
    const IID LIBID_ClusCfgWizard                  = {0xDCFE016D, 0x348D, 0x2847, [0xAD, 0x0B, 0xB3, 0xA2, 0x1A, 0x10, 0x3B, 0x42]};
    const IID LIBID_CommonControlObjects           = {0x5BA1ADBC, 0x28B4, 0x0C42, [0x8D, 0x28, 0x02, 0x35, 0x90, 0x92, 0x4C, 0x9F]};
    const IID LIBID_DirectAnimation                = {0x741FBBBC, 0x84E3, 0xD011, [0x9B, 0x99, 0x00, 0xC0, 0x4F, 0xC2, 0xF5, 0x1D]};
    const IID LIBID_DWbemServices_v3               = {0x31A07CCB, 0x29F7, 0xD011, [0x9E, 0x4D, 0x00, 0xC0, 0x4F, 0xC3, 0x24, 0xA8]};
    const IID LIBID_DXTMSFTLib                     = {0x03EB775E, 0x7C93, 0xD111, [0xB0, 0x47, 0x00, 0xAA, 0x00, 0x3B, 0x60, 0x61]};
    const IID LIBID_DXTRANSLib                     = {0x1D4D3154, 0xFE35, 0xD111, [0x81, 0xA1, 0x00, 0x00, 0xF8, 0x75, 0x57, 0xDB]};
    const IID LIBID_DXTRANSPLib                    = {0xA44D7A52, 0x2C7F, 0xD211, [0xB1, 0x2D, 0x00, 0x00, 0xF8, 0x1F, 0x59, 0x95]};
    const IID LIBID_EventQLib                      = {0xF28000A7, 0x3B40, 0xD111, [0x88, 0x36, 0x00, 0xA0, 0xC9, 0x49, 0xAC, 0x67]};
    const IID LIBID_IASPolicyLib                   = {0xA596C06B, 0xE60C, 0xD111, [0xBA, 0xAE, 0x00, 0xC0, 0x4F, 0xC2, 0xE2, 0x0D]};
    const IID LIBID_IEXTagLib                      = {0x40C48B7E, 0xFFAE, 0xD111, [0x89, 0xC2, 0x00, 0xC0, 0x4F, 0xB6, 0xBF, 0xC4]};
    const IID LIBID_IMAPILib                       = {0x84219FC4, 0xA750, 0xD311, [0x91, 0x44, 0x00, 0x10, 0x4B, 0xA1, 0x1C, 0x5E]};
    const IID LIBID_ImgUtilLib                     = {0x400879CF, 0xC42D, 0xD011, [0xB7, 0x24, 0x00, 0xAA, 0x00, 0x6C, 0x1A, 0x01]};
    const IID LIBID_ITRKADMNLib                    = {0x351F53A2, 0x7DC6, 0xD011, [0x8C, 0xB1, 0x00, 0xC0, 0x4F, 0xD9, 0x0F, 0x85]};
    const IID LIBID_McastLib                       = {0xC07C2164, 0x85A2, 0xD111, [0x86, 0x97, 0x00, 0x60, 0x08, 0xB0, 0xE5, 0xD2]};
    const IID LIBID_MSHTML                         = {0xC5F15030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID LIBID_MSHTMLINTERNAL                 = {0xE1F75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID LIBID_MSTIME                         = {0x7162C987, 0xDBAD, 0x4547, [0xB2, 0xE8, 0xDF, 0x88, 0xA8, 0x47, 0x2F, 0xD1]};
    const IID LIBID_MSXML                          = {0xE20C3ED6, 0xA2A0, 0xD011, [0x9C, 0x02, 0x00, 0xC0, 0x4F, 0xC9, 0x9C, 0x8E]};
    const IID LIBID_MultiLanguage                  = {0xE0235C27, 0x4737, 0xD011, [0x9F, 0xEA, 0x00, 0xAA, 0x00, 0x3F, 0x86, 0x46]};
    const IID LIBID_NATUPNPLib                     = {0x5858561C, 0x02F3, 0x1E47, [0xB4, 0x09, 0xF1, 0x80, 0xAA, 0x4A, 0xBE, 0xC6]};
    const IID LIBID_NETCONLib                      = {0xCA34E743, 0x3D04, 0x704A, [0x9A, 0x2C, 0xA8, 0xF2, 0x54, 0x06, 0x3D, 0x91]};
    const IID LIBID_PassiveSink                    = {0xEFEE02E0, 0xEAE6, 0xD211, [0x9C, 0xB3, 0x00, 0x10, 0x5A, 0x1F, 0x48, 0x01]};
    const IID LIBID_ProcessDebugManagerLib         = {0x2118A578, 0xF451, 0xD011, [0x8F, 0x20, 0x00, 0x80, 0x5F, 0x2C, 0xD0, 0x64]};
    const IID LIBID_RENDLib                        = {0x4D9E02F1, 0x5BCB, 0xD011, [0x8D, 0x59, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID LIBID_RTCCORELib                     = {0x940026CD, 0x10DE, 0xEE4A, [0xAC, 0x73, 0xEF, 0x87, 0xF6, 0xE1, 0x26, 0x83]};
    const IID LIBID_SDOIASLib                      = {0x32F7DD81, 0xA84A, 0x354A, [0xBD, 0xFF, 0x8B, 0x42, 0xEF, 0xE7, 0xC6, 0x24]};
    const IID LIBID_SDPBLBLib                      = {0x9AD759C2, 0xABC8, 0xD011, [0x8D, 0x58, 0x00, 0xC0, 0x4F, 0xD9, 0x1A, 0xC0]};
    const IID LIBID_SensEvents                     = {0xEDDE97D5, 0x9F5B, 0xD111, [0x8D, 0xD2, 0x00, 0xAA, 0x00, 0x4A, 0xBD, 0x5E]};
    const IID LIBID_SHDocVw                        = {0xC02AB2EA, 0xC130, 0xCF11, [0xA7, 0xEB, 0x00, 0x00, 0xC0, 0x5B, 0xAE, 0x0B]};
    const IID LIBID_Shell32                        = {0xB0E9A750, 0xEF70, 0xD111, [0xB7, 0x5A, 0x00, 0xA0, 0xC9, 0x05, 0x64, 0xFE]};
    const IID LIBID_ShellImageData                 = {0x06FF8A0B, 0xF08D, 0x134F, [0x8E, 0x25, 0x25, 0xB2, 0x31, 0x9C, 0x43, 0x6A]};
    const IID LIBID_ShellObjects                   = {0xB1E9A750, 0xEF70, 0xD111, [0xB7, 0x5A, 0x00, 0xA0, 0xC9, 0x05, 0x64, 0xFE]};
    const IID LIBID_SHGINALib                      = {0x025C050A, 0xBEBA, 0x8044, [0xBB, 0x7B, 0xA8, 0xEC, 0x72, 0x3C, 0xE9, 0xC0]};
    const IID LIBID_SubscriptionMgr                = {0x8AD84FC5, 0xA1FF, 0xD011, [0xBC, 0x5E, 0x00, 0xC0, 0x4F, 0xD9, 0x29, 0xDB]};
    const IID LIBID_TAPI3Lib                       = {0x80D4D621, 0x8BA8, 0xD011, [0x83, 0xDD, 0x00, 0xAA, 0x00, 0x3C, 0xCA, 0xBD]};
    const IID LIBID_TERMMGRLib                     = {0x5BD8DC28, 0xA4AC, 0xD011, [0xA0, 0x28, 0x00, 0xAA, 0x00, 0xB6, 0x05, 0xA4]};
    const IID LIBID_UPnPHostLib                    = {0xB3104820, 0xB273, 0xD411, [0xBF, 0x42, 0x00, 0xB0, 0xD0, 0x11, 0x8B, 0x56]};
    const IID LIBID_UPNPLib                        = {0xA74234DB, 0xE9A2, 0x594A, [0x9C, 0xB5, 0xF5, 0xC1, 0xA5, 0xD9, 0x01, 0xE5]};
    const IID LIBID_VIRUSSCAN                      = {0x70DB475F, 0xFED9, 0xD011, [0x95, 0x64, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x4F]};
    const IID LIBID_WbemClient_v1                  = {0xFE96C17E, 0x0570, 0xD111, [0xAD, 0x90, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID LIBID_WbemProviders_v1               = {0x10F72D09, 0x1070, 0xD111, [0xAD, 0x90, 0x00, 0xC0, 0x4F, 0xD8, 0xFD, 0xFF]};
    const IID LIBID_WbemScripting                  = {0xC6835756, 0x41CB, 0xD111, [0x8B, 0x02, 0x00, 0x60, 0x08, 0x06, 0xD9, 0xB6]};
    const IID LIBID_WbemTransports_v1              = {0xF3477902, 0x31D7, 0xCE11, [0xA3, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01]};
    const IID LIBID_WbemUtilities_v1               = {0x90926C22, 0x96DD, 0xD311, [0xA1, 0x20, 0x00, 0x10, 0x5A, 0x1F, 0x51, 0x5A]};
    const IID LIBID_WebCheck                       = {0x252EBD10, 0x35F2, 0xCF11, [0xB5, 0xDD, 0x00, 0xA0, 0xC9, 0x03, 0x48, 0xEC]};
    const IID LIBID_WMIEXTENSIONLib                = {0x00D003E5, 0x7F5C, 0xD211, [0x8B, 0x74, 0x00, 0x10, 0x4B, 0x2A, 0xFB, 0x41]};
    const IID LIBID_XENROLLLib                     = {0x7BF2F843, 0x207A, 0xD011, [0x8F, 0x06, 0x00, 0xC0, 0x4F, 0xC2, 0x95, 0xE1]};
    const IID LIBID_XMLPSR                         = {0x1C3642D2, 0xA051, 0xD211, [0x9C, 0xAF, 0x00, 0x60, 0xB0, 0xEC, 0x3D, 0x39]};
    const IID MDGUID_MDX                           = {0xD0CC7CA0, 0x4881, 0xD011, [0x87, 0xBB, 0x00, 0xC0, 0x4F, 0xC3, 0x39, 0x42]};
    const IID MDSCHEMA_ACTIONS                     = {0x08CD7CA0, 0x4881, 0xD011, [0x87, 0xBB, 0x00, 0xC0, 0x4F, 0xC3, 0x39, 0x42]};
    const IID MDSCHEMA_COMMANDS                    = {0x09CD7CA0, 0x4881, 0xD011, [0x87, 0xBB, 0x00, 0xC0, 0x4F, 0xC3, 0x39, 0x42]};
    const IID MDSCHEMA_CUBES                       = {0xD822B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID MDSCHEMA_DIMENSIONS                  = {0xD922B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID MDSCHEMA_FUNCTIONS                   = {0x07CD7CA0, 0x4881, 0xD011, [0x87, 0xBB, 0x00, 0xC0, 0x4F, 0xC3, 0x39, 0x42]};
    const IID MDSCHEMA_HIERARCHIES                 = {0xDA22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID MDSCHEMA_LEVELS                      = {0xDB22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID MDSCHEMA_MEASURES                    = {0xDC22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID MDSCHEMA_MEMBERS                     = {0xDE22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID MDSCHEMA_PROPERTIES                  = {0xDD22B5C8, 0xF35C, 0xCE11, [0xAD, 0xE5, 0x00, 0xAA, 0x00, 0x44, 0x77, 0x3D]};
    const IID MDSCHEMA_SETS                        = {0x0BCD7CA0, 0x4881, 0xD011, [0x87, 0xBB, 0x00, 0xC0, 0x4F, 0xC3, 0x39, 0x42]};
    const IID NAMEDTIMER_DRAW                      = {0x62F35030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID NOTFCOOKIE_SCHEDULE_GROUP_DAILY      = {0xB0184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTFCOOKIE_SCHEDULE_GROUP_MANUAL     = {0xB3184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTFCOOKIE_SCHEDULE_GROUP_MONTHLY    = {0xB2184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTFCOOKIE_SCHEDULE_GROUP_WEEKLY     = {0xB1184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_11                  = {0xFB174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_12                  = {0xFC174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_13                  = {0xFD174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_14                  = {0xFE174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_15                  = {0xFF174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_AGENT_INIT          = {0x90734A1E, 0x0BC7, 0xD011, [0x95, 0xF8, 0x00, 0xA0, 0xC9, 0x03, 0x48, 0xEC]};
    const IID NOTIFICATIONTYPE_AGENT_START         = {0xEC174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_ALERT               = {0xE3174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_ANOUNCMENT          = {0xE1174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_BEGIN_REPORT        = {0xEE174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_CONFIG_CHANGED      = {0xF2174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_CONNECT_TO_INTERNET = {0xF0174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_d                   = {0xF8174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_DISCONNECT_FROM_INTERN = {0xF1174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_e                   = {0xF9174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_END_REPORT          = {0xEF174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_f                   = {0xFA174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_GROUP_DONE          = {0x85184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_GROUP_RESTART       = {0x84184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_GROUP_START         = {0x83184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_i6                  = {0x86184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_i7                  = {0x87184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_i8                  = {0x88184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_i9                  = {0x89184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_iA                  = {0x8A184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_iB                  = {0x8B184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_iC                  = {0x8C184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_iD                  = {0x8D184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_iE                  = {0x8E184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_iF                  = {0x8F184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_INET_IDLE           = {0xE4174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_INET_OFFLINE        = {0xE5174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_INET_ONLINE         = {0xE6174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_ITEM_DONE           = {0x82184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_ITEM_RESTART        = {0x81184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_ITEM_START          = {0x80184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_NULL                = {0xE0174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_PROGRESS_REPORT     = {0xF3174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_0             = {0x00184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_1             = {0x01184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_2             = {0x02184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_3             = {0x03184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_4             = {0x04184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_5             = {0x05184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_6             = {0x06184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_7             = {0x07184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_8             = {0x08184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_9             = {0x09184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_A             = {0x0A184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_B             = {0x0B184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_C             = {0x0C184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_D             = {0x0D184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_E             = {0x0E184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_START_F             = {0x0F184FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_TASK                = {0xE2174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_TASKS_ABORT         = {0xE9174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_TASKS_COMPLETED     = {0xEA174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_TASKS_ERROR         = {0xF7174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_TASKS_PROGRESS      = {0xEB174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_TASKS_RESUME        = {0xE8174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_TASKS_STARTED       = {0xF6174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_TASKS_SUSPEND       = {0xE7174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_USER_IDLE_BEGIN     = {0xF4174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID NOTIFICATIONTYPE_USER_IDLE_END       = {0xF5174FD3, 0x6E57, 0xD011, [0xB2, 0x8C, 0x00, 0xC0, 0x4F, 0xD7, 0xCD, 0x22]};
    const IID OLE_DATAPATH_ALLIMAGE                = {0x0EDE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_ALLMM                   = {0x18DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_ALLTEXT                 = {0x1EDE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_ANSITEXT                = {0x19DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_AVI                     = {0x0FDE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_BASICAUDIO              = {0x12DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_BIFF                    = {0x21DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_BMP                     = {0x01DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_CGM                     = {0x0BDE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_COMMONIMAGE             = {0x0DDE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_DIB                     = {0x02DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_DIF                     = {0x1FDE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_ENHMF                   = {0x04DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_EPS                     = {0x0CDE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_GIF                     = {0x05DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_HTML                    = {0x1CDE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_JPEG                    = {0x06DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_MIDI                    = {0x13DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_MPEG                    = {0x10DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_PALETTE                 = {0x22DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_PCX                     = {0x09DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_PENDATA                 = {0x23DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_PICT                    = {0x0ADE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_POSTSCRIPT              = {0x1DDE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_QUICKTIME               = {0x11DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_RIFF                    = {0x15DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_RTF                     = {0x1BDE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_SOUND                   = {0x16DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_SYLK                    = {0x20DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_TIFF                    = {0x07DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_UNICODE                 = {0x1ADE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_VIDEO                   = {0x17DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_WAV                     = {0x14DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_WMF                     = {0x03DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLE_DATAPATH_XBM                     = {0x08DE0200, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
    const IID OLEDB_SVC_DSLPropertyPages           = {0x020C7451, 0x8E7E, 0xD211, [0xA0, 0x2D, 0x00, 0xC0, 0x4F, 0xA3, 0x73, 0x48]};
    const IID PSGUID_QUERY                         = {0x901C6949, 0x177E, 0x1A10, [0xA9, 0x1C, 0x08, 0x00, 0x2B, 0x2E, 0xCD, 0xA9]};
    const IID RESCLASSTYPE_IPAddress               = {0x0F0EA857, 0x186F, 0x8B45, [0xA7, 0x2A, 0xD1, 0x17, 0x0C, 0x47, 0x93, 0x90]};
    const IID RESCLASSTYPE_NetworkName             = {0xB99EA6BB, 0xD0F5, 0x7B48, [0x92, 0xAE, 0x1B, 0xA1, 0x0F, 0x39, 0x21, 0x58]};
    const IID RESCLASSTYPE_StorageDevice           = {0x473A4512, 0x5E8C, 0x3748, [0xBA, 0xC6, 0xB2, 0x54, 0xB8, 0xF2, 0x64, 0xCC]};
    const IID RESTYPE_ClusterIPAddress             = {0x32F80DE5, 0x7C47, 0x0C44, [0xB7, 0xA3, 0x38, 0x23, 0xA6, 0xEF, 0x6C, 0xCB]};
    const IID RESTYPE_ClusterNetName               = {0xCF7C89B2, 0x2C8D, 0xC14B, [0xB4, 0x96, 0x6E, 0x2B, 0xC7, 0xA0, 0xBB, 0x38]};
    const IID RESTYPE_ClusterQuorumDisk            = {0x80FBDDD9, 0xDC0B, 0xD440, [0xB3, 0x96, 0x1A, 0xFD, 0x77, 0xDD, 0xD1, 0x9C]};
    const IID RESTYPE_GenericScript                = {0x4D1872F3, 0xDBDF, 0x7043, [0xA0, 0x05, 0xE1, 0xEF, 0x30, 0x1B, 0x23, 0xA4]};
    const IID RESTYPE_IPAddress                    = {0x71DE1AE6, 0x9AC7, 0xDA4F, [0xB1, 0xDB, 0xA9, 0xB8, 0xD2, 0x0C, 0x8B, 0x14]};
    const IID RESTYPE_LocalQuorum                  = {0x6D6504F0, 0x485B, 0x8045, [0xA1, 0xF4, 0xC3, 0xEC, 0x14, 0x98, 0x3D, 0x1E]};
    const IID RESTYPE_MajorityNodeSet              = {0x11AEBF56, 0xF7D2, 0x4F4F, [0x99, 0x52, 0x55, 0xAF, 0x19, 0xBA, 0xC3, 0xE9]};
    const IID RESTYPE_NetworkName                  = {0x1EFED2C1, 0x32D3, 0x5F44, [0x8D, 0xA1, 0x12, 0xE5, 0xE2, 0xD3, 0x7C, 0xBF]};
    const IID RESTYPE_PhysicalDisk                 = {0x638755CC, 0x8633, 0xEF42, [0xB1, 0x50, 0xBE, 0x79, 0x33, 0x44, 0xD4, 0x5F]};
    const IID SID_CtxQueryAssociations             = {0x40FCADFA, 0x77B7, 0x694B, [0xAA, 0x81, 0x77, 0x03, 0x5E, 0xF0, 0xE6, 0xE8]};
    const IID SID_SContainerDispatch               = {0x00BE22B7, 0x684E, 0x1B10, [0xA2, 0xBC, 0x00, 0xAA, 0x00, 0x40, 0x47, 0x70]};
    const IID SID_SDataPathBrowser                 = {0xA50148FC, 0xA92B, 0xCF11, [0xA2, 0x29, 0x00, 0xAA, 0x00, 0x3D, 0x73, 0x52]};
    const IID SID_SGetViewFromViewDual             = {0x5D939A88, 0x1E97, 0x124B, [0xB9, 0x0C, 0x24, 0xDF, 0xC9, 0xE1, 0xE5, 0xE8]};
    const IID SID_SHTMLEditServices                = {0xF9F75030, 0xB598, 0xCF11, [0xBB, 0x82, 0x00, 0xAA, 0x00, 0xBD, 0xCE, 0x0B]};
    const IID SID_STopLevelBrowser                 = {0x40BE964C, 0x5C91, 0xCF11, [0x99, 0xD3, 0x00, 0xAA, 0x00, 0x4A, 0xE8, 0x37]};
    const IID SID_STopWindow                       = {0x00B5E149, 0x3646, 0xD311, [0x97, 0xF7, 0x00, 0xC0, 0x4F, 0x45, 0xD0, 0xB3]};
    const IID SID_SVersionHost                     = {0x34A61E37, 0x5CDC, 0xD111, [0xBA, 0x57, 0x00, 0xC0, 0x4F, 0xC2, 0x04, 0x0E]};
    const IID TAPIMEDIATYPE_Audio                  = {0xC2D88E02, 0x7ADC, 0xD011, [0x8E, 0xD3, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID TAPIMEDIATYPE_DataModem              = {0xC6D88E02, 0x7ADC, 0xD011, [0x8E, 0xD3, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID TAPIMEDIATYPE_G3Fax                  = {0xC7D88E02, 0x7ADC, 0xD011, [0x8E, 0xD3, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID TAPIMEDIATYPE_Video                  = {0xC4D88E02, 0x7ADC, 0xD011, [0x8E, 0xD3, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID TAPIPROTOCOL_H323                    = {0xD7E21C83, 0xB583, 0xD111, [0xBB, 0x5C, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID TAPIPROTOCOL_Multicast               = {0xD8E21C83, 0xB583, 0xD111, [0xBB, 0x5C, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID TAPIPROTOCOL_PSTN                    = {0xD6E21C83, 0xB583, 0xD111, [0xBB, 0x5C, 0x00, 0xC0, 0x4F, 0xB6, 0x80, 0x9F]};
    const IID TASK_AnalyzeCluster                  = {0xA6B54031, 0xFA9A, 0x8845, [0x8C, 0xA0, 0x9B, 0xE8, 0xF8, 0xB6, 0x15, 0x06]};
    const IID TASK_CommitClusterChanges            = {0x0B03032D, 0x84F0, 0x0748, [0xBB, 0xAC, 0x94, 0x26, 0x9E, 0x50, 0xB5, 0x6F]};
    const IID TASKID_Major_Check_Cluster_Feasibili = {0xFFAEC8EB, 0xC310, 0x5B4D, [0xAC, 0x17, 0xFC, 0x0F, 0x4C, 0x38, 0x71, 0xB7]};
    const IID TASKID_Major_Check_Node_Feasibility  = {0xB1575ECC, 0x2045, 0x7246, [0xB4, 0xBA, 0xA2, 0x88, 0xEC, 0x42, 0x94, 0x6E]};
    const IID TASKID_Major_Checking_For_Existing_Clust = {0x8F3B45B8, 0xFD92, 0x5043, [0xA6, 0xD9, 0x55, 0x1F, 0xD0, 0x18, 0xB7, 0x91]};
    const IID TASKID_Major_Client_And_Server_Log   = {0x9C9136CD, 0x319F, 0xB446, [0xA2, 0x9D, 0xAC, 0x87, 0xF4, 0xE6, 0xCC, 0x93]};
    const IID TASKID_Major_Client_Log              = {0xEAA0EC64, 0xB69C, 0x2443, [0x97, 0x02, 0xDF, 0x15, 0xC6, 0x96, 0xC3, 0x0A]};
    const IID TASKID_Major_Configure_Cluster_Servic = {0x74075F7C, 0x1116, 0xB542, [0xAF, 0x3C, 0x6E, 0x12, 0x4A, 0xC4, 0xD3, 0x6B]};
    const IID TASKID_Major_Configure_Resource_Type = {0x1FAF476D, 0x177F, 0x804B, [0x8F, 0xAB, 0x3A, 0x2D, 0x19, 0xB1, 0x23, 0x3D]};
    const IID TASKID_Major_Configure_Resources     = {0xECCD1B41, 0xD369, 0x8544, [0x8D, 0x5D, 0xE1, 0x9E, 0xE7, 0x7A, 0x6D, 0xD4]};
    const IID TASKID_Major_Establish_Connection    = {0x992FC393, 0xCA39, 0x384D, [0x9D, 0x7F, 0x27, 0x07, 0xCA, 0x0E, 0xAF, 0x46]};
    const IID TASKID_Major_Find_Devices            = {0x67F56B03, 0x7723, 0xB34B, [0x8A, 0xE1, 0xE4, 0x10, 0x4E, 0x2E, 0xB3, 0xC5]};
    const IID TASKID_Major_Reanalyze               = {0xDA6859E2, 0x7B9C, 0xDB42, [0xAD, 0xA9, 0xBC, 0x4E, 0x34, 0xF1, 0x7E, 0x6E]};
    const IID TASKID_Major_Server_Log              = {0x6807AA05, 0x495F, 0xCD49, [0xAF, 0xDC, 0x96, 0xF9, 0xD5, 0x18, 0x02, 0xD4]};
    const IID TASKID_Minor_Update_Progress         = {0xDAD36223, 0xA4A6, 0x5145, [0xB8, 0x46, 0x7B, 0xB3, 0xA1, 0x36, 0x5F, 0x56]};
    const IID TID_D3DRMAnimation                   = {0x4FAB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_D3DRMAnimationKey                = {0xA846DD10, 0x5B77, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMAnimationOptions            = {0xC056BFE2, 0x0F84, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMAnimationSet                = {0x50AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_D3DRMAppData                     = {0x805274E5, 0x4FB2, 0xCF11, [0x9D, 0xD5, 0x00, 0xAA, 0x00, 0xA7, 0x1A, 0x2F]};
    const IID TID_D3DRMBoolean                     = {0xA0A67D53, 0x37CA, 0xD011, [0x94, 0x1C, 0x00, 0x80, 0xC8, 0x0C, 0xFA, 0x7B]};
    const IID TID_D3DRMBoolean2d                   = {0x63AE8548, 0xE878, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMCamera                      = {0x51AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_D3DRMColorRGB                    = {0x816EE1D3, 0x3578, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMColorRGBA                   = {0xE044FF35, 0x7C6C, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMCoords2d                    = {0x443FF2F6, 0x8676, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMExternalVisual              = {0xA06A1198, 0xBABD, 0xD111, [0x82, 0xC0, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x71]};
    const IID TID_D3DRMFloatKeys                   = {0xA946DD10, 0x5B77, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMFrame                       = {0x46AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_D3DRMFramePosition               = {0xC156BFE2, 0x0F84, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMFrameRotation               = {0xC356BFE2, 0x0F84, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMFrameTransformMatrix        = {0x413FF2F6, 0x8676, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMFrameVelocity               = {0xC256BFE2, 0x0F84, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMGuid                        = {0xE09027A4, 0x1078, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMIndexedColor                = {0x20B83016, 0x4278, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMInfo                        = {0x0071952B, 0x9A9E, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_D3DRMInlineData                  = {0xA0EE233A, 0xB194, 0xD011, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_D3DRMLight                       = {0x4AAB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_D3DRMLightAttenuation            = {0xA08BA9A8, 0xE5C5, 0xCF11, [0xB9, 0x41, 0x00, 0x80, 0xC8, 0x0C, 0xFA, 0x7B]};
    const IID TID_D3DRMLightPenumbra               = {0x4127D2AE, 0x1FB3, 0xCF11, [0x9D, 0xD5, 0x00, 0xAA, 0x00, 0xA7, 0x1A, 0x2F]};
    const IID TID_D3DRMLightRange                  = {0x4227D2AE, 0x1FB3, 0xCF11, [0x9D, 0xD5, 0x00, 0xAA, 0x00, 0xA7, 0x1A, 0x2F]};
    const IID TID_D3DRMLightUmbra                  = {0x4027D2AE, 0x1FB3, 0xCF11, [0x9D, 0xD5, 0x00, 0xAA, 0x00, 0xA7, 0x1A, 0x2F]};
    const IID TID_D3DRMMaterial                    = {0x4DAB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_D3DRMMaterialAmbientColor        = {0x40184101, 0x8677, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMMaterialArray               = {0xE144FF35, 0x7C6C, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMMaterialDiffuseColor        = {0x41184101, 0x8677, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMMaterialEmissiveColor       = {0x806EE1D3, 0x3578, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMMaterialPower               = {0x43184101, 0x8677, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMMaterialSpecularColor       = {0x42184101, 0x8677, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMMaterialWrap                = {0x60AE8548, 0xE878, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMMatrix4x4                   = {0x453FF2F6, 0x8676, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMMesh                        = {0x44AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_D3DRMMeshFace                    = {0x5FAB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_D3DRMMeshFaceWraps               = {0xC0C51EED, 0xA8C0, 0xD011, [0x94, 0x1C, 0x00, 0x80, 0xC8, 0x0C, 0xFA, 0x7B]};
    const IID TID_D3DRMMeshMaterialList            = {0x423FF2F6, 0x8676, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMMeshNormals                 = {0x433FF2F6, 0x8676, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMMeshTextureCoords           = {0x403FF2F6, 0x8676, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMMeshVertexColors            = {0x21B83016, 0x4278, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMProgressiveMesh             = {0x60C3638A, 0x7D99, 0xD011, [0x94, 0x1C, 0x00, 0x80, 0xC8, 0x0C, 0xFA, 0x7B]};
    const IID TID_D3DRMPropertyBag                 = {0xE1210F7F, 0xE1BF, 0xD111, [0x82, 0xC0, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x71]};
    const IID TID_D3DRMRightHanded                 = {0xA05E5D7F, 0x3AD5, 0xD111, [0x82, 0xC0, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x71]};
    const IID TID_D3DRMStringProperty              = {0xE0210F7F, 0xE1BF, 0xD111, [0x82, 0xC0, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x71]};
    const IID TID_D3DRMTextureFilename             = {0xE19027A4, 0x1078, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMTextureReference            = {0xE29027A4, 0x1078, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMTimedFloatKeys              = {0x80B106F4, 0x3B7B, 0xCF11, [0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3]};
    const IID TID_D3DRMUrl                         = {0xA1EE233A, 0xB194, 0xD011, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_D3DRMVector                      = {0x5EAB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};
    const IID TID_DXFILEHeader                     = {0x43AB823D, 0xDA62, 0xCF11, [0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33]};

}
