class MenutabsController < ApplicationController
    unloadable

    before_filter :find_menutab, :only => [:edit]

    def index
      list
      render :action => 'list' unless request.xhr?
    end

    def list
       @menutab_pages, @menutabs = paginate :menutabs, :per_page => 25, :order => "position"
      render :action => "list", :layout => false if request.xhr?
    end

    def update
      @menutab = Menutab.find(params[:id])
      if @menutab.update_attributes(params[:menutab])
        refresh_tabs
        flash[:notice] = l(:notice_successful_update)
        redirect_to :action => 'list'
      else
        render :action => 'edit'
      end
    end


  def add
    @menutab = Menutab.new(params[:menutab])
    @menutab.wiki_type = params[:type_wiki] if @menutab.wiki_type.nil? 
    if request.post?
      if @menutab.save then
        refresh_tabs
        flash[:notice] = l(:notice_successful_create)
        redirect_to :controller => 'menutabs', :action => 'list'
      end
    end
  end

  def edit
    if request.post? and @menutab.update_attributes(params[:menutab])
      flash[:notice] = l(:notice_successful_update)
      refresh_tabs
      redirect_to :controller => 'menutabs', :action => 'list'
    end
  end
  
  def view
    @tabs = Redmine::MenuManager.items(:application_menu)
    @menutab = Menutab.find(params[:id])
  end
  
  def forward_wiki_page
    wiki_page = params[:wiki_page]
    target_project = params[:target_project]
    redirect_to :controller => 'wiki', :action => 'index', :id => target_project, :page => wiki_page
  end
  
  def external_page
    external_link = params[:external_link]
    redirect_to "#{external_link}"
  end


  def remove
    @menutab = Menutab.find(params[:id])
    Menutab.destroy(params[:id])
    refresh_tabs
    redirect_to :controller => 'menutabs', :action => 'list'
  end

  private 

  def refresh_tabs
    delete_all_tab_menu
    add_all_tab_menu
  end

  def add_all_tab_menu
    menulist = Menutab.find(:all, :order => :position)
    menulist.each {|menutab| 
      if menutab.wiki_type == 'custom' then 
        Redmine::MenuManager.map(:application_menu).push menutab.label, { :controller => 'menutabs', :action => 'view', :id => menutab.id},
        :caption => Proc.new{|proj| menutab.label} unless Redmine::MenuManager.map(:application_menu).exists?(menutab.label)
      elsif menutab.wiki_type == 'project' then
        Redmine::MenuManager.map(:application_menu).push menutab.label, { :controller => 'menutabs', :action => 'forward_wiki_page', :wiki_page => menutab.wiki_page, :target_project => menutab.project },
        :caption => Proc.new{|proj| menutab.label} unless Redmine::MenuManager.map(:application_menu).exists?(menutab.label)
      elsif menutab.wiki_type == 'external' then
        Redmine::MenuManager.map(:application_menu).push menutab.label, { :controller => 'menutabs', :action => 'external_page', :external_link => menutab.external_link },
        :caption => Proc.new{|proj| menutab.label} unless Redmine::MenuManager.map(:application_menu).exists?(menutab.label)
      end
    }
  end

 
  def delete_all_tab_menu
    my_list = Array::new
    Redmine::MenuManager.items(:application_menu).each do |item|
       my_list.push item.name unless item.name == 'root'
    end
    my_list.each do |tab|
      Redmine::MenuManager.map(:application_menu).delete(tab)
    end
  end

   def find_menutab
     @menutab = Menutab.find(params[:id])
   rescue ActiveRecord::RecordNotFound
     render_404
   end
end
