# redMine - project management software
# Copyright (C) 2008 Carl Nygard, Peter Van den Bosch
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

class CalendarController < ApplicationController
  unloadable
  
  layout 'base'
  
  helper :issues
  helper :projects
  before_filter :require_login
  
  def show
    @user = User.current;

    @trackers = Tracker.find(:all, :order => 'position')
    retrieve_selected_tracker_ids(@trackers)
    
    if params[:year] and params[:year].to_i > 1900
      @year = params[:year].to_i
      if params[:month] and params[:month].to_i > 0 and params[:month].to_i < 13
        @month = params[:month].to_i
      end    
    end
    @year ||= Date.today.year
    @month ||= Date.today.month    
    @calendar = Redmine::Helpers::Calendar.new(Date.civil(@year, @month, 1), 
                                               current_language, :month)
    
    events = Issue.find(:all,
                        :include => [:project, :tracker, :priority, :assigned_to],
                        :conditions => ["#{Issue.table_name}.assigned_to_id=? AND ((start_date>=? and start_date<=?) or (due_date>=? and due_date<=?)) AND #{Issue.table_name}.tracker_id IN (#{@selected_tracker_ids.join(',')})", @user.id, @calendar.startdt, @calendar.enddt, @calendar.startdt, @calendar.enddt]) unless @user.projects.empty?

    events += Version.find(:all,
                           :include => :project, 
                           :conditions => ["(effective_date BETWEEN ? AND ?) and (project_id IN (#{@user.project_ids.join(',')}))", @calendar.startdt, @calendar.enddt])
    
    @calendar.events = events
    
    render :layout => false if request.xhr?
  end
  
    
  private
  def retrieve_selected_tracker_ids(selectable_trackers)
    if ids = params[:tracker_ids]
      @selected_tracker_ids = (ids.is_a? Array) ? ids.collect { |id| id.to_i.to_s } : ids.split('/').collect { |id| id.to_i.to_s }
    else
      @selected_tracker_ids = selectable_trackers.collect {|t| t.id.to_s }
    end
  end

end
