# redMine - project management software
# Copyright (C) 2008 Peter Van den Bosch
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

# My calendar plugin
require 'redmine'

RAILS_DEFAULT_LOGGER.info 'Starting My Calendar plugin for RedMine'

Redmine::Plugin.register :my_calendar do
  name 'My Calendar plugin'
  author 'Author name'
  description 'A personal calendar across all projects.'
  version '0.0.1'

  # A new item is added to the project menu
  menu :top_menu, :my_calendar, { :controller => 'calendar', :action => 'show' }, :html => {:class => 'mypage'}, :if => Proc.new {User.current.logged?}, :after => :my_page
end
