require 'redmine'

::Rails.logger.info 'Starting Redmine Smile Hide Sidebar plugin for RedMine'


Redmine::Plugin.register :redmine_smile_togglesidebar do
  name 'Redmine - Smile - Hide Sidebar Button'
  author 'Jérôme BATAILLE'
  author_url 'mailto:Jérôme BATAILLE <redmine@smile.fr>?subject=redmine_smile'
  description 'Adds a button to hide the right sidebar'
  url 'https://github.com/Smile-SA/redmine_smile'
  version '1.0.0'
  requires_redmine :version_or_higher => '1.2.1'

  #Plugin home page
  settings :default => HashWithIndifferentAccess.new(), :partial => 'settings/redmine_smile_togglesidebar'
end


require File.dirname(__FILE__) + '/lib/helpers/smile_helpers_application'


if Rails::VERSION::MAJOR < 3
  require 'dispatcher'
end

#Executed each time the classes are reloaded
if Rails::VERSION::MAJOR < 3
  RAILS_DISPATCHER = Dispatcher
else
  RAILS_DISPATCHER = Rails.configuration
end

this_plugin = Redmine::Plugin::find('redmine_smile_togglesidebar')
plugin_version = '?.?'
if this_plugin
  plugin_version = this_plugin.version
end


RAILS_DISPATCHER.to_prepare do
  ::Rails.logger.info "\\=>--\\__ redmine_smile_togglesidebar V#{plugin_version}"
#  require_dependency 'issue'

  #######################
  # **** Controllers ****

  ###################
  # **** Helpers ****
  unless ApplicationHelper.include? Smile::Helpers::Application::ToggleSidebar
#    Rails.logger.info "\\=>ApplicationHelper.extend Smile::Helpers::Application::ToggleSidebar"
    # ApplicationHelper is a module
    ApplicationHelper.send(:extend, Smile::Helpers::Application::ToggleSidebar)
  end
  ::Rails.logger.info '\\=>__/--'
end
