#!/usr/bin/env ruby

RAILS_ENV = 'test'
REDMINE_ROOT = '/var/www/html/redmine/'
# This does _NOT_ work. I looked back 3 revisions and found the correct line
#require File.dirname(__FILE__) + '/../config/boot'
require REDMINE_ROOT + 'config/environment'

require 'getoptlong'
require 'mailer'
require 'actionmailer'
require 'application_helper'

class Whiner 

  attr_accessor :project, :tracker, :due, :debug

  def initialize
    @project = nil
    @tracker = nil
    @due = Date.today + 3
    @debug = false
  end

  def due_in_days(days)
    @due = Date.today + days
  end

  def process

    if(@debug)
      puts "Mailer settings [#{ActionMailer::Base.smtp_settings.to_yaml}]"
      puts "do deliveries [#{ActionMailer::Base.perform_deliveries.to_s}]"
      puts "method [#{ActionMailer::Base.delivery_method.to_s}]"
      puts "errors [#{ActionMailer::Base.raise_delivery_errors.to_s}]"
    end
    if( ActionMailer::Base.delivery_method != :smtp )
      puts "Need to reset delivery_method to make it go out"
      ActionMailer::Base.delivery_method = :smtp
    end

    u = User.find_by_login('admin')
    User.current = u

    projects = []
    proj = Project.find_by_identifier(@project)
    if(! proj) 
      projects = Project.find(:all)
    else
      projects << proj
    end

    puts "Scanning [#{projects.size}] projects..." if @debug
    projects.each { |p|
      t = p.trackers.find_by_name(@tracker)

      puts "Grabbing issues from [#{p.name}/#{p.id}] between #{Date.today} and #{@due}" if @debug

      if(t) 
        issues = Issue.find(:all,
                            :conditions => [ 'due_date < ? and due_date >= ? and project_id = ? and tracker_id = ?', 
                                            @due, Date.today, p.id, t.id]
                            )
      else
        issues = Issue.find(:all,
                            :conditions => [ 'due_date < ? and due_date >= ? and project_id = ?', 
                                            @due, Date.today, p.id]
                            )
      end

      puts "Found [#{issues.size}] issues" if @debug

      issues.each { |i| 
        puts "Whining about issue [#{i.id}]" if( @debug )

        puts "Delivery failed" unless Mailer.deliver_issue_due(i)
      }
    }

    return true
  end
end

opts = GetoptLong.new(
      [ '--help', '-h', GetoptLong::NO_ARGUMENT ],
      [ '--debug', GetoptLong::NO_ARGUMENT ],
      [ '--project', '-p', GetoptLong::REQUIRED_ARGUMENT ],
      [ '--tracker', '-t', GetoptLong::REQUIRED_ARGUMENT ],
      [ '--days', '-d',  GetoptLong::REQUIRED_ARGUMENT ]
    )

def usage
  puts "Usage: [--help] [--debug] [--project <projectName>] [--tracker <trackerName>] [--days <daysInFuture>]"
  puts " --help  show this help"
  puts " --debug show extra debug information"
  puts " --project   name of project to process"
  puts " --tracker   name of tracker for filtering issues"
  puts " --days      how many days in the future to whine about"
  exit
end

whiner = Whiner.new

opts.each do |opt, arg|
  case opt
  when '--help'
    usage
  when '--project'
    whiner.project = arg
  when '--tracker'
    whiner.tracker = arg
  when '--days'
    whiner.due_in_days(arg.to_i)
  when '--debug'
    whiner.debug = true
  end
end

whiner.process

