# Smile specific 2013-06-06
# Rails 2.3.14 C.f. actionmailer-2.3.14/lib/action_mailer/base.rb

module ActionMailer
  Base.class_eval do

    private

    def perform_delivery_smtp(mail)
      destinations = mail.destinations
      mail.ready_to_send
      sender = (mail['return-path'] && mail['return-path'].spec) || Array(mail.from).first

      # Smile specific : #146531 Remplir Enveloppe-From : mails en bounce
      # sender changed for the user making the change
      # only for smile members
      if User.current.mail.present? && User.current.mail.ends_with?('@smile.fr')
        sender = User.current.mail
#        Rails.logger.debug "==>Smile user sender=#{sender}"
      end

      smtp = Net::SMTP.new(smtp_settings[:address], smtp_settings[:port])
      smtp.enable_starttls_auto if smtp_settings[:enable_starttls_auto] && smtp.respond_to?(:enable_starttls_auto)
      smtp.start(smtp_settings[:domain], smtp_settings[:user_name], smtp_settings[:password],
                 smtp_settings[:authentication]) do |smtp|
        smtp.sendmail(mail.encoded, sender, destinations)
      end
    end

    def perform_delivery_sendmail(mail)
      sendmail_args = sendmail_settings[:arguments]

      # Smile specific : #146531 Remplir Enveloppe-From : mails en bounce
      sender = ''
      sender = mail['return-path'] if mail['return-path']

      # sender changed for the user making the change
      # only for smile members
      if User.current.mail.present? && User.current.mail.ends_with?('@smile.fr')
        sender = User.current.mail
        Rails.logger.debug "==>Smile sendmail sender=#{sender}"
      end

      sendmail_args += " -f \"#{sender}\"" if sender.present?
      # END --Smile specific : #146531 Remplir Enveloppe-From : mails en bounce

      IO.popen("#{sendmail_settings[:location]} #{sendmail_args}","w+") do |sm|
        sm.print(mail.encoded.gsub(/\r/, ''))
        sm.flush
      end
    end
  end
end
