# Specific 2013-06-06
# Rails 2.3.14 C.f. actionmailer-2.3.14/lib/action_mailer/base.rb

module ActionMailer
  Base.class_eval do

    private

    def perform_delivery_smtp(mail)
      destinations = mail.destinations
      mail.ready_to_send
      sender = (mail['return-path'] && mail['return-path'].spec) || Array(mail.from).first

      # Specific : Fill Enveloppe-From : bounce emails
      # sender changed for the user making the change
      # only for compagny members (change the domain name of the email)
      if User.current.mail.present? && User.current.mail.ends_with?('@smile.fr')
        sender = User.current.mail
      end
      # END -- Specific : Fill Enveloppe-From : bounce emails

      smtp = Net::SMTP.new(smtp_settings[:address], smtp_settings[:port])
      smtp.enable_starttls_auto if smtp_settings[:enable_starttls_auto] && smtp.respond_to?(:enable_starttls_auto)
      smtp.start(smtp_settings[:domain], smtp_settings[:user_name], smtp_settings[:password],
                 smtp_settings[:authentication]) do |smtp|
        smtp.sendmail(mail.encoded, sender, destinations)
      end
    end

    def perform_delivery_sendmail(mail)
      sendmail_args = sendmail_settings[:arguments]

      # Specific : Fill Enveloppe-From : bounce emails
      sender = ''
      sender = mail['return-path'] if mail['return-path']

      # sender changed for the user making the change
      # only for compagny members (change the domain name of the email)
      if User.current.mail.present? && User.current.mail.ends_with?('@smile.fr')
        sender = User.current.mail
      end

      sendmail_args += " -f \"#{sender}\"" if sender.present?
      # END -- Specific : Fill Enveloppe-From : bounce emails

      IO.popen("#{sendmail_settings[:location]} #{sendmail_args}","w+") do |sm|
        sm.print(mail.encoded.gsub(/\r/, ''))
        sm.flush
      end
    end
  end
end
