module Redmine
  module Hook
    HOOKS = %w(issue_show project_member_list_header project_member_list_row).collect {|h| h.to_sym}
    
    @@listener_classes = []
    @@listeners = nil
    @@hook_listeners = {}
    
    class << self
      def add_listener(klass)
        @@listener_classes << klass
      end
      
      def listeners
        @@listeners ||= @@listener_classes.collect {|listener| listener.instance}
      end
 
      def hook_listeners(hook)
        @@hook_listeners[hook] ||= listeners.select {|listener| listener.respond_to?(hook)}
      end
      
      def call_hook(hook, context={})
        response = ''
        hook_listeners(hook).each do |listener|
          response << listener.send(hook, context).to_s
        end
        response
      end
    end

    class Listener
      include Singleton

      def self.inherited(child)
        Redmine::Hook.add_listener(child)
        super
      end
    end
    
    class ViewExtensionListener < Listener
      include ERB::Util
      include ActionView::Helpers::TagHelper
      include ActionView::Helpers::FormHelper
      include ActionView::Helpers::FormTagHelper
      include ActionView::Helpers::FormOptionsHelper
      include ActionView::Helpers::JavaScriptHelper
      include ActionView::Helpers::PrototypeHelper
      include ActionView::Helpers::NumberHelper
      include ActionView::Helpers::UrlHelper
      include ActionController::UrlWriter
      include ApplicationHelper
    end

    module Helper
      def call_hook(hook, context={})
        Redmine::Hook.call_hook(hook, context)
      end
    end
  end
end

ApplicationHelper.send(:include, Redmine::Hook::Helper)

