@auth_method = AuthSourceLdap.find(1)
class AuthSourceLdap
  def import
    ldap_con = initialize_ldap_con(self.account, self.account_password)
    
    search_filter = Net::LDAP::Filter.eq("objectClass", "user")
    
    found = created = 0
    skipped = []
    ldap_con.search(
        :base => self.base_dn,
        :filter => search_filter,
        :attributes => ['dn', self.attr_firstname, self.attr_lastname, self.attr_mail, self.attr_login]
        ) do | entry |
            logger.debug("Found entry with DN: #{entry.dn}") if logger
            found += 1
            skip = false
            attrs = [:firstname => (AuthSourceLdap.get_attr(entry, self.attr_firstname) != nil ? \
                                    AuthSourceLdap.get_attr(entry, self.attr_firstname) : "Unknown"),
                     :lastname => AuthSourceLdap.get_attr(entry, self.attr_lastname),
                     :mail => AuthSourceLdap.get_attr(entry, self.attr_mail),
                     :auth_source_id => self.id ]
            #sanity checking (all the above attributes are required)
            login = AuthSourceLdap.get_attr(entry, self.attr_login)
            catch :SKIP do
              skip = false
              attrs.each { |e| 
                e.each { |k, v|
                  if v == nil
                    # give the admin a clue why importing failed...
                    logger.debug("User #{login} misses value for attribute '#{k}'.")
                    skipped.push(login+"(missing attribute '#{k}')")
                    skip = true
                    throw :SKIP
                  end
                }
              }
            end
            next if skip
            if User.find(:first, :conditions => ["login=?", login])
              logger.debug("User #{login} already there, skipping...") if logger
              skipped.push(login+'(exists)')
              next
            end
         
            #create user
            begin
              logger.debug("Trying to create user with attrs: %s" % attrs.to_s) if logger
              u = User.create(*attrs)
              u.login = login
              u.language = Setting.default_language
              if u.save
                created += 1
              else
                skipped.push(login+'(add failed)')
              end
            end
        end
        logger.info("Found #{found} users, imported #{created}.")
        logger.info("Skipped users: #{skipped.join(" ")}")
        return {:found => found, :imported => created, :skipped => skipped}
  end
end



@auth_method.import

