@auth_method = AuthSourceLdap.find(1)
class AuthSourceLdap
  
	def import
		logger.info("**********************************************************************\n")
		logger.info("#{Time.now.inspect}\n\n")

		ldap_con = initialize_ldap_con(self.account, self.account_password)

		search_filter = Net::LDAP::Filter.eq("objectClass", "user")

		found = created = skipped =0
		created = []
		disabled = []
		ldap_con.search(:base => self.base_dn,:filter => search_filter,
			:attributes => ['dn', self.attr_firstname, self.attr_lastname, self.attr_mail, self.attr_login, "distinguishedName",]
		) do | entry |

			login = AuthSourceLdap.get_attr(entry, self.attr_login)

			logger.info("Found DN: #{entry.dn}")
			found += 1

			distinguishedName = AuthSourceLdap.get_attr(entry,"distinguishedName")
			is_disabled_in_ldap = distinguishedName.include? "OU=Disabled"
			user_in_rm = User.find(:first, :conditions => ["login=?", login])
			#logger.info("  User #{login} inspect: #{user_in_rm.inspect}\n")

			attrs = [:firstname => (AuthSourceLdap.get_attr(entry, self.attr_firstname) != nil ? \
									AuthSourceLdap.get_attr(entry, self.attr_firstname) : "Unknown"),
					 :lastname => AuthSourceLdap.get_attr(entry, self.attr_lastname),
					 :mail => AuthSourceLdap.get_attr(entry, self.attr_mail),
					 :auth_source_id => self.id ]
			#sanity checking (all the above attributes are required)

			#If any of the attributes is missing then don't proceed but skip
			skip = false
			catch :SKIP do
				skip = false
				attrs.each { |e| 
					e.each { |k, v|
						if v == nil
						# give the admin a clue why importing failed...
						logger.info("  User #{login} misses value for attribute '#{k}'.\n")
						#skipped.push(login+" (missing attribute '#{k}')")
						skip = true
						throw :SKIP
						end
					}
				}
			end # catch			
			if skip
			    skipped += 1
				next
			end			

			#User account was disabled in LDAP
			if is_disabled_in_ldap
				logger.info("  User #{login} is disabled in ldap\n")
				#If user exists in redmine then lock the account
				if (user_in_rm != nil) and (user_in_rm.status != User::STATUS_LOCKED)
					user_in_rm.status=User::STATUS_LOCKED
					user_in_rm.save
				    logger.info("  User #{login} is now locked in redmine\n")
				end
				#skipped.push(login+' (disabled in ldap)')
			    skipped += 1
				next
			end
			
			#User exists in Redmine, no need to update, I think.
			if user_in_rm != nil
				logger.info("  User #{login} exists in redmine\n")
			    skipped += 1
			   next
			end
				 
			#create user
			logger.info("  User #{login} is added user with attrs: #{attrs.to_s}\n")
			u = User.create(*attrs)
			u.login = login
			u.language = Setting.default_language
			if u.save
				created.push(login+' (created)')
			else
				#skipped.push(login+' (add failed)')
			    skipped += 1
				logger.info("  User #{login} failed in saving: #{attrs.to_s}\n")
			end

		end #do
		logger.info("Found #{found} users in the system\n")
		logger.info("Skipped #{skipped} users in the system\n")
		logger.info("Created #{created.size} users:") #{created.join("\n")}\n")
		logger.info("Disabled #{created.size} users:") #{Disabled.join("\n")}\n")
		logger.info("#{Time.now.inspect}\n")		
		logger.info("\n**********************************************************************\n\n")
		return {:found => found, :imported => created, :skipped => skipped}
	end # import

end #class


@auth_method.import

