# encoding: utf-8
module CodeRay
module Scanners

  class My_lang < Scanner
    
    register_for :my_lang
    file_extension 'my_lang'

    # CodeRay entry hook. Starts parsing.
    def scan_tokens encoder, options

      state = :initial

      until eos?

        case state 

        when :initial
          if match = scan(%r! & [[:alpha:]]+ !mx)
            encoder.text_token match, :directive
          else
            encoder.text_token getch, :error
          end
        else
          raise_inspect 'Unknown state', encoder
        end

      end
      encoder
    end
  end
  
end
end
