require 'redmine'
require 'dispatcher'
require 'custom_fields_patch'

Redmine::Plugin.register :redmine_custom_field_users do
  name 'Redmine Custom Field Users plugin'
  author 'Pavel Vinokurov, Sergei Vasiliev'
  description 'Use the dropdown list of Redmine users as a custom field'
  version '0.0.2'

  Redmine::CustomFieldFormat.map do |fields|
    fields.register Redmine::CustomFieldFormat.new('user_list', :label => :label_user_list, :order => 8)
  end

 Dispatcher.to_prepare do
    IssuesHelper.send(:include, CustomFieldsPatch::IssuesHelperPatch)
    CustomFieldsHelper.send(:include, CustomFieldsPatch::CustomFieldsHelperPatch)
    Redmine::CustomFieldFormat.send(:include, CustomFieldsPatch::CustomFieldFormatPatch)
    CustomField.send(:include, CustomFieldsPatch::CustomFieldPatch)
    Issue.send(:include, CustomFieldsPatch::IssuePatch)
    Query.send(:include, CustomFieldsPatch::QueryPatch)
 end

end
