# redMine - project management software
# Copyright (C) 2006-2007  Jean-Philippe Lang
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

require 'simple-rss'
require 'open-uri'
require 'rubygems'

class HudsonController < ApplicationController
  unloadable
  layout 'base'
  before_filter :find_project, :authorize
  
  def show
    # Build the regular expression used to detect successful builds
    success_re = Regexp.new('success', Regexp::IGNORECASE)

    # Find the project's Hudson RSS feed URL 
    # This URL has to be constructed from the Base URL of the hudson Application and the 
    # projectname in Hudson and furthermore the /rssAll path.
    base_url = @project.custom_values.detect {|v| v.custom_field_id == Setting.plugin_hudson['hudson_base_url_custom_field'].to_i}
    project_name = @project.custom_values.detect {|v| v.custom_field_id == Setting.plugin_hudson['hudson_project_name_custom_field'].to_i}
    project_name = project_name.value if project_name
    feed_url = base_url.value if base_url 
    feed_url = feed_url + '/job/'
    feed_url = feed_url + project_name
    feed_url = feed_url + '/rssAll'

    if !feed_url.blank?
      begin
        rss = SimpleRSS.parse open(feed_url)
        if rss
          @builds = rss.items.collect do |item|
            build = {:time => item.published,
                     :title => item.title,
                     :description => item.description,
                     :url => item.link
                     }
            build[:success] = (success_re.match(item.title) ? true : false)
            build
          end
        else
          flash.now[:error] = 'Invalid RSS feed.' unless @builds
        end
      rescue SocketError
        flash.now[:error] = 'Unable to connect to remote host.'
      end
    else
      flash.now[:error] = 'The feed URL is not defined for this project.'
    end
  end

  def enable
    # Find the project's Hudson RSS feed URL 
    # This URL has to be constructed from the Base URL of the hudson Application and the 
    # projectname in Hudson and furthermore the /rssAll path.
    base_url = @project.custom_values.detect {|v| v.custom_field_id == Setting.plugin_hudson['hudson_base_url_custom_field'].to_i}
    project_name = @project.custom_values.detect {|v| v.custom_field_id == Setting.plugin_hudson['hudson_project_name_custom_field'].to_i}
    project_name = project_name.value if project_name
    feed_url = base_url.value if base_url 
    feed_url = feed_url + '/job/'
    feed_url = feed_url + project_name
    feed_url = feed_url + '/rssAll'
 
  end
  
private
  def find_project   
    @project = Project.find(params[:id])
  rescue ActiveRecord::RecordNotFound
    render_404
  end
end
