
# Move the path to the location of the current file
Dir.chdir(File.dirname(File.expand_path(__FILE__)))

Thread.abort_on_exception = true

# Require the unit test libs
require 'test/unit/testsuite'
require 'test/unit/ui/console/testrunner'
require 'test/unit/testcase'

def find_test_suites(dir_name, classes_to_exclude=[])
	(Dir.entries(dir_name) - ['.', '..']).each do |file|
		next unless file.downcase[-8..-1] == "_test.rb"
		require "#{dir_name}/#{file}"
	end

	suites = []
	ObjectSpace.each_object(Class) do |klass|
		next unless klass.superclass == Test::Unit::TestCase or klass.superclass == ActionController::IntegrationTest 
		next if klass.name.include? "ActionController::"
		next if classes_to_exclude.include? klass.suite
		suites << klass.suite
	end
	suites
end

class TestSuite
    def self.suite
        master_suite = Test::Unit::TestSuite.new
        
		unit_tests = find_test_suites('unit')
		functional_tests = find_test_suites('functional', unit_tests)
		integration_tests = find_test_suites('integration', unit_tests + functional_tests)

        [unit_tests,
		functional_tests,
		integration_tests].each do |suite_set|
            suite_set.each do |suite|
                master_suite << suite
            end
        end
        
        return master_suite
    end
end 

Test::Unit::UI::Console::TestRunner.run(TestSuite)


