
# Move the path to the location of the current file
Dir.chdir(File.dirname(File.expand_path(__FILE__)))

# Require the unit test libs
require 'test/unit/testsuite'
require 'test/unit/ui/console/testrunner'
require 'test/unit/testcase'

# Require the unit tests
['unit/board_test.rb',
'unit/comment_test.rb',
'unit/issue_status_test.rb',
'unit/issue_test.rb',
'unit/mailer_test.rb',
'unit/mail_handler_test.rb',
'unit/member_test.rb',
'unit/message_test.rb',
'unit/project_test.rb',
'unit/repository_test.rb',
'unit/setting_test.rb',
'unit/token_test.rb',
'unit/user_preference_test.rb',
'unit/user_test.rb',
'unit/watcher_test.rb',
'unit/wiki_content_test.rb',
'unit/wiki_page_test.rb',
'unit/wiki_test.rb'
].each do |file|
	require file
end

# Require the functional tests
['functional/application_controller_test.rb',
'functional/feeds_controller_test.rb',
'functional/my_controller_test.rb',
'functional/projects_controller_test.rb',
'functional/search_controller_test.rb',
'functional/timelog_controller_test.rb'
].each do |file|
	require file
end

# Require the integration tests
['integration/account_test.rb',
'integration/admin_test.rb',
'integration/issues_test.rb',
'integration/projects_test.rb'
].each do |file|
	require file
end

Thread.abort_on_exception = true

def unit_tests
    [BoardTest.suite,
	CommentTest.suite,
	IssueStatusTest.suite,
	IssueTest.suite,
	MailerTest.suite,
	MailHandlerTest.suite,
	MemberTest.suite,
	MessageTest.suite,
	ProjectTest.suite,
	RepositoryTest.suite,
	SettingTest.suite,
	TokenTest.suite,
	UserPreferenceTest.suite,
	UserTest.suite,
	WatcherTest.suite,
	WikiContentTest.suite,
	WikiPageTest.suite,
	WikiTest.suite]
end

def functional_tests
	[ApplicationControllerTest.suite,
	FeedsControllerTest.suite,
	MyControllerTest.suite,
	ProjectsControllerTest.suite,
	SearchControllerTest.suite,
	TimelogControllerTest.suite]
end

def integration_tests
	[AccountTest.suite,
	AdminTest.suite,
	IssuesTest.suite,
	ProjectsTest.suite]
end

class TestSuite
    def self.suite
        master_suite = Test::Unit::TestSuite.new
        
        [integration_tests].each do |suite_set|
            suite_set.each do |suite|
                master_suite << suite
            end
        end
        
        return master_suite
    end
end 

Test::Unit::UI::Console::TestRunner.run(TestSuite)


