# frozen_string_literal: true

require 'benchmark/ips'

project = Project.find(1)
members = project.members
puts "members.size: #{members.size}\n\n"

Benchmark.ips do |bench|
  bench.report('Redmine 5.1.0') do
    users =
      members.preload(:principal).select do |m|
        m.principal.present? &&
         (m.mail_notification? || m.principal.mail_notification == 'all')
      end
    users.collect {|m| m.principal}
  end

  # The last version before `preload(:principal)` was added in r15518
  bench.report('Redmine 3.2.6') do
    members.select {|m| m.principal.present? && (m.mail_notification? || m.principal.mail_notification == 'all')}.collect {|m| m.principal}
  end

  bench.report('#23328#note-8') do
    subquery =
      members.select(:user_id)
      .where.associated(:principal)
      .where('members.mail_notification = ? OR users.mail_notification = ?', true, 'all')
    User.where(id: subquery)
  end

  bench.report('#23328#note-2') do
    members.eager_load(:principal).find_each()
    .select {|m| m.principal.present? && (m.mail_notification? || m.principal.mail_notification == 'all')}
    .collect {|m| m.principal}
  end

  bench.compare!
end
