# redMine - project management software
# Copyright (C) 2006-2008  Jean-Philippe Lang
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

require 'net/pop'

module Redmine
  module POP3
    class << self
      def check(pop_options={}, options={})
        host = pop_options[:host] || '127.0.0.1'
        port = pop_options[:port] || '110'

        pop = Net::POP3.new(host,port)
        pop.start(pop_options[:username], pop_options[:password]) do |pop_session|
          pop_session.each_mail do |msg|
            message = msg.pop
            logger.debug "Receiving message: #{message.grep(/^Subject: /)}" if logger && logger.debug?
            if MailHandler.receive(message, options)
              logger.info "Message #{message.grep(/^Subject: /)} processed -- removing from server." if logger && logger.info?
              puts "#{message.grep(/^Subject: /)}"
              puts "--> Message processed and deleted from the server"
              msg.delete
            else
              puts "#{message.grep(/^Subject: /)}"
              puts "--> Message NOT processed -- leaving it on the server"
              logger.info "ERROR: Message #{message.grep(/^Subject: /)} can not be processed, leaving on the server." if logger && logger.info?
            end

          end
        end
 
      end
      
      private
      
      def logger
        RAILS_DEFAULT_LOGGER
      end
    end
  end
end
