require 'redmine'

Redmine::Plugin.register :redmine_global_new_links do
  name 'Global new links'
  description 'Adds global links to new issue/timelog in the top menu'
  
  menu :top_menu, :new_issue, '#', :caption => :label_issue_new,
                                   :html => {:onclick => "toggleNewIssueMenu(event); return false;"},
                                   :if => Proc.new { User.current.logged? && User.current.memberships.any? }
  menu :top_menu, :new_timelog, '#', :caption => :button_log_time,
                                     :html => {:onclick => "toggleNewTimelogMenu(event); return false;"},
                                     :if => Proc.new { User.current.logged? && User.current.memberships.any? }
                                     
  delete_menu_item :project_menu, :new_issue
end

class RedmineGlobalNewLinksHookListener < Redmine::Hook::ViewListener
  # Adds javascript and stylesheet tags
  def view_layouts_base_html_head(context)
    javascript_include_tag('global_new_links', :plugin => :redmine_global_new_links) +
    stylesheet_link_tag('global_new_links', :plugin => :redmine_global_new_links)
  end
  
  def view_layouts_base_body_bottom(context)
    s = ''
    s << content_tag('div', global_links_menu(:controller => :issues, :action => :new), :id=>"new-issue-menu", :style=>"display:none;)>") if User.current.memberships.any?
    s << content_tag('div', global_links_menu(:controller => :timelog, :action => :edit), :id=>"new-timelog-menu", :style=>"display:none;)>") if User.current.memberships.any?
  end
  
  def global_links_menu(action)
    user_projects_by_root = User.current.projects.find(:all, :include => :parent).group_by(&:root)
    s = '<div><ul>'
    user_projects_by_root.keys.sort.each do |root|
      s << "<li>#{ link_to h(root.name), action.merge(:project_id => root, :only_path => true) }</li>"
      user_projects_by_root[root].sort.each do |project|  
        next if project == root
        s << "<li>#{ link_to '&#187; '+h(project.name), action.merge(:project_id => project, :only_path => true) }</li>"
      end
    end
    s << '</ul></div>'
    s
  end
end
