#!/usr/bin/env ruby

require 'open-uri'
require 'nokogiri'
require 'optparse'

params = ARGV.getopts('', 'version_id:')
unless params['version_id']
  STDERR.puts "error: version_id is required."
  exit 1
end

URL = "http://www.redmine.org/projects/redmine/issues?fixed_version_id=#{params['version_id']}&set_filter=1&status_id=%2A"

Issue = Struct.new(:tracker, :id, :subject, :category)

issues = []
page = 1
while true
  html = open("#{URL}&page=#{page}").read
  doc = Nokogiri::HTML(html)
  rows = doc.css('table.list.issues tbody tr')
  break if rows.empty?
  rows.each do |tr|
    issue = Issue.new
    issue.tracker = tr.css('td.tracker').first.text
    issue.id = tr.css('td.id').first.text
    issue.subject = tr.css('td.subject').first.text.strip
    issue.category = tr.css('td.category').first.text
    issues << issue
  end
  page += 1
end

issues_by_category = issues.group_by {|item| item.category} 
issues_by_category.keys.sort.each do |category|
  print "\n=== #{category}\n\n"
  issues_by_category[category].sort_by {|v| [v.tracker, v.id.to_i]}.each do |issue|
    puts "* #{issue.tracker} ##{issue.id}: #{issue.subject}"
  end
end
