require_dependency 'issues_helper' 

module IssuesHelperPatch
  def self.included(base) # :nodoc:    
    base.send(:include, InstanceMethods)     
    base.class_eval do      
      unloadable
      alias_method_chain :sidebar_queries, :category
    end
  end
  module InstanceMethods    
    def sidebar_queries_with_category
      unless @sidebar_queries
        # User can see public queries and his own queries
        visible = ARCondition.new(["is_public = ? OR user_id = ?", true, (User.current.logged? ? User.current.id : 0)])
        # Project specific queries and global queries
        visible << (@project.nil? ? ["project_id IS NULL"] : ["project_id IS NULL OR project_id = ?", @project.id])
        @sidebar_queries = Query.find(:all, 
                                      :order => "name ASC",
                                      :conditions => visible.conditions)
      end
      @sidebar_queries
    end
    def column_plain_content(column_name, issue)
      column = @query.available_columns.find{|c| c.name == column_name}
  		if column.nil?
  			issue.project.parent ? issue.project.parent.name : issue.project.name if column_name = :main_project
  		else
  			if column.is_a?(QueryCustomFieldColumn)
  				cv = issue.custom_values.detect {|v| v.custom_field_id == column.custom_field.id}
  				show_value(cv)
  			else
  				value = issue.send(column.name.to_s)
  				if value.is_a?(Date)
  					format_date(value)
  				elsif value.is_a?(Time)
  					format_time(value)
  				elsif column.name == :done_ratio
            value.to_s.rjust(3) << '%'
  				else
  					value.to_s
  				end
  			end
  		end
    end
  end
end

IssuesHelper.send(:include, IssuesHelperPatch)