Redmine::WikiFormatting::Macros.register do
  desc "Restricts content access to specific project role IDs. Example {{restrict_access(1,2,4) Only for DevOps team.}}"
  macro :restrict_access do |obj, args, text|
    if User.current.logged?
      membership = User.current.membership(@project)
      if ( membership != nil ) 

        permitted_roles = args.to_a
        permitted_roles.map!{ |e| e.to_i }

        project_roles = membership.roles.to_a
        project_roles.map!{ |e| e.id }

        matching_roles = project_roles & permitted_roles

        if matching_roles.any?
          out = h( textilizable( text, :attachments => obj.attachments ) ) 
        else
          out = h( "Access prohibited - role is not permitted" )
        end 
      elsif (User.current.admin?)
        out = h(textilizable(text))
      else
        out = h( "Access prohibited - no project member" )
      end 
    else
      out = h( "Access prohibited - not logged in" )
    end 
  end 
end

