class CreateJournals < ActiveRecord::Migration[5.2]

  # model removed, but needed for data migration
  class IssueHistory < ActiveRecord::Base; belongs_to :issue; end
  # model removed
  class Permission < ActiveRecord::Base; end

  def self.up
    create_table :journals, force: true do |t|
      t.bigint :journalized_id, default: 0, null: false
      t.string :journalized_type, limit: 30, default: "", null: false
      t.bigint :user_id, default: 0, null: false
      t.text :notes
      t.datetime :created_on, null: false
    end
    create_table :journal_details, force: true do |t|
      t.bigint :journal_id, default: 0, null: false
      t.string :property, limit: 30, default: "", null: false
      t.string :prop_key, limit: 30, default: "", null: false
      t.string :old_value
      t.string :value
    end

    # indexes
    add_index "journals", ["journalized_id", "journalized_type"], :name => "journals_journalized_id"
    add_index "journal_details", ["journal_id"], :name => "journal_details_journal_id"

    Permission.create :controller => "issues", :action => "history", :description => "label_history", :sort => 1006, :is_public => true, :mail_option => 0, :mail_enabled => 0

    # data migration
    IssueHistory.all.each {|h|
      j = Journal.new(:journalized => h.issue, :user_id => h.author_id, :notes => h.notes, :created_on => h.created_on)
      j.details << JournalDetail.new(:property => 'attr', :prop_key => 'status_id', :value => h.status_id)
      j.save
    }

    drop_table :issue_histories
  end

  def self.down
    drop_table :journal_details
    drop_table :journals

    create_table :issue_histories, force: true do |t|
      t.bigint :issue_id, default: 0, null: false
      t.bigint :status_id, default: 0, null: false
      t.bigint :author_id, default: 0, null: false
      t.text :notes, default: ""
      t.datetime :created_on
    end

    add_index "issue_histories", ["issue_id"], :name => "issue_histories_issue_id"

    Permission.where("controller=? and action=?", 'issues', 'history').first.destroy
  end
end
