class CreateTimeEntries < ActiveRecord::Migration[5.2]
  def self.up
    create_table :time_entries do |t|
      t.bigint :project_id,   null: false
      t.bigint :user_id,      null: false
      t.bigint :issue_id   
      t.float :hours,          null: false
      t.string :comments,      limit: 255
      t.bigint :activity_id,  null: false
      t.date :spent_on,        null: false
      t.integer :tyear,        null: false
      t.integer :tmonth,       null: false
      t.integer :tweek,        null: false
      t.datetime :created_on,  null: false
      t.datetime :updated_on,  null: false
    end
    add_index :time_entries, [:project_id], :name => :time_entries_project_id
    add_index :time_entries, [:issue_id], :name => :time_entries_issue_id
  end

  def self.down
    drop_table :time_entries
  end
end
