class CreateMessages < ActiveRecord::Migration[5.2]
  def self.up
    create_table :messages do |t|
      t.bigint :board_id, null: false
      t.bigint :parent_id
      t.string :subject, default: "", null: false
      t.text :content
      t.bigint :author_id
      t.integer :replies_count, default: 0, null: false
      t.bigint :last_reply_id
      t.datetime :created_on, null: false
      t.datetime :updated_on, null: false
    end
    add_index :messages, [:board_id], :name => :messages_board_id
    add_index :messages, [:parent_id], :name => :messages_parent_id
  end

  def self.down
    drop_table :messages
  end
end
