# Redmine - project management software
# Copyright (C) 2006  Jean-Philippe Lang
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

class Setup < ActiveRecord::Migration[5.2]

  class User < ActiveRecord::Base
  end

  # model removed
  class Permission < ActiveRecord::Base; end

  def self.up
    create_table :attachments, force: true do |t|
      t.bigint :container_id, default: 0, null: false
      t.string :container_type, limit: 30, default: "", null: false
      t.string :filename, default: "", null: false
      t.string :disk_filename, default: "", null: false
      t.integer :filesize, default: 0, null: false
      t.string :content_type, limit: 60, default: ""
      t.string :digest, limit: 40, default: "", null: false
      t.bigint :downloads, default: 0, null: false
      t.bigint :author_id, default: 0, null: false
      t.datetime :created_on
    end

    create_table :auth_sources, force: true do |t|
      t.string :type, limit: 30, default: "", null: false
      t.string :name, limit: 60, default: "", null: false
      t.string :host, limit: 60
      t.integer :port
      t.string :account, limit: 60
      t.string :account_password, limit: 60
      t.string :base_dn, limit: 255
      t.string :attr_login, limit: 30
      t.string :attr_firstname, limit: 30
      t.string :attr_lastname, limit: 30
      t.string :attr_mail, limit: 30
      t.boolean :onthefly_register, default: false, null: false
    end

    create_table :custom_fields, force: true do |t|
      t.string :type, limit: 30, default: "", null: false
      t.string :name, limit: 30, default: "", null: false
      t.string :field_format, limit: 30, default: "", null: false
      t.text :possible_values
      t.string :regexp, default: ""
      t.integer :min_length, default: 0, null: false
      t.integer :max_length, default: 0, null: false
      t.boolean :is_required, default: false, null: false
      t.boolean :is_for_all, default: false, null: false
    end

    create_table :custom_fields_projects, :id => false, force: true do |t|
      t.bigint :custom_field_id, default: 0, null: false
      t.bigint :project_id, default: 0, null: false
    end

    create_table :custom_fields_trackers, :id => false, force: true do |t|
      t.bigint :custom_field_id, default: 0, null: false
      t.bigint :tracker_id, default: 0, null: false
    end

    create_table :custom_values, force: true do |t|
      t.string :customized_type, limit: 30, default: "", null: false
      t.bigint :customized_id, default: 0, null: false
      t.bigint :custom_field_id, default: 0, null: false
      t.text :value
    end

    create_table :documents, force: true do |t|
      t.bigint :project_id, default: 0, null: false
      t.bigint :category_id, default: 0, null: false
      t.string :title, limit: 60, default: "", null: false
      t.text :description
      t.datetime :created_on
    end

    add_index "documents", ["project_id"], :name => "documents_project_id"

    create_table :enumerations, force: true do |t|
      t.string :opt, limit: 4, default: "", null: false
      t.string :name, limit: 30, default: "", null: false
    end

    create_table :issue_categories, force: true do |t|
      t.bigint :project_id, default: 0, null: false
      t.string :name, limit: 30, default: "", null: false
    end

    add_index "issue_categories", ["project_id"], :name => "issue_categories_project_id"

    create_table :issue_histories, force: true do |t|
      t.bigint :issue_id, default: 0, null: false
      t.bigint :status_id, default: 0, null: false
      t.bigint :author_id, default: 0, null: false
      t.text :notes
      t.datetime :created_on
    end

    add_index "issue_histories", ["issue_id"], :name => "issue_histories_issue_id"

    create_table :issue_statuses, force: true do |t|
      t.string :name, limit: 30, default: "", null: false
      t.boolean :is_closed, default: false, null: false
      t.boolean :is_default, default: false, null: false
      t.string :html_color, limit: 6, default: "FFFFFF", null: false
    end

    create_table :issues, force: true do |t|
      t.bigint :tracker_id, default: 0, null: false
      t.bigint :project_id, default: 0, null: false
      t.string :subject, default: "", null: false
      t.text :description
      t.date "due_date"
      t.bigint :category_id
      t.bigint :status_id, default: 0, null: false
      t.bigint :assigned_to_id
      t.bigint :priority_id, default: 0, null: false
      t.bigint :fixed_version_id
      t.bigint :author_id, default: 0, null: false
      t.integer :lock_version, default: 0, null: false
      t.datetime :created_on
      t.datetime :updated_on
    end

    add_index "issues", ["project_id"], :name => "issues_project_id"

    create_table :members, force: true do |t|
      t.bigint :user_id, default: 0, null: false
      t.bigint :project_id, default: 0, null: false
      t.bigint :role_id, default: 0, null: false
      t.datetime :created_on
    end

    create_table :news, force: true do |t|
      t.bigint :project_id
      t.string :title, limit: 60, default: "", null: false
      t.string :summary, limit: 255, default: ""
      t.text :description
      t.bigint :author_id, default: 0, null: false
      t.datetime :created_on
    end

    add_index "news", ["project_id"], :name => "news_project_id"

    create_table :permissions, force: true do |t|
      t.string :controller, limit: 30, default: "", null: false
      t.string :action, limit: 30, default: "", null: false
      t.string :description, limit: 60, default: "", null: false
      t.boolean :is_public, default: false, null: false
      t.integer :sort, default: 0, null: false
      t.boolean :mail_option, default: false, null: false
      t.boolean :mail_enabled, default: false, null: false
    end

    create_table :permissions_roles, :id => false, force: true do |t|
      t.bigint :permission_id, default: 0, null: false
      t.bigint :role_id, default: 0, null: false
    end

    add_index "permissions_roles", ["role_id"], :name => "permissions_roles_role_id"

    create_table :projects, force: true do |t|
      t.string :name, limit: 30, default: "", null: false
      t.string :description, default: "", null: false
      t.string :homepage, limit: 60, default: ""
      t.boolean :is_public, default: true, null: false
      t.bigint :parent_id
      t.integer :projects_count, default: 0
      t.datetime :created_on
      t.datetime :updated_on
    end

    create_table :roles, force: true do |t|
      t.string :name, limit: 30, default: "", null: false
    end

    create_table :tokens, force: true do |t|
      t.bigint :user_id, default: 0, null: false
      t.string :action, limit: 30, default: "", null: false
      t.string :value, limit: 40, default: "", null: false
      t.datetime :created_on, null: false
    end

    create_table :trackers, force: true do |t|
      t.string :name, limit: 30, default: "", null: false
      t.boolean :is_in_chlog, default: false, null: false
    end

    create_table :users, force: true do |t|
      t.string :login, limit: 30, default: "", null: false
      t.string :hashed_password, limit: 40, default: "", null: false
      t.string :firstname, limit: 30, default: "", null: false
      t.string :lastname, limit: 30, default: "", null: false
      t.string :mail, limit: 60, default: "", null: false
      t.boolean :mail_notification, default: true, null: false
      t.boolean :admin, default: false, null: false
      t.integer :status, default: 1, null: false
      t.datetime :last_login_on
      t.string :language, limit: 2, default: ""
      t.bigint :auth_source_id
      t.datetime :created_on
      t.datetime :updated_on
    end

    create_table :versions, force: true do |t|
      t.bigint :project_id, default: 0, null: false
      t.string :name, limit: 30, default: "", null: false
      t.string :description, default: ""
      t.date "effective_date"
      t.datetime :created_on
      t.datetime :updated_on
    end

    add_index "versions", ["project_id"], :name => "versions_project_id"

    create_table :workflows, force: true do |t|
      t.bigint :tracker_id, default: 0, null: false
      t.bigint :old_status_id, default: 0, null: false
      t.bigint :new_status_id, default: 0, null: false
      t.bigint :role_id, default: 0, null: false
    end

    # project
    Permission.create :controller => "projects", :action => "show", :description => "label_overview", :sort => 100, :is_public => true
    Permission.create :controller => "projects", :action => "changelog", :description => "label_change_log", :sort => 105, :is_public => true
    Permission.create :controller => "reports", :action => "issue_report", :description => "label_report_plural", :sort => 110, :is_public => true
    Permission.create :controller => "projects", :action => "settings", :description => "label_settings", :sort => 150
    Permission.create :controller => "projects", :action => "edit", :description => "button_edit", :sort => 151
    # members
    Permission.create :controller => "projects", :action => "list_members", :description => "button_list", :sort => 200, :is_public => true
    Permission.create :controller => "projects", :action => "add_member", :description => "button_add", :sort => 220
    Permission.create :controller => "members", :action => "edit", :description => "button_edit", :sort => 221
    Permission.create :controller => "members", :action => "destroy", :description => "button_delete", :sort => 222
    # versions
    Permission.create :controller => "projects", :action => "add_version", :description => "button_add", :sort => 320
    Permission.create :controller => "versions", :action => "edit", :description => "button_edit", :sort => 321
    Permission.create :controller => "versions", :action => "destroy", :description => "button_delete", :sort => 322
    # issue categories
    Permission.create :controller => "projects", :action => "add_issue_category", :description => "button_add", :sort => 420
    Permission.create :controller => "issue_categories", :action => "edit", :description => "button_edit", :sort => 421
    Permission.create :controller => "issue_categories", :action => "destroy", :description => "button_delete", :sort => 422
    # issues
    Permission.create :controller => "projects", :action => "list_issues", :description => "button_list", :sort => 1000, :is_public => true
    Permission.create :controller => "projects", :action => "export_issues_csv", :description => "label_export_csv", :sort => 1001, :is_public => true
    Permission.create :controller => "issues", :action => "show", :description => "button_view", :sort => 1005, :is_public => true
    Permission.create :controller => "issues", :action => "download", :description => "button_download", :sort => 1010, :is_public => true
    Permission.create :controller => "projects", :action => "add_issue", :description => "button_add", :sort => 1050, :mail_option => 1, :mail_enabled => 1
    Permission.create :controller => "issues", :action => "edit", :description => "button_edit", :sort => 1055
    Permission.create :controller => "issues", :action => "change_status", :description => "label_change_status", :sort => 1060, :mail_option => 1, :mail_enabled => 1
    Permission.create :controller => "issues", :action => "destroy", :description => "button_delete", :sort => 1065
    Permission.create :controller => "issues", :action => "add_attachment", :description => "label_attachment_new", :sort => 1070
    Permission.create :controller => "issues", :action => "destroy_attachment", :description => "label_attachment_delete", :sort => 1075
    # news
    Permission.create :controller => "projects", :action => "list_news", :description => "button_list", :sort => 1100, :is_public => true
    Permission.create :controller => "news", :action => "show", :description => "button_view", :sort => 1101, :is_public => true
    Permission.create :controller => "projects", :action => "add_news", :description => "button_add", :sort => 1120
    Permission.create :controller => "news", :action => "edit", :description => "button_edit", :sort => 1121
    Permission.create :controller => "news", :action => "destroy", :description => "button_delete", :sort => 1122
    # documents
    Permission.create :controller => "projects", :action => "list_documents", :description => "button_list", :sort => 1200, :is_public => true
    Permission.create :controller => "documents", :action => "show", :description => "button_view", :sort => 1201, :is_public => true
    Permission.create :controller => "documents", :action => "download", :description => "button_download", :sort => 1202, :is_public => true
    Permission.create :controller => "projects", :action => "add_document", :description => "button_add", :sort => 1220
    Permission.create :controller => "documents", :action => "edit", :description => "button_edit", :sort => 1221
    Permission.create :controller => "documents", :action => "destroy", :description => "button_delete", :sort => 1222
    Permission.create :controller => "documents", :action => "add_attachment", :description => "label_attachment_new", :sort => 1223
    Permission.create :controller => "documents", :action => "destroy_attachment", :description => "label_attachment_delete", :sort => 1224
    # files
    Permission.create :controller => "projects", :action => "list_files", :description => "button_list", :sort => 1300, :is_public => true
    Permission.create :controller => "versions", :action => "download", :description => "button_download", :sort => 1301, :is_public => true
    Permission.create :controller => "projects", :action => "add_file", :description => "button_add", :sort => 1320
    Permission.create :controller => "versions", :action => "destroy_file", :description => "button_delete", :sort => 1322

    # create default administrator account
    user = User.new :firstname => "Redmine",
                    :lastname => "Admin",
                    :mail => "admin@example.net",
                    :mail_notification => true,
                    :status => 1
    user.login = 'admin'
    user.hashed_password = "d033e22ae348aeb5660fc2140aec35850c4da997"
    user.admin = true
    user.save


  end

  def self.down
    drop_table :attachments
    drop_table :auth_sources
    drop_table :custom_fields
    drop_table :custom_fields_projects
    drop_table :custom_fields_trackers
    drop_table :custom_values
    drop_table :documents
    drop_table :enumerations
    drop_table :issue_categories
    drop_table :issue_histories
    drop_table :issue_statuses
    drop_table :issues
    drop_table :members
    drop_table :news
    drop_table :permissions
    drop_table :permissions_roles
    drop_table :projects
    drop_table :roles
    drop_table :trackers
    drop_table :tokens
    drop_table :users
    drop_table :versions
    drop_table :workflows
  end
end
