class CreateQueries < ActiveRecord::Migration[5.2]
  def self.up
    create_table :queries, force: true do |t|
      t.bigint :project_id
      t.string :name, default: "", null: false
      t.text :filters
      t.bigint :user_id, default: 0, null: false
      t.boolean :is_public, default: false, null: false
    end
  end

  def self.down
    drop_table :queries
  end
end
