class CreateChanges < ActiveRecord::Migration[5.2]
  def self.up
    create_table :changes do |t|
      t.bigint :changeset_id, null: false
      t.string :action,  limit: 1, default: "", null: false
      t.string :path, default: "", null: false
      t.string :from_path
      t.integer :from_revision
    end
    add_index :changes, [:changeset_id], :name => :changesets_changeset_id
  end

  def self.down
    drop_table :changes
  end
end
