class CreateCustomFieldsRoles < ActiveRecord::Migration[5.2]
  def self.up
    create_table :custom_fields_roles, :id => false do |t|
      t.bigint :custom_field_id, null: false
      t.bigint :role_id, null: false
    end
    add_index :custom_fields_roles, [:custom_field_id, :role_id], :unique => true, :name => :custom_fields_roles_ids
    CustomField.where({:type => 'IssueCustomField'}).update_all({:visible => true})
  end

  def self.down
    drop_table :custom_fields_roles
  end
end
