class CreateWikiContents < ActiveRecord::Migration[5.2]
  def self.up
    create_table :wiki_contents do |t|
      t.bigint :page_id, null: false
      t.bigint :author_id
      t.text :text
      t.string :comments, limit: 255, default: ""
      t.datetime :updated_on, null: false
      t.integer :version, null: false
    end
    add_index :wiki_contents, :page_id, :name => :wiki_contents_page_id

    create_table :wiki_content_versions do |t|
      t.bigint :wiki_content_id, null: false
      t.bigint :page_id, null: false
      t.bigint :author_id
      t.binary :data
      t.string :compression, limit: 6, default: ""
      t.string :comments, limit: 255, default: ""
      t.datetime :updated_on, null: false
      t.integer :version, null: false
    end
    add_index :wiki_content_versions, :wiki_content_id, :name => :wiki_content_versions_wcid
  end

  def self.down
    drop_table :wiki_contents
    drop_table :wiki_content_versions
  end
end
