class CreateChangesets < ActiveRecord::Migration[5.2]
  def self.up
    create_table :changesets do |t|
      t.bigint :repository_id, null: false
      t.integer :revision, null: false
      t.string :committer, limit: 30
      t.datetime :committed_on, null: false
      t.text :comments
    end
    add_index :changesets, [:repository_id, :revision], :unique => true, :name => :changesets_repos_rev
  end

  def self.down
    drop_table :changesets
  end
end
