class CreateBoards < ActiveRecord::Migration[5.2]
  def self.up
    create_table :boards do |t|
      t.bigint :project_id, null: false
      t.string :name, default: "", null: false
      t.string :description
      t.integer :position, default: 1
      t.integer :topics_count, default: 0, null: false
      t.integer :messages_count, default: 0, null: false
      t.bigint :last_message_id
    end
    add_index :boards, [:project_id], :name => :boards_project_id
  end

  def self.down
    drop_table :boards
  end
end
