env = (<<'EOS')
  require "bundler/inline"

  gemfile(false) do
    source "https://rubygems.org"
    gem "rails", '5.2.3'
    gem "get_process_mem", "0.2.4"
    gem "sys-proctable", "1.1.5" if Gem.win_platform?
    gem "memory_profiler", "0.9.14" if profile
  end

  require 'benchmark'
  require 'get_process_mem'

  profile ||= false
  MemoryProfiler.start if profile
  result = Benchmark.measure { test }
  profile = MemoryProfiler.stop if profile
  puts "benchmark #{name}, mem: #{GetProcessMem.new.mb}mb, time: #{result.total}s"
  if profile
    profile_name = "profile_#{name}_#{Process.pid}.txt"
    puts "Profile written to: #{profile_name}"
    profile.pretty_print(to_file: profile_name)
  end
EOS

new = <<-RUBY
  def test
    require 'rails'

    require 'active_model/railtie'
    require 'active_job/railtie'
    require 'active_record/railtie'
    require 'active_storage/engine'
    require 'action_controller/railtie'
    require 'action_mailer/railtie'
    require 'action_view/railtie'
    require 'action_cable/engine'
    # require 'sprockets/railtie'
    require 'rails/test_unit/railtie'
  end
RUBY

old = <<-RUBY
  def test
    require 'rails/all'
  end
RUBY

(ENV['ITERATIONS'] || 10).to_i.times do
  ['new', 'old'].each do |name|
    pid = Process.spawn(RbConfig.ruby, "-eprofile=#{!!ENV['PROFILE']};name='#{name}';#{eval(name)}#{env}")
    Process.wait pid
  end
end
