/* Albanian initialisation for the jQuery UI date picker plugin. */
/* Written by Besnik Bleta. */
(function( factory ) {
	if ( typeof define === "function" && define.amd ) {

		// AMD. Register as an anonymous module.
		define([ "../datepicker" ], factory );
	} else {

		// Browser globals
		factory( jQuery.datepicker );
	}
}(function( datepicker ) {

datepicker.regional['sq'] = {
	closeText: 'U bë',
	prevText: 'E mëpar.',
	nextText: 'Pasuesja',
	currentText: 'Sot',
	monthNames: ['Janar','Shkurt','Mars','Prill','Maj','Qershor',
	'Korrik','Gusht','Shtator','Tetor','Nëntor','Dhjetor'],
	monthNamesShort: ['Jan', 'Shk', 'Mar', 'Pri', 'Maj', 'Qer',
	'Kor', 'Gus', 'Sht', 'Tet', 'Nën', 'Dhj'],
	dayNames: ['E dielë', 'E hënë', 'E martë', 'E mërkurë', 'E enjte', 'E premte', 'E shtunë'],
	dayNamesShort: ['Die', 'Hën', 'Mar', 'Mër', 'Enj', 'Pre', 'Sht'],
	dayNamesMin: ['Di','Hë','Ma','Më','En','Pr','Sh'],
	weekHeader: 'Jv',
	dateFormat: 'dd.mm.yy',
	firstDay: 1,
	isRTL: false,
	showMonthAfterYear: false,
	yearSuffix: ''};
datepicker.setDefaults(datepicker.regional['sq']);

return datepicker.regional['sq'];

}));
