# size.py - returns the size of the files in the 
#           repository without checking them out
#
# Copyright 2008 Ian P. Cardenas <ipc@srand.net>
#
# This software may be used and distributed according to the terms
# of the GNU General Public License, incorporated herein by reference.
#
# $Id$
#
# Setup in hgrc:
#
#   [extensions]
#   # enable extension
#   hgext.size =
# # Run "hg help size" to get info on configuration.  
'''size information in local repositories
'''

from mercurial import hg, cmdutil

def size(ui, repo, file1, *pats, **opts):
    """output the size of files
	returns the size of the files in a local repository
    """
    ctx = repo[opts['rev']]
    err = 1
    m = cmdutil.match(repo, (file1,) + pats, opts)
    for abs in ctx.walk(m):
        fp = cmdutil.make_file(repo, opts['output'], ctx.node(), pathname=abs)
        size = ctx[abs].size()
	formatted_size = "%d\n" % ( size )
        fp.write(formatted_size)
        err = 0
    return err

walkopts = [
    ('I', 'include', [], 'include names matching the given patterns'),
    ('X', 'exclude', [], 'exclude names matching the given patterns'),
]

cmdtable = {
    "size": (size,
         [('o', 'output', '', 'print output to file with formatted name'),
          ('r', 'rev', '', 'print the given revision'),
         ] + walkopts,
         'hg size [OPTION]... FILE...')
}

