# a patch against imports_controller
ActiveSupport::Reloader.to_prepare do
  unless ImportsController.included_modules.include?(SsImport::ImportsControllerPatch)
    ImportsController.send(:include, SsImport::ImportsControllerPatch)
  end
end

require_dependency "imports_controller"

module SsImport
  module ImportsControllerPatch
    def self.included(base) # :nodoc:
      base.send(:include, InstanceMethods)
      base.extend(ClassMethods)

      base.class_eval do
        unloadable
        alias_method :mapping_without_ss, :mapping
        alias_method :mapping, :mapping_with_ss

        alias_method :find_import_without_ss, :find_import
        alias_method :find_import, :find_import_with_ss

        alias_method :update_from_params_without_ss, :update_from_params
        alias_method :update_from_params, :update_from_params_with_ss
      end
    end

    module InstanceMethods
      # replacement of mapping that includes premap and trial build_objects
      def mapping_with_ss
        ## try mapping fields only when project or tracker is changed
        if @import.settings["dirty"]
          ## refrect fields difference
          ## core fields
          core_fields = @import.mappable_core_fields_for_ss
          core_fields.each do |attribute|
            attribute = attribute.sub(/_ids?\z/, "") if attribute != "parent_issue_id" && attribute != "unique_id"
            if attribute == "tracker" && @import.settings["mapping"]["tracker"].to_s =~ /\Avalue:(\d+)\z/
              ## tracker is designated for all records. do nothing.
            else
              field_symbol = "field_#{attribute}".to_sym
              if field_symbol
                col_num = @import.headers.find_index(l(field_symbol)).to_s
                if col_num
                  @import.settings["mapping"].merge!({ "#{attribute}" => col_num })
                end
              end
            end
          end
          ## custom fields
          custom_fields = @import.mappable_custom_fields_for_ss
          custom_fields.each do |field|
            col_num = @import.headers.find_index(field.name)
            if col_num
              @import.settings["mapping"].merge!({ "cf_#{field.id}" => col_num.to_s })
            end
          end
          ## initialize col_x => ys
          i = 0
          @import.headers.each do |header|
            if selected = @import.attribute_options_for_ss.find_index { |text, value| text == header }
              @import.settings["mapping"].merge!({ "col_#{i}" => selected.to_s })
            else
              @import.settings["mapping"].merge!({ "col_#{i}" => "" })
            end
            i += 1
          end
        else ## neither project nor tracker is changed. just refrect col_x => y changes.
          # parse { "col_[0-9]+" => "[0-9]+" } mappings then overrides { :field => col } ones
          inverted_mappings = {}
          @import.settings["mapping"].each do |key, value|
            if key.to_s.match("col_[0-9]+")
              col_num = key.to_s.sub("col_", "").to_i
              field_name = @import.mappable_fields_for_ss[value.to_i]

              if field_name == "tracker" && @import.settings["mapping"]["tracker"].to_s =~ /\Avalue:(\d+)\z/
                inverted_mappings.merge!({ key => "" })
              else
                inverted_mappings.merge!({ field_name => col_num.to_s })
              end
            end
          end
          @import.settings["mapping"].merge!(inverted_mappings)
        end
        # errors are added into @import.settings["errors"] as { position => { attribute => col_num }, ... }
        @import.validate_objects_for_ss
        @import.save!

        if request.post?
          respond_to do |format|
            format.html {
              if params[:previous]
                redirect_to import_settings_path(@import)
                return
              elsif params[:retry]
                @matrix = nil
                # render :action => "mapping"
                redirect_to import_mapping_path(@import)
                return
              else
                redirect_to import_run_path(@import)
                return
              end
            }
            format.js # updates mapping form on project or tracker change
          end
        end
      end

      # Calls update_from_params no matter whther the request is post or js
      def find_import_with_ss
        @import = Import.where(:user_id => User.current.id, :filename => params[:id]).first
        if @import.nil?
          render_404
          return
        elsif @import.finished? && action_name != "show"
          redirect_to import_path(@import)
          return
        end
        update_from_params if request.post?
      end

      def update_from_params_with_ss
        if params[:import_settings].present?
          settings = params[:import_settings].to_unsafe_hash

          if @import.settings["mapping"] && settings["mapping"]
            if @import.settings["mapping"]["project_id"].to_s != settings["mapping"]["project_id"].to_s ||
               @import.settings["mapping"]["tracker"].to_s != settings["mapping"]["tracker"].to_s
              settings.merge!({ "dirty" => true })
            else
              settings.merge!({ "dirty" => false })
            end
          else
            settings.merge!({ "dirty" => true })
          end
          @import.settings ||= {}
          @import.settings.merge!(settings)
          @import.save!
        end
      end
    end

    module ClassMethods
    end
  end
end
