# a patch against imports_controller
ActiveSupport::Reloader.to_prepare do
  unless ImportsController.included_modules.include?(SsImport::ImportsControllerPatch)
    ImportsController.send(:include, SsImport::ImportsControllerPatch)
  end
end

require_dependency "imports_controller"

module SsImport
  module ImportsControllerPatch
    def self.included(base) # :nodoc:
      base.send(:include, InstanceMethods)
      base.extend(ClassMethods)

      base.class_eval do
        unloadable
        alias_method :settings_without_ss, :settings
        alias_method :settings, :settings_with_ss

        alias_method :mapping_without_ss, :mapping
        alias_method :mapping, :mapping_with_ss

        alias_method :find_import_without_ss, :find_import
        alias_method :find_import, :find_import_with_ss

        alias_method :update_from_params_without_ss, :update_from_params
        alias_method :update_from_params, :update_from_params_with_ss
      end
    end

    module InstanceMethods
      # changes redirection from import_mapping_path to import_run_validation_path
      def settings_with_ss
        if request.post? && @import.parse_file
          redirect_to import_mapping_path(@import)
          # redirect_to import_run_validation_path(@import)
        end
      rescue CSV::MalformedCSVError, EncodingError => e
        if e.is_a?(CSV::MalformedCSVError) && e.message !~ /Invalid byte sequence/
          flash.now[:error] = l(:error_invalid_csv_file_or_settings)
        else
          flash.now[:error] = l(:error_invalid_file_encoding, :encoding => ERB::Util.h(@import.settings["encoding"]))
        end
      rescue SystemCallError => e
        flash.now[:error] = l(:error_can_not_read_import_file)
      end

      # replacement of mapping that includes premap and trial build_objects
      def mapping_with_ss
        @custom_fields = @import.mappable_custom_fields
        # Premapping shall occur only when @import.settings["mapping"] has only project_id or none.
        # After it is filled by this, it shall reflect the form only.
        unless @import.settings["mapping"] && @import.settings["mapping"].count > 1
          @custom_fields.each do |field|
            colunm = @import.headers.find_index(field.name).to_s
            if colunm
              if @import.settings["mapping"]
                @import.settings["mapping"].merge!({ "cf_#{field.id}" => colunm })
              else
                @import.settings.merge!("mapping" => { "cf_#{field.id}" => colunm })
              end
            end
          end
          @core_fields = @import.mappable_core_fields_for_ss
          @core_fields.each do |attribute|
            field_symbol_str = "field_" + attribute
            attribute = attribute.sub(/_ids?\z/, "") unless attribute == "parent_issue_id" || attribute == "unique_id"
            if field_symbol_str
              colunm = @import.headers.find_index(l(field_symbol_str.to_sym)).to_s
              if colunm
                if @import.settings["mapping"]
                  @import.settings["mapping"].merge!({ "#{attribute}" => colunm })
                else
                  @import.settings.merge!("mapping" => { "#{attribute}" => colunm })
                end
              end
            end
          end
        end

        # errors are added into @import.settings["errors"] as { position => { attribute => column }, ... }
        @import.validate_objects_for_ss

        if request.post?
          respond_to do |format|
            format.html {
              if params[:previous]
                redirect_to import_settings_path(@import)
              elsif params[:retry]
                @matrix = nil
                render :action => "mapping"
              else
                redirect_to import_run_path(@import)
              end
            }
            format.js # updates mapping form on project or tracker change
          end
        end
      end

      # Calls update_from_params no matter whther the request is post or js
      def find_import_with_ss
        @import = Import.where(:user_id => User.current.id, :filename => params[:id]).first
        if @import.nil?
          render_404
          return
        elsif @import.finished? && action_name != "show"
          redirect_to import_path(@import)
          return
        end
        update_from_params # if request.post?
      end

      # add { :field => col } ones
      def update_from_params_with_ss
        if params[:import_settings].present?
          settings = params[:import_settings].to_unsafe_hash

          if settings["mapping"]
            inverted_mappings = {}
            tracker_desginated = settings["mapping"]["tracker"].to_s =~ /\Avalue:(\d+)\z/ ? true : false

            settings["mapping"].each do |key, value|
              if key.to_s.match("col_[0-9]+") && value.to_s.strip != ""
                table_index = key.to_s.sub("col_", "").to_i
                field_name = @import.mappable_fields_for_ss[value.to_i]

                if tracker_desginated && field_name.match("tracker")
                  inverted_mappings.merge!({ key => "" })
                else
                  inverted_mappings.merge!({ field_name => table_index.to_s })
                end

              end
            end
            settings["mapping"].merge!(inverted_mappings)
          end
          @import.settings ||= {}
          @import.settings.merge!(settings)
          @import.save!
        end
      end
    end

    module ClassMethods
    end
  end
end
