module ImportsHelper
  def options_for_mapping_select_for_ss(import, field, options = {})
    tags = "".html_safe
    blank_text = options[:required] ? "-- #{l(:actionview_instancetag_blank_option)} --" : "&nbsp;".html_safe
    tags << content_tag("option", blank_text, :value => "")

    selected = nil
    col_header = import.headers[field.sub("col_", "").to_i]
    if "" == import.mapping[field]
      selected = import.mapping[field]
    else
      selected = import.attribute_options_for_ss.find_index{ |text, value| text == col_header }
    end
    # when in import destination, tracker is specified as CSV/SS column, column desgination sticks to it.
    if col_header == l(:field_tracker) && !(import.mapping["tracker"] =~ /\Avalue:(\d+)\z/)
      selected = import.attribute_options_for_ss.find_index{ |text, value| text == col_header }
    end
    tags << options_for_select(import.attribute_options_for_ss, selected)

    if values = options[:values]
      tags << content_tag("option", "--", :disabled => true)
      tags << options_for_select(values.map { |text, value| [text, "value:#{value}"] }, import.mapping[field] || options[:default_value])
    end
    tags
  end

  def mapping_select_tag_for_ss(import, field, options = {})
    name = "import_settings[mapping][#{field}]"
    select_tag name, options_for_mapping_select_for_ss(import, field, options), :id => "import_mapping_#{field}"
  end

  def mapping_error_tag_for_ss(import, row, column)
    errors = import.settings["errors"][row]
    if errors
      error = errors.key(column.to_s)
      if error
        name = "import_settings[errors][#{column}]"
        content_tag name, l(:label_error), :style => "color:red"
      end
    end
  end

  def mapping_ignore_tag_for_ss(import, row, column)
    ignores = import.settings["ignores"][row]
    if ignores
      ignore = ignores.key(column.to_s)
      if ignore
        name = "import_settings[ignores][#{column}]"
        content_tag name, l(:label_ignore), :style => "color:blue"
      end
    end
  end

end

