# a patch against Import model
ActiveSupport::Reloader.to_prepare do
  unless IssueImport.included_modules.include?(SsImport::IssueImportPatch)
    IssueImport.send(:include, SsImport::IssueImportPatch)
  end
end

require_dependency "issue_import"
require "roo"

module SsImport
  module IssueImportPatch
    def self.included(base) # :nodoc:
      base.send(:include, InstanceMethods)
      base.include(ClassMethods)

      base.class_eval do
        unloadable
        alias_method :build_object_without_ss, :build_object
        alias_method :build_object, :build_object_with_ss
      end
    end

    module InstanceMethods
      # inspired from issue_import.rb mappable_custom_fields
      def mappable_core_fields_for_ss
        attributes = []
        fields = []
        if tracker
          issue = Issue.new
          issue.project = project
          issue.tracker = tracker
          attributes = issue.safe_attribute_names(user)
        elsif project
          issue = Issue.new
          issue.project = project
          attributes = issue.safe_attribute_names(user)
        end
        # remove unnecessary attributes
        ["project_id", "custom_field_values", "custom_fields",
         "lock_version", "watcher_user_ids", "deleted_attachment_ids"].each do |unnecessary|
          attributes.delete(unnecessary)
        end
        ## add "#" to core fields list for update import
        fields << "#"
        ## add "exclude" to core fields list for line exclusion
        fields << "exclude"
        ## add "unique_id" to core fields list
        fields << "unique_id"
        # remove "_ids" from field names except "parent_issue_id"
        attributes.each do |attribute|
          fields << attribute.sub(/_ids?\z/, "") unless attribute == "parent_issue_id"
          fields << attribute if attribute == "parent_issue_id"
        end
        ## add "related_issues" to fields list for relations importation
        fields << "related_issues"

        fields
      end

      # concatenates core fields and custom fields as field names
      def mappable_fields_for_ss
        mappable_fields = self.mappable_core_fields_for_ss

        self.mappable_custom_fields.each do |cf|
          mappable_fields << "cf_#{cf.id.to_s}"
        end
        mappable_fields
      end

      # makes local language version of fields list for select
      def attribute_options_for_ss
        attributes = []
        core_fields = self.mappable_core_fields_for_ss
        core_fields.each do |field|
          field_symbol_str = "field_" + field
          local_attribute_name = l(field_symbol_str.to_sym)
          if local_attribute_name
            attributes << local_attribute_name
          end
        end

        custom_fields = self.mappable_custom_fields
        custom_fields.each do |field|
          attributes << field.name
        end
        i = -1
        attributes.map { |h| [h, i += 1] }
      end

      # validates each row of CSV/SS by tentatively build_object
      def validate_objects_for_ss
        self.settings["errors"] = {}
        self.settings["ignores"] = {}
        self.settings["excludes"] = {}

        read_items do |row, position|
          errors_per_position = {}
          ignores_per_position = {}
          duplicated_unique_id = []

          if exclude = row_value(row, "exclude")
            self.settings["excludes"].merge!({ position => true })
            next
          end
          issue = Issue.new
          issue.author = user

          if update?
            if issue_id = row_value(row, "#")
              issue = Issue.find_by_id(issue_id.to_i)
              unless issue && issue.project_id.to_s == mapping["project_id"]
                errors_per_position.merge!({ "#" => mapping["#"] })
                issue = Issue.new
              end
            else
              # missing issue_ids while update import.
              errors_per_position.merge!({ "#" => mapping["#"] })
            end
          else # means create import
            if issue_id = row_value(row, "#")
              # issue ids are included while create import.
              ignores_per_position.merge!({ "#" => mapping["#"] }) unless use_unique_id?
            end
          end

          ## Project: mandatory
          if update?
            unless issue.project_id.to_s == mapping["project_id"]
              errors_per_position.merge!({ "project_id" => mapping["project_id"] })
            end
          else
            attributes = { "project_id" => mapping["project_id"] }
            issue.send :safe_attributes=, attributes, user
            unless issue.project_id == mapping["project_id"].to_i
              errors_per_position.merge!({ "project_id" => mapping["project_id"] })
            end
          end
          ## Tracker: mandatory
          tracker_id = nil
          if tracker
            tracker_id = tracker.id
          elsif tracker_name = row_value(row, "tracker")
            tracker_id = allowed_target_trackers.named(tracker_name).first.try(:id)
          end
          attributes = { "tracker_id" => tracker_id }
          issue.send :safe_attributes=, attributes, user
          unless issue.tracker && issue.tracker_id == tracker_id
            errors_per_position.merge!({ "tracker" => mapping["tracker"] })
          end
          ## Subject: mandatory
          attributes = { "subject" => row_value(row, "subject") }
          issue.send :safe_attributes=, attributes, user
          unless issue.subject && issue.subject == row_value(row, "subject")
            errors_per_position.merge!({ "subject" => mapping["subject"] })
          end
          ## Description: non-mandatory. just left blank unless specified.
          if description = row_value(row, "description")
            description = nil if description == "nil"
            attributes = { "description" => description }
            issue.send :safe_attributes=, attributes, user
            unless issue.description && issue.description == row_value(row, "description")
              if issue.tracker.core_fields.include?("description")
                errors_per_position.merge!({ "description" => mapping["description"] })
              else
                ignores_per_position.merge!({ "description" => mapping["description"] })
              end
            end
          end
          ## Status: non-mandatory. defaults to "default status"
          if status_name = row_value(row, "status")
            if status_id = IssueStatus.named(status_name).first.try(:id)
              attributes = { "status_id" => status_id }
              issue.send :safe_attributes=, attributes, user
              unless issue.status && issue.status.name == row_value(row, "status")
                if issue.tracker && issue.tracker.core_fields.include?("status")
                  errors_per_position.merge!({ "status" => mapping["status"] })
                else
                  ignores_per_position.merge!({ "status" => mapping["status"] })
                end
              end
            else
              errors_per_position.merge!({ "status" => mapping["status"] })
            end
          end
          ## Priority: non-mandatory. defaults to "default priority"
          if priority_name = row_value(row, "priority")
            if priority_id = IssuePriority.active.named(priority_name).first.try(:id)
              attributes = { "priority_id" => priority_id }
              issue.send :safe_attributes=, attributes, user
              unless issue.priority && issue.priority.name == row_value(row, "priority")
                if issue.tracker.core_fields.include?("priority")
                  errors_per_position.merge!({ "priority" => mapping["priority"] })
                else
                  ignores_per_position.merge!({ "priority" => mapping["priority"] })
                end
              end
            else
              ## the priority name is not allowed to the project, the tracker or the user.
              errors_per_position.merge!({ "priority" => mapping["priority"] })
            end
          end
          ## Category: non-mandatory. just left blank unless specified.
          if issue.project && category_name = row_value(row, "category")
            if category = issue.project.issue_categories.named(category_name).first
              attributes = { "category_id" => category.id }
              issue.send :safe_attributes=, attributes, user
            elsif create_categories?
              ## should not create category during validation. Just overlook and continue.
              # category = issue.project.issue_categories.build
              # category.name = category_name
              # if category.save
              #   attributes["category_id"] = category.id
              # end
            end
            if category_name == "nil"
              attributes = { "category_id" => nil }
              issue.send :safe_attributes=, attributes, user
            end
            unless create_categories?
              unless (issue.category && issue.category.name == row_value(row, "category")) ||
                     (issue.category_id == nil && row_value(row, "category") == "nil")
                if issue.tracker.core_fields.include?("category_id")
                  errors_per_position.merge!({ "category" => mapping["category"] })
                else
                  ignores_per_position.merge!({ "category" => mapping["category"] })
                end
              end
            end
          end
          ## Assignee: non-mandatory. just left blank unless specified.
          if assignee_name = row_value(row, "assigned_to")
            if issue.project && issue.tracker && assignee = Principal.detect_by_keyword(issue.assignable_users, assignee_name)
              attributes = { "assigned_to_id" => assignee.id }
              issue.send :safe_attributes=, attributes, user
              unless issue.assigned_to && issue.assigned_to.name == row_value(row, "assigned_to")
                if issue.tracker.core_fields.include?("assigned_to")
                  errors_per_position.merge!({ "assigned_to" => mapping["assigned_to"] })
                else
                  ignores_per_position.merge!({ "assigned_to" => mapping["assigned_to"] })
                end
              end
            elsif assignee_name == "nil"
              ## for "assigned_to_id", safe_attributes= does not effect ...
              # attributes = { "assigned_to_id" => nil }
              # issue.send :safe_attributes=, attributes, user
              issue.assigned_to_id = nil
              errors_per_position.merge!({ "assigned_to" => mapping["assigned_to"] }) unless issue.assigned_to == nil
            else
              ## the assignee is not allowed.
              errors_per_position.merge!({ "assigned_to" => mapping["assigned_to"] })
            end
          end
          ## fixed version: non-mandatory. just left blank unless specified.
          if issue.project && version_name = row_value(row, "fixed_version")
            version =
              issue.project.versions.named(version_name).first ||
              issue.project.shared_versions.named(version_name).first
            if version
              attributes = { "fixed_version_id" => version.id }
              issue.send :safe_attributes=, attributes, user
            elsif create_versions?
              ## should not create version during validation. Just overlook and continue.
              # version = issue.project.versions.build
              # version.name = version_name
              # if version.save
              #   attributes["fixed_version_id"] = version.id
              # end
            end
            if version_name == "nil"
              attributes = { "fixed_version_id" => nil }
              issue.send :safe_attributes=, attributes, user
            end
            unless create_versions?
              unless (issue.fixed_version && issue.fixed_version.name == row_value(row, "fixed_version")) ||
                     (issue.fixed_version == nil && row_value(row, "fixed_version") == "nil")
                if issue.tracker.core_fields.include?("fixed_version_id")
                  errors_per_position.merge!({ "fixed_version" => mapping["fixed_version"] })
                else
                  ignores_per_position.merge!({ "fixed_version" => mapping["fixed_version"] })
                end
              end
            end
          end
          ## is private: non-mandatory: just left false unless specified as :general_text_yes or "1".
          if is_private = row_value(row, "is_private")
            if yes?(is_private)
              attributes = { "is_private" => "1" }
              issue.send :safe_attributes=, attributes, user
              unless issue.is_private == yes?(is_private)
                if issue.tracker.core_fields.include?("is_private")
                  errors_per_position.merge!({ "is_private" => mapping["is_private"] })
                else
                  ignores_per_position.merge!({ "is_private" => mapping["is_private"] })
                end
              end
            end
          end
          ## unique ID: non-mandatory and import specific column.
          if unique_id = row_value(row, "unique_id")
            unique_ids = @matrix.collect { |row| row[mapping["unique_id"].to_i] }
            duplicated_unique_ids = unique_ids.keep_if { |item| unique_ids.count(item) > 1 }
            if duplicated_unique_ids.include?(row_value(row, "unique_id"))
              errors_per_position.merge!({ "unique_id" => mapping["unique_id"] })
            end
          end
          ## parent issue id: non-mandatory.
          ## There are 2 cases that points existing issue and that points unique ID of another line,
          if parent_issue_id = row_value(row, "parent_issue_id")
            if use_unique_id?
              # refers to other row with unique id
              unique_ids = @matrix.collect { |row| row[mapping["unique_id"].to_i] }
              unless unique_ids.include?(parent_issue_id)
                errors_per_position.merge!({ "parent_issue_id" => mapping["parent_issue_id"] })
              end
            elsif parent_issue_id.to_s =~ /\A\d+\z/ && parent_issue = Issue.find_by_id(parent_issue_id)
              # refers to existing issue
              unless issue.valid_parent_project?(parent_issue)
                errors_per_position.merge!({ "parent_issue_id" => mapping["parent_issue_id"] })
              end
            elsif parent_issue_id == "nil"
              attributes = { "parent_issue_id" => nil }
              issue.send :safe_attributes=, attributes, user
              errors_per_position.merge!({ "parent_issue_id" => mapping["parent_issue_id"] }) unless issue.parent_issue_id == nil
            else
              # Something is odd
              errors_per_position.merge!({ "parent_issue_id" => mapping["parent_issue_id"] })
            end
          end
          ## start date and due date.
          if row_value(row, "start_date") == "nil"
            attributes = { "start_date" => nil }
            issue.send :safe_attributes=, attributes, user
            unless issue.start_date == nil
              if issue.tracker.core_fields.include?("start_date")
                errors_per_position.merge!({ "start_date" => mapping["start_date"] })
              else
                ignores_per_position.merge!({ "start_date" => mapping["start_date"] })
              end
            end
          elsif start_date = row_date(row, "start_date")
            attributes = { "start_date" => start_date }
            issue.send :safe_attributes=, attributes, user
            unless issue.start_date == row_date(row, "start_date")
              if issue.tracker.core_fields.include?("start_date")
                errors_per_position.merge!({ "start_date" => mapping["start_date"] })
              else
                ignores_per_position.merge!({ "start_date" => mapping["start_date"] })
              end
            end
          end
          if row_value(row, "due_date") == "nil"
            attributes = { "due_date" => nil }
            issue.send :safe_attributes=, attributes, user
            unless issue.due_date == nil
              if issue.tracker.core_fields.include?("due_date")
                errors_per_position.merge!({ "due_date" => mapping["due_date"] })
              else
                ignores_per_position.merge!({ "due_date" => mapping["due_date"] })
              end
            end
          elsif due_date = row_date(row, "due_date")
            attributes = { "due_date" => due_date }
            issue.send :safe_attributes=, attributes, user
            unless issue.due_date == row_date(row, "due_date")
              if issue.tracker.core_fields.include?("due_date")
                errors_per_position.merge!({ "due_date" => mapping["due_date"] })
              else
                ignores_per_position.merge!({ "due_date" => mapping["due_date"] })
              end
            end
          end
          if issue.start_date && issue.due_date && issue.start_date > issue.due_date
            errors_per_position.merge!({ "start_date" => mapping["start_date"] })
            errors_per_position.merge!({ "due_date" => mapping["due_date"] })
          end
          ## estimated hours
          if estimated_hours = row_value(row, "estimated_hours")
            if estimated_hours == "nil"
              attributes = { "estimated_hours" => nil }
              issue.send :safe_attributes=, attributes, user
            else
              attributes = { "estimated_hours" => estimated_hours }
              issue.send :safe_attributes=, attributes, user
            end
            unless issue.estimated_hours == row_value(row, "estimated_hours") || (issue.estimated_hours == nil && estimated_hours == "nil")
              if issue.tracker.core_fields.include?("estimated_hours")
                errors_per_position.merge!({ "estimated_hours" => mapping["estimated_hours"] })
              else
                ignores_per_position.merge!({ "estimated_hours" => mapping["estimated_hours"] })
              end
            end
          end
          ## done ratio
          if done_ratio = row_value(row, "done_ratio")
            if done_ratio == "nil"
              attributes = { "done_ratio" => nil }
              issue.send :safe_attributes=, attributes, user
            else
              attributes = { "done_ratio" => done_ratio }
              issue.send :safe_attributes=, attributes, user
            end
            unless (issue.done_ratio.to_s == done_ratio.to_s && Range.new(0, 100).include?(issue.done_ratio)) ||
                   (issue.done_ratio == nil && done_ratio == "nil")
              if issue.tracker.core_fields.include?("done_ratio")
                errors_per_position.merge!({ "done_ratio" => mapping["done_ratio"] })
              else
                ignores_per_position.merge!({ "done_ratio" => mapping["done_ratio"] })
              end
            end
          end
          ## custom field values
          attributes = {}
          issue.custom_field_values.each do |v|
            value = case v.custom_field.field_format
              when "date"
                row_date(row, "cf_#{v.custom_field.id}")
              else
                row_value(row, "cf_#{v.custom_field.id}")
              end
            if value == "nil"
              attributes = {
                "custom_field_values" => {
                  v.custom_field.id.to_s => nil,
                },
              }
            elsif value
              attributes = {
                "custom_field_values" => {
                  v.custom_field.id.to_s => v.custom_field.value_from_keyword(value, issue),
                },
              }
              issue.send :safe_attributes=, attributes, user
              unless issue.custom_field_value(v.custom_field.id) == v.custom_field.value_from_keyword(value, issue).to_s
                errors_per_position.merge!({ "cf_#{v.custom_field.id}" => mapping["cf_#{v.custom_field.id}"] })
              end
            end
          end
          ## invalid mapping to custom fields for a specific tracker
          cf_maps = mapping.select { |key, value| key =~ /\Acf_[0-9]+\z/ }
          cf_maps.each do |key, value|
            unless issue.tracker && issue.tracker.custom_fields.to_a.include?(CustomField.find_by_id(key.sub("cf_", "").to_i))
              ignores_per_position.merge!({ key => value })
            end
          end
          ## relations
          if related_issues = row_value(row, "related_issues")
            if related_issues == "nil"
              issue.relations.each do |relation|
                unless relation.deletable?(user)
                  errors_per_position.merge!({ "related_issues" => mapping["related_issues"] })
                end
              end
            else
              relations = []
              related_issues = related_issues.to_s.split(",")
              related_issues.each do |related_issue|
                related_issue.sub!(/\A[[:blank:]]*/, "")
                related_issue.sub!(/[[:blank:]]*\z/, "")
                if related_issue.match(/#?([0-9])+/)
                  relations << $1.to_i
                else
                  ## at least one of the relation is malformed.
                  errors_per_position.merge!({ "related_issues" => mapping["related_issues"] })
                end
              end
              if relations.count > 0
                relations.each do |relation|
                  if use_unique_id?
                    unique_ids = @matrix.collect { |row| row[mapping["unique_id"].to_i] }
                    unless unique_ids.include?(relation)
                      errors_per_position.merge!({ "related_issues" => mapping["related_issues"] })
                    end
                  else ## the related issue must pre exist.
                    unless Issue.find_by_id(relation)
                      errors_per_position.merge!({ "related_issues" => mapping["related_issues"] })
                    end
                  end

                  unless user.allowed_to?(:manage_issue_relations, issue.project)
                    errors_per_position.merge!({ "related_issues" => mapping["related_issues"] })
                  end
                end
              end
            end
          end
          ## finally, merge errors and ignores per line into all errors
          if errors_per_position.count > 0
            self.settings["errors"].merge!({ position => errors_per_position })
          else
            self.settings["errors"].delete(position)
          end
          if ignores_per_position.count > 0
            self.settings["ignores"].merge!({ position => ignores_per_position })
          else
            self.settings["ignores"].delete(position)
          end
        end
      end

      # Overrides to change behavior round "parent_issue_id"
      def build_object_with_ss(row, item)
        issue = Issue.new
        issue.author = user

        if update?
          issue = Issue.find_by_id(row_value(row, "#"))
          issue.init_journal(User.current,
                             ll(Setting.default_language, :text_status_changed_by_import))
        end
        ## to make the notification bulk, following command is disabled.
        # issue.notify = !!ActiveRecord::Type::Boolean.new.cast(settings["notifications"])
        issue.notify = false
        issue.current_journal.notify = false if update?

        tracker_id = nil

        if tracker
          tracker_id = tracker.id
        elsif tracker_name = row_value(row, "tracker")
          tracker_id = allowed_target_trackers.named(tracker_name).first.try(:id)
        end

        attributes = {
          "project_id" => mapping["project_id"],
          "tracker_id" => tracker_id,
          "subject" => row_value(row, "subject"),
          "description" => row_value(row, "description") == "nil" ? nil : row_value(row, "description"),
        }
        if status_name = row_value(row, "status")
          if status_id = IssueStatus.named(status_name).first.try(:id)
            attributes["status_id"] = status_id
          end
        end
        issue.send :safe_attributes=, attributes, user

        attributes = {}
        if priority_name = row_value(row, "priority")
          if priority_id = IssuePriority.active.named(priority_name).first.try(:id)
            attributes["priority_id"] = priority_id
          end
        end
        if issue.project && category_name = row_value(row, "category")
          if category_name == "nil"
            attributes["category_id"] = nil
          elsif category = issue.project.issue_categories.named(category_name).first
            attributes["category_id"] = category.id
          elsif create_categories?
            category = issue.project.issue_categories.build
            category.name = category_name
            if category.save
              attributes["category_id"] = category.id
            end
          end
        end
        if assignee_name = row_value(row, "assigned_to")
          if assignee_name == "nil"
            attributes["assigned_to_id"] = nil
          elsif assignee = Principal.detect_by_keyword(issue.assignable_users, assignee_name)
            attributes["assigned_to_id"] = assignee.id
          end
        end
        if issue.project && version_name = row_value(row, "fixed_version")
          if version_name == "nil"
            attributes["fixed_version_id"] = nil
          else
            version =
              issue.project.versions.named(version_name).first ||
              issue.project.shared_versions.named(version_name).first
            if version
              attributes["fixed_version_id"] = version.id
            elsif create_versions?
              version = issue.project.versions.build
              version.name = version_name
              if version.save
                attributes["fixed_version_id"] = version.id
              end
            end
          end
        end
        if is_private = row_value(row, "is_private")
          if yes?(is_private)
            attributes["is_private"] = "1"
          end
        end
        if parent_issue_id = row_value(row, "parent_issue_id")
          if parent_issue_id == "nil"
            attributes["parent_issue_id"] = nil
          elsif use_unique_id?
            # refers to other row with unique id
            issue_id = items.where(:unique_id => parent_issue_id).first.try(:obj_id)

            if issue_id
              attributes["parent_issue_id"] = issue_id
            else
              ## Because of use of roo (spreadsheet), parent_issue_id becomes a number
              ## despite of the corresponding unique_id in "import_items" is a string.
              add_callback(parent_issue_id.to_s, "set_as_parent", item.position)
            end
          elsif parent_issue_id.to_s =~ /\A\d+\z/
            # refers to existing issue
            attributes["parent_issue_id"] = parent_issue_id if Issue.find_by_id(parent_issue_id)
          else
            # Something is odd. Assign parent_issue_id to trigger validation error
            attributes["parent_issue_id"] = nil
          end
        end
        if row_value(row, "start_date") == "nil"
          attributes["start_date"] = nil
        elsif start_date = row_date(row, "start_date")
          attributes["start_date"] = start_date
        end
        if row_value(row, "due_date") == "nil"
          attributes["due_date"] = nil
        elsif due_date = row_date(row, "due_date")
          attributes["due_date"] = due_date
        end
        if estimated_hours = row_value(row, "estimated_hours")
          if estimated_hours == "nil"
            attributes["estimated_hours"] = nil
          else
            attributes["estimated_hours"] = estimated_hours
          end
        end
        if done_ratio = row_value(row, "done_ratio")
          if done_ratio == "nil"
            attributes["done_ratio"] = nil
          else
            attributes["done_ratio"] = done_ratio
          end
        end

        attributes["custom_field_values"] = issue.custom_field_values.inject({}) do |h, v|
          value = case v.custom_field.field_format
            when "date"
              if row_value(row, "cf_#{v.custom_field.id}") == "nil"
                nil
              else
                row_date(row, "cf_#{v.custom_field.id}")
              end
            else
              if row_value(row, "cf_#{v.custom_field.id}") == "nil"
                nil
              else
                row_value(row, "cf_#{v.custom_field.id}")
              end
            end
          h[v.custom_field.id.to_s] = v.custom_field.value_from_keyword(value, issue)
          h
        end

        issue.send :safe_attributes=, attributes, user

        if issue.tracker_id != tracker_id
          issue.tracker_id = nil
        end

        # issue.clear_journal unless issue.changed?
        issue
      end

      def build_relations_for_ss(row, item)
        ## relations

        if related_issues = row_value(row, "related_issues")
          if update?
            issue = Issue.find_by_id(item.obj_id)
            issue.relations.each do |relation|
              relation.delete
            end
          end

          relations = []
          related_issues = related_issues.to_s.split(",")
          related_issues.each do |related_issue|
            related_issue.sub!(/\A[[:blank:]]*/, "")
            related_issue.sub!(/[[:blank:]]*\z/, "")
            if related_issue.match(/#?([0-9])+/)
              relations << $1.to_i
            end
          end

          relations.each do |related|
            related_issue_id = nil
            if use_unique_id?
              related_issue_id = items.where(:unique_id => related).first.try(:obj_id)
              unless related_issue_id
                add_callback(related.to_s, "set_as_related", item.position)
              end
            else
              related_issue_id = related
            end
            if related_issue_id
              relation = IssueRelation.new
              relation.init_journals(user)
              relation.issue_from_id = item.obj_id
              relation.issue_to_id = related_issue_id
              relation.relation_type = "relates"
              relation.save!
            end
          end
        end
      end

      # Callback that sets issue as the parent of a previously imported issue
      def set_as_related_callback(issue, related_position)
        related_id = items.where(:position => related_position).first.try(:obj_id)
        return unless related_id

        related = Issue.find_by_id(related_id)
        return unless related

        relation = IssueRelation.new
        relation.init_journals(user)

        relation.issue_from_id = issue.id
        relation.issue_to_id = related_id
        relation.relation_type = "relates"

        relation.save!
        issue.reload
      end
    end

    module ClassMethods
    end
  end
end
