# a patch against Import model
ActiveSupport::Reloader.to_prepare do
  unless TimeEntryImport.included_modules.include?(SsImport::TimeEntryImportPatch)
    TimeEntryImport.send(:include, SsImport::TimeEntryImportPatch)
  end
end

require_dependency "time_entry_import"
require "roo"

module SsImport
  module TimeEntryImportPatch
    def self.included(base) # :nodoc:
      base.send(:include, InstanceMethods)
      base.include(ClassMethods)

      base.class_eval do
        unloadable
        alias_method :build_object_without_ss, :build_object
        alias_method :build_object, :build_object_with_ss

        alias_method :user_value_without_ss, :user_value
        alias_method :user_value, :user_value_with_ss
      end
    end

    module InstanceMethods
      # inspired from issue_import.rb mappable_custom_fields
      def mappable_core_fields_for_ss
        attributes = []
        fields = []
        if project
          time_entry = TimeEntry.new
          time_entry.project = project
          attributes = time_entry.safe_attribute_names(user)
        end
        # remove unnecessary attributes
        ["project_id", "custom_field_values", "custom_fields",
         "lock_version", "watcher_user_ids", "deleted_attachment_ids"].each do |unnecessary|
          attributes.delete(unnecessary)
        end
        # remove "_ids" from field names except "parent_issue_id"
        attributes.each do |attribute|
          fields << attribute.sub(/_ids?\z/, "")
        end
        fields
      end

      # concatenates core fields and custom fields as field names
      def mappable_fields_for_ss
        mappable_fields = self.mappable_core_fields_for_ss

        self.mappable_custom_fields.each do |cf|
          mappable_fields << "cf_#{cf.id.to_s}"
        end
        mappable_fields
      end

      # makes local language version of fields list for select
      def attribute_options_for_ss
        attributes = []
        core_fields = self.mappable_core_fields_for_ss
        core_fields.each do |field|
          field_symbol_str = "field_" + field.sub(/_ids?\z/, "")
          local_attribute_name = l(field_symbol_str.to_sym)
          if local_attribute_name
            attributes << local_attribute_name
          end
        end

        custom_fields = self.mappable_custom_fields
        custom_fields.each do |field|
          attributes << field.name
        end
        i = -1
        attributes.map { |h| [h, i += 1] }
      end

      # in ss_import, mapping key for user is "user", not "user_id"
      def user_value_with_ss
        if mapping["user"].to_s =~ /\Avalue:(\d+)\z/
          $1.to_i
        end
      end

      # validates each row of CSV/SS by tentatively build_object
      def validate_objects_for_ss
        self.settings["errors"] = {}
        self.settings["ignores"] = {}
        self.settings["excludes"] = {}

        read_items do |row, position|
          errors_per_position = {}
          ignores_per_position = {}

          if exclude = row_value(row, "exclude")
            self.settings["excludes"].merge!({ position => true })
            next
          end

          time_entry = TimeEntry.new
          time_entry.author = user

          ## Project: mandatory
          attributes = { "project_id" => mapping["project_id"] }
          time_entry.send :safe_attributes=, attributes, user
          unless time_entry.project_id == mapping["project_id"].to_i
            errors_per_position.merge!({ "project_id" => mapping["project_id"] })
          end
          ## activity ID: mandatory
          activity_id = nil
          if activity
            activity_id = activity.id
          elsif activity_name = row_value(row, "activity")
            activity_id = allowed_target_activities.named(activity_name).first.try(:id)
          end
          attributes = { "activity_id" => activity_id }
          time_entry.send :safe_attributes=, attributes, user
          unless time_entry.activity_id && time_entry.activity_id == activity_id
            errors_per_position.merge!({ "activity" => mapping["activity"] })
          end
          ## user ID: mandatory
          user_id = nil
          if user.allowed_to?(:log_time_for_other_users, project)
            if user_value
              user_id = user_value
              # original mapping hash key for time entry was "user_id", but is different from issue
            elsif user_name = row_value(row, "user")
              user_id = Principal.detect_by_keyword(allowed_target_users, user_name).try(:id)
            end
          else
            user_id = user.id
          end
          attributes = { "user_id" => user_id }
          time_entry.send :safe_attributes=, attributes, user
          unless time_entry.user_id && time_entry.user_id == user_id
            errors_per_position.merge!({ "user" => mapping["user"] })
          end
          ## issue ID: non-mandatory
          if issue_id = row_value(row, "issue")
            if issue = Issue.find_by_id(issue_id.to_i)
              unless issue.project == time_entry.project
                errors_per_position.merge!({ "issue" => mapping["issue"] })
              end
            end
          end
          ## custom field values
          attributes = {}
          time_entry.custom_field_values.each do |v|
            value = case v.custom_field.field_format
              when "date"
                row_date(row, "cf_#{v.custom_field.id}")
              else
                row_value(row, "cf_#{v.custom_field.id}")
              end
            if value
              attributes = {
                "custom_field_values" => {
                  v.custom_field.id.to_s => v.custom_field.value_from_keyword(value, time_entry),
                },
              }
              time_entry.send :safe_attributes=, attributes, user
              unless time_entry.custom_field_value(v.custom_field.id) == v.custom_field.value_from_keyword(value, time_entry)
                errors_per_position.merge!({ "cf_#{v.custom_field.id}" => mapping["cf_#{v.custom_field.id}"] })
              end
            end
          end
          ## invalid mapping to custom fields
          cf_maps = mapping.select { |key, value| key =~ /\Acf_[0-9]+\z/ }
          cf_maps.each do |key, value|
            unless time_entry.available_custom_fields.select { |cf| cf.id == key.sub("cf_", "").to_i }
              ignores_per_position.merge!({ key => value })
            end
          end
          ## finally, merge errors and ignores per line into all errors
          if errors_per_position.count > 0
            self.settings["errors"].merge!({ position => errors_per_position })
          else
            self.settings["errors"].delete(position)
          end
        end
      end

      # override to avoid hash key difference
      def build_object_with_ss(row, item)
        object = TimeEntry.new
        object.author = user

        activity_id = nil
        if activity
          activity_id = activity.id
        elsif activity_name = row_value(row, "activity")
          activity_id = allowed_target_activities.named(activity_name).first.try(:id)
        end

        user_id = nil
        if user.allowed_to?(:log_time_for_other_users, project)
          if user_value
            user_id = user_value
            # original mapping hash key for time entry was "user_id", but is different from issue
          elsif user_name = row_value(row, "user")
            user_id = Principal.detect_by_keyword(allowed_target_users, user_name).try(:id)
          end
        else
          user_id = user.id
        end

        attributes = {
          :project_id => project.id,
          :activity_id => activity_id,
          :author_id => user.id,
          :user_id => user_id,

          # original mapping hash key for time entry was "issue_id", but is different from issue
          :issue_id => row_value(row, "issue"),
          :spent_on => row_date(row, "spent_on"),
          :hours => row_value(row, "hours"),
          :comments => row_value(row, "comments"),
        }

        attributes["custom_field_values"] = object.custom_field_values.inject({}) do |h, v|
          value = case v.custom_field.field_format
            when "date"
              row_date(row, "cf_#{v.custom_field.id}")
            else
              row_value(row, "cf_#{v.custom_field.id}")
            end
          if value
            h[v.custom_field.id.to_s] = v.custom_field.value_from_keyword(value, object)
          end
          h
        end

        object.send(:safe_attributes=, attributes, user)
        object
      end
    end

    module ClassMethods
    end
  end
end
