# a patch against Import model
ActiveSupport::Reloader.to_prepare do
  unless Issue.included_modules.include?(SwsParentTicketHistory::IssuePatch)
    Issue.send(:include, SwsParentTicketHistory::IssuePatch)
  end
end

require_dependency "issue"

module SwsParentTicketHistory
  module IssuePatch
    def self.included(base) # :nodoc:
      base.send(:include, InstanceMethods)
      base.include(ClassMethods)

      base.class_eval do
        unloadable
        alias_method :recalculate_attributes_for_without_sws, :recalculate_attributes_for
        alias_method :recalculate_attributes_for, :recalculate_attributes_for_with_sws
      end
    end

    module InstanceMethods
      def recalculate_attributes_for_with_sws(issue_id)
        if issue_id && p = Issue.find_by_id(issue_id)

          # Local modification by SWS 2020-12-24 http://ele-pm.sys.sws.com/issues/379289
          p.init_journal(User.current,
                         ll(Setting.default_language, :text_status_changed_by_child_issue_status_change, self.id))
          p.current_journal.notify = false

          if p.priority_derived?
            # priority = highest priority of open children
            # priority is left unchanged if all children are closed and there's no default priority defined
            if priority_position = p.children.open.joins(:priority).maximum("#{IssuePriority.table_name}.position")
              p.priority = IssuePriority.find_by_position(priority_position)
            elsif default_priority = IssuePriority.default
              p.priority = default_priority
            end
          end

          if p.dates_derived?
            # start/due dates = lowest/highest dates of children
            p.start_date = p.children.minimum(:start_date)
            p.due_date = p.children.maximum(:due_date)
            if p.start_date && p.due_date && p.due_date < p.start_date
              p.start_date, p.due_date = p.due_date, p.start_date
            end
          end

          if p.done_ratio_derived?
            # done ratio = average ratio of children weighted with their total estimated hours
            unless Issue.use_status_for_done_ratio? && p.status && p.status.default_done_ratio
              children = p.children.to_a
              if children.any?
                child_with_total_estimated_hours = children.select { |c| c.total_estimated_hours.to_f > 0.0 }
                if child_with_total_estimated_hours.any?
                  average = child_with_total_estimated_hours.map(&:total_estimated_hours).sum.to_d / child_with_total_estimated_hours.count
                else
                  average = 1.0.to_d
                end
                done = children.map { |c|
                  estimated = (c.total_estimated_hours || 0.0).to_d
                  estimated = average unless estimated > 0.0
                  ratio = c.closed? ? 100 : (c.done_ratio || 0)
                  estimated * ratio
                }.sum
                progress = done / (average * children.count)
                p.done_ratio = progress.floor
              end
            end
          end
          # Local modification by SWS 2020-12-24 http://ele-pm.sys.sws.com/issues/379289
          p.clear_journal unless p.changed?

          # ancestors will be recursively updated
          p.save(:validate => false)
        end
      end
    end

    module ClassMethods
    end
  end
end
