SELECT "issues"."id" AS T0_R0,
	"issues"."tracker_id" AS T0_R1,
	"issues"."project_id" AS T0_R2,
	"issues"."subject" AS T0_R3,
	"issues"."description" AS T0_R4,
	"issues"."due_date" AS T0_R5,
	"issues"."category_id" AS T0_R6,
	"issues"."status_id" AS T0_R7,
	"issues"."assigned_to_id" AS T0_R8,
	"issues"."priority_id" AS T0_R9,
	"issues"."fixed_version_id" AS T0_R10,
	"issues"."author_id" AS T0_R11,
	"issues"."lock_version" AS T0_R12,
	"issues"."created_on" AS T0_R13,
	"issues"."updated_on" AS T0_R14,
	"issues"."start_date" AS T0_R15,
	"issues"."done_ratio" AS T0_R16,
	"issues"."estimated_hours" AS T0_R17,
	"issues"."parent_id" AS T0_R18,
	"issues"."root_id" AS T0_R19,
	"issues"."lft" AS T0_R20,
	"issues"."rgt" AS T0_R21,
	"issues"."is_private" AS T0_R22,
	"issues"."closed_on" AS T0_R23,
	"issue_statuses"."id" AS T1_R0,
	"issue_statuses"."name" AS T1_R1,
	"issue_statuses"."is_closed" AS T1_R2,
	"issue_statuses"."position" AS T1_R3,
	"issue_statuses"."default_done_ratio" AS T1_R4,
	"projects"."id" AS T2_R0,
	"projects"."name" AS T2_R1,
	"projects"."description" AS T2_R2,
	"projects"."homepage" AS T2_R3,
	"projects"."is_public" AS T2_R4,
	"projects"."parent_id" AS T2_R5,
	"projects"."created_on" AS T2_R6,
	"projects"."updated_on" AS T2_R7,
	"projects"."identifier" AS T2_R8,
	"projects"."status" AS T2_R9,
	"projects"."lft" AS T2_R10,
	"projects"."rgt" AS T2_R11,
	"projects"."inherit_members" AS T2_R12,
	"projects"."default_version_id" AS T2_R13,
	"projects"."default_assigned_to_id" AS T2_R14,
	"projects"."default_issue_query_id" AS T2_R15
FROM "issues"
INNER JOIN "projects" ON "projects"."id" = "issues"."project_id"
INNER JOIN "issue_statuses" ON "issue_statuses"."id" = "issues"."status_id"
WHERE (PROJECTS.STATUS <> 9
							AND PROJECTS.STATUS <> 10
							AND EXISTS
								(SELECT 1 AS ONE
									FROM ENABLED_MODULES EM
									WHERE EM.PROJECT_ID = PROJECTS.ID
										AND EM.NAME = 'issue_tracking'))
	AND ((ISSUES.STATUS_ID IN
								(SELECT ID
									FROM ISSUE_STATUSES
									WHERE IS_CLOSED = FALSE))
						AND ISSUES.ID IN
							(SELECT ISSUES.ID
								FROM ISSUES
								LEFT OUTER JOIN CUSTOM_VALUES ON CUSTOM_VALUES.CUSTOMIZED_TYPE = 'Issue'
								AND CUSTOM_VALUES.CUSTOMIZED_ID = ISSUES.ID
								AND CUSTOM_VALUES.CUSTOM_FIELD_ID = 13
								WHERE (CUSTOM_VALUES.VALUE ILIKE '%text%')
									AND (((1 = 1)
															AND (ISSUES.TRACKER_ID IN
																					(SELECT TRACKER_ID
																						FROM CUSTOM_FIELDS_TRACKERS
																						WHERE CUSTOM_FIELD_ID = 13))
															AND (EXISTS
																					(SELECT 1
																						FROM CUSTOM_FIELDS IFA
																						WHERE IFA.IS_FOR_ALL = TRUE
																							AND IFA.ID = 13)
																				OR ISSUES.PROJECT_ID IN
																					(SELECT PROJECT_ID
																						FROM CUSTOM_FIELDS_PROJECTS
																						WHERE CUSTOM_FIELD_ID = 13))
															AND (PROJECTS.STATUS <> 9
																				AND PROJECTS.STATUS <> 10
																				AND EXISTS
																					(SELECT 1 AS ONE
																						FROM ENABLED_MODULES EM
																						WHERE EM.PROJECT_ID = PROJECTS.ID
																							AND EM.NAME = 'issue_tracking'))))))
ORDER BY ISSUES.ID DESC
