require 'redmine'
require 'base64'
require 'dispatcher'

class UploadedScreenshot
  def initialize(base64)
    @raw = StringIO.new(Base64.decode64(base64))
  end
  
  def size
    @raw.size
  end
  
  def original_filename
    "screenshot.png"
  end
  
  def content_type
    "image/png"
  end
  
  def read(*args)
    @raw.read(*args)
  end
end

module RedmineScreenshotPaste
  def self.included(base)
    base.send(:include, InstanceMethods)
    base.send(:alias_method_chain, :attach_files, :screenshot)
  end

  module InstanceMethods
    # Patch Rails so engine's views are prepended to the view_path,
    # thereby letting plugins override application views
    def attach_files_with_screenshot(obj, attachments)
      if params[:uploaded_screenshot]
        attachments[:screenshot] = {:file => UploadedScreenshot.new(params[:uploaded_screenshot])}
      end
      attach_files_without_screenshot(obj, attachments)
    end
  end
end


class RedmineScreenshotPasteHook < Redmine::Hook::ViewListener
  render_on :view_issues_form_details_bottom, :partial => 'screenshot'
end

Dispatcher.to_prepare :redmine_screenshot_paste do
  ApplicationController.send :include, RedmineScreenshotPaste
end
