/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package imageuploadapplet;

import com.sun.java.browser.dom.DOMAccessException;
import com.sun.java.browser.dom.DOMAccessor;
import com.sun.java.browser.dom.DOMAction;
import com.sun.java.browser.dom.DOMService;
import com.sun.java.browser.dom.DOMUnsupportedException;
import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.datatransfer.*;
import java.awt.dnd.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Element;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

/**
 *
 * @author Chui
 */
public class Main extends JApplet {

    JButton btnPaste;
    JScrollPane scrollPane;
    JLabel label;
    BufferedImage image;

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        // TODO code application logic here
    }

    public void pasteFromClipboard() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
            try {
                image = (BufferedImage) clipboard.getData(DataFlavor.imageFlavor);
                label.setIcon(new ImageIcon(image));
            } catch (UnsupportedFlavorException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            } catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public void loadImageFromFile(File input){
        try {
            image = ImageIO.read(input);
            label.setIcon(new ImageIcon(image));
        } catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }


    public void setField()
    {
        final Object applet = this;
        try {
            DOMService service = DOMService.getService(this);
            service.invokeAndWait(new DOMAction()
            {
                public Object run(DOMAccessor accessor) {
                    Element e = accessor.getDocument(applet).getElementById("image");
                    
                    if (e != null)
                        e.setAttribute("value", getImageAsBase64());
                    
                    return null;
                }
            });
        } catch (DOMAccessException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        } catch (DOMUnsupportedException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    public String getImageAsBase64() {
        try {
            Iterator it = ImageIO.getImageWritersByMIMEType("image/png");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageOutputStream output = ImageIO.createImageOutputStream(baos);

            ImageWriter writer = (ImageWriter) it.next();
            writer.setOutput(output);
            writer.write(image);
            writer.dispose();

            return Base64.encodeBytes(baos.toByteArray());
        } catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    protected AccessControlContext context = AccessController.getContext();

    public void getImageFromClipboad()
    {
      image = (BufferedImage) AccessController.doPrivileged(
        new PrivilegedAction<BufferedImage>() {
          public BufferedImage run() {
            BufferedImage image = null;
            try {
              image = (BufferedImage) getToolkit().getSystemClipboard().getData(DataFlavor.imageFlavor);
            } catch (UnsupportedFlavorException ex) {
              Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
              Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            return image;
          }
        },
        context);
      if (image != null)
      {
        label.setIcon(new ImageIcon(image));
        setField();
      }
    }
    @Override
    public void init() {
        super.init();

        this.setLayout(new BorderLayout());

        label = new JLabel();
        scrollPane = new JScrollPane(label);
        this.add(scrollPane, BorderLayout.CENTER);

        /*btnPaste = new JButton("Paste");
        btnPaste.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                pasteFromClipboard();
                setField();
            }
        });
        this.add(btnPaste, BorderLayout.SOUTH);*/

        DropTargetListener dl = new DropTargetListener () {
          @Override
          public void dragEnter(DropTargetDragEvent dtde) {
                System.out.println( "dragEnter" );
          }
          @Override
          public void dragExit(DropTargetEvent dte) {
                System.out.println( "dragExit" );
          }
          @Override
          public void dragOver(DropTargetDragEvent dtde) {
                System.out.println( "dragOver" );
          }
          @Override
          public void drop(DropTargetDropEvent dtde) {
                System.out.println( "drop" );
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor))
                {
                  dtde.acceptDrop(DnDConstants.ACTION_LINK);
                  try {

                      java.util.List files = (java.util.List) dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                      if(files.size() > 0)
                      {
                        File one = (File) files.get(0);
                        loadImageFromFile(one);
                        setField();
                      }
                  } catch (UnsupportedFlavorException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                    dtde.rejectDrop();
                  } catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                    dtde.rejectDrop();
                  }

                  dtde.dropComplete(true);
                } else {
                  dtde.rejectDrop();
                }
          }
          @Override
          public void dropActionChanged(DropTargetDragEvent dtde) {
                System.out.println( "dropActionChanged" );
          }
        };

        DropTarget dt = new DropTarget(scrollPane, dl);

        MouseListener ml = new MouseListener() {
                @Override
                public void mouseClicked(MouseEvent arg0) {}

                @Override
                public void mouseEntered(MouseEvent arg0) {}

                @Override
                public void mouseExited(MouseEvent arg0) {}

                @Override
                public void mousePressed(MouseEvent arg0) {}

                @Override
                public void mouseReleased(MouseEvent arg0) {
                    pasteFromClipboard();
                    setField();
                }
        };

        scrollPane.addMouseListener( ml );
                        //pasteFromClipboard();
    }
}
