require_relative 'lib/itgn_module'

Redmine::Plugin.register :itgn_cl do
  name 'ITGN Consent Library plugin'
  author 'Guus Teley'
  description "This plugin for Redmine provides a library store for data subjects' consent for processing personal data"
  version '3.2'
  url 'http://www.itgn.nl/itgn_cl'
  author_url 'https://www.teley.nl/'
  menu :admin_menu, :itgn_cl, {:controller => 'menu', :action => 'index'}, :caption => 'ITGN Consent Library'
  # Restrict access to admin and permitted groups
  menu :application_menu, :itgn_cl, { :controller => 'menu', :action => 'index' }, :caption => 'Consent Library', :if => Proc.new {
    access_level() > 0
  }
  settings :default => {
    :rp_name => 'ACME Corporation',
    :rp_address => 'Desert Lane 987654321, Nevada',
    :rp_email => 'w.e.coyote@acme.corp',
    :rp_DPO_name => 'D.P.Overlord',
    :rp_DPO_email => 'dpo_overlord@acme.corp',
    :create_activity => 0,
    :num_per_page => 20,
    :activity_user => nil,
    :activity_project => nil,
    :activity_tracker => nil
  },:partial => 'setup/itgn_cl_setup'
Rails::logger.info("Registered ITGN_CL Plugin")
Rails::logger.info("Rails::Application.autoload_paths")
end

=begin
Version 1.3.5 : Using the global var $VERSION gave an error in the Import/Export plugin. Changed it to MY_VERSION
Version 1.4.2 : When initial Projects are not available, check for nil? and give error
Version 1.4.3 : Added Responsible Party's data within config page
                Added method for retrieving RP data
                Changed OpenSSL key length to fixed 32
Version 1.5.0 : Made Rails 4.0 compatible
Version 1.5.1 : Expanded list of seeds
Version 1.5.2 : Fixed problem with non-existing Project-ID in settings page
Version 1.6.0 : Moved AES encryption key to config/initiaizers and changed according migrate routine
                Changed database fields to administer for data subjects => Didn't work!
Version 2.1.0 : Added support for multiple email addresses per data subject
Version 2.1.1 : Some minor layout issues
Version 2.1.2 : Added query_email function to DataSubject + route
Version 2.1.3 : Addedd API function to create a Data Subject
Version 2.2.0 : Added DPO info to config and API returned data
Version 2.2.1 : Responsible Party returned default data (not actual one)
Version 2.2.2 : Support for multiple forms (in settings) to go to its own process (API parameter 'form')
version 2.2.3 : Fixed error in setting defaults
version 3.0.0 : Add support for attachments (evidence files)
version 3.0.1 : Some fixes
version 3.0.2 : Fixed error in Query form (jQuery wouldn't execute ajax:complete)
version 3.1   : Added check for activity and returning activity_id when creating activity
version 3.2   : Fixed issues with migration to Redmine 5.x/Rails 7
=end
