module ItgnModule
    #AES Encryption key
    Rails.configuration.itgn_consent_library_key = "redacted"
    @@seckey = Rails.configuration.itgn_consent_library_key
    require 'openssl'
    require 'digest'


    def access_level
        if User.current.admin?
            access_level = 3
        else
            if User.current.groups.where(:lastname=>"ITGN Consent Library Editor").count == 1
                access_level = 2
            else
                if User.current.groups.where(:lastname=>"ITGN Consent Library Query").count == 1
                    access_level = 1
                else
                    access_level = 0
                end
            end
        end
        access_level
    end

    def encrypt (val)
        cipher_encrypt = OpenSSL::Cipher::AES.new(256, :CBC).encrypt
        cipher_encrypt.key = (Digest::SHA1.hexdigest @@seckey)[0..31]
        rv = cipher_encrypt.update(val) + cipher_encrypt.final
        rv
    end
    def decrypt(val)
        return val if val.nil?
        cipher_decrypt = OpenSSL::Cipher::AES.new(256, :CBC).decrypt
        cipher_decrypt.key = (Digest::SHA1.hexdigest @@seckey)[0..31]
        rv = cipher_decrypt.update(val) + cipher_decrypt.final
        rv
    end
end
